/*
 * Decompiled with CFR 0.152.
 */
package oracle.oplan.sdk.exec.api;

import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import oracle.opatch.system.automation.AutomationHelper;
import oracle.opatch.system.automation.AutomationXMLException;
import oracle.opatch.system.automation.jaxb.Readme;
import oracle.opatch.system.automation.jaxb.UserMessage;
import org.xml.sax.SAXException;

public class ExecplanHelper {
    private static ExecplanHelper thisObj = null;
    private final Schema schema;
    private final JAXBContext jbc;
    Logger logger = Logger.getLogger(ExecplanHelper.class.getName());
    public static final Pattern PATTERN = Pattern.compile("\\%(.+?)\\%");

    private ExecplanHelper() {
        SchemaFactory sf = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        try {
            this.schema = sf.newSchema(this.getClass().getResource("/oracle/oplan/core/exec/xsd/execution-plan.xsd"));
        }
        catch (SAXException ex) {
            Logger.getLogger(AutomationHelper.class.getName()).log(Level.SEVERE, null, ex);
            throw new AutomationXMLException(null, (Throwable)ex);
        }
        try {
            this.jbc = JAXBContext.newInstance((String)"oracle.opatch.oplan.exec.api");
        }
        catch (JAXBException ex) {
            Logger.getLogger(AutomationHelper.class.getName()).log(Level.SEVERE, null, ex);
            throw new AutomationXMLException(null, (Throwable)ex);
        }
    }

    public static ExecplanHelper getInstance() {
        if (thisObj == null) {
            thisObj = new ExecplanHelper();
        }
        return thisObj;
    }

    public static Readme cloneReadme(Readme src) {
        if (src == null) {
            return null;
        }
        Readme tgt = new Readme();
        tgt.setTitle(ExecplanHelper.cloneUserMessage(src.getTitle()));
        tgt.setMessage(ExecplanHelper.cloneUserMessage(src.getMessage()));
        tgt.setTroubleshoot(ExecplanHelper.cloneUserMessage(src.getTroubleshoot()));
        for (Readme.Parameter param : src.getParameter()) {
            tgt.getParameter().add(ExecplanHelper.cloneParameter(param));
        }
        return tgt;
    }

    private static UserMessage cloneUserMessage(UserMessage src) {
        if (src == null) {
            return null;
        }
        UserMessage tgt = new UserMessage();
        tgt.setValue(src.getValue());
        tgt.setPropertyKey(src.getPropertyKey());
        return tgt;
    }

    private static Readme.Parameter cloneParameter(Readme.Parameter src) {
        if (src == null) {
            return null;
        }
        Readme.Parameter tgt = new Readme.Parameter();
        tgt.setName(src.getName());
        tgt.setType(src.getType());
        tgt.setValue(src.getValue());
        return tgt;
    }
}

