/*
 * Decompiled with CFR 0.152.
 */
package oracle.oplan.sdk.engine;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import model.common.Host;
import oracle.opatch.system.automation.jaxb.ActionType;
import oracle.opatch.system.automation.jaxb.PatchingPhase;
import oracle.oplan.sdk.exec.api.ExecutionStep;
import oracle.oplan.sdk.graphlib.ConfigGraph;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SequencingEngineUtils {
    private Logger logger = Logger.getLogger(SequencingEngineUtils.class.getName());

    public boolean includeAction(ActionType action) {
        return true;
    }

    public List<Host> sortHosts(List<Host> hostList, PatchingPhase auto_phase) {
        return hostList;
    }

    public List<Host> sortHosts(List<Host> hostList, ConfigGraph g) {
        return hostList;
    }

    public List<ExecutionStep> sortStepsForNonrollingPhase(List<ExecutionStep> steps, PatchingPhase auto_phase) {
        return steps;
    }

    public List<ExecutionStep> sortStepsForRollingPhase(List<ExecutionStep> steps, PatchingPhase auto_phase) {
        return steps;
    }

    public List<ExecutionStep> sortStepsByActsOntarget(List<ExecutionStep> steps) {
        LinkedHashMap targetToStepMap = new LinkedHashMap();
        if (this.logger.isLoggable(Level.FINE)) {
            this.displaySteps("Before Sorting", steps);
        }
        for (int i = 0; i < steps.size(); ++i) {
            ExecutionStep aStep = steps.get(i);
            if (targetToStepMap.containsKey(aStep.getActsOnTarget())) {
                ((List)targetToStepMap.get(aStep.getActsOnTarget())).add(aStep);
                continue;
            }
            ArrayList<ExecutionStep> aListOfSteps = new ArrayList<ExecutionStep>();
            aListOfSteps.add(aStep);
            targetToStepMap.put(aStep.getActsOnTarget(), aListOfSteps);
        }
        ArrayList<ExecutionStep> returnList = new ArrayList<ExecutionStep>();
        if (!targetToStepMap.isEmpty()) {
            for (Map.Entry pairs : targetToStepMap.entrySet()) {
                List stepsOfATarget = (List)pairs.getValue();
                returnList.addAll(stepsOfATarget);
            }
        }
        if (this.logger.isLoggable(Level.FINE)) {
            this.displaySteps("After Sorting", steps);
        }
        return returnList;
    }

    private void displaySteps(String stage, List<ExecutionStep> steps) {
        this.logger.fine(stage);
        for (int i = 0; i < steps.size(); ++i) {
            ExecutionStep step = steps.get(i);
            this.logger.fine("Host: " + step.getHost());
            this.logger.fine("ActsOnTarget: " + step.getActsOnTarget().getName());
            List<ExecutionStep.Command> cmds = step.getCommand();
            for (int j = 0; j < cmds.size(); ++j) {
                this.logger.fine("Command " + (j + 1) + ": " + cmds.get(j).getValue());
            }
        }
    }
}

