/*
 * Decompiled with CFR 0.152.
 */
package oracle.oplan.sdk.engine;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;
import model.common.AbstractBaseTarget;
import model.common.Host;
import model.common.OracleHome;
import oracle.oplan.sdk.cmdtranslator.CommandContext;
import oracle.oplan.sdk.graphlib.ConfigGraph;
import oracle.oplan.sdk.oplan.OPlan;
import oracle.oplan.sdk.oplan.OPlanInternalException;

public class ContextPopulator {
    static Logger logger = Logger.getLogger(ContextPopulator.class.getName());

    public void fixCloneContext(CommandContext context) {
        List<OracleHome> origs = context.getTargets(OracleHome.class);
        ArrayList<OracleHome> clones = new ArrayList<OracleHome>();
        for (OracleHome orig : origs) {
            List<OracleHome> clonehomes = OPlan.getInstance().getMakeCloneHome().getHomeClone(orig);
            for (OracleHome clone : clonehomes) {
                clones.add(clone);
            }
        }
        if (context.getPrimaryTarget() instanceof OracleHome) {
            context.setPrimaryTarget((AbstractBaseTarget)OPlan.getInstance().getMakeCloneHome().getHomeClone((OracleHome)context.getPrimaryTarget()).get(0));
        }
        context.putTargets(clones);
    }

    protected OracleHome getRunsFromHome(ConfigGraph g, AbstractBaseTarget v) {
        Iterator<OracleHome> iterator = g.getConnectedTargets(v, OracleHome.class).iterator();
        if (iterator.hasNext()) {
            OracleHome oh = iterator.next();
            return oh;
        }
        logger.info("Could not find connected oracle home target for target " + v.getDisplayName());
        return null;
    }

    protected Host getHost(ConfigGraph g, AbstractBaseTarget v) {
        if (v instanceof Host) {
            return (Host)v;
        }
        Iterator<Host> iterator = g.getConnectedTargets(v, Host.class).iterator();
        if (iterator.hasNext()) {
            Host host = iterator.next();
            return host;
        }
        throw new OPlanInternalException("Couldn't find host for " + v);
    }

    protected CommandContext populateContextForOH(ConfigGraph g, OracleHome oh) {
        ArrayList<Host> hosts = new ArrayList<Host>(oh.getHosts());
        Collections.sort(hosts, g.getComparator());
        CommandContext context = new CommandContext();
        context.setPrimaryTarget((AbstractBaseTarget)oh);
        if (hosts.size() > 1) {
            hosts.clear();
            hosts.add(g.getLocalHost());
        }
        context.putTargets(hosts);
        return context;
    }

    protected CommandContext getGenericContext(ConfigGraph g, AbstractBaseTarget t) {
        CommandContext context = new CommandContext();
        if (this.getRunsFromHome(g, t) != null) {
            context.putTarget((AbstractBaseTarget)this.getRunsFromHome(g, t));
        }
        context.putTarget((AbstractBaseTarget)this.getHost(g, t));
        context.setPrimaryTarget(t);
        return context;
    }

    public CommandContext populateContext(ConfigGraph g, AbstractBaseTarget target) {
        if (target instanceof OracleHome) {
            return this.populateContextForOH(g, (OracleHome)target);
        }
        return this.getGenericContext(g, target);
    }
}

