/*
 * Decompiled with CFR 0.152.
 */
package oracle.oplan.sdk.cmdtranslator.commands;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import model.common.AbstractBaseTarget;
import oracle.opatch.system.automation.jaxb.ActionType;
import oracle.oplan.sdk.cmdtranslator.Command;
import oracle.oplan.sdk.cmdtranslator.CommandContext;
import oracle.oplan.sdk.cmdtranslator.CommandUtils;
import oracle.oplan.sdk.exec.api.ExecutionStep;
import oracle.oplan.sdk.graphlib.ConfigGraph;
import oracle.oplan.sdk.intg.OPlanIntgFactory;
import oracle.oplan.sdk.oplan.OPlan;
import oracle.oplan.sdk.oplan.SystemModelUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SimpleDosCommand
extends Command {
    private final Logger logger = Logger.getLogger(SimpleDosCommand.class.getName());
    ExecutionStep executionStep;

    public SimpleDosCommand(ActionType originalAutomationAction) {
        super(originalAutomationAction);
    }

    public abstract List<String> getDosCommands(CommandContext var1);

    @Override
    public List<ExecutionStep> generateExecutionSteps(ConfigGraph configGraph, List<? extends AbstractBaseTarget> actsOnlyOnTargets) {
        ArrayList<ExecutionStep> executionSteps = new ArrayList<ExecutionStep>();
        for (AbstractBaseTarget abstractBaseTarget : actsOnlyOnTargets) {
            ExecutionStep es = this.getExecutionStep(configGraph, abstractBaseTarget);
            if (es == null) continue;
            executionSteps.add(es);
        }
        return executionSteps;
    }

    public final ExecutionStep getExecutionStep(ConfigGraph g, AbstractBaseTarget t) {
        OPlanIntgFactory oplanIntgFactory = OPlan.getInstance().getOPlanIntgFactory();
        CommandContext context = oplanIntgFactory.getContextPopulator().populateContext(g, t);
        if (this.automationAction.isActsOnClone()) {
            oplanIntgFactory.getContextPopulator().fixCloneContext(context);
        }
        this.executionStep = CommandUtils.getBasicExecutionStep(this.automationAction, context, this.getAutomationAction());
        List<String> cmds = this.getDosCommands(context);
        if (cmds != null) {
            for (String cmd : cmds) {
                this.executionStep.getCommand().add(new ExecutionStep.Command(cmd, ExecutionStep.Command.CommandType.DOS));
            }
        }
        return this.executionStep;
    }

    @Override
    protected List<? extends AbstractBaseTarget> getApplicableTargets(ConfigGraph g) {
        Class<? extends AbstractBaseTarget> type = SystemModelUtils.getClassForType(this.automationAction.getActsOn());
        return g.getTargets(type, this.automationAction.getStripe());
    }
}

