/*
 * Decompiled with CFR 0.152.
 */
package oracle.oplan.sdk.cmdtranslator.commands;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import model.common.AbstractBaseTarget;
import model.common.Host;
import oracle.opatch.system.automation.jaxb.ActionType;
import oracle.opatch.system.automation.jaxb.Strategy;
import oracle.oplan.sdk.cmdtranslator.Command;
import oracle.oplan.sdk.cmdtranslator.CommandBuilder;
import oracle.oplan.sdk.cmdtranslator.CommandUtils;
import oracle.oplan.sdk.cmdtranslator.commands.SimpleShellCommand;
import oracle.oplan.sdk.exec.api.ExecutionStep;
import oracle.oplan.sdk.graphlib.ConfigGraph;
import oracle.oplan.sdk.oplan.SystemModelUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleDCLICommand
extends Command {
    SimpleShellCommand command;

    public SimpleDCLICommand(SimpleShellCommand command) {
        super(command.getAutomationAction());
        this.command = command;
    }

    static boolean passDCLIHostFilter(ConfigGraph configGraph, AbstractBaseTarget v) {
        Iterator<Host> iterator = configGraph.getConnectedTargets(v, Host.class).iterator();
        if (iterator.hasNext()) {
            Host x = iterator.next();
            return x == configGraph.getLocalHost();
        }
        return true;
    }

    ExecutionStep getExecutionStep(ConfigGraph g, AbstractBaseTarget t) {
        ExecutionStep step = this.command.getExecutionStep(g, t);
        if (step == null) {
            return null;
        }
        for (ExecutionStep.Command c : step.getCommand()) {
            c.setValue(CommandUtils.dcliPrefix(c.getValue(), g.getTargets(Host.class), step.getUser().getValue()));
        }
        return step;
    }

    @Override
    public boolean isCommandApplicableForPatchesInContext() {
        return this.command.isCommandApplicableForPatchesInContext();
    }

    @Override
    protected List<ExecutionStep> generateExecutionSteps(ConfigGraph g, List<? extends AbstractBaseTarget> actsOnlyOnTargets) {
        ArrayList<ExecutionStep> executionSteps = new ArrayList<ExecutionStep>();
        for (AbstractBaseTarget abstractBaseTarget : actsOnlyOnTargets) {
            ExecutionStep es;
            if (!SimpleDCLICommand.passDCLIHostFilter(g, abstractBaseTarget) || (es = this.getExecutionStep(g, abstractBaseTarget)) == null) continue;
            executionSteps.add(es);
        }
        return executionSteps;
    }

    @Override
    protected List<? extends AbstractBaseTarget> getApplicableTargets(ConfigGraph g) {
        Class<? extends AbstractBaseTarget> type = SystemModelUtils.getClassForType(this.command.getAutomationAction().getActsOn());
        return g.getTargets(type, this.command.getAutomationAction().getStripe());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Builder
    implements CommandBuilder<Command> {
        CommandBuilder<? extends SimpleShellCommand> b;

        public Builder(CommandBuilder<? extends SimpleShellCommand> b) {
            this.b = b;
        }

        @Override
        public Command getCommand(ActionType a, Strategy s) {
            SimpleShellCommand c = this.b.getCommand(a, s);
            if (c == null || !s.equals((Object)Strategy.DCLI)) {
                return c;
            }
            return new SimpleDCLICommand(c);
        }
    }
}

