/*
 * Decompiled with CFR 0.152.
 */
package oracle.oplan.sdk.cmdtranslator.commands;

import java.util.ArrayList;
import java.util.List;
import model.common.OracleHome;
import model.patchmodel.CompositePatch;
import model.patchmodel.GenericPatch;
import model.patchmodel.OPatchSingleton;
import oracle.opatch.system.automation.jaxb.ActionType;
import oracle.opatch.system.automation.jaxb.OpatchAction;
import oracle.opatch.system.automation.jaxb.Strategy;
import oracle.oplan.sdk.ExecutionMode;
import oracle.oplan.sdk.cmdtranslator.CommandBuilder;
import oracle.oplan.sdk.cmdtranslator.CommandContext;
import oracle.oplan.sdk.cmdtranslator.CommandUtils;
import oracle.oplan.sdk.cmdtranslator.commands.SimpleShellCommand;
import oracle.oplan.sdk.oplan.OPlan;
import oracle.oplan.sdk.oplan.OPlanInternalException;
import oracle.osysmodel.driver.sdk.productdriver.OUIDriver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OPatchVersionCommand
extends SimpleShellCommand {
    public OPatchVersionCommand(ActionType automationAction) {
        super(automationAction);
    }

    @Override
    public List<String> getShellCommands(CommandContext context) {
        OracleHome oh = context.getFirstTarget(OracleHome.class);
        String invPtrOption = CommandUtils.getInvPtrOption(oh);
        String opatchPath = CommandUtils.getOPatchPath(oh);
        ArrayList<String> minVersions = new ArrayList<String>();
        minVersions.add(OPlan.getInstance().getOPlanEnv().getMinimumOPatchVersion());
        String version = oh.getVersion();
        if (version == null) {
            version = OPlan.getInstance().getConfigGraph().getRootVertex().getVersion();
        }
        if (version == null) {
            throw new OPlanInternalException("The version of top target in SystemInstance is missing");
        }
        if (version.startsWith("11.1")) {
            minVersions.add("11.1.0.9.0");
        } else if (version.startsWith("11.2")) {
            minVersions.add("11.2.0.3.0");
        } else if (version.startsWith("12.1")) {
            minVersions.add("12.1.0.1.0");
        }
        List<GenericPatch> patches = !OPlan.getInstance().getOPlanEnv().getExecutionMode().equals((Object)ExecutionMode.EM) ? OPlan.getInstance().getOPlanEnv().getPatchesBag().getPatchesForTargetType(CommandUtils.getApplicabilityTargetType(oh.getHomeType())) : CommandUtils.getPatchesByOHOwnerForEM(oh);
        if (patches == null || patches.size() == 0) {
            return null;
        }
        CommandUtils.storePatchIDsInContext(context, patches);
        for (GenericPatch patch : patches) {
            CompositePatch comPatch;
            if (patch instanceof OPatchSingleton) {
                OPatchSingleton op = (OPatchSingleton)patch;
                if (op.getMinimumOPatchVersion() == null) continue;
                minVersions.add(op.getMinimumOPatchVersion());
                continue;
            }
            if (!(patch instanceof CompositePatch) || (comPatch = (CompositePatch)patch).getMinimumOPatchVersion() == null) continue;
            minVersions.add(comPatch.getMinimumOPatchVersion());
        }
        String min_version = this.getMaxMinVersion(minVersions);
        ArrayList<String> cmds = new ArrayList<String>();
        cmds.add(opatchPath + " version -oh " + oh.getPath() + invPtrOption + " -v2c " + min_version);
        return cmds;
    }

    private String getMaxMinVersion(List<String> minVersions) {
        return OUIDriver.getMaxMinVersion(minVersions);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Builder
    implements CommandBuilder<OPatchVersionCommand> {
        @Override
        public OPatchVersionCommand getCommand(ActionType a, Strategy s) {
            if (!(a instanceof OpatchAction) || !a.getType().equals("version")) {
                return null;
            }
            OPatchVersionCommand com = new OPatchVersionCommand(a);
            return com;
        }
    }
}

