/*
 * Decompiled with CFR 0.152.
 */
package oracle.oplan.sdk.cmdtranslator.commands;

import java.util.ArrayList;
import java.util.List;
import model.common.OracleHome;
import oracle.opatch.system.automation.jaxb.ActionType;
import oracle.opatch.system.automation.jaxb.CommandAction;
import oracle.opatch.system.automation.jaxb.Strategy;
import oracle.oplan.sdk.ExecutionMode;
import oracle.oplan.sdk.cmdtranslator.Command;
import oracle.oplan.sdk.cmdtranslator.CommandBuilder;
import oracle.oplan.sdk.cmdtranslator.CommandContext;
import oracle.oplan.sdk.cmdtranslator.commands.CommandActionType;
import oracle.oplan.sdk.cmdtranslator.commands.SimpleShellCommand;
import oracle.oplan.sdk.oplan.OPlan;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigCompare
extends SimpleShellCommand {
    public ConfigCompare(ActionType automationAction) {
        super(automationAction);
    }

    @Override
    public List<String> getShellCommands(CommandContext context) {
        OracleHome oh = context.getFirstTarget(OracleHome.class);
        ArrayList<String> cmds = new ArrayList<String>();
        if (!OPlan.getInstance().isRunningStandalone()) {
            String cmd = "$ORACLE_HOME/OPatch/oplan/oplan configurationCompare <configuration.xml when these steps where generated>";
            cmds.add(cmd);
        } else {
            String oplanLocation = OPlan.getInstance().getOPlanEnv().getOPlanLocation().getAbsolutePath();
            String configXmlPath = OPlan.getInstance().getLogInfo().getConfigXml().getAbsolutePath();
            String setOH = "ORACLE_HOME=" + oh.getPath() + " ";
            String cmd = setOH + oplanLocation + " configurationCompare " + configXmlPath;
            cmds.add(cmd);
        }
        return cmds;
    }

    @Override
    public boolean shouldIncludeStepInExecutionMode(ExecutionMode exeMode) {
        if (ExecutionMode.EM.equals((Object)exeMode) || ExecutionMode.OPATCH.equals((Object)exeMode)) {
            return false;
        }
        return OPlan.getInstance().isRunningStandalone();
    }

    public static class Builder
    implements CommandBuilder {
        public Command getCommand(ActionType a, Strategy s) {
            if (!(a instanceof CommandAction) || !a.getType().equals(CommandActionType.ConfigCompare.toString())) {
                return null;
            }
            return new ConfigCompare(a);
        }
    }
}

