/*
 * Decompiled with CFR 0.152.
 */
package oracle.oplan.sdk.cmdtranslator.commands;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import model.common.OracleHome;
import model.patchmodel.GenericPatch;
import oracle.opatch.system.automation.jaxb.ActionType;
import oracle.opatch.system.automation.jaxb.ArtifactAction;
import oracle.opatch.system.automation.jaxb.ArtifactType;
import oracle.opatch.system.automation.jaxb.ArtifactVars;
import oracle.opatch.system.automation.jaxb.Command;
import oracle.opatch.system.automation.jaxb.Strategy;
import oracle.oplan.sdk.ExecutionMode;
import oracle.oplan.sdk.artifact.Artifact;
import oracle.oplan.sdk.artifact.ArtifactException;
import oracle.oplan.sdk.artifact.ArtifactSet;
import oracle.oplan.sdk.cmdtranslator.CommandBuilder;
import oracle.oplan.sdk.cmdtranslator.CommandContext;
import oracle.oplan.sdk.cmdtranslator.CommandUtils;
import oracle.oplan.sdk.cmdtranslator.commands.SimpleShellCommand;
import oracle.oplan.sdk.oplan.OPlan;
import oracle.oplan.sdk.oplan.VariableResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArtifactShellCommand
extends SimpleShellCommand {
    protected Logger logger = Logger.getLogger(ArtifactShellCommand.class.getName());
    protected List<Command> automationCommands;
    protected ArtifactType artifactType;
    protected String artifactTag;
    protected ArtifactVars artifactVars;
    protected String actOn;

    public ArtifactShellCommand(ArtifactAction artifactAction) {
        super((ActionType)artifactAction);
        this.automationCommands = artifactAction.getCommand();
        this.actOn = artifactAction.getActsOn();
        this.artifactTag = artifactAction.getArtifactTag();
        this.artifactVars = artifactAction.getArtifactVars();
        this.artifactType = artifactAction.getArtifactType();
        if (this.artifactType == null) {
            throw new ArtifactException("artifact type should not be null");
        }
    }

    @Override
    public List<String> getShellCommands(CommandContext context) {
        OracleHome oh = context.getFirstTarget(OracleHome.class);
        List<GenericPatch> patches = !OPlan.getInstance().getOPlanEnv().getExecutionMode().equals((Object)ExecutionMode.EM) ? OPlan.getInstance().getOPlanEnv().getPatchesBag().getPatchesForTargetType(CommandUtils.getApplicabilityTargetType(oh.getHomeType())) : CommandUtils.getPatchesByOHOwnerForEM(oh);
        if (patches == null || patches.size() == 0) {
            return null;
        }
        ArrayList<String> cmds = new ArrayList<String>();
        for (GenericPatch patch : patches) {
            String patchLocation = patch.getPatchLocation();
            File artifactFile = new File(patchLocation + "/etc/config/artifact.xml");
            if (!artifactFile.exists()) {
                this.logger.info("artifact.xml not found in " + patch.getPatchLocation());
                continue;
            }
            ArtifactSet artifactSet = ArtifactSet.makeArtifactSet(artifactFile, this.artifactType);
            for (Artifact artifact : artifactSet.getArtifactList(this.artifactTag)) {
                List<String> originalCmds = this.generateShellCommands(artifact);
                if (originalCmds.size() == 0) continue;
                for (String cmd : originalCmds) {
                    cmds.add(this.replaceArtifactCommands(cmd, artifact, context));
                }
            }
        }
        return cmds;
    }

    protected List<String> generateShellCommands(Artifact artifact) {
        ArrayList<String> cmds = new ArrayList<String>();
        for (Command c : this.automationCommands) {
            cmds.add(this.getCmdString(c));
        }
        return cmds;
    }

    private String replaceArtifactCommands(String cmd, Artifact artifact, CommandContext context) {
        Map<String, String> artifactVars = this.getVarMaps();
        artifact.getVars(artifactVars);
        StringBuffer sb = new StringBuffer();
        Matcher m = VariableResolver.PATTERN.matcher(cmd);
        if (!m.find()) {
            return cmd;
        }
        m.reset();
        while (true) {
            if (m.find()) {
                boolean all = m.group(1).length() == 1;
                String targetName = m.group(2);
                boolean fromEnv = false;
                if (m.group(3).length() == 0) {
                    fromEnv = true;
                }
                String propName = m.group(4);
                String property = targetName.equals("Artifact") ? artifact.getParameters().get(propName) : VariableResolver.resolveVariable(targetName, propName, context, all, fromEnv);
                property = Matcher.quoteReplacement(property);
                m.appendReplacement(sb, property);
                continue;
            }
            m.appendTail(sb);
            m = VariableResolver.PATTERN.matcher(sb);
            if (!m.find()) break;
            sb = new StringBuffer();
            m.reset();
        }
        return sb.toString();
    }

    protected Map<String, String> getVarMaps() {
        HashMap<String, String> varMaps = new HashMap<String, String>();
        if (this.artifactVars == null) {
            return varMaps;
        }
        for (ArtifactVars.Var var : this.artifactVars.getVar()) {
            varMaps.put(var.getName(), var.getValue());
        }
        return varMaps;
    }

    protected String getCmdString(Command c) {
        StringBuilder str = new StringBuilder();
        for (Command.EnvVar e : c.getEnvVar()) {
            str.append("export " + e.getName() + "=" + e.getValue() + "; ");
        }
        if (c.getCurrentWorkingDir() != null) {
            str.append("cd " + c.getCurrentWorkingDir() + "; ");
        }
        str.append(this.getSource(c));
        for (String arg : c.getParameter()) {
            str.append(" ").append(arg.trim());
        }
        return str.toString();
    }

    protected String getSource(Command c) {
        return c.getSource().getValue().trim();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Builder
    implements CommandBuilder<ArtifactShellCommand> {
        @Override
        public ArtifactShellCommand getCommand(ActionType a, Strategy s) {
            if (!(a instanceof ArtifactAction) || a.getType() == null || !a.getType().equals("shell")) {
                return null;
            }
            ArtifactShellCommand asc = new ArtifactShellCommand((ArtifactAction)a);
            return asc;
        }
    }
}

