/*
 * Decompiled with CFR 0.152.
 */
package oracle.oplan.sdk.cmdtranslator;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import model.common.AbstractBaseTarget;
import model.common.OracleHome;
import oracle.opatch.system.automation.jaxb.ActionType;
import oracle.opatch.system.automation.jaxb.PatchingPhase;
import oracle.opatch.system.automation.jaxb.Strategy;
import oracle.oplan.sdk.ExecutionMode;
import oracle.oplan.sdk.cmdtranslator.Command;
import oracle.oplan.sdk.cmdtranslator.CommandBuilder;
import oracle.oplan.sdk.cmdtranslator.CommandUtils;
import oracle.oplan.sdk.cmdtranslator.commands.ArtifactShellCommand;
import oracle.oplan.sdk.cmdtranslator.commands.ConfigCompare;
import oracle.oplan.sdk.cmdtranslator.commands.CopyHome;
import oracle.oplan.sdk.cmdtranslator.commands.CopyPatch;
import oracle.oplan.sdk.cmdtranslator.commands.GenericDosCommand;
import oracle.oplan.sdk.cmdtranslator.commands.GenericShellCommand;
import oracle.oplan.sdk.cmdtranslator.commands.ManualActionCommandBuilder;
import oracle.oplan.sdk.cmdtranslator.commands.OPatchApplyCommand;
import oracle.oplan.sdk.cmdtranslator.commands.OPatchCheckSystemSpaceCommand;
import oracle.oplan.sdk.cmdtranslator.commands.OPatchLsinventoryCommand;
import oracle.oplan.sdk.cmdtranslator.commands.OPatchLsinventoryGrepCommand;
import oracle.oplan.sdk.cmdtranslator.commands.OPatchPrereqCommand;
import oracle.oplan.sdk.cmdtranslator.commands.OPatchRollbackCommand;
import oracle.oplan.sdk.cmdtranslator.commands.OPatchVersionCommand;
import oracle.oplan.sdk.cmdtranslator.commands.SimpleDCLICommand;
import oracle.oplan.sdk.graphlib.ConfigGraph;
import oracle.oplan.sdk.oplan.OPlanInternalException;
import oracle.oplan.sdk.oplan.SystemModelUtils;

public class CommandFactory {
    private Logger logger = Logger.getLogger(CommandFactory.class.getName());
    protected List<CommandBuilder> constructables = new ArrayList<CommandBuilder>();

    public CommandFactory() {
        this.constructables.add(new ConfigCompare.Builder());
        this.constructables.add(new CopyPatch.Builder());
        this.constructables.add(new SimpleDCLICommand.Builder(new CopyHome.Builder()));
        this.constructables.add(new SimpleDCLICommand.Builder(new ManualActionCommandBuilder()));
        this.constructables.add(new SimpleDCLICommand.Builder(new OPatchApplyCommand.Builder()));
        this.constructables.add(new SimpleDCLICommand.Builder(new OPatchRollbackCommand.Builder()));
        this.constructables.add(new SimpleDCLICommand.Builder(new OPatchPrereqCommand.Builder()));
        this.constructables.add(new SimpleDCLICommand.Builder(new OPatchLsinventoryCommand.Builder()));
        this.constructables.add(new SimpleDCLICommand.Builder(new OPatchLsinventoryGrepCommand.Builder()));
        this.constructables.add(new SimpleDCLICommand.Builder(new OPatchVersionCommand.Builder()));
        this.constructables.add(new SimpleDCLICommand.Builder(new GenericShellCommand.Builder()));
        this.constructables.add(new GenericDosCommand.Builder());
        this.constructables.add(new SimpleDCLICommand.Builder(new ArtifactShellCommand.Builder()));
        this.constructables.add(new SimpleDCLICommand.Builder(new OPatchCheckSystemSpaceCommand.Builder()));
    }

    public Command getCommand(ActionType action, Strategy s, PatchingPhase automationPhase) {
        this.logger.log(Level.FINEST, "Choosing command for " + action.getClass().getName());
        for (CommandBuilder ac : this.constructables) {
            Object constructed = ac.getCommand(action, s);
            if (constructed == null) continue;
            ((Command)constructed).setPatchingPhase(automationPhase);
            return constructed;
        }
        throw new OPlanInternalException("Unsupported Action Type:" + action.getClass().getName() + " subtype:" + action.getType());
    }

    public boolean includeTargetByVersion(ConfigGraph g, AbstractBaseTarget abt, ExecutionMode exeMode) {
        return true;
    }

    protected boolean decideBasedOnWhilePatchingTargetAttribute(Command command, ConfigGraph g, AbstractBaseTarget abt) {
        Class<? extends AbstractBaseTarget> type = SystemModelUtils.getClassForType(command.getAutomationAction().getWhilePatching());
        if (abt instanceof OracleHome) {
            OracleHome oh = (OracleHome)abt;
            this.logger.log(Level.FINER, "SkipTargetCookie is set on OracleHome target :" + abt + " and while-patching condition(" + command.getAutomationAction().getWhilePatching() + ") is set for step: " + command.getAutomationAction() + " . Going to check all the targets running from OracleHome: " + oh.getInstalledSWComponents());
            for (AbstractBaseTarget dep : oh.getInstalledSWComponents()) {
                if (!CommandUtils.shouldIncludeTargetCosDependantsNotSkipped(command, g, abt, g.getConnectedTargets(dep, type))) continue;
                return true;
            }
            this.logger.log(Level.FINER, "All the targets running from this OracleHome is being skipped as well. Hence do not generate execution step for this target. ");
            return false;
        }
        return CommandUtils.shouldIncludeTargetCosDependantsNotSkipped(command, g, abt, g.getConnectedTargets(abt, type));
    }
}

