/*
 * Decompiled with CFR 0.152.
 */
package oracle.oplan.sdk;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Logger;
import model.SystemInstance;
import model.common.Host;
import oracle.opatch.system.automation.jaxb.Automation;
import oracle.opatch.system.automation.jaxb.DeploymentSubType;
import oracle.opatch.system.automation.jaxb.DeploymentType;
import oracle.opatch.system.automation.jaxb.Operation;
import oracle.opatch.system.automation.jaxb.PhaseType;
import oracle.opatch.system.automation.jaxb.Strategy;
import oracle.oplan.core.automationselection.AutomationSelection;
import oracle.oplan.core.engine.SequencingEngine;
import oracle.oplan.sdk.ExecutionMode;
import oracle.oplan.sdk.OPlanAccess;
import oracle.oplan.sdk.OPlanException;
import oracle.oplan.sdk.exec.api.ExecutionPhase;
import oracle.oplan.sdk.exec.api.ExecutionPlan;
import oracle.oplan.sdk.graphlib.ConfigGraph;
import oracle.oplan.sdk.intg.OPlanIntgFactory;
import oracle.oplan.sdk.oplan.OPlan;
import oracle.oplan.sdk.oplan.OPlanEnv;
import oracle.oplan.sdk.patch.PatchPackagesBag;
import oracle.oplan.sdk.util.OPlanUtils;
import oracle.osysmodel.driver.sdk.productdriver.HostComparatorCreator;
import oracle.osysmodel.driver.sdk.productdriver.LocalInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OPlanFacade {
    final Logger logger = Logger.getLogger(OPlanFacade.class.getName());
    protected final File patchLocation;
    protected final InputStream bundleXMLStream;
    protected final SystemInstance tobePatchedSystemInstance;
    protected final DeploymentType deploymentType;
    protected final DeploymentSubType subType;
    protected final Operation operation;
    protected final Strategy strategy;
    boolean switchBackAfterMigrate = false;
    protected OPlan oplan;
    protected OPlanEnv env;
    protected ConfigGraph configGraph;
    protected ExecutionPlan execPlan;
    protected List<Automation> automations;
    protected Automation usedAutomation;
    boolean selectivePatchingEnabled;
    protected ExecutionMode exeMode = ExecutionMode.EM;
    protected PatchPackagesBag patchesBag;
    protected OPlanIntgFactory oplanIntgFactory;
    private OPlanAccess oplanAccess = null;
    boolean init = false;

    OPlanFacade(OPlanIntgFactory oplanIntgFactory, SystemInstance tobePatchedSystemInstance, PatchPackagesBag patchesBag, DeploymentType deploymentType, DeploymentSubType subType, Operation operation, Strategy strategy, boolean switchBackAfterMigrate, ExecutionMode exeMode, OPlanAccess oplanAccess) {
        assert (tobePatchedSystemInstance != null);
        assert (patchesBag != null);
        assert (deploymentType != null);
        assert (subType != null);
        assert (operation != null);
        assert (strategy != null);
        assert (exeMode != null);
        assert (oplanIntgFactory != null);
        assert (oplanAccess != null);
        this.tobePatchedSystemInstance = tobePatchedSystemInstance;
        this.patchesBag = patchesBag;
        this.deploymentType = deploymentType;
        this.subType = subType;
        this.operation = operation;
        this.strategy = strategy;
        this.switchBackAfterMigrate = switchBackAfterMigrate;
        this.exeMode = exeMode;
        this.oplanIntgFactory = oplanIntgFactory;
        this.patchLocation = null;
        this.bundleXMLStream = null;
        this.oplanAccess = oplanAccess;
    }

    public OPlanFacade(File patchLocation, SystemInstance tobePatchedSystemInstance, DeploymentType deploymentType, DeploymentSubType subType, Operation operation, Strategy strategy, Properties props) {
        assert (patchLocation != null);
        assert (tobePatchedSystemInstance != null);
        assert (deploymentType != null);
        assert (subType != null);
        assert (operation != null);
        assert (strategy != null);
        this.patchLocation = patchLocation;
        this.bundleXMLStream = null;
        this.tobePatchedSystemInstance = tobePatchedSystemInstance;
        this.deploymentType = deploymentType;
        this.subType = subType;
        this.operation = operation;
        this.strategy = strategy;
        if (props != null) {
            props.setProperty("Operation", this.operation.value());
            props.setProperty("BundlePatchLocation", patchLocation.getAbsolutePath());
            this.oplan = OPlan.getInstance();
            this.env = this.oplan.getOPlanEnv();
            this.env.setProperties(props);
            this.init = true;
        }
    }

    private synchronized void init() {
        this.init(null);
    }

    private synchronized void init(Properties baseProps) {
        if (this.init) {
            return;
        }
        this.oplan = OPlan.getInstance();
        this.oplan.setRunningStandalone(false);
        this.env = this.oplan.getOPlanEnv();
        this.oplan.getLogger().setupLogs();
        if (null == baseProps) {
            baseProps = new Properties();
        }
        if (this.patchLocation != null) {
            baseProps.setProperty("BundlePatchLocation", this.patchLocation.getAbsolutePath());
        }
        OPlanFacade oPlanFacade = this;
        baseProps.put("OPlanVersion", oPlanFacade.oplan.getVersionInfo());
        baseProps.setProperty("ExecutionMode", this.exeMode.toString());
        baseProps.setProperty("Operation", this.operation.value());
        if (this.exeMode.equals((Object)ExecutionMode.EM)) {
            baseProps.setProperty("UserInvokingOplan", "emgc");
            baseProps.setProperty("SelectivePatchingEnabled", Boolean.toString(this.selectivePatchingEnabled));
        }
        this.env.setProperties(baseProps);
        if (this.patchesBag != null) {
            this.env.setPatchesBag(this.patchesBag);
        } else {
            this.env.setBundleXMLStream(this.bundleXMLStream);
        }
        this.oplan.setOPlanInstgFactory(this.oplanIntgFactory);
        Comparator<Host> hostComparator = this.oplanIntgFactory.getHostComparator();
        HostComparatorCreator.getInstance().setHostComparator(hostComparator);
        this.oplan.setLocalInfo(LocalInfo.getLocalInfoFromSystemInstance((SystemInstance)this.tobePatchedSystemInstance));
        this.oplan.setSystemInstance(this.tobePatchedSystemInstance);
        this.configGraph = this.oplan.getConfigGraph();
        this.init = true;
    }

    public OPlanIntgFactory getOplanIntgFactory() {
        return this.oplanIntgFactory;
    }

    protected OPlan getOPlan() {
        this.init();
        return this.oplan;
    }

    public synchronized ExecutionPlan generateExecutionPlan() throws OPlanAccess.ConfigSupportValidationException, OPlanAccess.PatchSupportValidationException {
        this.init();
        this.oplanAccess.isSupported();
        if (this.execPlan != null) {
            return this.execPlan;
        }
        this.setupAutomationMap();
        Iterator<Automation> iterator = this.automations.iterator();
        if (iterator.hasNext()) {
            Automation auto = iterator.next();
            this.logger.config("Generating execplan for " + OPlanUtils.getAutomationInfo(auto));
            SequencingEngine engine = new SequencingEngine(this.getOPlan().getConfigGraph(this.tobePatchedSystemInstance), auto);
            this.execPlan = engine.getExecutionPlan();
            assert (this.execPlan != null);
            this.logger.config("Generating execplan for " + OPlanUtils.getAutomationInfo(auto));
        }
        this.oplan.getLogger().resetIntegrationLog();
        return this.execPlan;
    }

    public Map<String, String> getPatchingStatusOfOracleHome() {
        return this.oplan.getOPlanEnv().getPatchingStatusOfOracleHome();
    }

    private void setupAutomationMap() {
        if (this.automations != null) {
            return;
        }
        List<Automation> autos = AutomationSelection.selectAutomation(this.deploymentType, this.subType, this.operation, this.strategy);
        if (autos.size() < 1) {
            if (DeploymentSubType.NON_ROLLING_UPGRADE.equals((Object)this.subType)) {
                autos = this.handleNonRollingUpgrade(autos);
            } else {
                throw new OPlanException.UnSupportedPatchException("Did not find any automation.xml for: {" + this.deploymentType + ", " + this.subType + ", " + this.operation + ", " + this.strategy);
            }
        }
        if (autos.size() > 1) {
            throw new OPlanException.UnSupportedPatchException("Found more than one automation XML for : {" + this.deploymentType + ", " + this.subType + ", " + this.operation + ", " + this.strategy + " Automation XMLs: " + autos);
        }
        this.logger.info("Automations found: " + autos);
        this.env.setAutomations(autos);
        Iterator<Automation> iterator = autos.iterator();
        while (iterator.hasNext()) {
            Automation auto;
            this.usedAutomation = auto = iterator.next();
        }
        this.automations = autos;
    }

    private List<Automation> handleNonRollingUpgrade(List<Automation> autos) {
        autos = AutomationSelection.selectAutomation(this.deploymentType, DeploymentSubType.ROLLING_UPGRADE, this.operation, this.strategy);
        if (autos.size() < 1) {
            throw new OPlanException.UnSupportedPatchException("Did not find any automation.xml for: {" + this.deploymentType + ", " + this.subType + ", " + this.operation + ", " + this.strategy);
        }
        if (autos.size() > 1) {
            throw new OPlanException.UnSupportedPatchException("Found more than one automation XML for : {" + this.deploymentType + ", " + this.subType + ", " + this.operation + ", " + this.strategy + " Automation XMLs: " + autos);
        }
        for (Automation auto : autos) {
            this.logger.info("Found a ROLLING_UPGRADE automation, setting it to NON_ROLLING_UPGRADE: " + auto);
            auto.setDeploymentSubType(DeploymentSubType.NON_ROLLING_UPGRADE);
        }
        return autos;
    }

    public synchronized void restoreThreadContext() {
        if (!this.init) {
            return;
        }
        this.getOPlan().restoreThreadContext();
    }

    public synchronized void cleanupThreadContext() {
        if (!this.init) {
            return;
        }
        if (this.getOPlan() != null) {
            this.getOPlan().cleanupThreadContext();
        }
    }

    public ExecutionPlan getExecutionPlan() {
        return this.execPlan;
    }

    public synchronized void writePlanToHTML(File fileToBeWritten) throws IOException {
        DeploymentSubType orig = this.execPlan.getAutomation().getDeploymentSubType();
        this.changeDeploymentSubTypeOfPlanToRolling();
        this.checkAndDeleteFile(fileToBeWritten);
        this.getOPlan().getReadmeFactory().writePlanToHTML(fileToBeWritten, this.execPlan);
        this.restoreDeploymentSubTypeOfPlan(orig);
        this.logger.info("Execution plan serialized to HTML: " + fileToBeWritten);
    }

    public synchronized void writePlanToText(File fileToBeWritten) throws IOException {
        DeploymentSubType orig = this.execPlan.getAutomation().getDeploymentSubType();
        this.changeDeploymentSubTypeOfPlanToRolling();
        this.checkAndDeleteFile(fileToBeWritten);
        this.getOPlan().getReadmeFactory().writePlanToText(fileToBeWritten, this.execPlan);
        this.restoreDeploymentSubTypeOfPlan(orig);
        this.logger.info("Execution plan serialized to Text: " + fileToBeWritten);
    }

    public synchronized void writePlanAsDiffableOutput(File fileToBeWritten) throws IOException {
        DeploymentSubType orig = this.execPlan.getAutomation().getDeploymentSubType();
        this.changeDeploymentSubTypeOfPlanToRolling();
        this.checkAndDeleteFile(fileToBeWritten);
        this.getOPlan().getReadmeFactory().writePlanAsGoldenSteps(fileToBeWritten, this.execPlan);
        this.restoreDeploymentSubTypeOfPlan(orig);
        this.logger.info("Execution plan serialized to diff format: " + fileToBeWritten);
    }

    private void changeDeploymentSubTypeOfPlanToRolling() {
        DeploymentSubType orig = this.execPlan.getAutomation().getDeploymentSubType();
        if (DeploymentSubType.NON_ROLLING_UPGRADE.equals((Object)orig)) {
            this.execPlan.getAutomation().setDeploymentSubType(DeploymentSubType.ROLLING_UPGRADE);
        }
    }

    private void restoreDeploymentSubTypeOfPlan(DeploymentSubType orig) {
        this.execPlan.getAutomation().setDeploymentSubType(orig);
    }

    private void checkAndDeleteFile(File fileToBeWritten) {
        if (fileToBeWritten.exists()) {
            this.logger.info(fileToBeWritten + " already exists. Deleting it before writing a new one.");
            fileToBeWritten.delete();
        }
    }

    public ConfigGraph getConfigGraph() {
        this.init();
        return this.getOPlan().getConfigGraph(this.tobePatchedSystemInstance);
    }

    public SystemInstance getSystemInstance() {
        return this.tobePatchedSystemInstance;
    }

    public List<ExecutionPhase> getExecutionPhasesOfType(PhaseType ... phaseTypes) {
        if (this.execPlan == null) {
            throw new IllegalStateException("This method can be called only after generateExecutionPlan() is called.");
        }
        List<PhaseType> wanted = Arrays.asList(phaseTypes);
        ArrayList<ExecutionPhase> ret = new ArrayList<ExecutionPhase>();
        for (ExecutionPhase ep : this.execPlan.getExecutionPhase()) {
            if (!wanted.contains(ep.getAutomationPatchingPhase().getPhaseType())) continue;
            ret.add(ep);
        }
        return ret;
    }

    public boolean isSwitchBackAfterMigrate() {
        return this.switchBackAfterMigrate;
    }

    protected void finalize() {
        this.cleanupThreadContext();
        this.oplan = null;
    }

    public void setSelectivePatching(boolean isEnabled) {
        if (this.init) {
            throw new IllegalStateException("This method should be called immediately after creating OplanFacade object.");
        }
        this.selectivePatchingEnabled = isEnabled;
    }

    public void setOPlanEnvProperty(String propName, String propValue) {
        this.getOPlan().getOPlanEnv().setProperty(propName, propValue);
    }

    public void setOPatchNapplyOptions(Map<String, String> options) {
        this.getOPlan().getOPlanEnv().setOPatchNapplyOptions(options);
    }

    public void setOPatchRollbackOptions(Map<String, String> options) {
        this.getOPlan().getOPlanEnv().setOPatchRollbackOptions(options);
    }
}

