/*
 * Decompiled with CFR 0.152.
 */
package oracle.oplan.core.readme;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import oracle.oplan.core.readme.HtmlReadmeGenerator;
import oracle.oplan.sdk.exec.api.ExecutionPlan;
import oracle.oplan.sdk.exec.api.ExeuctionPlanUtil;
import oracle.oplan.sdk.readme.ReadmeFactory;
import oracle.oplan.sdk.resource.OPlanBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HtmlMultiReadmeGenerator
extends HtmlReadmeGenerator {
    private static final Class c = HtmlMultiReadmeGenerator.class;

    public HtmlMultiReadmeGenerator(ReadmeFactory rf) {
        super(rf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<File> generateReadme() throws IOException {
        ArrayList<File> readmeList = new ArrayList<File>();
        List<Set<String>> splitHostList = this.rf.getSplitHostList();
        for (int i = 0; i < splitHostList.size(); ++i) {
            Set<String> filterHosts = splitHostList.get(i);
            this.setCurrentFilterHosts(filterHosts);
            File readme = null;
            readme = this.rf.isSplit() ? this.getReadmeFile(i + 1) : this.getReadmeFile();
            assert (!readme.isFile());
            this.generateConfigImageFile();
            FileWriter fw = new FileWriter(readme);
            try {
                this.arrangePlansOrder();
                ExecutionPlan singleEP = ExeuctionPlanUtil.first(this.allPlans);
                fw.write("<html>\n");
                this.writeTitleBarTitle(fw, singleEP);
                fw.write("<body onLoad='collapseAll()'>\n");
                this.writeCSS(fw);
                this.writeJS(fw);
                this.writeProductName(fw);
                this.writeTitle(fw, singleEP);
                this.writeTraditionalReadmeNotice(fw);
                this.writeConfigImage(fw, singleEP);
                this.writePlansBlurb(fw, ExeuctionPlanUtil.applyNswitchbacks(this.allPlans));
                this.writePlansBlurb(fw, ExeuctionPlanUtil.rollbacks(this.allPlans));
                this.writeFullPlans(fw, ExeuctionPlanUtil.applyNswitchbacks(this.allPlans));
                this.writeFullPlans(fw, ExeuctionPlanUtil.rollbacks(this.allPlans));
                this.writeTraditionalReadmeBody(fw);
                this.writeCopyRight(fw);
                fw.write("</body>\n");
                fw.write("</html>\n");
            }
            finally {
                fw.close();
            }
            readmeList.add(readme);
        }
        return readmeList;
    }

    protected void writePlansBlurb(FileWriter fw, List<ExecutionPlan> plans) throws IOException {
        if (plans.size() < 1) {
            return;
        }
        String operation = ReadmeFactory.getOperationBundlePropertySuffixKey(plans.get(0));
        String msg = OPlanBundle.getReadmeMessage("AVAILABLE_" + operation + "_STRATEGY", "<h2>", "</h2>");
        fw.write(msg);
        fw.write("<ol>");
        for (ExecutionPlan plan : plans) {
            fw.write("<li>");
            this.writePlanBlurb(fw, plan, true, true);
            fw.write("</li>");
        }
        fw.write("</ol>");
    }

    protected void writeFullPlans(FileWriter fw, List<ExecutionPlan> plans) throws IOException {
        for (ExecutionPlan plan : plans) {
            String prefixHeader = this.rf.getBundleMessagePrefix(plan);
            String titleMesgHeader = OPlanBundle.getPrefixedReadmeMessage(prefixHeader, "TITLE", "", "");
            fw.write("<hr/>");
            String hideShowID = this.makeId("hideShow", plan);
            String buttonID = this.makeId("button", plan);
            fw.write("<h2 id='" + this.makeId(titleMesgHeader, plan) + "'>");
            fw.write(titleMesgHeader);
            fw.write("<input type='button' id='" + buttonID + "' class=\"buttonposition\" onclick=\"toggleDiv('" + hideShowID + "','" + buttonID + "')\" value='Hide Steps'/>");
            fw.write("</h2>");
            fw.write("<script>");
            fw.write("callOnLoad('" + hideShowID + "','" + buttonID + "')");
            fw.write("</script>");
            fw.write("<span id='" + hideShowID + "' class=\"fullPlanSpan\">");
            this.writePlanBlurb(fw, plan, false, false);
            this.writePlanNote(fw, plan);
            this.writeTOC(fw, plan);
            this.writeBody(fw, plan);
            fw.write("</span>");
        }
    }

    @Override
    protected void writePlanStats(FileWriter fw, ExecutionPlan plan) throws IOException {
        List<String> strs = this.rf.getStepsStats(plan, "<b><i>", "</i></b>");
        assert (strs.size() > 1);
        fw.write("<li>");
        fw.write(strs.get(0));
        fw.write("</li>");
        fw.write("<ul>");
        for (int i = 1; i < strs.size(); ++i) {
            fw.write("<li>");
            fw.write(strs.get(i));
            fw.write("</li>");
        }
        fw.write("</ul>");
    }
}

