/*
 * Decompiled with CFR 0.152.
 */
package oracle.oplan.core.oplan;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.StringWriter;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.oplan.sdk.OPlanException;
import oracle.oplan.sdk.oplan.OPlanUserException;
import oracle.oplan.sdk.oplan.PlatformUtils;
import oracle.osysmodel.driver.sdk.productdriver.OUIDriver;

public class IOUtils {
    private Logger logger = Logger.getLogger(IOUtils.class.getName());

    public static void copyOwnerGroup(File src, File dst) {
        Logger logger = Logger.getLogger(IOUtils.class.getName());
        try {
            String ownerSrcFile = OUIDriver.checkFileOwner((File)src);
            String groupSrcFile = OUIDriver.checkFileGroup((File)src);
            logger.config("Copying owner/group: " + ownerSrcFile + "/" + groupSrcFile + "of " + src.getAbsolutePath() + " to " + dst.getAbsolutePath());
            ProcessBuilder chown = new ProcessBuilder(new String[0]);
            chown.command("chown", ownerSrcFile + ":" + groupSrcFile, dst.getAbsolutePath());
            Process ch = chown.start();
            int chown_failed = ch.waitFor();
            if (chown_failed != 0) {
                throw new OPlanUserException("UNABLE_TO_CHANGE_FILE_OWNER", dst.getAbsolutePath());
            }
        }
        catch (InterruptedException e) {
            throw new OPlanException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new OPlanException(e.getMessage(), e);
        }
    }

    @Deprecated
    public static void chmodTo777(File file) {
        Logger logger = Logger.getLogger(IOUtils.class.getName());
        try {
            if (!PlatformUtils.isWindows()) {
                logger.config("Change the permission of the file " + file.getAbsolutePath() + "to 777");
                ProcessBuilder chmod = new ProcessBuilder(new String[0]);
                chmod.command("chmod", "777", file.getAbsolutePath());
                Process ch = chmod.start();
                int chmod_failed = ch.waitFor();
                if (chmod_failed != 0) {
                    throw new OPlanUserException("UNABLE_TO_CHANGE_FILE_PERMISSION", file.getAbsolutePath());
                }
            }
        }
        catch (InterruptedException e) {
            throw new OPlanException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new OPlanException(e.getMessage(), e);
        }
    }

    public static void chmodTo775(File file) {
        Logger logger = Logger.getLogger(IOUtils.class.getName());
        try {
            if (!PlatformUtils.isWindows()) {
                logger.config("Change the permission of the file " + file.getAbsolutePath() + "to 775");
                ProcessBuilder chmod = new ProcessBuilder(new String[0]);
                chmod.command("chmod", "775", file.getAbsolutePath());
                Process ch = chmod.start();
                int chmod_failed = ch.waitFor();
                if (chmod_failed != 0) {
                    throw new OPlanUserException("UNABLE_TO_CHANGE_FILE_PERMISSION", file.getAbsolutePath());
                }
            }
        }
        catch (InterruptedException e) {
            throw new OPlanException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new OPlanException(e.getMessage(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeStream(InputStream is, OutputStream os) throws IOException {
        try {
            byte[] buff = new byte[1024];
            int bytesread = is.read(buff);
            while (bytesread != -1) {
                os.write(buff, 0, bytesread);
                bytesread = is.read(buff);
            }
        }
        finally {
            is.close();
            if (!os.equals(System.out)) {
                os.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static StringBuffer getContent(InputStream is) throws IOException {
        InputStreamReader isr = new InputStreamReader(is);
        StringWriter sw = new StringWriter();
        char[] buff = new char[1024];
        int len = 0;
        try {
            while ((len = isr.read(buff, 0, buff.length)) != -1) {
                sw.write(buff, 0, len);
            }
        }
        finally {
            sw.close();
            isr.close();
        }
        return sw.getBuffer();
    }

    public static void copyStream(InputStream is, OutputStream os) throws IOException {
        IOUtils.writeStream(is, os);
    }

    public static void copyFile(File in, File out) throws IOException {
        IOUtils.copyStream(new FileInputStream(in), new FileOutputStream(out));
    }

    public static void tryCopyFile(File in, File out) {
        Logger logger = Logger.getLogger(IOUtils.class.getName());
        try {
            IOUtils.copyFile(in, out);
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, "Failed to copy file", e);
        }
    }
}

