/*
 * Decompiled with CFR 0.152.
 */
package oracle.oplan.core.automationselection;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import model.patchmodel.PatchPackage;
import oracle.opatch.system.automation.AutomationHelper;
import oracle.opatch.system.automation.AutomationXMLValidationException;
import oracle.opatch.system.automation.jaxb.Automation;
import oracle.opatch.system.automation.jaxb.DeploymentSubType;
import oracle.opatch.system.automation.jaxb.DeploymentType;
import oracle.opatch.system.automation.jaxb.Operation;
import oracle.opatch.system.automation.jaxb.Strategy;
import oracle.oplan.sdk.intg.OPlanIntgFactory;
import oracle.oplan.sdk.oplan.OPlan;
import oracle.oplan.sdk.oplan.OPlanEnv;
import oracle.oplan.sdk.oplan.OPlanInternalException;
import oracle.oplan.sdk.oplan.OPlanUserException;
import oracle.oplan.sdk.util.OPlanUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AutomationSelection {
    public static Automation URLtoAutomation(URL url) {
        Logger logger = Logger.getLogger(AutomationSelection.class.getName());
        AutomationHelper ah = AutomationHelper.getInstance();
        try {
            InputStream s = url.openStream();
            Automation auto = ah.readAutomation(s, true);
            return auto;
        }
        catch (IOException e) {
            System.out.println("Unable to read automation file:" + url.toString());
            System.out.println(e.getMessage());
            logger.log(Level.CONFIG, "Automation Reading Error", e);
        }
        catch (AutomationXMLValidationException e) {
            System.out.println("Found an invalid automation file:" + url.toString());
            System.out.println("Invalid due to :" + e.getMessage());
            logger.log(Level.CONFIG, "AutomationParsingFailure", e);
        }
        return null;
    }

    private static Automation StringContenttoAutomation(String automationContent) {
        Logger logger = Logger.getLogger(AutomationSelection.class.getName());
        AutomationHelper ah = AutomationHelper.getInstance();
        try {
            Automation auto = ah.readAutomation(automationContent, true);
            return auto;
        }
        catch (AutomationXMLValidationException e) {
            System.out.println("Found an invalid automation because of " + e.getMessage());
            logger.log(Level.CONFIG, "AutomationParsingFailure", e);
            return null;
        }
    }

    public static Map<Automation, URL> selectAutomation() {
        Logger logger = Logger.getLogger(AutomationSelection.class.getName());
        OPlanEnv env = OPlan.getInstance().getOPlanEnv();
        PatchPackage primaryPatch = env.getPatchesBag().getPrimaryPatchPackage();
        ArrayList<Automation> patchAutomations = new ArrayList<Automation>();
        ArrayList<URL> patchAutomationURLs = new ArrayList<URL>();
        HashMap<Automation, URL> patchAuto_map = new HashMap<Automation, URL>();
        if (primaryPatch != null) {
            File automationXmlsLocation;
            logger.log(Level.INFO, "Found primary package at location " + primaryPatch.getPatchLocation());
            if (primaryPatch.getAutomationXmlLocation() != null && primaryPatch.getAutoXmls() != null && !primaryPatch.getAutoXmls().isEmpty() && (automationXmlsLocation = new File(primaryPatch.getAutomationXmlLocation())).exists()) {
                assert (automationXmlsLocation.isDirectory());
                for (File autoxml : automationXmlsLocation.listFiles()) {
                    if (!autoxml.isFile() || !autoxml.getName().contains(".xml")) continue;
                    URL url = null;
                    try {
                        url = autoxml.toURI().toURL();
                        logger.log(Level.INFO, "Found URL of automation.xml in patch " + url.toString());
                    }
                    catch (MalformedURLException e) {
                        logger.log(Level.SEVERE, "Couldn't make a URL out of the automation xml at path " + autoxml.getAbsolutePath());
                    }
                    if (url == null) continue;
                    patchAutomationURLs.add(url);
                    Automation auto = AutomationSelection.URLtoAutomation(url);
                    if (auto == null) continue;
                    patchAutomations.add(AutomationSelection.URLtoAutomation(url));
                    patchAuto_map.put(auto, url);
                }
            }
        }
        HashMap<Automation, URL> oplanAuto_map = new HashMap<Automation, URL>();
        OPlanIntgFactory oplanIntgFactory = OPlan.getInstance().getOPlanIntgFactory();
        ArrayList<Automation> oplanAutomations = new ArrayList<Automation>();
        List<Object> oplanAutomationURLs = new ArrayList();
        oplanAutomationURLs = oplanIntgFactory.getAutomationSetSelection().selectAutomationSetForPatches();
        if (oplanAutomationURLs != null && oplanAutomationURLs.size() > 0) {
            for (int i = 0; i < oplanAutomationURLs.size(); ++i) {
                Automation auto = AutomationSelection.URLtoAutomation((URL)oplanAutomationURLs.get(i));
                if (auto == null) continue;
                oplanAutomations.add(auto);
                oplanAuto_map.put(auto, (URL)oplanAutomationURLs.get(i));
            }
        }
        if (oplanIntgFactory.ifSelectAutomationFilesOnlyFromIntegration()) {
            if (oplanAutomations.size() > 0) {
                return AutomationSelection.selectAutomationHelp(oplanAuto_map, env.getOperation());
            }
            throw new OPlanUserException("INTERGRATION_DID_NOT_PROVIDE_ANY_AUTOMATION", new Object[0]);
        }
        if (patchAutomations.size() > 0 && oplanAutomations.size() > 0) {
            Automation patchAutomation = (Automation)patchAutomations.get(0);
            Automation oplanAutomation = (Automation)oplanAutomations.get(0);
            logger.info("The version of patch automation is " + patchAutomation.getVersion() + ", the version of oplan automation is " + oplanAutomation.getVersion());
            if (AutomationSelection.compareVersion(patchAutomation.getVersion(), oplanAutomation.getVersion()) >= 0) {
                logger.log(Level.INFO, "Selected automation come from patch side.");
                return AutomationSelection.selectAutomationHelp(patchAuto_map, env.getOperation());
            }
        } else if (patchAutomations.size() > 0) {
            logger.log(Level.INFO, "Selected automation come from patch side. The version of patch automation is " + ((Automation)patchAutomations.get(0)).getVersion());
            return AutomationSelection.selectAutomationHelp(patchAuto_map, env.getOperation());
        }
        logger.log(Level.INFO, "Selected automation come from Oplan side.");
        return AutomationSelection.selectAutomationHelp(oplanAuto_map, env.getOperation());
    }

    private static Map<Automation, URL> selectAutomationHelp(HashMap<Automation, URL> auto_map, Operation operation) {
        Logger logger = Logger.getLogger(AutomationSelection.class.getName());
        logger.entering(AutomationSelection.class.getName(), "selectAutomationHelp");
        HashMap<Automation, URL> selectedAuto_map = new HashMap<Automation, URL>();
        File autoDir = OPlan.getInstance().getLogInfo().getAutomationXmlDir();
        for (Map.Entry<Automation, URL> entry : auto_map.entrySet()) {
            Automation auto = entry.getKey();
            URL automationFile = entry.getValue();
            logger.info(OPlanUtils.getAutomationInfo(auto));
            OPlanIntgFactory oplanIntgFactory = OPlan.getInstance().getOPlanIntgFactory();
            oplanIntgFactory.getAutomationSetSelection().addAutomationMap(selectedAuto_map, auto, operation, automationFile, autoDir);
        }
        if (selectedAuto_map.size() == 0) {
            throw new OPlanInternalException("Failed to find an automation supporting the selected operation.");
        }
        logger.exiting(AutomationSelection.class.getName(), "selectAutomationHelp");
        if (logger.isLoggable(Level.FINE)) {
            for (Automation a : selectedAuto_map.keySet()) {
                logger.fine("Selected Automation: " + OPlanUtils.getAutomationInfo(a));
            }
        }
        return selectedAuto_map;
    }

    public static List<Automation> selectAutomation(DeploymentType deploymentType, DeploymentSubType subType, Operation operation, Strategy strategy) {
        Logger logger = Logger.getLogger(AutomationSelection.class.getName());
        PatchPackage primaryPatch = OPlan.getInstance().getOPlanEnv().getPatchesBag().getPrimaryPatchPackage();
        ArrayList<Automation> patchAutomations = new ArrayList<Automation>();
        if (primaryPatch != null) {
            logger.log(Level.INFO, "Found primary package at location " + primaryPatch.getPatchLocation());
            List autoXmls = primaryPatch.getAutoXmls();
            if (autoXmls != null && !autoXmls.isEmpty()) {
                logger.log(Level.CONFIG, "The primary patch contains automationXmls. Hence,using the automations included in the patch instead of the library automation xmls.");
                for (String autoxml : autoXmls) {
                    logger.info("Reading automation xml from the string content");
                    Automation auto = AutomationSelection.StringContenttoAutomation(autoxml);
                    if (auto == null) continue;
                    patchAutomations.add(auto);
                }
            }
        }
        OPlanIntgFactory oplanIntgFactory = OPlan.getInstance().getOPlanIntgFactory();
        List<URL> automationFiles = oplanIntgFactory.getAutomationSetSelection().selectAutomationSetForPatches();
        ArrayList<Automation> oplanAutomations = new ArrayList<Automation>();
        for (URL url : automationFiles) {
            logger.info("Loading automation file: " + url.toString());
            Automation auto = AutomationSelection.URLtoAutomation(url);
            if (auto == null) continue;
            oplanAutomations.add(auto);
        }
        if (patchAutomations.size() == 0 && oplanAutomations.size() == 0) {
            throw new OPlanUserException("PATCH_NOT_SUPPORTED", new Object[0]);
        }
        if (oplanIntgFactory.ifSelectAutomationFilesOnlyFromIntegration()) {
            if (oplanAutomations.size() > 0) {
                return AutomationSelection.selectAutomation(oplanAutomations, deploymentType, subType, operation, strategy);
            }
            throw new OPlanUserException("INTERGRATION_DID_NOT_PROVIDE_ANY_AUTOMATION", new Object[0]);
        }
        if (patchAutomations.size() > 0 && oplanAutomations.size() > 0) {
            Automation patchAutomation = (Automation)patchAutomations.get(0);
            Automation oplanAutomation = (Automation)oplanAutomations.get(0);
            logger.info("The version of patch automation is " + patchAutomation.getVersion() + ", the version of oplan automation is " + oplanAutomation.getVersion());
            if (AutomationSelection.compareVersion(patchAutomation.getVersion(), oplanAutomation.getVersion()) >= 0) {
                return AutomationSelection.selectAutomation(patchAutomations, deploymentType, subType, operation, strategy);
            }
        } else if (patchAutomations.size() > 0) {
            logger.info("The version of patch automation is " + ((Automation)patchAutomations.get(0)).getVersion());
            return AutomationSelection.selectAutomation(patchAutomations, deploymentType, subType, operation, strategy);
        }
        logger.info("choose automation from oplan side.");
        return AutomationSelection.selectAutomation(oplanAutomations, deploymentType, subType, operation, strategy);
    }

    private static List<Automation> selectAutomation(List<Automation> automations, DeploymentType deploymentType, DeploymentSubType subType, Operation operation, Strategy strategy) {
        ArrayList<Automation> selectedAutomations = new ArrayList<Automation>();
        for (int i = 0; i < automations.size(); ++i) {
            Automation auto = automations.get(i);
            if (!auto.getDeploymentType().equals((Object)deploymentType) || !auto.getOperation().equals((Object)operation) || !auto.getStrategy().equals((Object)strategy) || auto.getDeploymentSubType() != null && !auto.getDeploymentSubType().equals((Object)subType)) continue;
            if (auto.getDeploymentSubType() == null) {
                auto.setDeploymentSubType(subType);
            }
            selectedAutomations.add(auto);
            break;
        }
        return selectedAutomations;
    }

    static int compareVersion(String version1, String version2) {
        if (!(version1 != null && version1.trim().length() != 0 || version2 != null && version2.trim().length() != 0)) {
            return 0;
        }
        if (version1 == null || version1.trim().length() == 0) {
            return -1;
        }
        if (version2 == null || version2.trim().length() == 0) {
            return 1;
        }
        String[] versionDigs1 = version1.split("\\.");
        String[] versionDigs2 = version2.split("\\.");
        int minVersionNum = Math.min(versionDigs1.length, versionDigs2.length);
        for (int i = 0; i < minVersionNum; ++i) {
            int versionDig2;
            int versionDig1 = Integer.valueOf(versionDigs1[i]);
            if (versionDig1 > (versionDig2 = Integer.valueOf(versionDigs2[i]).intValue())) {
                return 1;
            }
            if (versionDig1 >= versionDig2) continue;
            return -1;
        }
        return versionDigs1.length - versionDigs2.length;
    }
}

