/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.repository.resolver;

import com.oracle.cie.common.util.StringUtil;
import com.oracle.cie.dependency.mgmt.Artifact;
import com.oracle.cie.dependency.mgmt.Dependency;
import com.oracle.cie.dependency.mgmt.DependencyManagementFactory;
import com.oracle.cie.dependency.mgmt.DependencyManagementHelper;
import com.oracle.cie.dependency.mgmt.Module;
import com.oracle.cie.dependency.mgmt.Version;
import com.oracle.cie.repository.common.NextGenHelper;
import com.oracle.cie.repository.resolver.RepositoryVersionResolverException;
import com.oracle.cie.rest.Repository;
import com.oracle.cie.rest.RestException;
import com.oracle.cie.rest.RestFactory;
import com.oracle.cie.rest.RestHandler;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class RepositoryVersionResolver {
    private static final Logger _log = Logger.getLogger(RepositoryVersionResolver.class.getName());
    private NextGenHelper _nextGenHelper;
    private Repository[] _repositories;
    private List<Module> _overrideModules = new ArrayList<Module>();
    private List<Module> _expandedOverrideDependencies = new ArrayList<Module>();
    private List<Module> _dependencyModules = new ArrayList<Module>();
    private Set<Dependency> _latestDependencies = new LinkedHashSet<Dependency>();
    private List<Module> _nginstOverrideModules = new ArrayList<Module>();
    private boolean _useLatest = false;
    private boolean _enforceDeterministicVersions = false;

    public RepositoryVersionResolver(NextGenHelper nextGenHelper, Repository[] repositories) throws RepositoryVersionResolverException {
        this(nextGenHelper, repositories, null);
    }

    public RepositoryVersionResolver(NextGenHelper nextGenHelper, Repository[] repositories, List<Module> overrideModules) throws RepositoryVersionResolverException {
        this(nextGenHelper, repositories, overrideModules, false);
    }

    public RepositoryVersionResolver(NextGenHelper nextGenHelper, Repository[] repositories, List<Module> overrideModules, boolean useLatest) throws RepositoryVersionResolverException {
        this(nextGenHelper, repositories, overrideModules, useLatest, true);
    }

    public RepositoryVersionResolver(NextGenHelper nextGenHelper, Repository[] repositories, List<Module> overrideModules, boolean useLatest, boolean expandOverrideModules) throws RepositoryVersionResolverException {
        if (nextGenHelper == null) {
            throw new RepositoryVersionResolverException("The next gen helper provided was null.");
        }
        this._nextGenHelper = nextGenHelper;
        this._repositories = repositories != null ? repositories : new Repository[]{};
        this.setOverrideModules(overrideModules, expandOverrideModules);
        this._useLatest = useLatest;
    }

    public NextGenHelper getNextGenHelper() {
        return this._nextGenHelper;
    }

    public RestHandler getRestHandler() {
        return this.getNextGenHelper().getRestHandler();
    }

    public Repository[] getRepositories() {
        return this._repositories;
    }

    public void reset() {
        this._dependencyModules.clear();
        this._latestDependencies.clear();
    }

    public boolean isUseLatest() {
        return this._useLatest;
    }

    public void setUseLatest(boolean useLatest) {
        this._useLatest = useLatest;
    }

    public boolean isEnforceDeterministicVersions() {
        return this._enforceDeterministicVersions;
    }

    public void setEnforceDeterministicVersions(boolean enforceDeterministicVersions) {
        this._enforceDeterministicVersions = enforceDeterministicVersions;
    }

    public List<Module> getOverrideModules() {
        return this._overrideModules;
    }

    public void setOverrideModules(List<Module> overrideModules) throws RepositoryVersionResolverException {
        this.setOverrideModules(overrideModules, true);
    }

    public void setOverrideModules(List<Module> overrideModules, boolean expandOverrideModules) throws RepositoryVersionResolverException {
        if (!this._overrideModules.isEmpty()) {
            this._overrideModules.clear();
            this._expandedOverrideDependencies.clear();
        }
        if (overrideModules != null && !overrideModules.isEmpty()) {
            this._overrideModules.addAll(overrideModules);
            if (expandOverrideModules) {
                this.expandOverrideModules(this._overrideModules);
            }
        }
    }

    private void expandOverrideModules(List<Module> overrideModules) throws RepositoryVersionResolverException {
        if (overrideModules != null && !overrideModules.isEmpty()) {
            ArrayList<String> groups = new ArrayList<String>();
            groups.add("com.oracle.cie.gdr.distribution.dependencies");
            groups.add("com.oracle.cie.gdr.featureset.dependencies");
            ArrayList<String> types = new ArrayList<String>();
            types.add("xml");
            try {
                this._expandedOverrideDependencies.addAll(RestFactory.getRestHelper((RestHandler)this.getNextGenHelper().getRestHandler()).getModulesTransitively(overrideModules, Arrays.asList(this.getRepositories()), groups, types));
            }
            catch (Exception e) {
                throw new RepositoryVersionResolverException(e);
            }
        }
    }

    public void setNextGenInstallerOverrides(List<Module> nginstOverrideModules) {
        this._nginstOverrideModules = nginstOverrideModules;
    }

    public List<Module> getDependencyModules() {
        return this._dependencyModules;
    }

    public void setDependencyModules(List<Module> dependencyModules) {
        this._dependencyModules.clear();
        if (dependencyModules != null) {
            this._dependencyModules.addAll(dependencyModules);
        }
    }

    public void addDependencyModule(Module module) {
        this._dependencyModules.add(module);
    }

    private void addLatestDependency(String group, String name, Version version, String type) {
        if (group != null && name != null && version != null) {
            this.addLatestDependency(DependencyManagementFactory.getInstance().getDependency(group, name, version, type));
        }
    }

    private void addLatestDependency(Dependency dependency) {
        if (dependency != null) {
            this._latestDependencies.add(dependency);
        }
    }

    public Set<Dependency> getLatestDependencies() {
        return this._latestDependencies;
    }

    public Version getVersion(String group, String name, String version) throws RepositoryVersionResolverException, RestException, IOException {
        return this.getVersion(group, name, version, this.isUseLatest());
    }

    public Version getVersion(String group, String name, String version, boolean useLatest) throws RepositoryVersionResolverException, RestException, IOException {
        if ("com.oracle.cie.gdr.distribution".equals(group)) {
            return this.getDistributionVersion(name, version, useLatest);
        }
        if ("com.oracle.cie.gdr.distribution.dependencies".equals(group)) {
            return this.getDistributionDependencyVersion(name, version, useLatest);
        }
        if ("com.oracle.cie.gdr.distribution.info".equals(group)) {
            return this.getDistributionInfoVersion(name, version, useLatest);
        }
        if ("com.oracle.cie.gdr.distribution.resources".equals(group)) {
            return this.getDistributionResourcesVersion(name, version, useLatest);
        }
        if ("com.oracle.cie.gdr.featureset".equals(group)) {
            return this.getFeatureSetVersion(name, version, useLatest);
        }
        if ("com.oracle.cie.gdr.featureset.dependencies".equals(group)) {
            return this.getFeatureSetDependencyVersion(name, version, useLatest);
        }
        if ("com.oracle.cie.gdr.featureset.resources".equals(group)) {
            return this.getFeatureSetResourcesVersion(name, version, useLatest);
        }
        if (group != null && group.startsWith("com.oracle.cie.gdr.carb")) {
            return this.getComponentArchiveVersion(group, name, version, useLatest);
        }
        if ("com.oracle.cie.gdr.carb.info".equals(group)) {
            return this.getComponentInfoVersion(name, version, useLatest);
        }
        if ("com.oracle.cie.gdr.farb".equals(group)) {
            return this.getFeatureArchiveVersion(name, version, useLatest);
        }
        throw new RepositoryVersionResolverException("Unable to resolve version for unknown group value " + group);
    }

    public Version getProductLayersDefinitionVersion(String name, String version) throws RepositoryVersionResolverException, IOException, RestException {
        return this.getProductLayersDefinitionVersion(name, version, this.isUseLatest());
    }

    public Version getProductLayersDefinitionVersion(String name, String version, boolean useLatest) throws RepositoryVersionResolverException, IOException, RestException {
        Version pldVersion = DependencyManagementFactory.getInstance().getVersion(version);
        if (pldVersion.hasQualifier()) {
            int count = pldVersion.getQualifierCount();
            if (count == 2) {
                pldVersion = DependencyManagementFactory.getInstance().getVersion(pldVersion.getBaseVersion(), new String[]{pldVersion.getQualifier(1)});
            } else if (count > 2) {
                throw new RepositoryVersionResolverException("A product layers definition version with more than 2 qualifiers is not supported " + name + " : " + version);
            }
        } else {
            Version tmpVersion = this.getExplicitVersion("com.oracle.cie.gdr.shiphome.layer", name, pldVersion, "json");
            if (tmpVersion != null) {
                pldVersion = tmpVersion;
            } else if (useLatest) {
                pldVersion = this._nextGenHelper.getLatestProductLayersDefinitionVersion(this.getRepositories(), name, version);
                if (pldVersion == null) {
                    throw new RepositoryVersionResolverException("Unable to determine latest version of product layers definition " + name + " : " + version);
                }
                this.addLatestDependency("com.oracle.cie.gdr.shiphome.layer", name, pldVersion, "json");
            } else {
                throw new RepositoryVersionResolverException("Unable to determine version of product layers definition " + name + " : " + version);
            }
        }
        return pldVersion;
    }

    public Artifact getArtifact(String group, String name, String version, boolean useLatest) throws RepositoryVersionResolverException, RestException, IOException {
        if ("com.oracle.cie.gdr.distribution".equals(group)) {
            return this.getDistributionArtifact(name, version, useLatest);
        }
        if ("com.oracle.cie.gdr.distribution.dependencies".equals(group)) {
            return this.getDistributionDependencyArtifact(name, version, useLatest);
        }
        if ("com.oracle.cie.gdr.distribution.info".equals(group)) {
            return this.getDistributionInfoArtifact(name, version, useLatest);
        }
        if ("com.oracle.cie.gdr.distribution.resources".equals(group)) {
            return this.getDistributionResourcesArtifact(name, version, useLatest);
        }
        if ("com.oracle.cie.gdr.featureset".equals(group)) {
            return this.getFeatureSetArtifact(name, version, useLatest);
        }
        if ("com.oracle.cie.gdr.featureset.dependencies".equals(group)) {
            return this.getFeatureSetDependencyArtifact(name, version, useLatest);
        }
        if ("com.oracle.cie.gdr.featureset.resources".equals(group)) {
            return this.getFeatureSetResourcesArtifact(name, version, useLatest);
        }
        if ("com.oracle.cie.gdr.carb.info".equals(group)) {
            return this.getComponentInfoArtifact(name, version, useLatest);
        }
        if ("com.oracle.cie.gdr.patch.carb.info".equals(group)) {
            return this.getPatchComponentInfoArtifact(name, version, useLatest);
        }
        if ("com.oracle.cie.gdr.farb".equals(group)) {
            return this.getFeatureArchiveArtifact(name, version, useLatest);
        }
        if (group != null && group.startsWith("com.oracle.cie.gdr.carb")) {
            return this.getComponentArchiveArtifact(group, name, version, useLatest);
        }
        throw new RepositoryVersionResolverException("Unable to resolve version for unknown group value " + group);
    }

    public Version getDistributionVersion(String name, String version) throws RepositoryVersionResolverException, IOException, RestException {
        return this.getDistributionVersion(name, version, this.isUseLatest());
    }

    public Version getDistributionVersion(String name, String version, boolean useLatest) throws RepositoryVersionResolverException, IOException, RestException {
        Version distVersion = DependencyManagementFactory.getInstance().getVersion(version);
        if (distVersion.hasQualifier()) {
            int count = distVersion.getQualifierCount();
            if (count == 2) {
                distVersion = DependencyManagementFactory.getInstance().getVersion(distVersion.getBaseVersion(), new String[]{distVersion.getQualifier(1)});
            } else if (count > 2) {
                throw new RepositoryVersionResolverException("A distribution version with more than 2 qualifiers is not supported " + name + " : " + version);
            }
        } else {
            Version tmpVersion = this.getExplicitVersion("com.oracle.cie.gdr.distribution", name, distVersion, "xml");
            if (tmpVersion != null) {
                distVersion = tmpVersion;
            } else {
                tmpVersion = this.getExplicitVersion("com.oracle.cie.gdr.distribution.dependencies", name, distVersion, "xml");
                if (tmpVersion != null) {
                    distVersion = DependencyManagementFactory.getInstance().getVersion(tmpVersion.getBaseVersion(), new String[]{tmpVersion.getQualifier(1)});
                } else if (useLatest) {
                    distVersion = this._nextGenHelper.getLatestDistributionVersion(this.getRepositories(), name, version);
                    if (distVersion == null) {
                        throw new RepositoryVersionResolverException("Unable to determine latest version of distribution " + name + " : " + version + " in repository.");
                    }
                    this.addLatestDependency("com.oracle.cie.gdr.distribution", name, distVersion, "xml");
                } else {
                    throw new RepositoryVersionResolverException("Unable to determine version of distribution " + name + " : " + version + " in repository. Please make sure the distribution has been published in the repository.");
                }
            }
        }
        return distVersion;
    }

    public Artifact getDistributionArtifact(String name, String version) throws RepositoryVersionResolverException, IOException, RestException {
        return this.getDistributionArtifact(name, version, this.isUseLatest());
    }

    public Artifact getDistributionArtifact(String name, String version, boolean useLatest) throws RepositoryVersionResolverException, IOException, RestException {
        Version distVersion = this.getDistributionVersion(name, version, useLatest);
        return distVersion != null ? DependencyManagementFactory.getInstance().getArtifact("com.oracle.cie.gdr.distribution", name, distVersion, "xml") : null;
    }

    public Version getDistributionDependencyVersion(String name, String version) throws RepositoryVersionResolverException, IOException, RestException {
        return this.getDistributionDependencyVersion(name, version, this.isUseLatest());
    }

    public Version getDistributionDependencyVersion(String name, String version, boolean useLatest) throws RepositoryVersionResolverException, IOException, RestException {
        return this.getDistributionDependencyVersion(name, version, useLatest, true);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Version getDistributionDependencyVersion(String name, String version, boolean useLatest, boolean addLatestDependency) throws RepositoryVersionResolverException, IOException, RestException {
        Version distDepsVersion = DependencyManagementFactory.getInstance().getVersion(version);
        int count = distDepsVersion.getQualifierCount();
        if (count == 0 || count == 1) {
            Version distVersion = count == 1 ? distDepsVersion : this.getDistributionVersion(name, version);
            distDepsVersion = this.getExplicitVersion("com.oracle.cie.gdr.distribution.dependencies", name, distVersion, "xml");
            if (distDepsVersion != null) return distDepsVersion;
            if (!useLatest) throw new RepositoryVersionResolverException("Unable to determine version of distribution dependency module " + name + " : " + version);
            distDepsVersion = this._nextGenHelper.getLatestDistributionDependenciesVersion(this.getRepositories(), name, distVersion.getBaseVersion(), distVersion.getQualifier(1));
            if (distDepsVersion == null) {
                throw new RepositoryVersionResolverException("Unable to determine latest version of distribution dependency module " + name + " : " + version);
            }
            if (!addLatestDependency) return distDepsVersion;
            this.addLatestDependency("com.oracle.cie.gdr.distribution.dependencies", name, distDepsVersion, "xml");
            return distDepsVersion;
        } else {
            if (count <= 2) return distDepsVersion;
            throw new RepositoryVersionResolverException("A distribution dependency module version with more than 2 qualifiers is not supported " + name + " : " + version);
        }
    }

    public Artifact getDistributionDependencyArtifact(String name, String version) throws RepositoryVersionResolverException, IOException, RestException {
        return this.getDistributionDependencyArtifact(name, version, this.isUseLatest());
    }

    public Artifact getDistributionDependencyArtifact(String name, String version, boolean useLatest) throws RepositoryVersionResolverException, IOException, RestException {
        return this.getDistributionDependencyArtifact(name, version, useLatest, true);
    }

    public Artifact getDistributionDependencyArtifact(String name, String version, boolean useLatest, boolean addLatestDependency) throws RepositoryVersionResolverException, IOException, RestException {
        Version distDepsVersion = this.getDistributionDependencyVersion(name, version, useLatest, addLatestDependency);
        return distDepsVersion != null ? DependencyManagementFactory.getInstance().getArtifact("com.oracle.cie.gdr.distribution.dependencies", name, distDepsVersion, "xml") : null;
    }

    public Version getDistributionInfoVersion(String name, String version) throws RepositoryVersionResolverException, IOException, RestException {
        return this.getDistributionInfoVersion(name, version, this.isUseLatest());
    }

    public Version getDistributionInfoVersion(String name, String version, boolean useLatest) throws RepositoryVersionResolverException, IOException, RestException {
        Version distInfoVersion = DependencyManagementFactory.getInstance().getVersion(version);
        if (distInfoVersion.hasQualifier()) {
            if (distInfoVersion.getQualifierCount() > 1) {
                throw new RepositoryVersionResolverException("A distribution info version with more than 1 qualifier is not supported " + name + " : " + version);
            }
        } else if ((distInfoVersion = this.getExplicitVersion("com.oracle.cie.gdr.distribution.info", name, distInfoVersion, "xml")) == null) {
            if (useLatest) {
                distInfoVersion = this._nextGenHelper.getLatestDistributionInfoVersion(this.getRepositories(), name, version);
                if (distInfoVersion == null) {
                    throw new RepositoryVersionResolverException("Unable to determine latest version of distribution info " + name + " : " + version);
                }
                this.addLatestDependency("com.oracle.cie.gdr.distribution.info", name, distInfoVersion, "xml");
            } else {
                throw new RepositoryVersionResolverException("Unable to determine version of distribution info " + name + " : " + version);
            }
        }
        return distInfoVersion;
    }

    public Artifact getDistributionInfoArtifact(String name, String version) throws RepositoryVersionResolverException, IOException, RestException {
        return this.getDistributionInfoArtifact(name, version, this.isUseLatest());
    }

    public Artifact getDistributionInfoArtifact(String name, String version, boolean useLatest) throws RepositoryVersionResolverException, IOException, RestException {
        Version distInfoVersion = this.getDistributionInfoVersion(name, version, useLatest);
        return distInfoVersion != null ? DependencyManagementFactory.getInstance().getArtifact("com.oracle.cie.gdr.distribution.info", name, distInfoVersion, "xml") : null;
    }

    public Version getDistributionCompatibilityVersion(String name, String version) throws RepositoryVersionResolverException, IOException, RestException {
        return this.getDistributionCompatibilityVersion(name, version, this.isUseLatest());
    }

    public Version getDistributionCompatibilityVersion(String name, String version, boolean useLatest) throws RepositoryVersionResolverException, IOException, RestException {
        Version distCompatVersion = DependencyManagementFactory.getInstance().getVersion(version);
        if (distCompatVersion.hasQualifier()) {
            if (distCompatVersion.getQualifierCount() > 1) {
                throw new RepositoryVersionResolverException("A distribution compatibility version with more than 1 qualifier is not supported " + name + " : " + version);
            }
        } else if ((distCompatVersion = this.getExplicitVersion("com.oracle.cie.gdr.distribution.compatibility", name, distCompatVersion, "xml")) == null) {
            if (useLatest) {
                distCompatVersion = this._nextGenHelper.getLatestDistributionCompatibilityVersion(this.getRepositories(), name, version);
                if (distCompatVersion == null) {
                    throw new RepositoryVersionResolverException("Unable to determine latest version of distribution compatibility " + name + " : " + version);
                }
                this.addLatestDependency("com.oracle.cie.gdr.distribution.compatibility", name, distCompatVersion, "xml");
            } else {
                throw new RepositoryVersionResolverException("Unable to determine version of distribution compatibility " + name + " : " + version);
            }
        }
        return distCompatVersion;
    }

    public Version getDistributionResourcesVersion(String name, String version) throws RepositoryVersionResolverException, IOException, RestException {
        return this.getDistributionResourcesVersion(name, version, this.isUseLatest());
    }

    public Version getDistributionResourcesVersion(String name, String version, boolean useLatest) throws RepositoryVersionResolverException, IOException, RestException {
        Version distResourcesVersion = DependencyManagementFactory.getInstance().getVersion(version);
        if (distResourcesVersion.hasQualifier()) {
            if (distResourcesVersion.getQualifierCount() > 1) {
                throw new RepositoryVersionResolverException("A distribution resources version with more than 1 qualifier is not supported " + name + " : " + version);
            }
        } else if ((distResourcesVersion = this.getExplicitVersion("com.oracle.cie.gdr.distribution.resources", name, distResourcesVersion, "jar")) == null) {
            if (useLatest) {
                distResourcesVersion = this._nextGenHelper.getLatestDistributionResourceVersion(this.getRepositories(), name, version);
                if (distResourcesVersion == null) {
                    throw new RepositoryVersionResolverException("Unable to determine latest version of distribution resources " + name + " : " + version);
                }
                this.addLatestDependency("com.oracle.cie.gdr.distribution.resources", name, distResourcesVersion, "jar");
            } else {
                throw new RepositoryVersionResolverException("Unable to determine version of distribution resources " + name + " : " + version);
            }
        }
        return distResourcesVersion;
    }

    public Artifact getDistributionResourcesArtifact(String name, String version) throws RepositoryVersionResolverException, IOException, RestException {
        return this.getDistributionResourcesArtifact(name, version, this.isUseLatest());
    }

    public Artifact getDistributionResourcesArtifact(String name, String version, boolean useLatest) throws RepositoryVersionResolverException, IOException, RestException {
        Version distResourcesVersion = this.getDistributionResourcesVersion(name, version, useLatest);
        return distResourcesVersion != null ? DependencyManagementFactory.getInstance().getArtifact("com.oracle.cie.gdr.distribution.resources", name, distResourcesVersion, "jar") : null;
    }

    public Version getFeatureSetVersion(String name, String version) throws RepositoryVersionResolverException, IOException, RestException {
        return this.getFeatureSetVersion(name, version, this.isUseLatest());
    }

    public Version getFeatureSetVersion(String name, String version, boolean useLatest) throws RepositoryVersionResolverException, IOException, RestException {
        Version featureVersion = DependencyManagementFactory.getInstance().getVersion(version);
        if (featureVersion.hasQualifier()) {
            int count = featureVersion.getQualifierCount();
            if (count == 2) {
                featureVersion = DependencyManagementFactory.getInstance().getVersion(featureVersion.getBaseVersion(), new String[]{featureVersion.getQualifier(1)});
            } else if (count > 2) {
                throw new RepositoryVersionResolverException("A feature set version with more than 2 qualifiers is not supported " + name + " : " + version);
            }
        } else {
            Version tmpVersion = this.getExplicitVersion("com.oracle.cie.gdr.featureset", name, featureVersion, "xml");
            if (tmpVersion != null) {
                featureVersion = tmpVersion;
            } else {
                tmpVersion = this.getExplicitVersion("com.oracle.cie.gdr.featureset.dependencies", name, featureVersion, "xml");
                if (tmpVersion != null) {
                    featureVersion = DependencyManagementFactory.getInstance().getVersion(tmpVersion.getBaseVersion(), new String[]{tmpVersion.getQualifier(1)});
                } else if (useLatest) {
                    featureVersion = this._nextGenHelper.getLatestFeatureSetVersion(this.getRepositories(), name, version);
                    if (featureVersion == null) {
                        throw new RepositoryVersionResolverException("Unable to determine latest version of feature set " + name + " : " + version);
                    }
                    this.addLatestDependency("com.oracle.cie.gdr.featureset", name, featureVersion, "xml");
                } else {
                    throw new RepositoryVersionResolverException("Unable to determine version of feature set " + name + " : " + version);
                }
            }
        }
        return featureVersion;
    }

    public Artifact getFeatureSetArtifact(String name, String version) throws RepositoryVersionResolverException, IOException, RestException {
        return this.getFeatureSetArtifact(name, version, this.isUseLatest());
    }

    public Artifact getFeatureSetArtifact(String name, String version, boolean useLatest) throws RepositoryVersionResolverException, IOException, RestException {
        Version featureVersion = this.getFeatureSetVersion(name, version, useLatest);
        return featureVersion != null ? DependencyManagementFactory.getInstance().getArtifact("com.oracle.cie.gdr.featureset", name, featureVersion, "xml") : null;
    }

    public Artifact getFeatureArchiveArtifact(String name, String version) throws RepositoryVersionResolverException, IOException, RestException {
        return this.getFeatureArchiveArtifact(name, version, this.isUseLatest());
    }

    public Artifact getFeatureArchiveArtifact(String name, String version, boolean useLatest) throws RepositoryVersionResolverException, IOException, RestException {
        Version featureVersion = this.getFeatureArchiveVersion(name, version, useLatest);
        return featureVersion != null ? DependencyManagementFactory.getInstance().getArtifact("com.oracle.cie.gdr.farb", name, featureVersion, "farb") : null;
    }

    public Version getFeatureSetDependencyVersion(String name, String version) throws RepositoryVersionResolverException, IOException, RestException {
        return this.getFeatureSetDependencyVersion(name, version, this.isUseLatest());
    }

    public Version getFeatureSetDependencyVersion(String name, String version, boolean useLatest) throws RepositoryVersionResolverException, IOException, RestException {
        return this.getFeatureSetDependencyVersion(name, version, useLatest, true);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Version getFeatureSetDependencyVersion(String name, String version, boolean useLatest, boolean addLatestDependency) throws RepositoryVersionResolverException, IOException, RestException {
        Version featureDepsVersion = DependencyManagementFactory.getInstance().getVersion(version);
        int count = featureDepsVersion.getQualifierCount();
        if (count == 0 || count == 1) {
            Version featureVersion = count == 1 ? featureDepsVersion : this.getFeatureSetVersion(name, version);
            featureDepsVersion = this.getExplicitVersion("com.oracle.cie.gdr.featureset.dependencies", name, featureVersion, "xml");
            if (featureDepsVersion != null) return featureDepsVersion;
            if (!useLatest) throw new RepositoryVersionResolverException("Unable to determine version of feature set dependency module " + name + " : " + version);
            featureDepsVersion = this._nextGenHelper.getLatestFeatureSetDependenciesVersion(this.getRepositories(), name, featureVersion.getBaseVersion(), featureVersion.getQualifier(1));
            if (featureDepsVersion == null) {
                throw new RepositoryVersionResolverException("Unable to determine latest version of feature set dependency module " + name + " : " + version);
            }
            if (!addLatestDependency) return featureDepsVersion;
            this.addLatestDependency("com.oracle.cie.gdr.featureset.dependencies", name, featureDepsVersion, "xml");
            return featureDepsVersion;
        } else {
            if (count <= 2) return featureDepsVersion;
            throw new RepositoryVersionResolverException("A feature set dependency module version with more than 2 qualifiers is not supported " + name + " : " + version);
        }
    }

    public Artifact getFeatureSetDependencyArtifact(String name, String version) throws RepositoryVersionResolverException, IOException, RestException {
        return this.getFeatureSetDependencyArtifact(name, version, this.isUseLatest());
    }

    public Artifact getFeatureSetDependencyArtifact(String name, String version, boolean useLatest) throws RepositoryVersionResolverException, IOException, RestException {
        return this.getFeatureSetDependencyArtifact(name, version, useLatest, true);
    }

    public Artifact getFeatureSetDependencyArtifact(String name, String version, boolean useLatest, boolean addLatestDependency) throws RepositoryVersionResolverException, IOException, RestException {
        Version featureDepsVersion = this.getFeatureSetDependencyVersion(name, version, useLatest, addLatestDependency);
        return featureDepsVersion != null ? DependencyManagementFactory.getInstance().getArtifact("com.oracle.cie.gdr.featureset.dependencies", name, featureDepsVersion, "xml") : null;
    }

    public Version getFeatureSetResourcesVersion(String name, String version) throws RepositoryVersionResolverException, IOException, RestException {
        return this.getFeatureSetResourcesVersion(name, version, this.isUseLatest());
    }

    public Version getFeatureSetResourcesVersion(String name, String version, boolean useLatest) throws RepositoryVersionResolverException, IOException, RestException {
        Version featureResourcesVersion = DependencyManagementFactory.getInstance().getVersion(version);
        if (featureResourcesVersion.hasQualifier()) {
            if (featureResourcesVersion.getQualifierCount() > 1) {
                throw new RepositoryVersionResolverException("A feature set resources version with more than 1 qualifier is not supported " + name + " : " + version);
            }
        } else if ((featureResourcesVersion = this.getExplicitVersion("com.oracle.cie.gdr.featureset.resources", name, featureResourcesVersion, "jar")) == null) {
            if (useLatest) {
                featureResourcesVersion = this._nextGenHelper.getLatestFeatureSetResourceVersion(this.getRepositories(), name, version);
                if (featureResourcesVersion == null) {
                    _log.warning("Unable to determine latest version of feature set resources " + name + " : " + version);
                } else {
                    this.addLatestDependency("com.oracle.cie.gdr.featureset.resources", name, featureResourcesVersion, "jar");
                }
            } else {
                throw new RepositoryVersionResolverException("Unable to determine version of feature set resources " + name + " : " + version);
            }
        }
        return featureResourcesVersion;
    }

    public Artifact getFeatureSetResourcesArtifact(String name, String version) throws RepositoryVersionResolverException, IOException, RestException {
        return this.getFeatureSetResourcesArtifact(name, version, this.isUseLatest());
    }

    public Artifact getFeatureSetResourcesArtifact(String name, String version, boolean useLatest) throws RepositoryVersionResolverException, IOException, RestException {
        Version featureResourcesVersion = this.getFeatureSetResourcesVersion(name, version, useLatest);
        return featureResourcesVersion != null ? DependencyManagementFactory.getInstance().getArtifact("com.oracle.cie.gdr.featureset.resources", name, featureResourcesVersion, "jar") : null;
    }

    public boolean featureSetQualifierExist(String name, String version) throws RepositoryVersionResolverException, RestException, IOException {
        Version featureVersion = DependencyManagementFactory.getInstance().getVersion(version);
        if (featureVersion.hasQualifier()) {
            int count = featureVersion.getQualifierCount();
            if (count == 2) {
                return true;
            }
            if (count > 2) {
                throw new RepositoryVersionResolverException("A feature set version with more than 2 qualifiers is not supported " + name + " : " + version);
            }
        } else {
            Version tmpVersion = this.getExplicitVersion("com.oracle.cie.gdr.featureset", name, featureVersion, "xml");
            if (tmpVersion != null) {
                return true;
            }
            tmpVersion = this.getExplicitVersion("com.oracle.cie.gdr.featureset.dependencies", name, featureVersion, "xml");
            if (tmpVersion != null) {
                return true;
            }
            if (this.isUseLatest() && (featureVersion = this._nextGenHelper.getLatestFeatureSetVersion(this.getRepositories(), name, version)) != null) {
                return true;
            }
        }
        return false;
    }

    public Version getComponentArchiveVersion(String name, String version) throws RepositoryVersionResolverException, IOException, RestException {
        return this.getComponentArchiveVersion(name, version, this.isUseLatest());
    }

    public Version getComponentArchiveVersion(String name, String version, boolean useLatest) throws RepositoryVersionResolverException, IOException, RestException {
        return this.getComponentArchiveVersion("com.oracle.cie.gdr.carb", name, version, useLatest);
    }

    public Version getComponentArchiveVersion(String groupId, String name, String version) throws RepositoryVersionResolverException, IOException, RestException {
        return this.getComponentArchiveVersion(groupId, name, version, this.isUseLatest());
    }

    public Version getComponentArchiveVersion(String groupId, String name, String version, boolean useLatest) throws RepositoryVersionResolverException, IOException, RestException {
        Version carbVersion;
        if (StringUtil.isNullOrEmpty((String)groupId, (boolean)true)) {
            groupId = "com.oracle.cie.gdr.carb";
        }
        if (!(carbVersion = DependencyManagementFactory.getInstance().getVersion(version)).hasQualifier() && (carbVersion = this.getExplicitVersion(groupId, name, carbVersion, "carb")) == null) {
            if (useLatest) {
                carbVersion = this._nextGenHelper.getLatestComponentVersion(this.getRepositories(), groupId, name, version);
                if (carbVersion == null) {
                    throw new RepositoryVersionResolverException("Unable to determine latest version of component archive " + name + " : " + version);
                }
                this.addLatestDependency(groupId, name, carbVersion, "carb");
            } else {
                throw new RepositoryVersionResolverException("Unable to determine version of component archive " + name + " : " + version);
            }
        }
        return carbVersion;
    }

    public Artifact getComponentArchiveArtifact(String groupId, String name, String version) throws IOException, RestException, RepositoryVersionResolverException {
        return this.getComponentArchiveArtifact(groupId, name, version, this.isUseLatest());
    }

    public Artifact getComponentArchiveArtifact(String groupId, String name, String version, boolean useLatest) throws RestException, IOException, RepositoryVersionResolverException {
        Version carbVersion = this.getComponentArchiveVersion(groupId, name, version, useLatest);
        return carbVersion != null ? DependencyManagementFactory.getInstance().getArtifact(groupId, name, carbVersion, "carb") : null;
    }

    public Version getComponentInfoVersion(String name, String version) throws RepositoryVersionResolverException, IOException, RestException {
        return this.getComponentInfoVersion(name, version, this.isUseLatest());
    }

    public Version getComponentInfoVersion(String name, String version, boolean useLatest) throws RepositoryVersionResolverException, IOException, RestException {
        Version compInfoVersion = DependencyManagementFactory.getInstance().getVersion(version);
        if (!compInfoVersion.hasQualifier() && (compInfoVersion = this.getExplicitVersion("com.oracle.cie.gdr.carb.info", name, compInfoVersion, "xml")) == null) {
            if (useLatest) {
                compInfoVersion = this._nextGenHelper.getLatestComponentInfoVersion(this.getRepositories(), name, version);
                if (compInfoVersion == null) {
                    throw new RepositoryVersionResolverException("Unable to determine latest version of component info " + name + " : " + version);
                }
                this.addLatestDependency("com.oracle.cie.gdr.carb.info", name, compInfoVersion, "xml");
            } else {
                throw new RepositoryVersionResolverException("Unable to determine version of component info " + name + " : " + version);
            }
        }
        return compInfoVersion;
    }

    public Artifact getComponentInfoArtifact(String name, String version) throws RepositoryVersionResolverException, IOException, RestException {
        return this.getComponentInfoArtifact(name, version, this.isUseLatest());
    }

    public Artifact getComponentInfoArtifact(String name, String version, boolean useLatest) throws RepositoryVersionResolverException, IOException, RestException {
        Version compInfoVersion = this.getComponentInfoVersion(name, version, useLatest);
        return compInfoVersion != null ? DependencyManagementFactory.getInstance().getArtifact("com.oracle.cie.gdr.carb.info", name, compInfoVersion, "xml") : null;
    }

    public Artifact getPatchComponentInfoArtifact(String name, String version) throws RepositoryVersionResolverException, IOException, RestException {
        return this.getPatchComponentInfoArtifact(name, version, this.isUseLatest());
    }

    public Artifact getPatchComponentInfoArtifact(String name, String version, boolean useLatest) throws RepositoryVersionResolverException, IOException, RestException {
        Version compInfoVersion = this.getComponentInfoVersion(name, version, useLatest);
        return compInfoVersion != null ? DependencyManagementFactory.getInstance().getArtifact("com.oracle.cie.gdr.patch.carb.info", name, compInfoVersion, "xml") : null;
    }

    public Version getFeatureArchiveVersion(String name, String version) throws RepositoryVersionResolverException, IOException, RestException {
        return this.getFeatureArchiveVersion(name, version, this.isUseLatest());
    }

    public Version getFeatureArchiveVersion(String name, String version, boolean useLatest) throws RepositoryVersionResolverException, IOException, RestException {
        Version featureArchiveVersion = DependencyManagementFactory.getInstance().getVersion(version);
        if (!featureArchiveVersion.hasQualifier() && (featureArchiveVersion = this.getExplicitVersion("com.oracle.cie.gdr.farb", name, featureArchiveVersion, "farb")) == null) {
            if (useLatest) {
                featureArchiveVersion = this._nextGenHelper.getLatestFeatureArchiveVersion(this.getRepositories(), name, version);
                if (featureArchiveVersion == null) {
                    throw new RepositoryVersionResolverException("Unable to determine latest version of feature archive " + name + " : " + version);
                }
                this.addLatestDependency("com.oracle.cie.gdr.farb", name, featureArchiveVersion, "farb");
            } else {
                throw new RepositoryVersionResolverException("Unable to determine version of feature archive " + name + " : " + version);
            }
        }
        return featureArchiveVersion;
    }

    public Version getMosPatchVersion(String groupId, String name, String version) throws RepositoryVersionResolverException, IOException, RestException {
        return this.getMosPatchVersion(groupId, name, version, this.isUseLatest());
    }

    public Version getMosPatchVersion(String groupId, String name, String version, boolean useLatest) throws RepositoryVersionResolverException, IOException, RestException {
        Version patchVersion = DependencyManagementFactory.getInstance().getVersion(version);
        if (!patchVersion.hasQualifier()) {
            if (patchVersion.isEmptyVersion()) {
                patchVersion = null;
            }
            if ((patchVersion = this.getExplicitVersion(groupId, name, patchVersion, "zip")) == null) {
                if (useLatest) {
                    try {
                        patchVersion = this.getBuildArtifactVersion(groupId, name, null, null, "zip", null);
                    }
                    catch (RepositoryVersionResolverException e) {
                        throw new RepositoryVersionResolverException("Unable to determine latest version of patch " + name + " : " + version, e);
                    }
                    if (patchVersion == null) {
                        throw new RepositoryVersionResolverException("Unable to determine latest version of patch " + name + " : " + version);
                    }
                    this.addLatestDependency(groupId, name, patchVersion, "zip");
                } else {
                    throw new RepositoryVersionResolverException("Unable to determine version of patch " + name + " : " + version);
                }
            }
        }
        return patchVersion;
    }

    public Version getJarVersion(String groupId, String name, String classifier, String version) throws RepositoryVersionResolverException, IOException, RestException {
        return this.getJarVersion(groupId, name, version, classifier, this.isUseLatest());
    }

    public Version getJarVersion(String groupId, String name, String version, String classifier, boolean useLatest) throws RepositoryVersionResolverException, IOException, RestException {
        Version dependencyVersion = DependencyManagementFactory.getInstance().getVersion(version);
        if (!dependencyVersion.hasQualifier()) {
            if (dependencyVersion.isEmptyVersion()) {
                dependencyVersion = null;
            }
            if ((dependencyVersion = this.getExplicitVersion(groupId, name, dependencyVersion, "jar")) == null) {
                if (useLatest) {
                    dependencyVersion = this.getBuildArtifactVersion(groupId, name, null, null, "jar", classifier);
                    if (dependencyVersion == null) {
                        throw new RepositoryVersionResolverException("Unable to determine latest version of jar " + name + " : " + version);
                    }
                    this.addLatestDependency(groupId, name, dependencyVersion, "jar");
                } else {
                    throw new RepositoryVersionResolverException("Unable to determine version of jar " + name + " : " + version);
                }
            }
        }
        return dependencyVersion;
    }

    public Version getNextGenInstallVersion() throws RepositoryVersionResolverException, IOException, RestException {
        return this.getNextGenInstallVersion(null);
    }

    public Version getNextGenInstallVersion(String version) throws RepositoryVersionResolverException, IOException, RestException {
        return this.getNextGenInstallVersion(version, this.isUseLatest());
    }

    public Version getNextGenInstallVersion(String version, boolean useLatest) throws RepositoryVersionResolverException, IOException, RestException {
        Version nginstVersion;
        Version version2 = nginstVersion = version != null ? DependencyManagementFactory.getInstance().getVersion(version) : null;
        if (nginstVersion != null) {
            if (!nginstVersion.hasQualifier()) {
                nginstVersion = this.getExplicitVersion("com.oracle.cie", "nginst", nginstVersion, "jar", "bin", this._nginstOverrideModules);
            } else if (nginstVersion.getQualifierCount() > 1) {
                throw new RepositoryVersionResolverException("An nginst version with more than 1 qualifier is not supported : " + version);
            }
        } else {
            nginstVersion = this.getExplicitVersion("com.oracle.cie", "nginst", null, "jar", "bin", this._nginstOverrideModules);
        }
        if (nginstVersion == null) {
            if (useLatest) {
                nginstVersion = this._nextGenHelper.getLatestNginstVersion(this.getRepositories());
                if (nginstVersion == null) {
                    throw new RepositoryVersionResolverException("Unable to determine latest version of nginst : " + version);
                }
                Dependency dependency = DependencyManagementFactory.getInstance().getDependency("com.oracle.cie", "nginst", nginstVersion, "jar");
                dependency.setClassifier("bin");
                this.addLatestDependency(dependency);
            } else {
                throw new RepositoryVersionResolverException("Unable to determine version of nginst : " + version);
            }
        }
        return nginstVersion;
    }

    public Version getBuildArtifactVersion(String group, String name, String baseVersionStr, String type) throws RepositoryVersionResolverException, IOException, RestException {
        return this.getBuildArtifactVersion(group, name, null, baseVersionStr, type, null, this.isUseLatest());
    }

    public Version getBuildArtifactVersion(String group, String name, String versionStr, String baseVersionStr, String type, String classifier) throws RepositoryVersionResolverException, IOException, RestException {
        return this.getBuildArtifactVersion(group, name, versionStr, baseVersionStr, type, classifier, this.isUseLatest());
    }

    public Version getBuildArtifactVersion(String group, String name, String versionStr, boolean ignoreVersionKeywords, String baseVersionStr, String type, String classifier) throws RepositoryVersionResolverException, IOException, RestException {
        return this.getBuildArtifactVersion(group, name, versionStr, ignoreVersionKeywords, baseVersionStr, type, classifier, this.isUseLatest());
    }

    public Version getBuildArtifactVersion(String group, String name, String versionStr, String baseVersionStr, String type, String classifier, boolean useLatest) throws RepositoryVersionResolverException, IOException, RestException {
        return this.getBuildArtifactVersion(group, name, versionStr, false, baseVersionStr, type, classifier, useLatest);
    }

    public Version getBuildArtifactVersion(String group, String name, String versionStr, boolean ignoreVersionKeywords, String baseVersionStr, String type, String classifier, boolean useLatest) throws RepositoryVersionResolverException, IOException, RestException {
        String qualifier;
        Version version = null;
        if (!StringUtil.isNullOrEmpty((String)versionStr)) {
            version = DependencyManagementFactory.getInstance().getVersion(versionStr);
        }
        Version baseVersion = null;
        if (!StringUtil.isNullOrEmpty((String)baseVersionStr)) {
            baseVersion = DependencyManagementFactory.getInstance().getVersion(baseVersionStr);
        }
        if (_log.isLoggable(Level.FINER)) {
            _log.finer("Processing build artifact with group=" + group + " name=" + name + " version=" + version + " baseVersion=" + baseVersion + " classifier=" + classifier + " type=" + type);
        }
        if (version != null && baseVersion != null) {
            RepositoryVersionResolverException ex = new RepositoryVersionResolverException("The version and baseVersion attributes on a repo artifact are mutually exclusive.");
            _log.throwing(RepositoryVersionResolver.class.getName(), "getBuildArtifactVersion", ex);
            throw ex;
        }
        if (version == null) {
            version = this.getExplicitVersion(group, name, baseVersionStr, type, classifier, null, true);
            if (_log.isLoggable(Level.FINER)) {
                _log.finer("Located version in artifact manifest for artifact with group=" + group + " artifact name=" + name + " version=" + version);
            }
        }
        boolean getLatest = false;
        if (!ignoreVersionKeywords && version != null && ((qualifier = version.getQualifier(1)) != null && "SNAPSHOT".equals(qualifier) || "LATEST".equals(qualifier) || "RELEASE".equals(qualifier))) {
            Artifact artifact = DependencyManagementFactory.getInstance().getArtifact(group, name, version, type);
            if (!StringUtil.isNullOrEmpty((String)classifier, (boolean)true)) {
                artifact.setClassifier(classifier);
            }
            if (!this.getRestHandler().artifactExists(artifact, RestFactory.getRestHandlerConfig().getDefaultCacheRepository())) {
                if ("RELEASE".equals(qualifier)) {
                    version = DependencyManagementFactory.getInstance().getVersion(version.getBaseVersion());
                } else {
                    getLatest = true;
                }
            }
        }
        if (useLatest && version == null || getLatest) {
            Version latestVersion;
            if (baseVersionStr == null) {
                baseVersionStr = version != null ? version.getBaseVersion() : null;
            }
            ArrayList<Repository> repos = new ArrayList<Repository>();
            repos.add(RestFactory.getRestHandlerConfig().getDefaultCacheRepository());
            repos.addAll(Arrays.asList(this.getRepositories()));
            if (_log.isLoggable(Level.FINER)) {
                _log.finer("Attempting to locate latest version for artifact with group=" + group + " artifact name=" + name + " version=" + version + " from repositories " + repos);
            }
            if ((latestVersion = RestFactory.getRestHelper((RestHandler)this.getNextGenHelper().getRestHandler()).getLatestVersion(repos, group, name, baseVersionStr, type)) != null) {
                if (_log.isLoggable(Level.FINER)) {
                    _log.finer("Located latest version in repository for artifact with group=" + group + " artifact name=" + name + " version=" + latestVersion);
                }
                version = latestVersion;
            }
        }
        if (version == null) {
            String v = versionStr != null ? versionStr : baseVersionStr;
            throw new RepositoryVersionResolverException("Unable to determine version of build artifact [" + group + ":" + name + ":" + v + ":" + type + ":" + classifier + "]");
        }
        return version;
    }

    private Version getExplicitVersion(String group, String name, Version version, String type) throws RepositoryVersionResolverException {
        return this.getExplicitVersion(group, name, version, type, null);
    }

    private Version getExplicitVersion(String group, String name, Version version, String type, String classifier) throws RepositoryVersionResolverException {
        String baseVersion = version != null ? version.getBaseVersion() : null;
        String[] qualifiers = version != null ? version.getQualifiers() : null;
        return this.getExplicitVersion(group, name, baseVersion, type, classifier, qualifiers, this.isEnforceDeterministicVersions());
    }

    private Version getExplicitVersion(String group, String name, Version version, String type, String classifier, List<Module> overrideModules) throws RepositoryVersionResolverException {
        Object[] qualifiers;
        String baseVersion = version != null ? version.getBaseVersion() : null;
        Object[] objectArray = qualifiers = version != null ? version.getQualifiers() : null;
        if (overrideModules != null && !overrideModules.isEmpty()) {
            for (Module module : overrideModules) {
                Collection dependencies = DependencyManagementHelper.getFilteredDependencies((Module)module, (String)group, (String)name, (String)baseVersion, (String)type, (String)classifier, (String[])qualifiers);
                if (dependencies == null || dependencies.isEmpty()) continue;
                Dependency dependency = (Dependency)dependencies.iterator().next();
                if (_log.isLoggable(Level.FINER)) {
                    _log.finer("Resolved explicit version [" + dependency.getCoordinateString() + "] from override modules for group [" + group + "] name [" + name + "] baseVersion [" + baseVersion + "] type [" + type + "] classifier [" + classifier + "] qualifiers [" + Arrays.toString(qualifiers) + "]");
                }
                return dependency.getVersion();
            }
        } else {
            return this.getExplicitVersion(group, name, baseVersion, type, classifier, (String[])qualifiers, this.isEnforceDeterministicVersions());
        }
        return null;
    }

    private Version getExplicitVersion(String group, String name, String baseVersion, String type, String classifier, String[] qualifiers, boolean enforceDeterministicVersions) throws RepositoryVersionResolverException {
        Collection dependencies;
        for (Module module : this._overrideModules) {
            dependencies = DependencyManagementHelper.getFilteredDependencies((Module)module, (String)group, (String)name, (String)baseVersion, (String)type, (String)classifier, (String[])qualifiers);
            if (dependencies == null || dependencies.isEmpty()) continue;
            Dependency dependency = (Dependency)dependencies.iterator().next();
            if (_log.isLoggable(Level.FINER)) {
                _log.finer("Resolved explicit version [" + dependency.getCoordinateString() + "] from override modules for group [" + group + "] name [" + name + "] baseVersion [" + baseVersion + "] type [" + type + "] classifier [" + classifier + "] qualifiers [" + Arrays.toString(qualifiers) + "]");
            }
            return dependency.getVersion();
        }
        for (Module module : this._expandedOverrideDependencies) {
            dependencies = DependencyManagementHelper.getFilteredDependencies((Module)module, (String)group, (String)name, (String)baseVersion, (String)type, (String)classifier, (String[])qualifiers);
            if (dependencies == null || dependencies.isEmpty()) continue;
            Dependency dependency = (Dependency)dependencies.iterator().next();
            if (_log.isLoggable(Level.FINER)) {
                _log.finer("Resolved explicit version [" + dependency.getCoordinateString() + "] from expanded override dependencies for group [" + group + "] name [" + name + "] baseVersion [" + baseVersion + "] type [" + type + "] classifier [" + classifier + "] qualifiers [" + Arrays.toString(qualifiers) + "]");
            }
            return dependency.getVersion();
        }
        if (!enforceDeterministicVersions) {
            Collection dependencies2 = DependencyManagementHelper.getFilteredArtifacts(this._latestDependencies, (String)group, (String)name, (String)baseVersion, (String)type, (String)classifier, (String[])qualifiers);
            if (dependencies2 != null && !dependencies2.isEmpty()) {
                Dependency dependency = (Dependency)dependencies2.iterator().next();
                if (_log.isLoggable(Level.FINER)) {
                    _log.finer("Resolved explicit version [" + dependency.getCoordinateString() + "] from latest dependencies for group [" + group + "] name [" + name + "] baseVersion [" + baseVersion + "] type [" + type + "] classifier [" + classifier + "] qualifiers [" + Arrays.toString(qualifiers) + "]");
                }
                return dependency.getVersion();
            }
            for (Module module : this._dependencyModules) {
                dependencies2 = DependencyManagementHelper.getFilteredDependencies((Module)module, (String)group, (String)name, (String)baseVersion, (String)type, (String)classifier, (String[])qualifiers);
                if (dependencies2 == null || dependencies2.isEmpty()) continue;
                Dependency dependency = (Dependency)dependencies2.iterator().next();
                if (_log.isLoggable(Level.FINER)) {
                    _log.finer("Resolved explicit version [" + dependency.getCoordinateString() + "] from dependency modules for group [" + group + "] name [" + name + "] baseVersion [" + baseVersion + "] type [" + type + "] classifier [" + classifier + "] qualifiers [" + Arrays.toString(qualifiers) + "]");
                }
                return dependency.getVersion();
            }
        } else {
            LinkedHashSet allDeps = new LinkedHashSet();
            Collection dependencies3 = DependencyManagementHelper.getFilteredArtifacts(this._latestDependencies, (String)group, (String)name, (String)baseVersion, (String)type, (String)classifier, (String[])qualifiers);
            if (dependencies3 != null && !dependencies3.isEmpty()) {
                if (_log.isLoggable(Level.FINER)) {
                    _log.finer("Resolved explicit version(s) [" + dependencies3 + "] from latest dependencies for group [" + group + "] name [" + name + "] baseVersion [" + baseVersion + "] type [" + type + "] classifier [" + classifier + "] qualifiers [" + Arrays.toString(qualifiers) + "]");
                }
                allDeps.addAll(dependencies3);
            }
            for (Module module : this._dependencyModules) {
                dependencies3 = DependencyManagementHelper.getFilteredDependencies((Module)module, (String)group, (String)name, (String)baseVersion, (String)type, (String)classifier, (String[])qualifiers);
                if (dependencies3 == null || dependencies3.isEmpty()) continue;
                if (_log.isLoggable(Level.FINER)) {
                    _log.finer("Resolved explicit version(s) [" + dependencies3 + "] from dependency modules for group [" + group + "] name [" + name + "] baseVersion [" + baseVersion + "] type [" + type + "] classifier [" + classifier + "] qualifiers [" + Arrays.toString(qualifiers) + "]");
                }
                allDeps.addAll(dependencies3);
            }
            if (!allDeps.isEmpty()) {
                if (allDeps.size() > 1) {
                    throw new RepositoryVersionResolverException("Unable to deterministically resolve version of \"" + group + ":" + name + ":" + baseVersion + "\" because encountered multiple versions for artifact.  To correct this use an explicit override for the artifacts which specifies one of the following coordinates: " + allDeps);
                }
                return ((Dependency)allDeps.iterator().next()).getVersion();
            }
        }
        return null;
    }

    public boolean containsDependencyArtifact(Artifact artifact) {
        if (artifact != null) {
            String group = artifact.getGroup();
            String name = artifact.getName();
            String baseVersion = artifact.getBaseVersion();
            String[] qualifiers = artifact.getQualifiers();
            String type = artifact.getType();
            String classifier = artifact.getClassifier();
            if (StringUtil.isNullOrEmpty((String)type, (boolean)true)) {
                type = "jar";
            }
            if ("com.oracle.cie.gdr.featureset".equals(group)) {
                group = "com.oracle.cie.gdr.featureset.dependencies";
            } else if ("com.oracle.cie.gdr.distribution".equals(group)) {
                group = "com.oracle.cie.gdr.distribution.dependencies";
            }
            for (Module module : this._dependencyModules) {
                if (DependencyManagementHelper.artifactMatches((Artifact)module.getArtifact(), (String)group, (String)name, (String)baseVersion, (String)type, (String)classifier, (String[])new String[]{artifact.getQualifier(1)})) {
                    return true;
                }
                Collection dependencies = DependencyManagementHelper.getFilteredDependencies((Module)module, (String)group, (String)name, (String)baseVersion, (String)type, (String)classifier, (String[])qualifiers);
                if (dependencies == null || dependencies.isEmpty()) continue;
                return true;
            }
        }
        return false;
    }
}

