/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.repository.common.tools;

import com.oracle.cie.common.util.StringUtil;
import com.oracle.cie.dependency.mgmt.Artifact;
import com.oracle.cie.dependency.mgmt.DependencyFileType;
import com.oracle.cie.dependency.mgmt.DependencyManagementException;
import com.oracle.cie.dependency.mgmt.DependencyManagementFactory;
import com.oracle.cie.dependency.mgmt.DependencyManagementHelper;
import com.oracle.cie.dependency.mgmt.Module;
import com.oracle.cie.repository.common.RepositoryUtils;
import com.oracle.cie.repository.common.exceptions.RepositoryCommonException;
import com.oracle.cie.rest.Repository;
import com.oracle.cie.rest.RestFactory;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class BomModuleGenerator {
    private static final Logger _log = Logger.getLogger(BomModuleGenerator.class.getName());
    private Collection<File> _localRepositories;
    private String _destModuleCoordinate;
    private File _destinationRepo;
    private List<String> _additionalDependencyCoordinates;

    public BomModuleGenerator(Collection<File> localRepositories, String destModuleCoordinate, File destinationRepo) {
        this(localRepositories, destModuleCoordinate, destinationRepo, null);
    }

    public BomModuleGenerator(Collection<File> localRepositories, String destModuleCoordinate, File destinationRepo, List<String> additionalDependencyCoordinates) {
        this._localRepositories = localRepositories;
        this._destModuleCoordinate = destModuleCoordinate;
        this._destinationRepo = destinationRepo;
        this._additionalDependencyCoordinates = additionalDependencyCoordinates;
    }

    public void generate() throws RepositoryCommonException {
        Module bomModule;
        if (this._localRepositories == null || this._localRepositories.isEmpty()) {
            throw new RepositoryCommonException("No local repositories were specified for bom pom generation.");
        }
        if (StringUtil.isNullOrEmpty((String)this._destModuleCoordinate, (boolean)true)) {
            throw new RepositoryCommonException("The destination module coordinate was null or empty.");
        }
        if (this._destinationRepo == null) {
            throw new RepositoryCommonException("The destination repository was null.");
        }
        _log.info("Searching for artifacts in " + this._localRepositories);
        DependencyFileType dependencyFileType = DependencyFileType.pom;
        try {
            Artifact artifact = DependencyManagementFactory.getArtifact((String)this._destModuleCoordinate);
            Iterator<String> type = artifact.getType();
            if (!StringUtil.isNullOrEmpty((String)((Object)type), (boolean)true)) {
                try {
                    dependencyFileType = DependencyFileType.valueOf((String)((Object)type));
                }
                catch (IllegalArgumentException e) {
                    throw new RepositoryCommonException("The module type specified is not supported: " + (String)((Object)type), e);
                }
            }
            bomModule = DependencyManagementFactory.getInstance().getModule(artifact.getGroup(), artifact.getName(), artifact.getVersion(), dependencyFileType.name());
        }
        catch (DependencyManagementException e) {
            throw new RepositoryCommonException("Failed to create artifact from destination coordinate: " + this._destModuleCoordinate, e);
        }
        _log.info("The destination module coordinate is " + bomModule.getCoordinateString());
        LinkedHashSet<Artifact> artifacts = new LinkedHashSet<Artifact>();
        for (File localRepository : this._localRepositories) {
            Repository repo = RestFactory.getRepository(null, (String)localRepository.getAbsolutePath(), null, null);
            try {
                artifacts.addAll(DependencyManagementHelper.getArtifacts((Repository)repo));
            }
            catch (Exception e) {
                throw new RepositoryCommonException("Failed to load artifacts from local repository: " + localRepository, e);
            }
        }
        if (this._additionalDependencyCoordinates != null) {
            for (String coordinate : this._additionalDependencyCoordinates) {
                try {
                    artifacts.add(DependencyManagementFactory.getArtifact((String)coordinate));
                }
                catch (DependencyManagementException e) {
                    throw new RepositoryCommonException("Failed to parse additional artifact coordinate: " + coordinate, e);
                }
            }
        }
        bomModule.setDependencies(DependencyManagementHelper.convertToDependencies(artifacts, (boolean)true));
        File destFile = bomModule.getLocalLocation(this._destinationRepo);
        _log.info("Saving bom pom module to " + destFile);
        try {
            DependencyManagementFactory.getInstance().getDependencyFileHandler(dependencyFileType).writeDependenciesFile(bomModule, destFile);
        }
        catch (Exception e) {
            throw new RepositoryCommonException("Failed to save bom pom to " + destFile, e);
        }
    }

    public static void main(String[] args) {
        int retVal = 0;
        LinkedHashMap<String, String> arguments = new LinkedHashMap<String, String>();
        arguments.put("-localRepos", "<localRepoDir1, localRepoDir2, etc...>");
        arguments.put("-destGAV", "<group:name:version:type>");
        arguments.put("-destRepo", "<destRepo>");
        arguments.put("-additionalDeps", "<dependency-coordinates>");
        ArrayList<String> requiredArgs = new ArrayList<String>();
        requiredArgs.add("-localRepos");
        requiredArgs.add("-destGAV");
        requiredArgs.add("-destRepo");
        Map<String, String> parsedArgs = null;
        try {
            parsedArgs = RepositoryUtils.parseCommandLineArgs(args, requiredArgs);
        }
        catch (RepositoryCommonException e) {
            System.out.println(e.getMessage() + "\n");
            BomModuleGenerator.usage(arguments);
            retVal = -1;
        }
        try {
            if (parsedArgs != null) {
                String destRepoStr;
                LinkedHashSet<File> localRepositories = new LinkedHashSet<File>();
                String localReposString = parsedArgs.get("-localRepos");
                if (!StringUtil.isNullOrEmpty((String)localReposString)) {
                    for (String s : localReposString.split(",")) {
                        localRepositories.add(new File(s));
                    }
                }
                File destRepo = StringUtil.isNullOrEmpty((String)(destRepoStr = parsedArgs.get("-destRepo")), (boolean)true) ? null : new File(destRepoStr);
                ArrayList<String> additionalDependencyCoordinates = null;
                String additionalDeps = parsedArgs.get("-additionalDeps");
                if (!StringUtil.isNullOrEmpty((String)additionalDeps, (boolean)true)) {
                    additionalDependencyCoordinates = new ArrayList<String>();
                    for (String coordinate : additionalDeps.split(",")) {
                        additionalDependencyCoordinates.add(coordinate.trim());
                    }
                }
                BomModuleGenerator bomModuleGenerator = new BomModuleGenerator(localRepositories, parsedArgs.get("-destGAV"), destRepo, additionalDependencyCoordinates);
                bomModuleGenerator.generate();
            }
        }
        catch (Exception e) {
            _log.log(Level.SEVERE, "The BOM module generation failed.", e);
            e.printStackTrace();
            retVal = -1;
        }
        System.exit(retVal);
    }

    private static void usage(Map<String, String> arguments) {
        String s = "";
        for (Map.Entry<String, String> arg : arguments.entrySet()) {
            s = s + " " + arg.getKey() + " " + arg.getValue();
        }
        System.out.println("Usage: java " + BomModuleGenerator.class.getName() + s);
    }
}

