/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.repository.common.impl;

import com.oracle.cie.common.util.StringUtil;
import com.oracle.cie.dependency.mgmt.Artifact;
import com.oracle.cie.dependency.mgmt.Dependency;
import com.oracle.cie.dependency.mgmt.DependencyManagementException;
import com.oracle.cie.dependency.mgmt.DependencyManagementFactory;
import com.oracle.cie.dependency.mgmt.Module;
import com.oracle.cie.dependency.mgmt.Version;
import com.oracle.cie.repository.common.NextGenHelper;
import com.oracle.cie.repository.common.RepositoryConvention;
import com.oracle.cie.repository.common.RepositoryUtils;
import com.oracle.cie.repository.common.config.RepoCommonConfig;
import com.oracle.cie.repository.common.exceptions.RepositoryCommonException;
import com.oracle.cie.repository.resolver.RepositoryVersionResolver;
import com.oracle.cie.rest.Repository;
import com.oracle.cie.rest.RestException;
import com.oracle.cie.rest.RestFactory;
import com.oracle.cie.rest.RestHandler;
import com.oracle.cie.rest.RestHelper;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class NextGenHelperImpl
implements NextGenHelper,
RepositoryConvention {
    private RestHandler _restHandler;
    private RestHelper _restHelper;

    public NextGenHelperImpl(RestHandler restHandler) {
        this._restHandler = restHandler;
        this._restHelper = RestFactory.getRestHelper((RestHandler)this._restHandler);
    }

    @Override
    public RestHandler getRestHandler() {
        return this._restHandler;
    }

    @Override
    public Version[] getDistributionVersions(Repository[] repositories, String distributionName, String baseVersion) throws RestException, IOException {
        return this._restHelper.getVersionsArray(repositories, "com.oracle.cie.gdr.distribution", distributionName, baseVersion);
    }

    @Override
    public Version getLatestDistributionVersion(Repository[] repositories, String distributionName, String baseVersion) throws RestException, IOException {
        return this._restHelper.getLatestVersion(repositories, "com.oracle.cie.gdr.distribution", distributionName, baseVersion, "xml");
    }

    @Override
    public Version getLatestDistributionDependenciesVersion(Repository[] repositories, String distributionName, String baseVersion, String qualifier1) throws RestException, IOException {
        return this._restHelper.getLatestVersion(repositories, "com.oracle.cie.gdr.distribution.dependencies", distributionName, baseVersion, "xml", qualifier1);
    }

    @Override
    public Version getLatestDistributionInfoVersion(Repository[] repositories, String distributionName, String baseVersion) throws RestException, IOException {
        return this._restHelper.getLatestVersion(repositories, "com.oracle.cie.gdr.distribution.info", distributionName, baseVersion, "xml");
    }

    @Override
    public Version getLatestDistributionCompatibilityVersion(Repository[] repositories, String distributionName, String baseVersion) throws RestException, IOException {
        return this._restHelper.getLatestVersion(repositories, "com.oracle.cie.gdr.distribution.compatibility", distributionName, baseVersion, "xml");
    }

    @Override
    public Version getLatestDistributionResourceVersion(Repository[] repositories, String distributionName, String baseVersion) throws RestException, IOException {
        return this._restHelper.getLatestVersion(repositories, "com.oracle.cie.gdr.distribution.resources", distributionName, baseVersion, "jar");
    }

    @Override
    public Version[] getFeatureSetVersions(Repository[] repositories, String featureSetName, String baseVersion) throws RestException, IOException {
        return this._restHelper.getVersionsArray(repositories, "com.oracle.cie.gdr.featureset", featureSetName, baseVersion, null);
    }

    @Override
    public Version getLatestFeatureSetVersion(Repository[] repositories, String featureSetName, String baseVersion) throws RestException, IOException {
        return this._restHelper.getLatestVersion(repositories, "com.oracle.cie.gdr.featureset", featureSetName, baseVersion, "xml");
    }

    @Override
    public Version getLatestFeatureSetDependenciesVersion(Repository[] repositories, String featureSetName, String baseVersion, String qualifier1) throws RestException, IOException {
        return this._restHelper.getLatestVersion(repositories, "com.oracle.cie.gdr.featureset.dependencies", featureSetName, baseVersion, "xml", qualifier1);
    }

    @Override
    public Version getLatestFeatureSetResourceVersion(Repository[] repositories, String featureSetName, String baseVersion) throws RestException, IOException {
        return this._restHelper.getLatestVersion(repositories, "com.oracle.cie.gdr.featureset.resources", featureSetName, baseVersion, "jar");
    }

    @Override
    public Version getLatestComponentVersion(Repository[] repositories, String componentName, String baseVersion) throws RestException, IOException {
        return this.getLatestComponentVersion(repositories, null, componentName, baseVersion);
    }

    @Override
    public Version getLatestComponentVersion(Repository[] repositories, String groupId, String componentName, String baseVersion) throws RestException, IOException {
        if (StringUtil.isNullOrEmpty((String)groupId, (boolean)true)) {
            groupId = "com.oracle.cie.gdr.carb";
        } else if (!groupId.startsWith("com.oracle.cie.gdr.carb")) {
            throw new RestException("The group id specified did not start with the standard carb group id com.oracle.cie.gdr.carb");
        }
        return this._restHelper.getLatestVersion(repositories, groupId, componentName, baseVersion, "carb");
    }

    @Override
    public Version getLatestComponentInfoVersion(Repository[] repositories, String componentName, String baseVersion) throws RestException, IOException {
        return this._restHelper.getLatestVersion(repositories, "com.oracle.cie.gdr.carb.info", componentName, baseVersion, "xml");
    }

    @Override
    public Version getLatestFeatureArchiveVersion(Repository[] repositories, String featureArchiveName, String baseVersion) throws RestException, IOException {
        return this._restHelper.getLatestVersion(repositories, "com.oracle.cie.gdr.farb", featureArchiveName, baseVersion, "farb");
    }

    @Override
    public Version getLatestNginstVersion(Repository[] repositories) throws RestException, IOException {
        return this._restHelper.getLatestVersion(repositories, "com.oracle.cie", "nginst", null, "jar", "bin", null);
    }

    @Override
    public Version getLatestProductLayersDefinitionVersion(Repository[] repositories, String layerName, String baseVersion) throws RestException, IOException {
        return this._restHelper.getLatestVersion(repositories, "com.oracle.cie.gdr.shiphome.layer", layerName, baseVersion, "json");
    }

    @Override
    public RepositoryVersionResolver getConfiguredRepositoryVersionResolver(RepoCommonConfig repoCommonConfig) throws RepositoryCommonException, RestException, IOException, DependencyManagementException {
        List<Module> overrideModules = this.getOverrideDependencyModules(repoCommonConfig);
        RepositoryVersionResolver versionResolver = new RepositoryVersionResolver(this, repoCommonConfig.getRepositories(), overrideModules, Boolean.valueOf(repoCommonConfig.getProperty("USE_LATEST")));
        if (repoCommonConfig.hasProperty("NGINST_VERSION_OVERRIDE_COORDINATES")) {
            ArrayList<Module> nginstOverrideModules = new ArrayList<Module>();
            nginstOverrideModules.addAll(this.getOverrideDependencyModules(repoCommonConfig.getProperty("NGINST_VERSION_OVERRIDE_COORDINATES"), null, repoCommonConfig.getRemoteRepositories()));
            versionResolver.setNextGenInstallerOverrides(nginstOverrideModules);
        }
        return versionResolver;
    }

    @Override
    public List<Module> getOverrideDependencyModules(RepoCommonConfig repoCommonConfig) throws IOException, DependencyManagementException, RepositoryCommonException, RestException {
        int count;
        Version version;
        ArrayList<Dependency> dependencies;
        Collection<String[]> nameVersions;
        ArrayList<Module> overrideModules = new ArrayList<Module>();
        if (repoCommonConfig.hasProperty("COMPONENT_OVERRIDES")) {
            nameVersions = RepositoryUtils.parseNameVersionString(repoCommonConfig.getProperty("COMPONENT_OVERRIDES"));
            dependencies = new ArrayList<Dependency>();
            for (String[] nameVersion : nameVersions) {
                version = DependencyManagementFactory.getInstance().getVersion(nameVersion[1]);
                count = version.getQualifierCount();
                if (count == 1) {
                    dependencies.add(DependencyManagementFactory.getInstance().getDependency("com.oracle.cie.gdr.carb", nameVersion[0], version, "carb"));
                    continue;
                }
                throw new RepositoryCommonException("Unable to processes component archive override with unsupported format: " + nameVersion[0] + " " + nameVersion[1]);
            }
            if (!dependencies.isEmpty()) {
                Module carbOverrideModule = DependencyManagementFactory.getInstance().getModule("com.oracle.cie.gdr.featureset.dependencies", "carbOverrideModule", "1.0.0");
                carbOverrideModule.setDependencies(dependencies);
                overrideModules.add(carbOverrideModule);
            }
        }
        if (repoCommonConfig.hasProperty("FEATURESET_OVERRIDES")) {
            nameVersions = RepositoryUtils.parseNameVersionString(repoCommonConfig.getProperty("FEATURESET_OVERRIDES"));
            dependencies = new ArrayList();
            for (String[] nameVersion : nameVersions) {
                version = DependencyManagementFactory.getInstance().getVersion(nameVersion[1]);
                count = version.getQualifierCount();
                if (count == 1) {
                    dependencies.add(DependencyManagementFactory.getInstance().getDependency("com.oracle.cie.gdr.featureset", nameVersion[0], version, "xml"));
                    continue;
                }
                if (count == 2) {
                    dependencies.add(DependencyManagementFactory.getInstance().getDependency("com.oracle.cie.gdr.featureset.dependencies", nameVersion[0], version, "xml"));
                    continue;
                }
                throw new RepositoryCommonException("Unable to processes feature set override with unsupported format: " + nameVersion[0] + " " + nameVersion[1]);
            }
            if (!dependencies.isEmpty()) {
                Module featureOverrideModule = DependencyManagementFactory.getInstance().getModule("com.oracle.cie.gdr.distribution.dependencies", "featureOverrideModule", "1.0.0");
                featureOverrideModule.setDependencies(dependencies);
                overrideModules.add(featureOverrideModule);
            }
        }
        overrideModules.addAll(this.getOverrideDependencyModules(repoCommonConfig.getProperty("DEPENDENCY_OVERRIDE_COORDINATES"), repoCommonConfig.getProperty("DEPENDENCY_OVERRIDE_FILE"), repoCommonConfig.getRemoteRepositories(), Boolean.parseBoolean(repoCommonConfig.getProperty("INCLUDE_BASE_MODULES"))));
        return overrideModules;
    }

    @Override
    public List<Module> getOverrideDependencyModules(String dependencyOverrideCoordinates, String dependencyOverrideFile, List<Repository> remoteRepositories) throws IOException, DependencyManagementException, RestException {
        return this.getOverrideDependencyModules(dependencyOverrideCoordinates, dependencyOverrideFile, remoteRepositories, false);
    }

    @Override
    public List<Module> getOverrideDependencyModules(String dependencyOverrideCoordinates, String dependencyOverrideFile, List<Repository> remoteRepositories, boolean includeBaseModules) throws IOException, DependencyManagementException, RestException {
        ArrayList<Module> overrideModules = new ArrayList<Module>();
        ArrayList<File> overrideFiles = new ArrayList<File>();
        if (!StringUtil.isNullOrEmpty((String)dependencyOverrideFile, (boolean)true)) {
            String[] split = dependencyOverrideFile.trim().split(",");
            for (String s : split) {
                if (StringUtil.isNullOrEmpty((String)(s = s.trim()), (boolean)true)) continue;
                overrideFiles.add(new File(s));
            }
        }
        if (!StringUtil.isNullOrEmpty((String)dependencyOverrideCoordinates, (boolean)true)) {
            for (Artifact artifact : this.parseDependencyOverrideCoordinates(dependencyOverrideCoordinates)) {
                overrideFiles.add(this._restHandler.retrieveArtifact(artifact, remoteRepositories, true));
            }
        }
        if (!overrideFiles.isEmpty()) {
            List dependencies = RestFactory.getRestHelper((RestHandler)this._restHandler).getTransitiveDependencies(overrideFiles, remoteRepositories, includeBaseModules);
            Module module = DependencyManagementFactory.getInstance().getModule("override.dependency.module", "overrides", "1.0.0");
            module.setDependencies(dependencies);
            overrideModules.add(module);
        }
        return overrideModules;
    }

    @Override
    public List<Artifact> parseDependencyOverrideCoordinates(String dependencyOverrideCoordinates) throws DependencyManagementException {
        ArrayList<Artifact> artifacts = new ArrayList<Artifact>();
        if (!StringUtil.isNullOrEmpty((String)dependencyOverrideCoordinates, (boolean)true)) {
            String[] split;
            for (String s : split = dependencyOverrideCoordinates.trim().split(",")) {
                if (StringUtil.isNullOrEmpty((String)(s = s.trim()), (boolean)true)) continue;
                Artifact artifact = DependencyManagementFactory.getArtifact((String)s);
                if (artifact.getType().equals("jar")) {
                    artifact.setType("pom");
                }
                artifacts.add(artifact);
            }
        }
        return artifacts;
    }
}

