/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.xmlsec.saml2.profiles.sso.ecp;

import oracle.security.xmlsec.saml2.core.Issuer;
import oracle.security.xmlsec.saml2.core.NameID;
import oracle.security.xmlsec.saml2.protocol.IDPList;
import oracle.security.xmlsec.saml2.util.SAML2Initializer;
import oracle.security.xmlsec.saml2.util.SAML2Utils;
import oracle.security.xmlsec.util.SOAPInitializer;
import oracle.security.xmlsec.util.XMLElement;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Request
extends XMLElement {
    public Request(Element element) throws DOMException {
        super(element);
    }

    public Request(Element element, String systemId) throws DOMException {
        super(element, systemId);
    }

    public Request(Document owner) throws DOMException {
        super(owner, "urn:oasis:names:tc:SAML:2.0:profiles:SSO:ecp", "Request");
        this.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", "urn:oasis:names:tc:SAML:2.0:profiles:SSO:ecp");
        this.addNSPrefixAttrDefault("urn:oasis:names:tc:SAML:2.0:profiles:SSO:ecp");
        String prefix = XMLElement.getDefaultNSPrefix((String)"http://schemas.xmlsoap.org/soap/envelope/");
        if (prefix == null || prefix.length() < 2) {
            prefix = "S";
        }
        this.addNSPrefixAttr(prefix, "http://schemas.xmlsoap.org/soap/envelope/");
        this.setAttributeNS("http://schemas.xmlsoap.org/soap/envelope/", "xmlns:" + prefix, "http://schemas.xmlsoap.org/soap/envelope/");
    }

    protected Request(Document owner, String nsURI, String localName) throws DOMException {
        super(owner, nsURI, localName);
        this.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", "urn:oasis:names:tc:SAML:2.0:profiles:SSO:ecp");
        this.addNSPrefixAttrDefault("urn:oasis:names:tc:SAML:2.0:profiles:SSO:ecp");
        String prefix = XMLElement.getDefaultNSPrefix((String)"http://schemas.xmlsoap.org/soap/envelope/");
        if (prefix == null || prefix.length() < 2) {
            prefix = "S";
        }
        this.addNSPrefixAttr(prefix, "http://schemas.xmlsoap.org/soap/envelope/");
        this.setAttributeNS("http://schemas.xmlsoap.org/soap/envelope/", "xmlns:" + prefix, "http://schemas.xmlsoap.org/soap/envelope/");
    }

    public void setMustUnderstand(boolean mu) {
        String prefix = XMLElement.getDefaultNSPrefix((String)"http://schemas.xmlsoap.org/soap/envelope/");
        this.setAttributeNS("http://schemas.xmlsoap.org/soap/envelope/", prefix + ":mustUnderstand", String.valueOf(mu));
    }

    public boolean getMustUnderstand() {
        String mu = this.getAttributeNS("http://schemas.xmlsoap.org/soap/envelope/", "mustUnderstand");
        return "true".equals(mu) || "1".equals(mu);
    }

    public void setActor(String actor) {
        String prefix = XMLElement.getDefaultNSPrefix((String)"http://schemas.xmlsoap.org/soap/envelope/");
        this.setAttributeNS("http://schemas.xmlsoap.org/soap/envelope/", prefix + ":actor", actor);
    }

    public String getActor() {
        String str = this.getAttributeNS("http://schemas.xmlsoap.org/soap/envelope/", "actor");
        if ("".equals(str)) {
            return null;
        }
        return str;
    }

    public void setIsPassive(boolean passive) {
        this.setAttribute("IsPassive", String.valueOf(passive));
    }

    public boolean getIsPassive() {
        String str;
        return this.hasAttribute("IsPassive") && ("true".equals(str = this.getAttribute("IsPassive")) || "1".equals(str));
    }

    public void setProviderName(String name) {
        this.setAttribute("ProviderName", name);
    }

    public String getProviderName() {
        if (this.hasAttribute("ProviderName")) {
            return this.getAttribute("ProviderName");
        }
        return null;
    }

    public void setIssuer(NameID issuer) {
        Node n = this.getFirstChild();
        if (n == null) {
            this.appendChild(issuer.getNode());
        } else if (n.getNamespaceURI().equals("urn:oasis:names:tc:SAML:2.0:assertion") && n.getLocalName().equals("Issuer")) {
            this.replaceChild(issuer.getNode(), n);
        } else {
            this.insertBefore(issuer.getNode(), n);
        }
    }

    public Issuer getIssuer() {
        return (Issuer)SAML2Utils.getChildElement(this, "urn:oasis:names:tc:SAML:2.0:assertion", "Issuer");
    }

    public void setIDPList(IDPList list) {
        NodeList nl = this.getChildNodes();
        int len = nl.getLength();
        if (len == 0) {
            this.appendChild(list.getNode());
        } else {
            Node is = null;
            Node id = null;
            Node next = null;
            for (int i = 0; i < len; ++i) {
                Node n = nl.item(i);
                if (n.getNamespaceURI().equals("urn:oasis:names:tc:SAML:2.0:assertion") && n.getLocalName().equals("Issuer")) {
                    is = n;
                    continue;
                }
                if (n.getNamespaceURI().equals("urn:oasis:names:tc:SAML:2.0:protocol") && n.getLocalName().equals("IDPList")) {
                    id = n;
                    continue;
                }
                if (next == null) continue;
                next = n;
                break;
            }
            if (is == null && id == null && next == null) {
                this.appendChild(list.getNode());
                return;
            }
            if (id != null) {
                this.replaceChild(list.getNode(), id);
            } else if (next == null) {
                this.appendChild(list.getNode());
            } else {
                this.insertBefore(list.getNode(), next);
            }
        }
    }

    public IDPList getIDPList() {
        return (IDPList)SAML2Utils.getChildElement(this, "urn:oasis:names:tc:SAML:2.0:protocol", "IDPList");
    }

    static {
        SAML2Initializer.initialize();
        SOAPInitializer.initialize();
    }
}

