/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.xmlsec.saml2.metadata;

import oracle.security.xmlsec.saml2.util.SAML2Initializer;
import oracle.security.xmlsec.util.XMLElement;
import oracle.security.xmlsec.util.XMLUtils;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public abstract class LocalizedURI
extends XMLElement {
    public LocalizedURI(Element element) throws DOMException {
        super(element);
    }

    public LocalizedURI(Element element, String systemId) throws DOMException {
        super(element, systemId);
    }

    protected LocalizedURI(Document owner, String nsURI, String localName) throws DOMException {
        super(owner, nsURI, localName);
        this.addNSPrefixAttrDefault("urn:oasis:names:tc:SAML:2.0:metadata");
    }

    public void setLanguage(String lang) {
        this.setAttributeNS("http://www.w3.org/XML/1998/namespace", XMLElement.getDefaultNSPrefix((String)"http://www.w3.org/XML/1998/namespace") + ":lang", lang);
    }

    public String getLanguage() {
        if (this.hasAttributeNS("http://www.w3.org/XML/1998/namespace", "lang")) {
            return this.getAttributeNS("http://www.w3.org/XML/1998/namespace", "lang");
        }
        return null;
    }

    public void setURI(String uri) {
        XMLUtils.removeChildren((Element)((Element)this.getNode()), (String)"*", (String)"*");
        Text child = this.getOwnerDocument().createTextNode(uri);
        this.appendChild(child);
    }

    public String getURI() {
        return XMLUtils.collectText((Node)this.getNode());
    }

    static {
        SAML2Initializer.initialize();
    }
}

