/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.xmlsec.saml2.metadata;

import java.util.List;
import oracle.security.xmlsec.saml2.metadata.AssertionIDRequestService;
import oracle.security.xmlsec.saml2.metadata.AuthnQueryService;
import oracle.security.xmlsec.saml2.metadata.NameIDFormat;
import oracle.security.xmlsec.saml2.metadata.RoleDescriptor;
import oracle.security.xmlsec.saml2.util.SAML2Utils;
import oracle.security.xmlsec.util.XMLElement;
import oracle.security.xmlsec.util.XMLUtils;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class AuthnAuthorityDescriptor
extends RoleDescriptor {
    private static final String[] tagList = new String[]{"Signature", "Extensions", "KeyDescriptor", "Organization", "ContactPerson", "AuthnQueryService", "AssertionIDRequestService", "NameIDFormat"};
    private static final String[] nsList = new String[]{"http://www.w3.org/2000/09/xmldsig#", "urn:oasis:names:tc:SAML:2.0:metadata", "urn:oasis:names:tc:SAML:2.0:metadata", "urn:oasis:names:tc:SAML:2.0:metadata", "urn:oasis:names:tc:SAML:2.0:metadata", "urn:oasis:names:tc:SAML:2.0:metadata", "urn:oasis:names:tc:SAML:2.0:metadata", "urn:oasis:names:tc:SAML:2.0:metadata"};

    public AuthnAuthorityDescriptor(Element element) throws DOMException {
        super(element);
    }

    public AuthnAuthorityDescriptor(Element element, String systemId) throws DOMException {
        super(element, systemId);
    }

    public AuthnAuthorityDescriptor(Document owner) throws DOMException {
        super(owner, "urn:oasis:names:tc:SAML:2.0:metadata", "AuthnAuthorityDescriptor");
        this.addNSPrefixAttrDefault("urn:oasis:names:tc:SAML:2.0:metadata");
    }

    public void addAuthnQueryService(AuthnQueryService aqs) {
        XMLUtils.insertChild((XMLElement)this, (XMLElement)aqs, (String[])nsList, (String[])tagList);
    }

    public List getAuthnQueryServices() {
        return SAML2Utils.getChildElements(this, "urn:oasis:names:tc:SAML:2.0:metadata", "AuthnQueryService");
    }

    public void addAssertionIDRequestService(AssertionIDRequestService ars) {
        XMLUtils.insertChild((XMLElement)this, (XMLElement)ars, (String[])nsList, (String[])tagList);
    }

    public List getAssertionIDRequestServices() {
        return SAML2Utils.getChildElements(this, "urn:oasis:names:tc:SAML:2.0:metadata", "AssertionIDRequestService");
    }

    public void addNameIDFormat(NameIDFormat nid) {
        XMLUtils.insertChild((XMLElement)this, (XMLElement)nid, (String[])nsList, (String[])tagList);
    }

    public List getNameIDFormats() {
        return SAML2Utils.getChildElements(this, "urn:oasis:names:tc:SAML:2.0:metadata", "NameIDFormat");
    }
}

