/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.xmlsec.saml2.core;

import java.util.Date;
import java.util.List;
import oracle.security.xmlsec.saml2.core.Condition;
import oracle.security.xmlsec.saml2.util.SAML2Initializer;
import oracle.security.xmlsec.saml2.util.SAML2Utils;
import oracle.security.xmlsec.util.XMLElement;
import oracle.security.xmlsec.util.XMLNode;
import oracle.security.xmlsec.util.XMLUtils;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class Conditions
extends XMLElement {
    public Conditions(Element element) throws DOMException {
        super(element);
    }

    public Conditions(Element element, String systemId) throws DOMException {
        super(element, systemId);
    }

    public Conditions(Document owner) throws DOMException {
        super(owner, "urn:oasis:names:tc:SAML:2.0:assertion", "Conditions");
        this.addNSPrefixAttrDefault("urn:oasis:names:tc:SAML:2.0:assertion");
    }

    public void setNotBefore(Date notBefore) {
        this.setAttribute("NotBefore", XMLUtils.formatDateTime((Date)notBefore));
    }

    public Date getNotBefore() {
        if (this.hasAttribute("NotBefore")) {
            return XMLUtils.parseDateTime((String)this.getAttribute("NotBefore"));
        }
        return null;
    }

    public void setNotOnOrAfter(Date notOnOrAfter) {
        this.setAttribute("NotOnOrAfter", XMLUtils.formatDateTime((Date)notOnOrAfter));
    }

    public Date getNotOnOrAfter() {
        if (this.hasAttribute("NotOnOrAfter")) {
            return XMLUtils.parseDateTime((String)this.getAttribute("NotOnOrAfter"));
        }
        return null;
    }

    public void addCondition(Condition condition) {
        this.appendChild((XMLNode)condition);
    }

    public List getConditions() {
        return SAML2Utils.getChildElements(this, "urn:oasis:names:tc:SAML:2.0:assertion", "*");
    }

    public List getAudienceRestrictions() {
        return SAML2Utils.getChildElements(this, "urn:oasis:names:tc:SAML:2.0:assertion", "AudienceRestriction");
    }

    public List getOneTimeUses() {
        return SAML2Utils.getChildElements(this, "urn:oasis:names:tc:SAML:2.0:assertion", "OneTimeUse");
    }

    public List getProxyRestrictions() {
        return SAML2Utils.getChildElements(this, "urn:oasis:names:tc:SAML:2.0:assertion", "ProxyRestriction");
    }

    static {
        SAML2Initializer.initialize();
    }
}

