/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.xmlsec.saml2.ac;

import java.util.List;
import oracle.security.xmlsec.saml2.ac.ActivationPin;
import oracle.security.xmlsec.saml2.ac.Extension;
import oracle.security.xmlsec.saml2.ac.Password;
import oracle.security.xmlsec.saml2.ac.RestrictedPassword;
import oracle.security.xmlsec.saml2.ac.Smartcard;
import oracle.security.xmlsec.saml2.ac.Token;
import oracle.security.xmlsec.saml2.util.SAML2Initializer;
import oracle.security.xmlsec.saml2.util.SAML2Utils;
import oracle.security.xmlsec.util.XMLElement;
import oracle.security.xmlsec.util.XMLUtils;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class PrincipalAuthenticationMechanism
extends XMLElement {
    String[] tagList = new String[]{"Password", "RestrictedPassword", "Token", "Smartcard", "ActivationPin", "Extension"};

    public PrincipalAuthenticationMechanism(Element element) throws DOMException {
        super(element);
    }

    public PrincipalAuthenticationMechanism(Element element, String systemID) throws DOMException {
        super(element, systemID);
    }

    public PrincipalAuthenticationMechanism(Document doc, String nsURI) throws DOMException {
        super(doc, nsURI, "PrincipalAuthenticationMechanism");
        String prefix = XMLElement.getDefaultNSPrefix((String)nsURI);
        if (prefix != null && prefix.length() > 0) {
            this.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:" + prefix, nsURI);
        } else {
            this.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", nsURI);
        }
    }

    public void setPreAuth(int preauth) {
        this.setAttribute("preauth", Integer.toString(preauth));
    }

    public int getPreAuth() {
        try {
            String str;
            if (this.hasAttribute("preauth") && (str = this.getAttribute("preauth")) != null) {
                return Integer.parseInt(str);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return 0;
    }

    public void setPassword(Password password) {
        XMLUtils.removeChildren((Element)((Element)this.getNode()), (String)this.getNamespaceURI(), (String)"Password");
        SAML2Utils.insertChild(this, password, this.getNamespaceURI(), this.tagList);
    }

    public Password getPassword() {
        return (Password)SAML2Utils.getChildElement(this, this.getNamespaceURI(), "Password");
    }

    public void setRestrictedPassword(RestrictedPassword password) {
        XMLUtils.removeChildren((Element)((Element)this.getNode()), (String)this.getNamespaceURI(), (String)"RestrictedPassword");
        SAML2Utils.insertChild(this, password, this.getNamespaceURI(), this.tagList);
    }

    public RestrictedPassword getRestrictedPassword() {
        return (RestrictedPassword)SAML2Utils.getChildElement(this, this.getNamespaceURI(), "RestrictedPassword");
    }

    public void setToken(Token tok) {
        XMLUtils.removeChildren((Element)((Element)this.getNode()), (String)this.getNamespaceURI(), (String)"Token");
        SAML2Utils.insertChild(this, tok, this.getNamespaceURI(), this.tagList);
    }

    public Token getToken() {
        return (Token)SAML2Utils.getChildElement(this, this.getNamespaceURI(), "Token");
    }

    public void setSmartcard(Smartcard sc) {
        XMLUtils.removeChildren((Element)((Element)this.getNode()), (String)this.getNamespaceURI(), (String)"Smartcard");
        SAML2Utils.insertChild(this, sc, this.getNamespaceURI(), this.tagList);
    }

    public Smartcard getSmartcard() {
        return (Smartcard)SAML2Utils.getChildElement(this, this.getNamespaceURI(), "Smartcard");
    }

    public void setActivationPin(ActivationPin ap) {
        XMLUtils.removeChildren((Element)((Element)this.getNode()), (String)this.getNamespaceURI(), (String)"ActivationPin");
        SAML2Utils.insertChild(this, ap, this.getNamespaceURI(), this.tagList);
    }

    public ActivationPin getActivationPin() {
        return (ActivationPin)SAML2Utils.getChildElement(this, this.getNamespaceURI(), "ActivationPin");
    }

    public void addExtension(Extension extn) {
        this.appendChild(extn.getNode());
    }

    public List getExtensions() {
        return SAML2Utils.getChildElements(this, this.getNamespaceURI(), "Extension");
    }

    static {
        SAML2Initializer.initialize();
    }
}

