/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.glcm.patch.auto.db.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Properties;

public class UpdatePropertiesFile {
    private static final String NODE_NAME_LIST = "NODE_NAME_LIST";
    private static final String CRSCONFIG_PARAMS = File.separator + "crs" + File.separator + "install" + File.separator + "crsconfig_params";
    private static final int FAILED_LOAD_CONFIG_PARAM = 2;

    public static void main(String[] args) {
        try {
            String originalHomePath = args[0];
            String cloneHomePath = args[1];
            UpdatePropertiesFile updatePropertiesFile = new UpdatePropertiesFile();
            if (updatePropertiesFile.validateNodeListEmpty(cloneHomePath)) {
                String nodeList = updatePropertiesFile.readNodeInfo(originalHomePath);
                updatePropertiesFile.updateNodeList(cloneHomePath, nodeList);
            }
        }
        catch (IOException e) {
            System.exit(2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String readNodeInfo(String originalHomePath) throws IOException, FileNotFoundException {
        Properties properties = new Properties();
        String nodeList = "";
        try (FileInputStream inStream = null;){
            inStream = new FileInputStream(originalHomePath + File.separator + CRSCONFIG_PARAMS);
            properties.load(inStream);
            nodeList = (String)properties.get(NODE_NAME_LIST);
        }
        return nodeList;
    }

    private boolean validateNodeListEmpty(String cloneHomePath) throws FileNotFoundException, IOException {
        String nodeList = this.readNodeInfo(cloneHomePath);
        return this.isEmpty(nodeList);
    }

    private boolean isEmpty(String nodeList) {
        return nodeList == null || nodeList.equalsIgnoreCase("");
    }

    private void updateNodeList(String cloneHomePath, String nodeList) throws IOException {
        if (this.isEmpty(nodeList)) {
            return;
        }
        String file = cloneHomePath + File.separator + CRSCONFIG_PARAMS;
        Path path = Paths.get(file, new String[0]);
        Charset charset = StandardCharsets.UTF_8;
        String content = new String(Files.readAllBytes(path), charset);
        content = content.replaceAll("NODE_NAME_LIST=", "NODE_NAME_LIST=" + nodeList);
        Files.write(path, content.getBytes(charset), new OpenOption[0]);
    }
}

