/*
 * Decompiled with CFR 0.152.
 */
package oracle.glcm.opatch.common.utils;

import java.io.File;
import java.util.Collection;
import oracle.glcm.opatch.common.api.alias.ArtifactReference;
import oracle.glcm.opatch.common.api.alias.MaintenanceAlias;
import oracle.glcm.opatch.common.impl.alias.patch.MaintenanceAliasPatchHandlerImpl;

public class ViewAliasInfo {
    private static final String SHOW_ALIASES_ARG = "-showAliases";
    private static final String SHOW_ALIAS_INFO_ARG = "-showAliasInfo";
    private static final String ALIAS_KEY_ARG = "-aliasKey";
    private static final String HELP_ARG = "-help";
    private static boolean _help = false;
    private static boolean _showAliases = false;
    private static boolean _showAliasInfo = false;
    private static String _aliasKey = "";
    private static String _oraHomePath;
    private static MaintenanceAliasPatchHandlerImpl _maPatch;
    private static String _format;
    private static String HEADER_KEY;
    private static String HEADER_ALIAS;
    private static String HEADER_ARTIFACT;
    private static String HEADER_TYPE;
    private static String HEADER_PATCH_LEVEL;
    private static String HEADER_PRODUCT_FAMILY;

    public static void main(String[] args) {
        block7: {
            try {
                ViewAliasInfo.processArgs(args);
                ViewAliasInfo.validateArgs();
                if (_help) break block7;
                _maPatch = new MaintenanceAliasPatchHandlerImpl(_oraHomePath);
                Collection<MaintenanceAlias> aliases = _maPatch.getAllMaintenanceAliasToDisplay();
                if (!aliases.isEmpty()) {
                    if (_showAliases) {
                        ViewAliasInfo.configureFormat(aliases);
                        ViewAliasInfo.printHeader();
                        for (MaintenanceAlias alias : aliases) {
                            ViewAliasInfo.printAlias(alias, false);
                        }
                        break block7;
                    }
                    if (!_showAliasInfo) break block7;
                    for (MaintenanceAlias alias : aliases) {
                        if (!alias.getMaintenanceAliasKey().equals(_aliasKey)) continue;
                        ViewAliasInfo.printAlias(alias, true);
                        break block7;
                    }
                    break block7;
                }
                StringBuffer sb = new StringBuffer("\r\nNo maintenance alias information found in Oracle Home: ");
                sb.append(_oraHomePath);
                System.out.println(sb.toString());
            }
            catch (IllegalArgumentException e) {
                StringBuffer sb = new StringBuffer("\nError: ");
                sb.append("\n\t" + e.getMessage());
                sb.append("\n");
                System.out.println(sb.toString());
                ViewAliasInfo.printUsageInstructions();
            }
            catch (Exception e) {
                StringBuffer sb = new StringBuffer("View Maintenance Alias Error:");
                sb.append("\r\n");
                sb.append("----------------------Error Message----------------------");
                sb.append("\r\n");
                sb.append("Error: ");
                sb.append(e.getMessage());
                sb.append("\r\n");
                sb.append("-------------------------The End-------------------------");
                System.out.println(sb.toString());
            }
        }
    }

    private static void configureFormat(Collection<MaintenanceAlias> aliases) {
        int keyLength = HEADER_KEY.length();
        int aliasLength = HEADER_ALIAS.length();
        for (MaintenanceAlias alias : aliases) {
            keyLength = alias.getMaintenanceAliasKey().length() > keyLength ? alias.getMaintenanceAliasKey().length() : keyLength;
            aliasLength = alias.getCompleteMaintenanceAlias().length() > aliasLength ? alias.getCompleteMaintenanceAlias().length() : aliasLength;
        }
        _format = " %-" + keyLength + "s %-" + aliasLength + "s %n";
    }

    private static void printHeader() {
        System.out.format(_format, HEADER_KEY, HEADER_ALIAS);
    }

    private static void printAlias(MaintenanceAlias maintenanceAlias, boolean detailed) {
        String key = maintenanceAlias.getMaintenanceAliasKey();
        String completeAlias = maintenanceAlias.getCompleteMaintenanceAlias();
        if (detailed) {
            String type = maintenanceAlias.getPatchType();
            String patchLevel = maintenanceAlias.getPatchLevel() != null ? maintenanceAlias.getPatchLevel() : "None";
            String productFamily = maintenanceAlias.getProductFamily();
            String components = "";
            String features = "";
            String distributions = "";
            for (ArtifactReference ref : maintenanceAlias.getComponents()) {
                components = components + (components.isEmpty() ? " " + ref : ", " + ref);
            }
            for (ArtifactReference ref : maintenanceAlias.getFeatureSets()) {
                features = features + (features.isEmpty() ? " " + ref : ", " + ref);
            }
            for (ArtifactReference ref : maintenanceAlias.getDistributions()) {
                distributions = distributions + (distributions.isEmpty() ? " " + ref : ", " + ref);
            }
            System.out.println(System.getProperty("line.separator") + HEADER_KEY + ": " + key);
            System.out.println(HEADER_ALIAS + ": " + completeAlias);
            if (!components.isEmpty()) {
                System.out.println("Components: " + components);
            }
            if (!features.isEmpty()) {
                System.out.println("Feature Sets: " + features);
            }
            if (!distributions.isEmpty()) {
                System.out.println("Distributions: " + distributions);
            }
            System.out.println(HEADER_PATCH_LEVEL + ": " + patchLevel);
            System.out.println(HEADER_PRODUCT_FAMILY + ": " + productFamily);
        } else {
            System.out.format(_format, key, completeAlias);
        }
    }

    private static boolean validateArgs() throws Exception {
        if (!_help && _oraHomePath == null || _oraHomePath.isEmpty()) {
            throw new Exception("The Oracle Home has not been specified or is empty.");
        }
        if (!_help && !new File(_oraHomePath).exists()) {
            throw new Exception("The Oracle Home: " + _oraHomePath + " does not exist.");
        }
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void processArgs(String[] args) {
        String parameter = null;
        String value = null;
        for (int i = 0; i < args.length; ++i) {
            parameter = args[i];
            if (i + 1 < args.length) {
                value = args[i + 1];
            }
            if (parameter.equalsIgnoreCase(SHOW_ALIASES_ARG)) {
                _showAliases = true;
            } else if (!_showAliases && parameter.equalsIgnoreCase(SHOW_ALIAS_INFO_ARG)) {
                _showAliasInfo = true;
            } else if (parameter.equalsIgnoreCase(ALIAS_KEY_ARG)) {
                if (!_showAliasInfo) throw new IllegalArgumentException("-aliasKey option needs to be used with -showAliasInfo option.");
                if (value == null || value.isEmpty()) {
                    throw new IllegalArgumentException("The -aliasKey hasn't been specified or is empty.");
                }
                _aliasKey = value;
                ++i;
            } else {
                if (!parameter.equalsIgnoreCase(HELP_ARG)) throw new IllegalArgumentException("Invalid input parameter: " + parameter);
                _help = true;
                ViewAliasInfo.printUsageInstructions();
            }
            parameter = null;
            value = null;
        }
        _oraHomePath = System.getProperty("ORACLE_HOME");
        if (args.length != 0) return;
        throw new IllegalArgumentException("Syntax Error... No command specified.");
    }

    private static void printUsageInstructions() {
        StringBuffer sb = new StringBuffer("View Maintenance Alias Usage:");
        sb.append("\n\n\tviewAliasInfo {").append(SHOW_ALIASES_ARG).append(" |  ").append(SHOW_ALIAS_INFO_ARG).append(" [-aliasKey <maintenance_alias>]");
        sb.append("\n\n").append(SHOW_ALIASES_ARG).append(" : Display all patch level aliases available in the parent Oracle Home..");
        sb.append("\n").append(SHOW_ALIAS_INFO_ARG).append(": Display the specific details of a given alias.");
        sb.append("\n").append(ALIAS_KEY_ARG).append(" <maintenance_alias>: Indicate which alias to display info for.");
        sb.append("\n").append(HELP_ARG).append(" : Prints usage instructions");
        sb.append("\n\nExample:");
        sb.append("\n\t./viewAliasInfo.sh -showAliases");
        sb.append("\n\t./viewAliasInfo.sh -showAliasInfo -aliasKey 133456222");
        System.out.println(sb.toString());
    }

    static {
        _format = " %-10s %-70s %n";
        HEADER_KEY = "Key";
        HEADER_ALIAS = "Alias";
        HEADER_ARTIFACT = "Artifact";
        HEADER_TYPE = "Type";
        HEADER_PATCH_LEVEL = "Patch Level";
        HEADER_PRODUCT_FAMILY = "Product Family";
    }
}

