/*
 * Decompiled with CFR 0.152.
 */
package oracle.glcm.opatch.common.utils;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.StringTokenizer;
import java.util.TimeZone;
import java.util.logging.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class LocalUtils {
    private static final Logger logger = Logger.getLogger("LocalUtils");

    public static List<ArrayList<String>> getAttributes(Document doc, String outerElement, String elementName, List<String> attributeNames, String metadata) {
        ArrayList<ArrayList<String>> listoflist = new ArrayList<ArrayList<String>>();
        NodeList nList = doc.getElementsByTagName(outerElement);
        if (nList.getLength() == 0) {
            logger.info(outerElement + " does not exist in " + metadata);
            return listoflist;
        }
        for (int i = 0; i < nList.getLength(); ++i) {
            Node nNode = nList.item(i);
            if (nNode.getNodeType() != 1) continue;
            Element eElement = (Element)nNode;
            NodeList cList = eElement.getElementsByTagName(elementName);
            for (int j = 0; j < cList.getLength(); ++j) {
                Node n = cList.item(j);
                if (n.getNodeType() != 1) continue;
                Element e = (Element)n;
                ArrayList<String> aList = new ArrayList<String>();
                for (String s : attributeNames) {
                    aList.add(e.getAttribute(s));
                }
                listoflist.add(aList);
            }
        }
        return listoflist;
    }

    public static List<List<ArrayList<String>>> getAttributesMultiple(Document doc, String outerElement, String elementName, List<String> attributeNames, String metadata) {
        ArrayList<List<ArrayList<String>>> result = new ArrayList<List<ArrayList<String>>>();
        NodeList nList = doc.getElementsByTagName(outerElement);
        if (nList.getLength() == 0) {
            logger.info(outerElement + " does not exist in " + metadata);
            return result;
        }
        for (int i = 0; i < nList.getLength(); ++i) {
            Node nNode = nList.item(i);
            ArrayList level2 = new ArrayList();
            if (nNode.getNodeType() == 1) {
                Element eElement = (Element)nNode;
                NodeList cList = eElement.getElementsByTagName(elementName);
                for (int j = 0; j < cList.getLength(); ++j) {
                    Node n = cList.item(j);
                    if (n.getNodeType() != 1) continue;
                    Element e = (Element)n;
                    ArrayList<String> aList = new ArrayList<String>();
                    for (String s : attributeNames) {
                        aList.add(e.getAttribute(s));
                    }
                    level2.add(aList);
                }
            }
            result.add(level2);
        }
        return result;
    }

    public static List<String> getAttributes(Document doc, String elementName, List<String> attributeNames, String metadata) {
        ArrayList<String> strList = new ArrayList<String>();
        NodeList nList = doc.getElementsByTagName(elementName);
        if (nList.getLength() == 0) {
            logger.info(elementName + " does not exist in " + metadata);
            return strList;
        }
        Node nNode = nList.item(0);
        if (nNode.getNodeType() == 1) {
            Element e = (Element)nNode;
            for (String s : attributeNames) {
                strList.add(e.getAttribute(s));
            }
        }
        return strList;
    }

    public static String getAttribute(Document doc, String elementName, String attributeName, String metadata) {
        String result = null;
        NodeList nList = doc.getElementsByTagName(elementName);
        if (nList.getLength() == 0) {
            logger.info(elementName + " does not exist in " + metadata);
            return null;
        }
        Node nNode = nList.item(0);
        if (nNode.getNodeType() == 1) {
            Element e = (Element)nNode;
            result = e.getAttribute(attributeName);
        }
        return result;
    }

    public static Boolean getBooleanValue(Document doc, String elementName, String metadata) {
        Boolean result = new Boolean(false);
        NodeList nList = doc.getElementsByTagName(elementName);
        if (nList.getLength() == 0) {
            logger.info(elementName + " does not exist in " + metadata);
            return result;
        }
        Node node = nList.item(0);
        Node textNode = node.getFirstChild();
        if (textNode != null) {
            return new Boolean(textNode.getNodeValue());
        }
        return result;
    }

    public static String getValue(Document doc, String elementName, String metadata) {
        NodeList nList = doc.getElementsByTagName(elementName);
        if (nList.getLength() == 0) {
            logger.info(elementName + " does not exist in " + metadata);
            return null;
        }
        Node node = nList.item(0);
        Node textNode = node.getFirstChild();
        if (textNode != null) {
            return textNode.getNodeValue();
        }
        return null;
    }

    public static List<String> getValues(Document doc, String outerElement, List<String> innerElements, String metadata) {
        ArrayList<String> result = new ArrayList<String>();
        NodeList nList = doc.getElementsByTagName(outerElement);
        if (nList.getLength() == 0) {
            logger.info(outerElement + " does not exist in " + metadata);
            return result;
        }
        Node nNode = nList.item(0);
        if (nNode.getNodeType() == 1) {
            Element eElement = (Element)nNode;
            for (String s : innerElements) {
                Node node = eElement.getElementsByTagName(s).item(0);
                result.add(node.getFirstChild().getNodeValue());
            }
        }
        return result;
    }

    public static Calendar getDate(Document doc, String elementName, String metadata) {
        ArrayList<String> attrNames = new ArrayList<String>(Arrays.asList("year", "month", "day", "time", "zone"));
        List<String> attrValues = LocalUtils.getAttributes(doc, elementName, attrNames, metadata);
        if (attrValues.size() == 0) {
            throw new RuntimeException("Error: The patch creation date is missing");
        }
        StringBuffer errMesg = new StringBuffer();
        for (int i = 0; i < attrValues.size(); ++i) {
            String v = attrValues.get(i);
            if (v.length() != 0) continue;
            errMesg.append(LocalUtils.getDateErrorMesg(i));
        }
        if (errMesg.length() > 0) {
            throw new RuntimeException("Error: The patch creation date does not have " + errMesg.substring(0, errMesg.length() - 1) + " element(s)");
        }
        String timezone = attrValues.get(attrValues.size() - 1);
        Calendar c = Calendar.getInstance(TimeZone.getTimeZone(timezone));
        int[] timeComponents = LocalUtils.getTimeComponents(attrValues.get(3));
        c.set(Integer.parseInt(attrValues.get(0)), LocalUtils.getMonth(attrValues.get(1)), Integer.parseInt(attrValues.get(2)), timeComponents[0], timeComponents[1], timeComponents[2]);
        return c;
    }

    private static String getDateErrorMesg(int i) {
        String missingElement = null;
        switch (i) {
            case 0: {
                missingElement = "\"year\",";
                break;
            }
            case 1: {
                missingElement = "\"month\",";
                break;
            }
            case 2: {
                missingElement = "\"day\",";
                break;
            }
            case 3: {
                missingElement = "\"time\",";
                break;
            }
            case 4: {
                missingElement = "\"timezone\",";
                break;
            }
            default: {
                missingElement = "";
            }
        }
        return missingElement;
    }

    public static List<String> getAttributes(Element element, List<String> attributeNames, String metadata) {
        ArrayList<String> strList = new ArrayList<String>();
        for (String s : attributeNames) {
            strList.add(element.getAttribute(s));
        }
        return strList;
    }

    private static int getMonth(String month) {
        if (month.equalsIgnoreCase("Jan")) {
            return 0;
        }
        if (month.equalsIgnoreCase("Feb")) {
            return 1;
        }
        if (month.equalsIgnoreCase("Mar")) {
            return 2;
        }
        if (month.equalsIgnoreCase("Apr")) {
            return 3;
        }
        if (month.equalsIgnoreCase("May")) {
            return 4;
        }
        if (month.equalsIgnoreCase("Jun")) {
            return 5;
        }
        if (month.equalsIgnoreCase("Jul")) {
            return 6;
        }
        if (month.equalsIgnoreCase("Aug")) {
            return 7;
        }
        if (month.equalsIgnoreCase("Sep")) {
            return 8;
        }
        if (month.equalsIgnoreCase("Oct")) {
            return 9;
        }
        if (month.equalsIgnoreCase("Nov")) {
            return 10;
        }
        if (month.equalsIgnoreCase("Dec")) {
            return 11;
        }
        logger.info("Invalid month string in date");
        return -1;
    }

    private static int[] getTimeComponents(String time) {
        int[] result = new int[3];
        if (time == null || time.equals("")) {
            return result;
        }
        StringTokenizer st = new StringTokenizer(time, ":");
        logger.info("Tokens in time:" + st.countTokens());
        int i = 0;
        while (st.hasMoreElements()) {
            String token = st.nextToken();
            if (token.length() > 2) {
                token = token.substring(0, 2);
            }
            result[i++] = Integer.parseInt(token);
        }
        return result;
    }

    public static String convertDate(Date date) {
        String TIME_ZONE = "UTC";
        String FORMAT = "yyyyMMddHHmmss'Z'";
        TimeZone utcZone = null;
        SimpleDateFormat isoFormat = null;
        utcZone = TimeZone.getTimeZone("UTC");
        isoFormat = new SimpleDateFormat("yyyyMMddHHmmss'Z'");
        isoFormat.setTimeZone(utcZone);
        return isoFormat.format(date);
    }

    public static boolean checkStringExistsInListIgnoreCase(String s, List<String> list) {
        boolean result = false;
        if (list != null) {
            for (String str : list) {
                if (!s.equalsIgnoreCase(str)) continue;
                result = true;
                break;
            }
        }
        return result;
    }

    public static boolean isNullOrEmpty(String str, boolean trim) {
        return str == null || (trim ? str.trim().length() : str.length()) < 1;
    }
}

