/*
 * Decompiled with CFR 0.152.
 */
package oracle.glcm.opatch.common.impl.dao;

import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.logging.Logger;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.ValidationEventHandler;
import oracle.glcm.common.nio.NioServiceFactory;
import oracle.glcm.opatch.common.api.PatchMetadataLoadingException;
import oracle.glcm.opatch.common.api.PatchMetadataWritingException;
import oracle.glcm.opatch.common.impl.Constants;
import oracle.glcm.opatch.common.impl.PatchXMLValidationEventHandler;
import oracle.glcm.opatch.common.impl.bundle.SystemPatchBundleXml;
import oracle.glcm.opatch.common.utils.SecureUnmarshaller;

public class PatchBundleDAO {
    private final Logger logger = Logger.getLogger(this.getClass().getName());
    private static Class<SystemPatchBundleXml> bundleClass = SystemPatchBundleXml.class;
    private static String bundlePackage = bundleClass.getPackage().getName();
    private SystemPatchBundleXml bundleObj = null;
    private Marshaller marshaller = null;
    private Unmarshaller unmarshaller = null;

    public PatchBundleDAO(String bundleLocation) throws PatchMetadataLoadingException {
        this.logger.info("Enter PatchBundleDAO constructor (from file)...");
        this.init();
        try (InputStream inputStream = Files.newInputStream(NioServiceFactory.getNioService().getPath(bundleLocation, new String[0]), new OpenOption[0]);){
            this.bundleObj = (SystemPatchBundleXml)SecureUnmarshaller.unmarshal(this.unmarshaller, inputStream);
        }
        catch (Exception je) {
            throw new PatchMetadataLoadingException("Failed to load or parse the bundle.xml", (Throwable)je);
        }
        this.logger.info("Done PatchBundleDAO creation (from file.");
    }

    public PatchBundleDAO(InputStream zis) throws PatchMetadataLoadingException {
        this.logger.info("Enter PatchBundleDAO constructor (from ZipInputStream)...");
        this.init();
        try {
            this.bundleObj = (SystemPatchBundleXml)SecureUnmarshaller.unmarshal(this.unmarshaller, zis);
        }
        catch (JAXBException je) {
            throw new PatchMetadataLoadingException("Failed to load or parse the bundle.xml", (Throwable)je);
        }
        this.logger.info("Done PatchBundleDAO creation (from ZipInputStream.");
    }

    private void init() throws PatchMetadataLoadingException {
        try {
            JAXBContext jaxbContext = JAXBContext.newInstance((String)bundlePackage);
            this.marshaller = jaxbContext.createMarshaller();
            this.marshaller.setEventHandler((ValidationEventHandler)new PatchXMLValidationEventHandler());
            this.marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            this.unmarshaller = jaxbContext.createUnmarshaller();
            this.unmarshaller.setEventHandler((ValidationEventHandler)new PatchXMLValidationEventHandler());
        }
        catch (JAXBException e) {
            throw new PatchMetadataLoadingException("Failed to initialize jaxb context for bundle.xml", (Throwable)e);
        }
    }

    public SystemPatchBundleXml getBundleObj() {
        return this.bundleObj;
    }

    protected void save(String bundleFile) throws PatchMetadataWritingException {
        try (OutputStream outputStream = Files.newOutputStream(NioServiceFactory.getNioService().getPath(bundleFile, new String[0]), new OpenOption[0]);){
            this.marshaller.marshal((Object)this.bundleObj, outputStream);
        }
        catch (Exception e) {
            throw new PatchMetadataWritingException("Failed to save bundle.xml", (Throwable)e);
        }
    }

    public void saveToDir(String patchLocation) throws PatchMetadataWritingException {
        String bundleFile = patchLocation + Constants.PATH + Constants.BUNDLE_XML;
        this.save(bundleFile);
    }
}

