/*
 * Decompiled with CFR 0.152.
 */
package oracle.glcm.opatch.common.impl.dao;

import com.oracle.xmlns.cie.glcm.patch.map.MaintenanceAliasPatch;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.logging.Logger;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.ValidationEventHandler;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import oracle.glcm.opatch.common.api.alias.MaintenanceAliasException;
import oracle.glcm.opatch.common.impl.PatchXMLValidationEventHandler;
import oracle.glcm.opatch.common.utils.SecureUnmarshaller;

public class MaintenanceAliasPatchDAO {
    private static final Logger logger = Logger.getLogger(MaintenanceAliasPatchDAO.class.getName());
    private static final String xsdFile = "maintenance_alias_patch.xsd";
    private Marshaller marshaller;
    private Unmarshaller unmarshaller;
    private static volatile MaintenanceAliasPatchDAO instance = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static MaintenanceAliasPatchDAO getInstance() throws MaintenanceAliasException {
        if (instance != null) return instance;
        Class<MaintenanceAliasPatchDAO> clazz = MaintenanceAliasPatchDAO.class;
        synchronized (MaintenanceAliasPatchDAO.class) {
            if (instance != null) return instance;
            instance = new MaintenanceAliasPatchDAO();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private MaintenanceAliasPatchDAO() throws MaintenanceAliasException {
        try {
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{MaintenanceAliasPatch.class});
            SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            Schema schema = schemaFactory.newSchema(MaintenanceAliasPatch.class.getResource(xsdFile));
            this.marshaller = context.createMarshaller();
            this.marshaller.setSchema(schema);
            this.marshaller.setEventHandler((ValidationEventHandler)new PatchXMLValidationEventHandler());
            this.marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            this.marshaller.setProperty("jaxb.fragment", (Object)Boolean.FALSE);
            this.marshaller.setProperty("jaxb.encoding", (Object)"UTF-8");
            this.unmarshaller = context.createUnmarshaller();
            this.unmarshaller.setSchema(schema);
            this.unmarshaller.setEventHandler((ValidationEventHandler)new PatchXMLValidationEventHandler());
        }
        catch (Exception e) {
            throw new MaintenanceAliasException("Failed to initialize jaxb context", (Throwable)e);
        }
    }

    public MaintenanceAliasPatch load(Path xmlFile) throws MaintenanceAliasException {
        MaintenanceAliasPatch maintenanceAliasPatch;
        logger.finest("Unmarshal from file " + xmlFile);
        if (!(xmlFile != null && Files.exists(xmlFile, new LinkOption[0]) && Files.isRegularFile(xmlFile, new LinkOption[0]) && Files.isReadable(xmlFile))) {
            throw new MaintenanceAliasException("Can not load XML from an invalid file.");
        }
        try {
            InputStream inputStream = Files.newInputStream(xmlFile, new OpenOption[0]);
            maintenanceAliasPatch = (MaintenanceAliasPatch)SecureUnmarshaller.unmarshal(this.unmarshaller, inputStream);
        }
        catch (Exception e) {
            throw new MaintenanceAliasException((Throwable)e);
        }
        return maintenanceAliasPatch;
    }

    public void store(MaintenanceAliasPatch maintenanceAliasPatch, Path xmlFile) throws MaintenanceAliasException {
        logger.finest("Marshal to file " + xmlFile);
        if (!(xmlFile != null && Files.exists(xmlFile, new LinkOption[0]) && Files.isRegularFile(xmlFile, new LinkOption[0]) && Files.isWritable(xmlFile))) {
            throw new MaintenanceAliasException("Can not store XML to an invalid file.");
        }
        try {
            OutputStream outputStream = Files.newOutputStream(xmlFile, new OpenOption[0]);
            this.marshaller.marshal((Object)maintenanceAliasPatch, outputStream);
        }
        catch (Exception e) {
            throw new MaintenanceAliasException((Throwable)e);
        }
    }
}

