/*
 * Decompiled with CFR 0.152.
 */
package oracle.glcm.opatch.common.impl.alias.patch;

import com.oracle.xmlns.cie.glcm.patch.map.MaintenanceAliasPatch;
import com.oracle.xmlns.cie.glcm.patch.map.MaintenanceAliasType;
import com.oracle.xmlns.cie.glcm.patch.map.PatchType;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import oracle.glcm.common.nio.NioServiceFactory;
import oracle.glcm.opatch.common.api.alias.MaintenanceAliasException;
import oracle.glcm.opatch.common.api.alias.patch.MaintenanceAliasPatchBuilderFactory;
import oracle.glcm.opatch.common.api.alias.patch.MaintenanceAliasPatchRec;
import oracle.glcm.opatch.common.api.alias.patch.MaintenanceAliasRec;
import oracle.glcm.opatch.common.api.alias.patch.PatchRec;
import oracle.glcm.opatch.common.impl.alias.patch.MaintenanceAliasPatchBuilderFactoryImpl;
import oracle.glcm.opatch.common.impl.dao.MaintenanceAliasPatchDAO;

public class MaintenanceAliasPatchService {
    public static final DateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss Z");
    private static volatile MaintenanceAliasPatchService instance = null;
    private MaintenanceAliasPatchDAO maintenanceAliasPatchDAO = MaintenanceAliasPatchDAO.getInstance();
    private MaintenanceAliasPatchBuilderFactory builderFactory = this.getMaintenanceAliasPatchBuilderFactory();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static MaintenanceAliasPatchService getInstance() throws MaintenanceAliasException {
        if (instance != null) return instance;
        Class<MaintenanceAliasPatchService> clazz = MaintenanceAliasPatchService.class;
        synchronized (MaintenanceAliasPatchService.class) {
            if (instance != null) return instance;
            instance = new MaintenanceAliasPatchService();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private MaintenanceAliasPatchService() throws MaintenanceAliasException {
    }

    public MaintenanceAliasPatchRec loadMaintenanceAliasPatch(String xmlFilePath) throws MaintenanceAliasException {
        return this.loadMaintenanceAliasPatch(NioServiceFactory.getNioService().getPath(xmlFilePath, new String[0]));
    }

    public MaintenanceAliasPatchRec loadMaintenanceAliasPatch(Path xmlFile) throws MaintenanceAliasException {
        if (!(xmlFile != null && Files.exists(xmlFile, new LinkOption[0]) && Files.isRegularFile(xmlFile, new LinkOption[0]) && Files.isReadable(xmlFile))) {
            throw new MaintenanceAliasException("Can not load XML from an invalid file.");
        }
        MaintenanceAliasPatch maintenanceAliasPatch = this.maintenanceAliasPatchDAO.load(xmlFile);
        List maintenanceAliases = maintenanceAliasPatch.getMaintenanceAlias();
        HashSet<MaintenanceAliasRec> maintenanceAliasRecs = new HashSet<MaintenanceAliasRec>();
        List patches = maintenanceAliasPatch.getPatch();
        HashSet<PatchRec> patchRecs = new HashSet<PatchRec>();
        for (MaintenanceAliasType maintenanceAlias : maintenanceAliases) {
            String maintenanceAliasKey = maintenanceAlias.getMaintenanceAliasKey();
            HashSet patchUpis = new HashSet(maintenanceAlias.getPatchUpi());
            MaintenanceAliasRec maintenanceAliasRec = this.builderFactory.getMaintenanceAliasRecBuilder(maintenanceAliasKey).setPatchUpis(patchUpis).build();
            maintenanceAliasRecs.add(maintenanceAliasRec);
        }
        for (PatchType patch : patches) {
            String upi = patch.getUpi();
            String id = patch.getId();
            String patchLocation = patch.getPatchLocation();
            Date creationTime = null;
            Date applicationTime = null;
            try {
                creationTime = dateFormat.parse(patch.getCreationTime());
                applicationTime = dateFormat.parse(patch.getApplicationTime());
            }
            catch (ParseException e) {
                throw new MaintenanceAliasException("Failed to parse time string to Date.");
            }
            PatchRec patchRec = this.builderFactory.getPatchRecBuilder(upi).setId(id).setPatchLocation(patchLocation).setCreationTime(creationTime).setApplicationTime(applicationTime).build();
            patchRecs.add(patchRec);
        }
        return this.builderFactory.getMaintenanceAliasPatchRecBuilder(maintenanceAliasRecs, patchRecs).build();
    }

    public void storeMaintenanceAliasPatch(MaintenanceAliasPatchRec maintenanceAliasPatchRec, String xmlFilePath) throws MaintenanceAliasException {
        this.storeMaintenanceAliasPatch(maintenanceAliasPatchRec, NioServiceFactory.getNioService().getPath(xmlFilePath, new String[0]));
    }

    public void storeMaintenanceAliasPatch(MaintenanceAliasPatchRec maintenanceAliasPatchRec, Path xmlFile) throws MaintenanceAliasException {
        if (!(xmlFile != null && Files.exists(xmlFile, new LinkOption[0]) && Files.isRegularFile(xmlFile, new LinkOption[0]) && Files.isWritable(xmlFile))) {
            throw new MaintenanceAliasException("Can not store XML to an invalid file.");
        }
        MaintenanceAliasPatch maintenanceAliasPatch = new MaintenanceAliasPatch();
        Set maintenanceAliasRecs = maintenanceAliasPatchRec.getMaintenanceAliasRecs();
        List maintenanceAliases = maintenanceAliasPatch.getMaintenanceAlias();
        Set patchRecs = maintenanceAliasPatchRec.getPatchRecs();
        List patches = maintenanceAliasPatch.getPatch();
        if (maintenanceAliasRecs != null && !maintenanceAliasRecs.isEmpty()) {
            for (MaintenanceAliasRec maintenanceAliasRec : maintenanceAliasRecs) {
                MaintenanceAliasType maintenanceAlias = new MaintenanceAliasType();
                maintenanceAlias.setMaintenanceAliasKey(maintenanceAliasRec.getMaintenanceAliasKey());
                maintenanceAlias.getPatchUpi().addAll(maintenanceAliasRec.getPatchUpis());
                maintenanceAliases.add(maintenanceAlias);
            }
        }
        if (patchRecs != null && !patchRecs.isEmpty()) {
            for (PatchRec patchRec : patchRecs) {
                PatchType patch = new PatchType();
                patch.setUpi(patchRec.getUpi());
                patch.setId(patchRec.getId());
                patch.setPatchLocation(patchRec.getPatchLocation());
                patch.setCreationTime(dateFormat.format(patchRec.getCreationTime()));
                patch.setApplicationTime(dateFormat.format(patchRec.getApplicationTime()));
                patches.add(patch);
            }
        }
        this.maintenanceAliasPatchDAO.store(maintenanceAliasPatch, xmlFile);
    }

    public MaintenanceAliasPatchRec initMaintenanceAliasPatch(String xmlFilePath) throws MaintenanceAliasException {
        return this.initMaintenanceAliasPatch(NioServiceFactory.getNioService().getPath(xmlFilePath, new String[0]));
    }

    public MaintenanceAliasPatchRec initMaintenanceAliasPatch(Path xmlFile) throws MaintenanceAliasException {
        if (!(xmlFile != null && Files.exists(xmlFile, new LinkOption[0]) && Files.isRegularFile(xmlFile, new LinkOption[0]) && Files.isWritable(xmlFile))) {
            throw new MaintenanceAliasException("Can not init XML to an invalid file.");
        }
        MaintenanceAliasPatchRec maintenanceAliasPatchRec = this.builderFactory.getMaintenanceAliasPatchRecBuilder(null, null).build();
        this.storeMaintenanceAliasPatch(maintenanceAliasPatchRec, xmlFile);
        return maintenanceAliasPatchRec;
    }

    public Set<MaintenanceAliasRec> filterMaintenanceAlias(MaintenanceAliasPatchRec maintenanceAliasPatchRec, Set<String> maintenanceAliasKeys) throws MaintenanceAliasException {
        if (maintenanceAliasPatchRec == null) {
            throw new MaintenanceAliasException("Invalid parameters were given.");
        }
        HashSet<MaintenanceAliasRec> results = new HashSet<MaintenanceAliasRec>();
        if (maintenanceAliasKeys != null && !maintenanceAliasKeys.isEmpty()) {
            Iterator iterator = maintenanceAliasPatchRec.getMaintenanceAliasRecs().iterator();
            while (!maintenanceAliasKeys.isEmpty() && iterator.hasNext()) {
                MaintenanceAliasRec maintenanceAliasRec = (MaintenanceAliasRec)iterator.next();
                String maintenanceAliasKey = maintenanceAliasRec.getMaintenanceAliasKey();
                if (!maintenanceAliasKeys.contains(maintenanceAliasKey)) continue;
                results.add(maintenanceAliasRec);
                maintenanceAliasKeys.remove(maintenanceAliasKey);
            }
        }
        return results;
    }

    public Set<MaintenanceAliasRec> filterMaintenanceAlias(MaintenanceAliasPatchRec maintenanceAliasPatchRec, String patchUpi) throws MaintenanceAliasException {
        if (maintenanceAliasPatchRec == null) {
            throw new MaintenanceAliasException("Invalid parameters were given.");
        }
        HashSet<MaintenanceAliasRec> results = new HashSet<MaintenanceAliasRec>();
        if (patchUpi != null && !patchUpi.isEmpty()) {
            for (MaintenanceAliasRec maintenanceAliasRec : maintenanceAliasPatchRec.getMaintenanceAliasRecs()) {
                Set patchUpis = maintenanceAliasRec.getPatchUpis();
                if (!patchUpis.contains(patchUpi)) continue;
                results.add(maintenanceAliasRec);
            }
        }
        return results;
    }

    public PatchRec retrievePatch(MaintenanceAliasPatchRec maintenanceAliasPatchRec, String patchUpi) throws MaintenanceAliasException {
        if (maintenanceAliasPatchRec == null || patchUpi == null) {
            throw new MaintenanceAliasException("Invalid parameters were given.");
        }
        Set patchRecs = maintenanceAliasPatchRec.getPatchRecs();
        if (patchRecs != null && !patchRecs.isEmpty()) {
            for (PatchRec patchRec : patchRecs) {
                if (!patchRec.getUpi().equals(patchUpi)) continue;
                return patchRec;
            }
        }
        return null;
    }

    public MaintenanceAliasPatchBuilderFactory getMaintenanceAliasPatchBuilderFactory() {
        if (this.builderFactory == null) {
            this.builderFactory = new MaintenanceAliasPatchBuilderFactoryImpl();
        }
        return this.builderFactory;
    }
}

