/*
 * Decompiled with CFR 0.152.
 */
package oracle.glcm.opatch.common.impl;

import java.util.ArrayList;
import java.util.List;
import oracle.glcm.opatch.common.api.BackportPatchNotes;
import oracle.glcm.opatch.common.api.BackportReadmePostinstalls;
import oracle.glcm.opatch.common.api.BackportReadmePreinstalls;
import oracle.glcm.opatch.common.api.PatchConfigAction;
import oracle.glcm.opatch.common.api.PatchDeployArtifact;
import oracle.glcm.opatch.common.api.PatchMetadataLoadingException;
import oracle.glcm.opatch.common.api.PatchMetadataWritingException;
import oracle.glcm.opatch.common.impl.BackportPatchNotesImpl;
import oracle.glcm.opatch.common.impl.BackportReadmePostinstallsImpl;
import oracle.glcm.opatch.common.impl.BackportReadmePreinstallsImpl;
import oracle.glcm.opatch.common.impl.Constants;
import oracle.glcm.opatch.common.impl.PatchConfigActionImpl;
import oracle.glcm.opatch.common.impl.dao.PatchDeployDAO;
import oracle.glcm.opatch.common.impl.pad.ActionType;
import oracle.glcm.opatch.common.impl.pad.BackportPatchNotesType;
import oracle.glcm.opatch.common.impl.pad.BackportReadmePostinstallType;
import oracle.glcm.opatch.common.impl.pad.BackportReadmePreinstallType;
import oracle.glcm.opatch.common.impl.pad.PatchDeploy;

public class PatchDeployArtifactImpl
implements PatchDeployArtifact {
    private PatchDeployDAO pddao = null;
    private PatchDeploy patchdeploy = null;

    public PatchDeployArtifactImpl(String patchDeployFileLocation) throws PatchMetadataLoadingException {
        this.pddao = new PatchDeployDAO(patchDeployFileLocation);
        this.patchdeploy = this.pddao.getPatchDeployObj();
    }

    protected PatchDeployArtifactImpl() throws PatchMetadataLoadingException {
        this.pddao = new PatchDeployDAO((String)null);
        this.patchdeploy = this.pddao.getPatchDeployObj();
    }

    public BackportPatchNotes getBackportPatchNotes() {
        return new BackportPatchNotesImpl(this.patchdeploy.getBackportPatchNotes());
    }

    public BackportReadmePostinstalls getBackportReadmePostinstall() {
        return new BackportReadmePostinstallsImpl(this.patchdeploy.getBackportReadmePostinstalls());
    }

    public BackportReadmePreinstalls getBackportReadmePreinstall() {
        return new BackportReadmePreinstallsImpl(this.patchdeploy.getBackportReadmePreinstalls());
    }

    public String getInstanceShutdown() {
        return this.patchdeploy.getInstanceShutdown();
    }

    public String getPatchUptimeOption() {
        return this.patchdeploy.getPatchUptimeOption() == null ? null : this.patchdeploy.getPatchUptimeOption().toUpperCase();
    }

    public List<PatchConfigAction> getPatchConfigAction() {
        List al;
        ArrayList<PatchConfigAction> list = new ArrayList<PatchConfigAction>();
        if (this.patchdeploy.getPatchConfiguration() != null && this.patchdeploy.getPatchConfiguration().getAction() != null && (al = this.patchdeploy.getPatchConfiguration().getAction()) != null && al.size() > 0) {
            for (ActionType at : al) {
                list.add(new PatchConfigActionImpl(at));
            }
        }
        return list;
    }

    public String getUpid() {
        return this.patchdeploy.getPatchUpi();
    }

    public boolean validate() {
        return this.pddao.validate();
    }

    public void setBackportPatchNotes(BackportPatchNotes backportPatchNotes) {
        if (backportPatchNotes != null && this.patchdeploy != null) {
            BackportPatchNotesType backportNotesType = new BackportPatchNotesType();
            backportNotesType.getBackportPatchNote().clear();
            if (null != backportPatchNotes.getBackportPatchNote()) {
                for (String backportPatchNote : backportPatchNotes.getBackportPatchNote()) {
                    backportNotesType.getBackportPatchNote().add(backportPatchNote);
                }
            }
            this.patchdeploy.setBackportPatchNotes(backportNotesType);
        }
    }

    public void setBackportReadmePostinstall(BackportReadmePostinstalls backportReadmePostinstalls) {
        if (backportReadmePostinstalls != null && this.patchdeploy != null) {
            BackportReadmePostinstallType backportReadmePostinstallType = new BackportReadmePostinstallType();
            backportReadmePostinstallType.getBackportReadmePostinstall().clear();
            if (null != backportReadmePostinstalls.getBackportReadmePostinstall()) {
                for (String backportReadmePostinstall : backportReadmePostinstalls.getBackportReadmePostinstall()) {
                    backportReadmePostinstallType.getBackportReadmePostinstall().add(backportReadmePostinstall);
                }
            }
            this.patchdeploy.setBackportReadmePostinstalls(backportReadmePostinstallType);
        }
    }

    public void setBackportReadmePreinstall(BackportReadmePreinstalls backportReadmePreinstalls) {
        if (backportReadmePreinstalls != null && this.patchdeploy != null) {
            BackportReadmePreinstallType backportReadmePreinstallType = new BackportReadmePreinstallType();
            backportReadmePreinstallType.getBackportReadmePreinstall().clear();
            if (null != backportReadmePreinstalls.getBackportReadmePreinstall()) {
                for (String backportReadmePreinstall : backportReadmePreinstalls.getBackportReadmePreinstall()) {
                    backportReadmePreinstallType.getBackportReadmePreinstall().add(backportReadmePreinstall);
                }
            }
            this.patchdeploy.setBackportReadmePreinstalls(backportReadmePreinstallType);
        }
    }

    public void setInstanceShutdown(String str) {
        if (str != null && this.patchdeploy != null) {
            this.patchdeploy.setInstanceShutdown(str);
        }
    }

    public void setPatchConfigAction(List<PatchConfigAction> pcaList) {
        if (this.patchdeploy != null) {
            List atList = this.patchdeploy.getPatchConfiguration().getAction();
            for (PatchConfigAction pca : pcaList) {
                ActionType at = PatchConfigActionImpl.convertToActionType(pca);
                atList.add(at);
            }
        }
    }

    public void setPatchUptimeOption(String str) {
        if (str != null && this.patchdeploy != null) {
            this.patchdeploy.setPatchUptimeOption(str);
        }
    }

    public void setUpid(String str) {
        if (str != null && this.patchdeploy != null) {
            this.patchdeploy.setPatchUpi(str);
        }
    }

    public void save(String fileLocation) throws PatchMetadataWritingException {
        this.pddao.savePatchDeployObj(fileLocation);
    }

    public PatchConfigAction createPatchConfigAction() {
        return new PatchConfigActionImpl();
    }

    protected void saveToDir(String patchLoc) throws PatchMetadataWritingException {
        this.save(patchLoc + Constants.PATH + Constants.PATCH_DEPLOY_XML);
    }

    public String getPatchId() {
        return this.patchdeploy.getPatchId();
    }

    public String getSchemaVersion() {
        return this.patchdeploy.getSchemaVersion();
    }

    public void setPatchId(String str) {
        this.patchdeploy.setPatchId(str);
    }

    public void setSchemaVersion(String str) {
        this.patchdeploy.setSchemaVersion(str);
    }

    public boolean validate(String patchDeployFile) {
        boolean result = false;
        try {
            PatchDeployDAO patchDeployObj = new PatchDeployDAO(patchDeployFile);
            result = patchDeployObj.validate();
        }
        catch (PatchMetadataLoadingException ex) {
            result = false;
        }
        return result;
    }
}

