/*
 * Decompiled with CFR 0.152.
 */
package oracle.glcm.opatch.common.impl;

import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.util.List;
import java.util.logging.Logger;
import oracle.glcm.opatch.common.api.InvalidPatchMetadataException;
import oracle.glcm.opatch.common.api.Patch;
import oracle.glcm.opatch.common.api.PatchMetadataLoadingException;
import oracle.glcm.opatch.common.api.PatchNotFoundException;
import oracle.glcm.opatch.common.impl.patchhash.HashComputeFunction;

public abstract class AbstractPatch {
    private final Logger logger = Logger.getLogger(this.getClass().getName());

    protected abstract AbstractPatch createPatch(String var1) throws PatchNotFoundException, PatchMetadataLoadingException, InvalidPatchMetadataException;

    public String calculateHash(String function, String patchLocation, List<Patch> subpatchObjs) {
        HashComputeFunction hashFunc = HashComputeFunction.getHashFunction(function);
        String hash = null;
        if (hashFunc != null) {
            try {
                hash = hashFunc.computeHash(patchLocation, subpatchObjs);
            }
            catch (NoSuchAlgorithmException e) {
                this.logger.severe("Hash algorithm invalid: " + e.getMessage());
            }
            catch (IOException e) {
                this.logger.severe("IO error when reading hash data: " + e.getMessage());
            }
        } else {
            this.logger.severe("Invalid hash function: " + function);
        }
        return hash;
    }
}

