/*
 * Decompiled with CFR 0.152.
 */
package oracle.glcm.opatch.common.helpers;

import java.io.File;
import java.io.IOException;
import java.util.logging.Logger;
import oracle.glcm.opatch.common.api.PatchDeployArtifact;
import oracle.glcm.opatch.common.api.PatchMetadataLoadingException;
import oracle.glcm.opatch.common.api.PatchMetadataWritingException;
import oracle.glcm.opatch.common.impl.PatchFactoryImpl;

public class PatchDeployHelper {
    private static final Logger _log = Logger.getLogger(PatchDeployHelper.class.getName());
    public static final String NAMESPACE = "http://xmlns.oracle.com/cie/patch/pdy";
    public static final String PATCH_DEPLOY = "patch-deploy";
    public static final String RESOURCE_BASENAME = "patch";
    public static final String PATCH_DEPLOY_FILE_NAME = "patchDeploy.xml";
    private static PatchDeployHelper _instance;

    public static PatchDeployHelper getInstance() {
        if (_instance == null) {
            _instance = new PatchDeployHelper();
        }
        return _instance;
    }

    public String getPath() {
        return null;
    }

    public String getRootElement() {
        return PATCH_DEPLOY;
    }

    public String getNamespace() {
        return NAMESPACE;
    }

    public File generateDefault(File directory) throws PatchMetadataLoadingException, PatchMetadataWritingException, IOException {
        PatchFactoryImpl patchFactory = new PatchFactoryImpl();
        PatchDeployArtifact patchDeployArtifact = patchFactory.createPatchDeployArtifact();
        File tmpFile = File.createTempFile("patchDeploy", ".xml", directory);
        patchDeployArtifact.setPatchUptimeOption("FMW_ROLLING_ORACLE_HOME");
        patchDeployArtifact.save(tmpFile.getAbsolutePath());
        return tmpFile;
    }
}

