/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.helper.util;

import com.oracle.glcm.patch.auto.OPatchAutoException;
import com.oracle.glcm.patch.auto.OPatchAutoHelper;
import com.oracle.glcm.patch.auto.credential.Credential;
import com.oracle.glcm.patch.auto.credential.CredentialManager;
import com.oracle.glcm.patch.auto.credential.ValueHolder;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;

public class WalletHelper {
    public static Credential getCredentialForLocalHost(File walletLocation, char[] walletPassword) throws OPatchAutoException {
        return WalletHelper.getCredentialForLocalHost(walletLocation, walletPassword, System.getProperty("user.name"));
    }

    public static Credential getCredentialForLocalHost(File walletLocation, char[] walletPassword, String username) throws OPatchAutoException {
        String localHostName = null;
        try {
            localHostName = InetAddress.getLocalHost().getHostName();
            if (localHostName != null && localHostName.indexOf(".") != -1) {
                localHostName = localHostName.substring(0, localHostName.indexOf("."));
            }
        }
        catch (IOException e) {
            throw new OPatchAutoException(OPatchAutoHelper.getPublishedMessage((String)"70028", (Object[])new Object[]{walletLocation.getAbsolutePath()}), new Object[0]);
        }
        return WalletHelper.getCredentialForHost(walletLocation, walletPassword, localHostName, username);
    }

    public static Credential getCredentialForHost(File walletLocation, char[] walletPassword, String hostName, String username) throws OPatchAutoException {
        Credential credential;
        if (walletLocation == null) {
            throw new NullPointerException("The wallet location provided was null.");
        }
        try {
            CredentialManager manager = new CredentialManager();
            ValueHolder valueHolder = null;
            if (walletPassword != null && walletPassword.length > 0) {
                valueHolder = new ValueHolder(walletPassword);
            }
            manager.setWallet(walletLocation, valueHolder);
            credential = manager.getCredential(hostName, null, username);
            if (credential == null && !(credential = manager.getCredential(hostName, null, null)).getUsername().equalsIgnoreCase(username)) {
                credential = null;
            }
        }
        catch (Exception e) {
            throw new OPatchAutoException(OPatchAutoHelper.getPublishedMessage((String)"70028", (Object[])new Object[]{walletLocation.getAbsolutePath()}), new Object[0]);
        }
        if (credential == null) {
            throw new OPatchAutoException(OPatchAutoHelper.getPublishedMessage((String)"70029", (Object[])new Object[]{hostName}), new Object[0]);
        }
        return credential;
    }
}

