/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.helper.remote.ssh;

import com.oracle.cie.remote.RemoteConnectionException;
import com.oracle.cie.remote.RemoteConnectionHandler;
import com.oracle.cie.remote.RemoteConnectionHost;
import com.oracle.cie.remote.RemoteConnectionManager;
import com.oracle.glcm.patch.auto.topology.HostImpl;
import com.oracle.helper.remote.RemoteExecutionResult;
import com.oracle.helper.remote.RequestParam;
import com.oracle.helper.remote.ssh.RemoteSSHCommandListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

public class SSHEquivalenceCommandExecutor
implements Runnable {
    private Logger logger = Logger.getLogger(SSHEquivalenceCommandExecutor.class.getName());
    private List<RequestParam> requestParams;
    private String host;
    private RemoteSSHCommandListener commandListener;
    private static int FILE_NOT_FOUND = 2;
    private boolean exitOnFailure;
    private Map<RemoteExecutionResult.PrereqFailureCode, Throwable> prereqFailureMap = new HashMap<RemoteExecutionResult.PrereqFailureCode, Throwable>();

    public SSHEquivalenceCommandExecutor(List<RequestParam> requestParams, String host, RemoteSSHCommandListener commandListener, boolean exitOnFailure) {
        this.host = host;
        this.commandListener = commandListener;
        this.requestParams = requestParams;
        this.exitOnFailure = exitOnFailure;
    }

    @Override
    public void run() {
        this.logger.info("Executing remote commands using SSH equivalence via command line on host : " + this.host);
        ArrayList<RemoteExecutionResult> remoteExecutionResults = new ArrayList<RemoteExecutionResult>();
        this.executeAndNotify(remoteExecutionResults);
        this.commandListener.notifyResult(this.host, remoteExecutionResults);
    }

    private void executeAndNotify(List<RemoteExecutionResult> remoteExecutionResults) {
        for (RequestParam param : this.requestParams) {
            RemoteExecutionResult remoteExecutionResult;
            try {
                HostImpl connHost = new HostImpl();
                connHost.setHost(this.host);
                connHost.setRemoteConnectionType("linuxclisshuserequivalence");
                RemoteConnectionHandler handler = RemoteConnectionManager.getRemoteConnectionManager().getRemoteConnectionHandler((RemoteConnectionHost)connHost);
                this.logger.info("Handler for remote connection for " + this.host + " is " + handler);
                String command = param.getCommandToExecute();
                Map<RequestParam.PrereqCode, List<String>> prereqMap = param.getPrereqMap();
                boolean hasPrereqFailed = this.executePrereqs(prereqMap, handler);
                if (hasPrereqFailed) {
                    remoteExecutionResult = new RemoteExecutionResult();
                    remoteExecutionResult.setRequestParam(param);
                    remoteExecutionResult.setPrereqFailureMap(this.prereqFailureMap);
                    remoteExecutionResult.setResultID(4);
                    remoteExecutionResults.add(remoteExecutionResult);
                    continue;
                }
                this.logger.info("Executing command on host " + this.host + " : " + command);
                try {
                    String outPutMsg = handler.exec(command);
                    this.logger.info("Output from command execution on host " + this.host + " : " + outPutMsg);
                    remoteExecutionResult = new RemoteExecutionResult();
                    remoteExecutionResult.setRequestParam(param);
                    remoteExecutionResult.setOutputMsg(outPutMsg);
                    remoteExecutionResult.setResultID(3);
                    remoteExecutionResults.add(remoteExecutionResult);
                }
                catch (RemoteConnectionException e) {
                    this.logger.warning("Error while executing command \"" + command + "\" on host " + this.host + " : " + e.getMessage());
                    throw new Exception(e.getMessage());
                }
            }
            catch (Exception e) {
                this.logger.warning("Exception while executing command \"\" on host " + this.host + " : " + e.getMessage());
                remoteExecutionResult = new RemoteExecutionResult();
                remoteExecutionResult.setRequestParam(param);
                remoteExecutionResult.setException(e);
                remoteExecutionResult.setResultID(1);
                remoteExecutionResults.add(remoteExecutionResult);
                if (!this.exitOnFailure) continue;
                break;
            }
        }
    }

    private boolean executePrereqs(Map<RequestParam.PrereqCode, List<String>> prereqMap, RemoteConnectionHandler handler) {
        this.logger.info("Executing prereqs on host " + this.host + " : " + prereqMap);
        boolean hasPrereqFailed = false;
        for (Map.Entry<RequestParam.PrereqCode, List<String>> prereqMapEntry : prereqMap.entrySet()) {
            boolean loopPrereqFailed = false;
            if (!RequestParam.PrereqCode.HOME_EXIST_CHECK.equals((Object)prereqMapEntry.getKey())) continue;
            StringBuffer failureReason = new StringBuffer("");
            int failureCode = 0;
            for (String prereqCommand : prereqMapEntry.getValue()) {
                try {
                    boolean fileExists = handler.exists(prereqCommand);
                    if (fileExists) continue;
                    failureCode = FILE_NOT_FOUND;
                    failureReason.append(prereqCommand);
                    failureReason.append("not found").append(System.lineSeparator());
                    loopPrereqFailed = true;
                }
                catch (RemoteConnectionException e) {
                    failureReason.append(prereqCommand);
                    failureReason.append(e.getMessage()).append(System.lineSeparator());
                    loopPrereqFailed = true;
                }
            }
            if (!loopPrereqFailed) continue;
            if (!hasPrereqFailed) {
                hasPrereqFailed = loopPrereqFailed;
            }
            if (failureCode == FILE_NOT_FOUND) {
                this.preparePrereqFailure(failureReason, RemoteExecutionResult.PrereqFailureCode.HOME_DOES_NOT_EXIST);
                continue;
            }
            this.preparePrereqFailure(failureReason, RemoteExecutionResult.PrereqFailureCode.OTHER_PREREQ_FAILURE);
        }
        return hasPrereqFailed;
    }

    private void preparePrereqFailure(StringBuffer failureReason, RemoteExecutionResult.PrereqFailureCode prereqFailureCode) {
        String errorMsg = "Exception while executing prereq command on host " + this.host + " due to : \n " + failureReason;
        this.logger.warning(errorMsg);
        this.prereqFailureMap.put(prereqFailureCode, new Exception(errorMsg));
    }
}

