/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.helper.remote.exec;

import com.oracle.cie.remote.RemoteConnectionException;
import com.oracle.cie.remote.RemoteConnectionHandler;
import com.oracle.helper.remote.exec.RemoteRequestHandler;
import com.oracle.helper.remote.exec.model.FileOPeration;
import com.oracle.helper.remote.exec.model.OPeration;
import com.oracle.helper.remote.exec.model.TransferOPeration;
import java.io.File;
import java.util.logging.Logger;

public class RemoteOPerationExecutor {
    private static final Logger logger = Logger.getLogger(RemoteRequestHandler.class.getName());
    private OPeration operation;
    private final RemoteConnectionHandler handler;
    private final RemoteRequestHandler.RemoteOperationListener listener;

    public RemoteOPerationExecutor(RemoteConnectionHandler handler, RemoteRequestHandler.RemoteOperationListener listener) {
        this.handler = handler;
        this.listener = listener;
    }

    public void execute(OPeration operation) {
        this.operation = operation;
        OPeration.OPerationType type = operation.getType();
        logger.info("Started executing operation of type ::" + (Object)((Object)operation.getType()));
        try {
            switch (type) {
                case COPY: {
                    this.copy();
                    break;
                }
                case TRANSFER: {
                    this.transfer();
                    break;
                }
                case FILEEXIST: {
                    this.pathExists();
                    break;
                }
            }
        }
        catch (RemoteConnectionException e) {
            logger.info("RemoteConnectionException: " + e.getMessage());
            String cause = "";
            if (e.getCause() != null) {
                cause = e.getCause().getMessage();
                logger.info("RemoteConnectionException root cause: " + cause);
            }
            this.operation.setStatus(OPeration.Status.FAILED);
            this.operation.setErrorMsg(e.getMessage() + ":" + cause);
        }
        logger.finest("Notifying operation status");
        this.listener.notifyOperationResult(this.operation);
    }

    private void copy() throws RemoteConnectionException {
        TransferOPeration ops = (TransferOPeration)this.operation;
        logger.info("Copy Operation Source  @ :" + ops.getSrc());
        logger.info("Copy Operation Destination  @ :" + ops.getDest());
        if (this.handler.exists(ops.getSrc())) {
            this.handler.get(ops.getSrc(), new File(ops.getDest()));
            this.operation.setStatus(OPeration.Status.SUCCESS);
        }
    }

    private void transfer() throws RemoteConnectionException {
        TransferOPeration ops = (TransferOPeration)this.operation;
        logger.info("Transfer Operation Source  @ :" + ops.getDest());
        logger.info("Transfer Operation Destination  @ :" + ops.getSrc());
        File copyLocation = new File(ops.getSrc());
        String parentDirPath = copyLocation.getParent();
        if (!this.handler.exists(parentDirPath)) {
            this.handler.mkdir(parentDirPath);
        }
        this.handler.put(ops.getSrc(), new File(ops.getDest()));
        this.operation.setStatus(OPeration.Status.SUCCESS);
    }

    private void pathExists() throws RemoteConnectionException {
        FileOPeration ops = (FileOPeration)this.operation;
        logger.info("Checking path exists  @ :" + ops.getFileLoc());
        boolean success = this.handler.exists(ops.getFileLoc());
        if (success) {
            this.operation.setStatus(OPeration.Status.EXISTS);
        } else {
            this.operation.setStatus(OPeration.Status.NOTEXISTS);
        }
        logger.info("Checking path exists result  @ :" + (Object)((Object)this.operation.getStatus()));
    }
}

