/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.glcm.patch.auto.tracking;

import com.oracle.cie.common.util.Delete;
import com.oracle.cie.common.util.TempFileHandler;
import com.oracle.cie.common.util.reporting.Reporting;
import com.oracle.cie.remote.RemoteConnectionHandler;
import com.oracle.cie.remote.RemoteConnectionHost;
import com.oracle.glcm.patch.auto.OPatchAutoException;
import com.oracle.glcm.patch.auto.OPatchAutoHelper;
import com.oracle.glcm.patch.auto.lifecycle.Phase;
import com.oracle.glcm.patch.auto.topology.Instance;
import com.oracle.glcm.patch.auto.tracking.ConfigActionResult;
import com.oracle.glcm.patch.auto.tracking.ConfigPatchActionResultData;
import com.oracle.glcm.patch.auto.tracking.ConfigPatchResult;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import oracle.glcm.opatch.common.api.BasePatchFactory;
import oracle.glcm.opatch.common.api.DomainConfigInventory;
import oracle.glcm.opatch.common.api.DomainInventoryUpdatingException;
import oracle.glcm.opatch.common.api.Patch;
import oracle.glcm.opatch.common.api.PatchConfigAction;
import oracle.glcm.opatch.common.api.PatchDeployArtifact;
import oracle.glcm.opatch.common.api.PatchFactory;
import oracle.glcm.opatch.common.api.PatchType;
import oracle.glcm.opatch.common.helpers.PatchHelper;

public class InstanceInventory {
    private static final Logger _log = Logger.getLogger(InstanceInventory.class.getName());
    private static File _tempDir = null;
    private Instance _instance;
    private transient DomainConfigInventory _domainConfigInventory;

    public InstanceInventory(Instance instance) {
        if (instance == null) {
            throw new IllegalArgumentException("68144");
        }
        this._instance = instance;
    }

    public Instance getInstance() {
        return this._instance;
    }

    public List<Patch> getInstancePatchDelta(Phase phase) throws OPatchAutoException {
        return this.getInstancePatchDelta(phase, null);
    }

    public List<Patch> getInstancePatchDelta(Phase phase, List<Patch> currentPatches) throws OPatchAutoException {
        ArrayList<Patch> instancePatchDelta = null;
        DomainConfigInventory.PhaseType phaseType = this.getPhaseType(phase);
        if (phaseType != null) {
            instancePatchDelta = new ArrayList<Patch>();
            List<Patch> ohPatches = this.getPatchesInHome();
            if (currentPatches != null) {
                for (Patch currentPatch : currentPatches) {
                    for (Patch patch : PatchHelper.getAllPatches((Patch)currentPatch, (PatchType)PatchType.SINGLETON_PATCH).values()) {
                        if (ohPatches.contains(patch)) continue;
                        ohPatches.add(patch);
                    }
                }
            }
            try {
                DomainConfigInventory dci = this.getDomainConfigInventory();
                if (dci != null) {
                    instancePatchDelta.addAll(dci.getDelta(ohPatches, phaseType));
                } else {
                    instancePatchDelta.addAll(ohPatches);
                }
            }
            catch (Exception e) {
                throw new OPatchAutoException("68104", (Throwable)e, this.getInstance().getDisplayLocation());
            }
            finally {
                InstanceInventory.cleanup();
            }
        }
        return instancePatchDelta == null ? new ArrayList<Patch>() : instancePatchDelta;
    }

    public DomainConfigInventory getDomainConfigInventory() throws OPatchAutoException {
        if (this._domainConfigInventory == null) {
            try {
                String domainLocation = null;
                String dciDirPath = PatchHelper.getDomainConfigInventoryDirLocation((String)this.getInstance().getLocation());
                if (this.getInstance().getHost().isRemote()) {
                    String dciFilePath;
                    RemoteConnectionHandler handler = OPatchAutoHelper.getRemoteConnectionManager().getRemoteConnectionHandler((RemoteConnectionHost)this.getInstance().getHost());
                    if (handler.exists(dciFilePath = PatchHelper.getPatchConfigInventoryFileLocation((String)this.getInstance().getLocation()))) {
                        if (_tempDir == null) {
                            _tempDir = TempFileHandler.getTempFolder((String)"opatchauto", (String)".dci", (boolean)false);
                        }
                        File tempDomain = TempFileHandler.getTempFolder((String)"opatchauto", (String)".dci", (boolean)false, (File)_tempDir);
                        _log.info("Getting domain config inventory from remote instance " + this.getInstance().getDisplayLocation());
                        handler.get(dciDirPath, new File(PatchHelper.getDomainConfigInventoryDirLocation((String)tempDomain.getAbsolutePath())));
                        domainLocation = tempDomain.getAbsolutePath();
                    }
                } else {
                    _log.info("Getting domain config inventory from local instance " + this.getInstance().getDisplayLocation());
                    domainLocation = this.getInstance().getLocation();
                }
                if (domainLocation != null) {
                    this._domainConfigInventory = BasePatchFactory.instance().getDomainConfigInventory(domainLocation);
                }
            }
            catch (Throwable t) {
                throw new OPatchAutoException("68105", t, this.getInstance().getDisplayLocation());
            }
        }
        try {
            if (this._domainConfigInventory != null) {
                this._domainConfigInventory.createPatchEntries(this.getPatchesInHome());
            }
        }
        catch (DomainInventoryUpdatingException e) {
            throw new OPatchAutoException("68105", (Throwable)e, this.getInstance().getDisplayLocation());
        }
        return this._domainConfigInventory;
    }

    public List<Patch> getPatchesInHome() throws OPatchAutoException {
        ArrayList<Patch> homePatches;
        try {
            if (this.getInstance().getHost().isRemote()) {
                List dirs;
                _log.info("Getting patches in remote home " + this.getInstance().getHome().getDisplayLocation());
                homePatches = new ArrayList();
                RemoteConnectionHandler handler = OPatchAutoHelper.getRemoteConnectionManager().getRemoteConnectionHandler((RemoteConnectionHost)this.getInstance().getHost());
                String oneOffsDir = PatchHelper.getOneoffsDirectoryPath((String)this.getInstance().getHome().getLocation());
                if (handler.exists(oneOffsDir) && (dirs = handler.ls(oneOffsDir)) != null && !dirs.isEmpty()) {
                    PatchFactory patchFactory = BasePatchFactory.instance();
                    File remotePatchesCache = new File(OPatchAutoHelper.getOPatchAutoHome(), "inventory/opatchauto/remote-patches");
                    for (String patchId : dirs) {
                        Patch patch = PatchHelper.getCachedPatch((String)patchId);
                        if (patch != null) continue;
                        File localPatchDir = new File(remotePatchesCache, patchId);
                        if (!localPatchDir.exists()) {
                            handler.get(oneOffsDir + "/" + patchId, localPatchDir);
                        }
                        patch = patchFactory.createPatch(localPatchDir.getAbsolutePath());
                        PatchHelper.cachePatch((Patch)patch);
                        homePatches.add(patch);
                    }
                }
            } else {
                _log.info("Getting patches in local home " + this.getInstance().getHome().getDisplayLocation());
                homePatches = PatchHelper.getPatchesInOH((String)this.getInstance().getHome().getLocation());
            }
        }
        catch (Exception e) {
            throw new OPatchAutoException("68145", (Throwable)e, this.getInstance().getHome().getDisplayLocation());
        }
        _log.info("Found patches " + PatchHelper.getPatchIds(homePatches) + " in home " + this.getInstance().getHome().getDisplayLocation());
        return homePatches;
    }

    public void updateDeltaPatchActionStatus(Phase phase, ConfigPatchActionResultData result) throws OPatchAutoException {
        if (result == null) {
            return;
        }
        DomainConfigInventory.PhaseType phaseType = this.getPhaseType(phase);
        if (phaseType != null) {
            if (this.getInstance().getHost().isRemote()) {
                _log.severe("Updates to the delta patch action status is only supported locally.  An attempt was made to update instance " + this.getInstance() + " on host " + this.getInstance().getHost());
                throw new OPatchAutoException("68146", new Object[0]);
            }
            DomainConfigInventory domainConfigInventory = this.getDomainConfigInventory();
            for (ConfigPatchResult configPatchResult : result.getPatchResultList()) {
                Patch patch = configPatchResult.getPatch();
                HashMap<DomainConfigInventory.PhaseType, ArrayList<PatchConfigAction>> phaseActions = new HashMap<DomainConfigInventory.PhaseType, ArrayList<PatchConfigAction>>();
                List patchDeploys = patch.getPatchDeployArtifacts();
                if (patchDeploys != null && !patchDeploys.isEmpty()) {
                    for (PatchDeployArtifact patchDeploy : patchDeploys) {
                        List patchConfigActions = patchDeploy.getPatchConfigAction();
                        if (patchConfigActions == null || patchConfigActions.isEmpty()) continue;
                        for (PatchConfigAction patchConfigAction : patchConfigActions) {
                            List categories = patchConfigAction.getCategory();
                            for (String category : categories) {
                                DomainConfigInventory.PhaseType p = DomainConfigInventory.PhaseType.valueOf((String)category.toUpperCase());
                                ArrayList<PatchConfigAction> a = (ArrayList<PatchConfigAction>)phaseActions.get(p);
                                if (a == null) {
                                    a = new ArrayList<PatchConfigAction>();
                                    phaseActions.put(p, a);
                                }
                                a.add(patchConfigAction);
                            }
                        }
                    }
                }
                List actions = (List)phaseActions.get(phaseType);
                try {
                    DomainConfigInventory.Status status = null;
                    if (actions == null || actions.isEmpty()) {
                        status = DomainConfigInventory.Status.SUCCESS;
                        domainConfigInventory.updateActionStatus(null, patch.getPatchId(), phaseType, status);
                        continue;
                    }
                    for (PatchConfigAction patchConfigAction : actions) {
                        ConfigActionResult configActionResult = configPatchResult.getConfigActionResult(patchConfigAction.getId());
                        if (configActionResult == null) continue;
                        status = configActionResult.getStatus();
                        domainConfigInventory.updateActionStatus(patchConfigAction.getId(), patch.getPatchId(), phaseType, status);
                    }
                }
                catch (Exception e) {
                    Reporting.report((String)"Exception");
                    throw new OPatchAutoException("68147", (Throwable)e, patch.getPatchId(), this.getInstance().getDisplayLocation());
                }
            }
        }
    }

    public Map<String, String> getDeltaPatchUptimeOptions(List<Patch> currentPatches) throws OPatchAutoException {
        HashMap<String, String> uptimeOptions = new HashMap<String, String>();
        List<Patch> instancePatchDelta = this.getInstancePatchDelta(Phase.offline, currentPatches);
        LinkedHashMap patches = new LinkedHashMap();
        for (Patch patch : instancePatchDelta) {
            patches.putAll(PatchHelper.getAllPatches((Patch)patch, (PatchType)PatchType.SINGLETON_PATCH));
        }
        for (Map.Entry entry : patches.entrySet()) {
            List patchDeploys = ((Patch)entry.getValue()).getPatchDeployArtifacts();
            if (patchDeploys != null && !patchDeploys.isEmpty()) {
                for (PatchDeployArtifact patchDeploy : patchDeploys) {
                    uptimeOptions.put((String)entry.getKey(), patchDeploy.getPatchUptimeOption());
                }
                continue;
            }
            uptimeOptions.put((String)entry.getKey(), (String)null);
        }
        return uptimeOptions;
    }

    private DomainConfigInventory.PhaseType getPhaseType(Phase phase) {
        DomainConfigInventory.PhaseType phaseType = null;
        if (phase.isOffline()) {
            phaseType = DomainConfigInventory.PhaseType.OFFLINE;
        } else if (phase.isOnline()) {
            phaseType = DomainConfigInventory.PhaseType.ONLINE;
        } else {
            _log.warning("The " + (Object)((Object)phase) + " phase is not supported by the instance patch inventory delta processing.");
        }
        return phaseType;
    }

    public static void cleanup() {
        if (_tempDir != null) {
            Delete.delete((File)_tempDir);
        }
    }
}

