/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.glcm.patch.auto.report.patches;

import com.oracle.cie.common.util.reporting.Reporting;
import com.oracle.glcm.patch.auto.OPatchAutoHelper;
import com.oracle.glcm.patch.auto.report.OPatchAutoReporting;
import com.oracle.glcm.patch.auto.report.ReportingData;
import com.oracle.glcm.patch.auto.report.bindings.Home;
import com.oracle.glcm.patch.auto.report.bindings.HomePatchLevel;
import com.oracle.glcm.patch.auto.report.bindings.Host;
import com.oracle.glcm.patch.auto.report.bindings.ObjectFactory;
import com.oracle.glcm.patch.auto.report.bindings.Patch;
import com.oracle.glcm.patch.auto.report.patches.PatchLevel;
import com.oracle.glcm.patch.auto.report.patches.PatchReportingData;
import com.oracle.glcm.patch.auto.session.PatchTarget;
import java.io.File;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;

public class PatchReporting
implements OPatchAutoReporting {
    protected HomePatchLevel homePatchLevel = null;
    private static final Logger _log = Logger.getLogger(PatchReporting.class.getName());

    @Override
    public boolean store(PatchTarget target, ReportingData data) {
        if (this.homePatchLevel == null) {
            this.homePatchLevel = new HomePatchLevel();
        }
        this.addHomePatchLevel(target, data);
        return true;
    }

    @Override
    public boolean report(String location, String format, String version) {
        boolean report = false;
        this.homePatchLevel.setVersion(version);
        if (format.equals("xml")) {
            try {
                this.displayReport(this.homePatchLevel, location);
                report = true;
            }
            catch (JAXBException e) {
                _log.warning("Failed to save report " + e.getMessage());
            }
        }
        return report;
    }

    private void addHomePatchLevel(PatchTarget target, ReportingData data) {
        ArrayList<Host> hostList = new ArrayList<Host>();
        String hostName = target.getHost().getHost();
        Host host = this.getHost(hostList, hostName);
        if (host == null) {
            host = new Host();
            host.setName(hostName);
            hostList.add(host);
        }
        Home home = new Home();
        home.setPath(target.getHome().getLocation());
        home.setType(target.getProductType().getType());
        List<PatchLevel> patches = ((PatchReportingData)data).getReportingData();
        ArrayList<Patch> patchList = new ArrayList<Patch>(patches.size());
        for (PatchLevel patch : patches) {
            Patch p = new Patch();
            p.setId(patch.getId());
            p.setUniquePatchId(patch.getUniqueID());
            p.setIsSqlpatch(patch.isSqlPatch());
            patchList.add(p);
        }
        home.getPatch().addAll(patchList);
        host.getHomes().add(home);
        this.homePatchLevel.getHost().addAll(hostList);
    }

    private Host getHost(List<Host> hostList, String hostName) {
        Host host = null;
        for (Host h : hostList) {
            if (!h.getName().equals(hostName)) continue;
            host = h;
            break;
        }
        return host;
    }

    private void displayReport(HomePatchLevel homePatchLevel, String location) throws JAXBException {
        JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{HomePatchLevel.class});
        Marshaller jaxbMarshaller = jaxbContext.createMarshaller();
        jaxbMarshaller.setProperty("jaxb.formatted.output", (Object)true);
        if (location.equals("console")) {
            StringWriter sw = new StringWriter();
            jaxbMarshaller.marshal(new ObjectFactory().createHomePatchLevel(homePatchLevel), (Writer)sw);
            Reporting.report((String)OPatchAutoHelper.getLocalizedString("OPatchAuto.report.patches.start", new Object[0]));
            Reporting.report((String)sw.toString());
            Reporting.report((String)OPatchAutoHelper.getLocalizedString("OPatchAuto.report.patches.end", new Object[0]));
        } else {
            File parent;
            File report = new File(location);
            if (report.isFile() && report.exists()) {
                report.delete();
            }
            if (!(parent = new File(report.getParent())).exists()) {
                parent.mkdirs();
            }
            jaxbMarshaller.marshal(new ObjectFactory().createHomePatchLevel(homePatchLevel), report);
        }
    }
}

