/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.glcm.patch.auto.plan;

import com.oracle.glcm.patch.auto.plan.PatchPlanIncrementContainer;
import com.oracle.glcm.patch.auto.plan.PatchPlanIncrementContainerImpl;
import com.oracle.glcm.patch.auto.plan.PatchPlanIncrementSetCreator;
import com.oracle.glcm.patch.auto.plan.PatchPlanIncrementType;
import com.oracle.glcm.patch.auto.session.PatchTarget;
import com.oracle.glcm.patch.auto.topology.Home;
import com.oracle.glcm.patch.auto.topology.Host;
import com.oracle.glcm.patch.auto.topology.Instance;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Set;

public class PatchPlanIncrementSetCreatorImpl
implements PatchPlanIncrementSetCreator {
    private PatchPlanIncrementType _incrementType;

    private PatchPlanIncrementSetCreatorImpl(PatchPlanIncrementType incrementType) {
        this._incrementType = incrementType;
    }

    @Override
    public Set<PatchPlanIncrementContainer> getContainers(Set<PatchTarget> patchTargets) {
        LinkedHashSet<PatchPlanIncrementContainer> containers;
        block11: {
            block13: {
                block12: {
                    block10: {
                        containers = new LinkedHashSet<PatchPlanIncrementContainer>();
                        if (this._incrementType != DefaultPatchPlanIncrementType.target) break block10;
                        for (PatchTarget patchTarget : patchTargets) {
                            LinkedHashSet<PatchTarget> patchTargetSet = new LinkedHashSet<PatchTarget>();
                            patchTargetSet.add(patchTarget);
                            containers.add(new PatchPlanIncrementContainerImpl(patchTargetSet));
                        }
                        break block11;
                    }
                    if (this._incrementType != DefaultPatchPlanIncrementType.host) break block12;
                    LinkedHashMap<Host, LinkedHashSet<PatchTarget>> hostToPatchTargets = new LinkedHashMap<Host, LinkedHashSet<PatchTarget>>();
                    for (PatchTarget patchTarget : patchTargets) {
                        Host host = patchTarget.getHost();
                        LinkedHashSet<PatchTarget> patchTargetSet = (LinkedHashSet<PatchTarget>)hostToPatchTargets.get(host);
                        if (patchTargetSet == null) {
                            patchTargetSet = new LinkedHashSet<PatchTarget>();
                            hostToPatchTargets.put(host, patchTargetSet);
                        }
                        patchTargetSet.add(patchTarget);
                    }
                    for (Set patchTargetSet : hostToPatchTargets.values()) {
                        containers.add(new PatchPlanIncrementContainerImpl(patchTargetSet));
                    }
                    break block11;
                }
                if (this._incrementType != DefaultPatchPlanIncrementType.home) break block13;
                LinkedHashMap<Home, LinkedHashSet<PatchTarget>> homeToPatchTargets = new LinkedHashMap<Home, LinkedHashSet<PatchTarget>>();
                for (PatchTarget patchTarget : patchTargets) {
                    Home home = patchTarget.getHome();
                    LinkedHashSet<PatchTarget> patchTargetSet = (LinkedHashSet<PatchTarget>)homeToPatchTargets.get(home);
                    if (patchTargetSet == null) {
                        patchTargetSet = new LinkedHashSet<PatchTarget>();
                        homeToPatchTargets.put(home, patchTargetSet);
                    }
                    patchTargetSet.add(patchTarget);
                }
                for (Set patchTargetSet : homeToPatchTargets.values()) {
                    containers.add(new PatchPlanIncrementContainerImpl(patchTargetSet));
                }
                break block11;
            }
            if (this._incrementType != DefaultPatchPlanIncrementType.instance) break block11;
            LinkedHashMap<Instance, LinkedHashSet<PatchTarget>> instanceToPatchTargets = new LinkedHashMap<Instance, LinkedHashSet<PatchTarget>>();
            for (PatchTarget patchTarget : patchTargets) {
                Instance instance = patchTarget.getInstance();
                if (instance == null) continue;
                LinkedHashSet<PatchTarget> patchTargetSet = (LinkedHashSet<PatchTarget>)instanceToPatchTargets.get(instance);
                if (patchTargetSet == null) {
                    patchTargetSet = new LinkedHashSet<PatchTarget>();
                    instanceToPatchTargets.put(instance, patchTargetSet);
                }
                patchTargetSet.add(patchTarget);
            }
            for (Set patchTargetSet : instanceToPatchTargets.values()) {
                containers.add(new PatchPlanIncrementContainerImpl(patchTargetSet));
            }
        }
        return containers;
    }

    public static enum DefaultPatchPlanIncrementType implements PatchPlanIncrementType
    {
        target,
        host,
        home,
        instance;


        @Override
        public PatchPlanIncrementSetCreator getPatchPlanIncrementSetCreator() {
            return new PatchPlanIncrementSetCreatorImpl(this);
        }
    }
}

