/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.glcm.patch.auto.action;

import com.oracle.cie.common.util.StringUtil;
import com.oracle.glcm.patch.auto.OPatchAutoException;
import com.oracle.glcm.patch.auto.action.PatchAction;
import com.oracle.glcm.patch.auto.action.PatchActionManager;
import com.oracle.glcm.patch.auto.lifecycle.Goal;
import com.oracle.glcm.patch.auto.lifecycle.PatchPhase;
import com.oracle.glcm.patch.auto.lifecycle.Phase;
import com.oracle.glcm.patch.auto.session.PatchSession;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class PatchActionManagerImpl
implements PatchActionManager {
    private Map<Goal, List<PatchAction>> _patchActions;

    public PatchActionManagerImpl(Set<Class<? extends PatchAction>> patchActionClasses) throws OPatchAutoException {
        this._patchActions = this.loadPatchActions(patchActionClasses);
    }

    protected Map<Goal, List<PatchAction>> loadPatchActions(Set<Class<? extends PatchAction>> patchActionClasses) throws OPatchAutoException {
        LinkedHashMap<Goal, List<PatchAction>> patchActions = new LinkedHashMap<Goal, List<PatchAction>>();
        ArrayList<PatchAction> actionClasses = new ArrayList<PatchAction>();
        if (patchActionClasses != null) {
            for (Class clazz : patchActionClasses) {
                try {
                    PatchAction patchAction = (PatchAction)clazz.newInstance();
                    actionClasses.add(patchAction);
                }
                catch (Exception e) {
                    throw new OPatchAutoException("68080", (Throwable)e, clazz);
                }
            }
        }
        if (!actionClasses.isEmpty()) {
            for (Phase phase : Phase.values()) {
                PatchPhase patchPhase = phase.getPhaseInstance();
                for (final Goal goal : patchPhase.getGoals()) {
                    ArrayList<PatchAction> goalActions = new ArrayList<PatchAction>();
                    for (PatchAction patchAction : actionClasses) {
                        for (Goal actionGoal : patchAction.getGoals()) {
                            if (goal != actionGoal) continue;
                            goalActions.add(patchAction);
                        }
                    }
                    Collections.sort(goalActions, new Comparator<PatchAction>(){

                        @Override
                        public int compare(PatchAction action1, PatchAction action2) {
                            int weight2;
                            int weight1 = action1.getOrderingWeight(goal);
                            if (weight1 >= (weight2 = action2.getOrderingWeight(goal))) {
                                return 1;
                            }
                            return -1;
                        }
                    });
                    patchActions.put(goal, goalActions);
                }
            }
        }
        return patchActions;
    }

    @Override
    public void setPatchSession(PatchSession patchSession) {
        for (List<PatchAction> patchActions : this.getPatchActions().values()) {
            for (PatchAction patchAction : patchActions) {
                patchAction.setPatchSession(patchSession);
            }
        }
    }

    @Override
    public List<PatchAction> getPatchActions(Goal goal) {
        return this._patchActions.get(goal);
    }

    @Override
    public Map<Goal, List<PatchAction>> getPatchActions() {
        return this._patchActions;
    }

    @Override
    public PatchAction getPatchAction(String name) {
        if (!StringUtil.isNullOrEmpty((String)name, (boolean)true)) {
            for (List<PatchAction> patchActions : this.getPatchActions().values()) {
                for (PatchAction patchAction : patchActions) {
                    if (!patchAction.getClass().getName().equals(name)) continue;
                    return patchAction;
                }
            }
        }
        return null;
    }
}

