/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.glcm.patch.auto.action;

import com.oracle.cie.remote.RemoteConnectionException;
import com.oracle.cie.remote.RemoteConnectionHandler;
import com.oracle.glcm.patch.auto.OPatchAutoException;
import com.oracle.glcm.patch.auto.OPatchAutoHelper;
import com.oracle.glcm.patch.auto.OPatchAutoOptions;
import com.oracle.glcm.patch.auto.action.PatchAction;
import com.oracle.glcm.patch.auto.action.PatchActionException;
import com.oracle.glcm.patch.auto.action.PatchActionExecutorContainer;
import com.oracle.glcm.patch.auto.action.PatchActionResult;
import com.oracle.glcm.patch.auto.action.PatchActionStatus;
import com.oracle.glcm.patch.auto.lifecycle.Goal;
import com.oracle.glcm.patch.auto.lifecycle.Phase;
import com.oracle.glcm.patch.auto.session.MutablePatchSession;
import com.oracle.glcm.patch.auto.session.PatchSession;
import com.oracle.glcm.patch.auto.session.PatchTarget;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;

public abstract class CommonPatchAction
implements PatchAction {
    protected final Logger _logger = Logger.getLogger(this.getClass().getName());
    protected Set<Goal> _goals = new LinkedHashSet<Goal>();
    protected PatchSession _patchSession;

    protected CommonPatchAction(Goal ... goals) {
        if (goals != null && goals.length > 0) {
            this._goals.addAll(Arrays.asList(goals));
        }
    }

    @Override
    public boolean isActionRequired(PatchTarget patchTarget) throws PatchActionException {
        return true;
    }

    @Override
    public boolean isActionRequiredNeeded() {
        try {
            Class<?> declaringClass = this.getClass().getMethod("isActionRequired", PatchTarget.class).getDeclaringClass();
            if (CommonPatchAction.class.equals(declaringClass)) {
                return false;
            }
        }
        catch (NoSuchMethodException e) {
            this._logger.log(Level.WARNING, "Unable to locate isActionRequired method in " + this.getClass(), e);
        }
        return true;
    }

    @Override
    public boolean isActionRequiredLocalOnly() {
        return false;
    }

    @Override
    public Set<Phase> getPhases() {
        LinkedHashSet<Phase> phases = new LinkedHashSet<Phase>();
        for (Goal goal : this.getGoals()) {
            phases.add(goal.getPhase());
        }
        return phases;
    }

    @Override
    public Set<Goal> getGoals() {
        return this._goals;
    }

    @Override
    public PatchSession getPatchSession() {
        return this._patchSession;
    }

    @Override
    public void setPatchSession(PatchSession session) {
        this._patchSession = session;
    }

    @Override
    public boolean isRollbackSupported() {
        return false;
    }

    @Override
    public boolean isRemoteParallelExecutionSupported() {
        return true;
    }

    @Override
    public boolean isLocalParallelExecutionSupported() {
        return false;
    }

    @Override
    public boolean isRemoteExecutionHandled(PatchTarget patchTarget) throws OPatchAutoException {
        return false;
    }

    @Override
    public boolean isLocalTargetsToBeExecutedFirst() {
        return false;
    }

    @Override
    public boolean isRemoteOutOfPlaceRequired() {
        return false;
    }

    @Override
    public void prepareRemoteActionExecutionHost(RemoteConnectionHandler handler, PatchActionExecutorContainer container) throws RemoteConnectionException, PatchActionException {
    }

    @Override
    public void setupRemoteActionExecutionEnvironment(MutablePatchSession patchSession, PatchActionExecutorContainer container) throws PatchActionException {
    }

    @Override
    public boolean isAnalyzeSupported() {
        return false;
    }

    @Override
    public long getExecutionProgressLength() {
        return -1L;
    }

    @Override
    public void setCurrentExecutionProgress(long current) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
            }
        });
    }

    @Override
    public String getDisplayName() {
        return this.getClass().getSimpleName();
    }

    @Override
    public String getDescription() {
        return null;
    }

    @Override
    public void updateOptions(OPatchAutoOptions options, Set<Goal> goals) throws OPatchAutoException {
    }

    @Override
    public int getOrderingWeight(Goal goal) {
        return 100;
    }

    public Goal getCurrentGoal() {
        PatchSession session = this.getPatchSession();
        if (session == null) {
            throw new IllegalStateException(OPatchAutoHelper.getPublishedMessage("68063", new Object[0]));
        }
        return session.getCurrentGoal();
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    @Override
    public PatchAction clone() throws CloneNotSupportedException {
        try {
            PatchAction patchAction = (PatchAction)this.getClass().newInstance();
            patchAction.setPatchSession(this.getPatchSession());
            return patchAction;
        }
        catch (Exception e) {
            this._logger.log(Level.SEVERE, "Failed to clone patch action " + this.getClass(), e);
            throw new CloneNotSupportedException(OPatchAutoHelper.getPublishedMessage("68064", this.getClass()));
        }
    }

    @Override
    public void postExecute(PatchTarget patchTarget, PatchActionResult patchActionResult) throws OPatchAutoException {
    }

    @Override
    public String getStatusMessage(PatchTarget patchTarget, PatchActionStatus status) {
        return null;
    }
}

