/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.glcm.patch.auto;

import com.oracle.cie.common.util.StringUtil;
import com.oracle.glcm.patch.auto.OPatchAutoCommand;
import com.oracle.glcm.patch.auto.OPatchAutoException;
import com.oracle.glcm.patch.auto.OPatchAutoHelper;
import com.oracle.glcm.patch.auto.credential.ValueHolder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;

public class OPatchAutoOption {
    private String _key;
    private String _arg;
    private String _description;
    private boolean _switch;
    private boolean _required;
    private boolean _parameter;
    private boolean _global;
    private boolean _perCommandGlobal;
    private boolean _isPassword;
    private boolean _tracked = true;
    private boolean _visible = true;
    private boolean _usingDefault;
    private OPatchAutoCommand[] _commands;
    private Set<String> _patchPlans;
    private String _value;
    private ValueHolder _passwordValue;
    private DefaultValueResolver _defaultValueResolver;
    private String[] _supportedValues;
    private ValueValidator _validator;
    private Object[] _descriptionMessageFormatting;
    private boolean _disabled;

    public static OPatchAutoOption getCommandOption(String key, String arg, String description, OPatchAutoCommand ... commands) {
        return new OPatchAutoOption(key, arg, description, false, false, false, false, commands);
    }

    public static OPatchAutoOption getCommandOption(String key, String arg, String description, boolean isSwitch, boolean required, OPatchAutoCommand ... commands) {
        return new OPatchAutoOption(key, arg, description, isSwitch, required, false, false, commands);
    }

    public static OPatchAutoOption getParameterOption(String key, String arg, String description, boolean required, OPatchAutoCommand ... commands) {
        return new OPatchAutoOption(key, arg, description, false, required, true, false, commands);
    }

    public static OPatchAutoOption getGlobalOption(String key, String arg, String description, boolean isSwitch, boolean required) {
        return new OPatchAutoOption(key, arg, description, isSwitch, required, false, true, new OPatchAutoCommand[0]);
    }

    protected OPatchAutoOption(String key, String arg, String description, boolean isSwitch, boolean required, boolean parameter, boolean global, OPatchAutoCommand ... commands) {
        this._key = key;
        this._arg = arg;
        this._description = description;
        this._switch = isSwitch;
        this._required = required;
        this._parameter = parameter;
        this._global = global;
        this._commands = commands;
    }

    public String getKey() {
        return this._key;
    }

    public String getArg() {
        return this._arg;
    }

    public String getDescription() {
        if (this._description != null) {
            return OPatchAutoHelper.getLocalizedString(this._description, this.getDescriptionMessageFormatting());
        }
        return null;
    }

    public Object[] getDescriptionMessageFormatting() {
        return this._descriptionMessageFormatting;
    }

    public void setDescriptionMessageFormatting(Object ... descriptionMessageFormatting) {
        this._descriptionMessageFormatting = descriptionMessageFormatting;
    }

    public boolean isSwitch() {
        return this._switch;
    }

    public boolean isSwitchEnabled() throws OPatchAutoException {
        boolean isSwitchEnabled = false;
        if (!this.isSwitch()) {
            throw new OPatchAutoException("68152", this.getArg());
        }
        isSwitchEnabled = this.hasValue() && Boolean.parseBoolean(this.getValue());
        return isSwitchEnabled;
    }

    public boolean isRequired() {
        return this._required;
    }

    public void setRequired(boolean required) {
        this._required = required;
    }

    public boolean isParameter() {
        return this._parameter;
    }

    public boolean isGlobal() {
        return this._global;
    }

    public boolean isPerCommandGlobal() {
        return this._perCommandGlobal;
    }

    public void setPerCommandGlobal(boolean perCommandGlobal) {
        this._perCommandGlobal = perCommandGlobal;
    }

    public boolean isPassword() {
        return this._isPassword;
    }

    public void setPassword(boolean isPassword) {
        this._isPassword = isPassword;
    }

    public boolean isTracked() {
        return this._tracked;
    }

    public void setTracked(boolean tracked) {
        this._tracked = tracked;
    }

    public OPatchAutoCommand[] getCommands() {
        return this._commands;
    }

    public void setCommands(OPatchAutoCommand ... commands) {
        this._commands = commands;
    }

    public boolean hasCommand(OPatchAutoCommand command) {
        OPatchAutoCommand[] commands;
        if (command != null && (commands = this.getCommands()) != null) {
            for (OPatchAutoCommand c : this.getCommands()) {
                if (c != command) continue;
                return true;
            }
        }
        return false;
    }

    public Set<String> getPatchPlans() {
        return this._patchPlans;
    }

    public void setPatchPlans(Set<String> patchPlans) {
        this._patchPlans = patchPlans;
    }

    public void addPatchPlans(String ... patchPlans) {
        if (patchPlans != null) {
            if (this._patchPlans == null) {
                this._patchPlans = new LinkedHashSet<String>();
            }
            this._patchPlans.addAll(Arrays.asList(patchPlans));
        }
    }

    public boolean hasPatchPlan(String plan) {
        Set<String> patchPlans = this.getPatchPlans();
        return patchPlans != null && patchPlans.contains(plan);
    }

    public boolean isPatchPlanSpecific() {
        Set<String> patchPlans = this.getPatchPlans();
        return patchPlans != null && !patchPlans.isEmpty();
    }

    public boolean isVisible() {
        return this._visible && !StringUtil.isNullOrEmpty((String)this.getArg(), (boolean)true);
    }

    public void setVisible(boolean visible) {
        this._visible = visible;
    }

    public boolean isUsingDefault() {
        return this._usingDefault;
    }

    public String getValue() throws OPatchAutoException {
        return this.getValue(null);
    }

    public String getValue(String defaultValue) throws OPatchAutoException {
        if (this.isPassword()) {
            throw new IllegalStateException("Password option values must be retrieved via the getPasswordValue() method.");
        }
        if (this._value == null) {
            if (!StringUtil.isNullOrEmpty((String)defaultValue, (boolean)true)) {
                this._value = defaultValue;
                this._usingDefault = true;
            } else if (this.hasDefaultValue()) {
                this._value = this.getDefaultValue();
                this._usingDefault = true;
            }
        }
        return this._value;
    }

    public void setValue(String value) {
        if (this.isPassword()) {
            throw new IllegalStateException("Password option values must be set via the setPasswordValue() method.");
        }
        this._value = value;
        this._usingDefault = false;
    }

    public char[] getPasswordValue() throws OPatchAutoException {
        return this._passwordValue != null ? this._passwordValue.getValue() : null;
    }

    public void setPasswordValue(char[] value) throws OPatchAutoException {
        this._passwordValue = value != null && value.length > 0 ? new ValueHolder(value) : null;
    }

    public boolean hasValue() throws OPatchAutoException {
        if (this.isPassword()) {
            return this._passwordValue != null;
        }
        return !StringUtil.isNullOrEmpty((String)this.getValue(), (boolean)true);
    }

    public boolean hasDefaultValue() {
        return this._defaultValueResolver != null;
    }

    public String getDefaultValue() throws OPatchAutoException {
        return this._defaultValueResolver.getDefaultValue();
    }

    public void setDefaultValue(final String defaultValue) {
        this._defaultValueResolver = new DefaultValueResolver(){

            @Override
            public String getDefaultValue() {
                return defaultValue;
            }
        };
    }

    public void setDefaultValueResolver(DefaultValueResolver resolver) {
        this._defaultValueResolver = resolver;
    }

    public String getCommandLineDescription() {
        String s = this.getArg();
        if (!this.isSwitch()) {
            s = s + " <" + this.getKey() + ">";
        }
        return s;
    }

    public String[] getSupportedValues() {
        return this._supportedValues;
    }

    public void setSupportedValues(String[] supportedValues) {
        this._supportedValues = supportedValues;
    }

    public boolean isDisabled() {
        return this._disabled;
    }

    public void setDisabled(boolean disabled) {
        this._disabled = disabled;
        if (disabled) {
            this._visible = false;
        }
    }

    public boolean hasSupportedValues() {
        return this.getSupportedValues() != null && this.getSupportedValues().length > 0;
    }

    public void setValueValidator(ValueValidator validator) {
        this._validator = validator;
    }

    public void validate() throws OPatchAutoException {
        if (this._validator != null) {
            this._validator.validate(this.getValue());
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof OPatchAutoOption)) {
            return false;
        }
        OPatchAutoOption option = (OPatchAutoOption)o;
        if (this._arg != null ? !this._arg.equals(option._arg) : option._arg != null) {
            return false;
        }
        return !(this._key != null ? !this._key.equals(option._key) : option._key != null);
    }

    public int hashCode() {
        int result = this._key != null ? this._key.hashCode() : 0;
        result = 31 * result + (this._arg != null ? this._arg.hashCode() : 0);
        return result;
    }

    public String toString() {
        return this._key + ':' + this._arg;
    }

    public String getCommandLineString() throws OPatchAutoException {
        String s = "";
        Collection<String> collection = this.getCommandLine();
        if (!collection.isEmpty()) {
            for (String c : collection) {
                if (s.isEmpty()) {
                    s = c;
                    continue;
                }
                s = s + " " + c;
            }
        }
        return s;
    }

    public Collection<String> getCommandLine() throws OPatchAutoException {
        ArrayList<String> c = new ArrayList<String>();
        if (this.hasValue()) {
            if (this.isSwitch()) {
                if (Boolean.parseBoolean(this.getValue())) {
                    c.add(this.getArg());
                }
            } else if (this.isParameter()) {
                c.add(this.getValue());
            } else {
                c.add(this.getArg());
                c.add(this.getValue());
            }
        }
        return c;
    }

    public static interface ValueValidator {
        public void validate(String var1) throws OPatchAutoException;
    }

    public static interface DefaultValueResolver {
        public String getDefaultValue() throws OPatchAutoException;
    }
}

