/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.glcm.patch.auto;

import com.oracle.cie.common.comdev.ComdevHelper;
import com.oracle.cie.common.services.ClassLoaderService;
import com.oracle.cie.common.util.DirectoryCopy;
import com.oracle.cie.common.util.IOUtil;
import com.oracle.cie.common.util.PublishedMessage;
import com.oracle.cie.common.util.ResourceBundleManager;
import com.oracle.cie.common.util.StringUtil;
import com.oracle.cie.common.util.TempFileHandler;
import com.oracle.cie.common.util.reporting.Reporting;
import com.oracle.cie.remote.RemoteConnectionException;
import com.oracle.cie.remote.RemoteConnectionHandler;
import com.oracle.cie.remote.RemoteConnectionHost;
import com.oracle.cie.remote.RemoteConnectionManager;
import com.oracle.glcm.patch.auto.ClasspathCopier;
import com.oracle.glcm.patch.auto.OPatchAuto;
import com.oracle.glcm.patch.auto.OPatchAutoCommand;
import com.oracle.glcm.patch.auto.OPatchAutoException;
import com.oracle.glcm.patch.auto.OPatchAutoOption;
import com.oracle.glcm.patch.auto.product.ProductSupport;
import com.oracle.glcm.patch.auto.product.ProductSupportManager;
import com.oracle.glcm.patch.auto.session.PatchSession;
import com.oracle.glcm.patch.auto.topology.Host;
import com.oracle.glcm.patch.auto.utils.HostPortUrlHolder;
import com.oracle.glcm.patch.auto.utils.LoggedOutputStream;
import java.io.BufferedReader;
import java.io.Console;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.Reader;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;

public class OPatchAutoHelper {
    private static final Logger _log = Logger.getLogger(OPatchAutoHelper.class.getName());
    public static final String OPATCHAUTO_CLASSLOADER_KEY_PREFIX = "OPatchAuto.plugin.classloader";
    public static final String OPATCHAUTO_PLUGINS_PATH = "/plugins/opatchauto/modules";
    public static final String OPATCH_PATH = System.getProperty("OPatch.path", "OPatch");
    public static final String OUI_PATH = System.getProperty("OUI.path", "oui");
    public static final String OPATCHAUTO_BIN_PATH = System.getProperty("OPatchAuto.bin.path", OPATCH_PATH + "/auto/core/bin");
    public static final String OPATCHAUTO_REMOTE_MESSAGE_INDICATOR = System.getProperty("OPatchAuto.remote.message.indicator", "ReportingMessage");
    public static final String OPATCHAUTO_SCRIPT = "opatchauto";
    public static final String OPATCHAUTO_COPY_SCRIPT = "opatchautoCopy";
    public static final String ROLLING_PATCH_PLAN = "rolling";
    public static final String PARALLEL_PATCH_PLAN = "parallel";
    public static final String PUSH_IMAGE_PATCH_PLAN = "push-image";
    public static final String DEFAULT_PATCH_PLAN = "rolling";
    public static final String OPATCHAUTO_MESSAGE_PREFIX = "OPATCHAUTO";
    public static final String OPATCHAUTO_INVENTORY_DIR = "inventory/opatchauto";
    public static final PrintStream SYSTEM_OUT = System.out;
    public static final PrintStream SYSTEM_ERR = System.err;
    public static final ClassLoader ORIGINAL_CONTEXT_CLASSLOADER = Thread.currentThread().getContextClassLoader();
    private String _opatchAutoHome;
    private String _opatchAutoHost;
    private RemoteConnectionManager _remoteConnectionManager;
    private String _opatchAutoVersion;
    private List<File> _pluginClasspath;
    private String _classLoaderKey = "OPatchAuto.plugin.classloader." + OPatchAutoHelper.getCurrentDateTimeStamp("yyMMdd.HHmmss");
    private static boolean _streamsRedirected = false;
    private static boolean _resourceBundlesManaged = false;
    private static OPatchAutoHelper _instance;

    public static OPatchAutoHelper getInstance() {
        if (_instance == null) {
            _instance = new OPatchAutoHelper();
        }
        return _instance;
    }

    static void disposeInstance() {
        if (_instance != null) {
            if (OPatchAutoHelper._instance._remoteConnectionManager != null) {
                OPatchAutoHelper._instance._remoteConnectionManager.closeAllHandlers();
                OPatchAutoHelper._instance._remoteConnectionManager = null;
            }
            ClassLoaderService.getInstance().clearCachedClassLoader(OPatchAutoHelper._instance._classLoaderKey);
            Thread.currentThread().setContextClassLoader(ORIGINAL_CONTEXT_CLASSLOADER);
            OPatchAutoHelper.restoreStandardStreams();
            _instance = null;
        }
    }

    private OPatchAutoHelper() {
    }

    String getClassLoaderKey() {
        return this._classLoaderKey;
    }

    public static void manageResourceBundles() {
        if (!_resourceBundlesManaged) {
            ResourceBundleManager.manageBundle((String)OPATCHAUTO_SCRIPT, (String)"resources/opatchauto/messages");
            ResourceBundleManager.manageBundle((String)OPATCHAUTO_SCRIPT, (String)"resources/opatchauto/opatchauto");
            ResourceBundleManager.manageBundle((String)OPATCHAUTO_SCRIPT, (String)"resources/opatchauto/usage");
            ResourceBundleManager.setPrefix((String)OPATCHAUTO_SCRIPT, (String)OPATCHAUTO_MESSAGE_PREFIX);
            _resourceBundlesManaged = true;
        }
    }

    public static String getLocalizedString(String key, Object ... messageFormatting) {
        String message = ResourceBundleManager.getString((String)OPATCHAUTO_SCRIPT, (String)key);
        if (StringUtil.isNullOrEmpty((String)message)) {
            message = key;
        }
        if (message != null && messageFormatting != null && messageFormatting.length > 0) {
            message = MessageFormat.format(message, messageFormatting);
        }
        return message;
    }

    public static String getPublishedMessage(String code, Object ... messageFormatting) {
        PublishedMessage publishedMessage = ResourceBundleManager.getPublishedMessage((String)OPATCHAUTO_SCRIPT, (String)code, (Object[])messageFormatting);
        if (publishedMessage == null) {
            if (code != null && StringUtil.isPositiveInteger((String)code)) {
                return "OPATCHAUTO-" + code;
            }
            return code;
        }
        return publishedMessage.getFullMessage();
    }

    public static void redirectStandardStreams(String log) {
        if (log != null) {
            log = log.trim();
        }
        if (!"stdout".equalsIgnoreCase(log) && !"stderr".equalsIgnoreCase(log)) {
            PrintStream stdout = new PrintStream(new LoggedOutputStream());
            PrintStream stderr = new PrintStream(new LoggedOutputStream());
            System.setOut(stdout);
            System.setErr(stderr);
            _streamsRedirected = true;
        }
    }

    public static void restoreStandardStreams() {
        if (_streamsRedirected) {
            System.setOut(SYSTEM_OUT);
            System.setErr(SYSTEM_ERR);
        }
    }

    public static ClassLoader getPluginClassLoader() throws OPatchAutoException {
        return OPatchAutoHelper.getInstance().getInstancePluginClassLoader();
    }

    public ClassLoader getInstancePluginClassLoader() throws OPatchAutoException {
        return this.getPluginClassLoader(new File(System.getProperty("OPatchAuto.plugin.classloader.home", OPatchAutoHelper.getOPatchAutoHome())));
    }

    public ClassLoader getPluginClassLoader(File oracleHome) throws OPatchAutoException {
        ClassLoader pluginClassLoader;
        if (!ClassLoaderService.getInstance().hasClassLoader(this.getClassLoaderKey())) {
            pluginClassLoader = ClassLoaderService.getInstance().getClassLoader(this.getClassLoaderKey(), this.getPluginClasspath(oracleHome), OPatchAutoHelper.class.getClassLoader());
            Thread.currentThread().setContextClassLoader(pluginClassLoader);
        } else {
            pluginClassLoader = ClassLoaderService.getInstance().getCachedClassLoader(this.getClassLoaderKey());
        }
        return pluginClassLoader;
    }

    public URL[] getPluginClasspath(File oracleHome) throws OPatchAutoException {
        ArrayList<URL> jars = new ArrayList<URL>();
        for (File file : this.getPluginClasspathFiles(oracleHome)) {
            try {
                jars.add(file.toURI().toURL());
            }
            catch (MalformedURLException e) {
                throw new OPatchAutoException("68037", (Throwable)e, file);
            }
        }
        return jars.toArray(new URL[jars.size()]);
    }

    public List<File> getPluginClasspathFiles(File oracleHome) throws OPatchAutoException {
        if (this._pluginClasspath == null) {
            this._pluginClasspath = new ArrayList<File>();
            File[] prodDirs = oracleHome.listFiles(new FileFilter(){

                @Override
                public boolean accept(File pathname) {
                    return pathname.isDirectory();
                }
            });
            if (prodDirs != null) {
                for (File prodDir : prodDirs) {
                    File[] files;
                    File modulesDir = new File(prodDir, OPATCHAUTO_PLUGINS_PATH);
                    if (!modulesDir.isDirectory() || (files = modulesDir.listFiles(new FileFilter(){

                        @Override
                        public boolean accept(File pathname) {
                            return !pathname.isDirectory() && pathname.getName().endsWith(".jar");
                        }
                    })) == null || files.length <= 0) continue;
                    Collections.addAll(this._pluginClasspath, files);
                }
            }
            _log.fine("Using plugin classpath: " + this._pluginClasspath);
        }
        return this._pluginClasspath;
    }

    public void updatePluginClassLoader(Set<File> files) throws OPatchAutoException {
        if (files != null && !files.isEmpty()) {
            _log.fine("Adding to plugin classpath: " + files);
            this._pluginClasspath.addAll(files);
            URL[] urls = new URL[files.size()];
            int x = 0;
            for (File file : files) {
                try {
                    urls[x] = file.toURI().toURL();
                }
                catch (MalformedURLException e) {
                    throw new OPatchAutoException("68037", (Throwable)e, file);
                }
                ++x;
            }
            this.getInstancePluginClassLoader();
            ClassLoaderService.getInstance().getClassLoader(this.getClassLoaderKey(), urls, OPatchAutoHelper.class.getClassLoader());
        }
    }

    public List<File> getPluginClasspath() {
        return this._pluginClasspath != null ? this._pluginClasspath : new ArrayList<File>();
    }

    public static String getOPatchAutoHome() throws OPatchAutoException {
        return OPatchAutoHelper.getInstance().getInstanceOPatchAutoHome();
    }

    public String getInstanceOPatchAutoHome() throws OPatchAutoException {
        if (this._opatchAutoHome == null) {
            this._opatchAutoHome = System.getProperty("OPatchAuto.HOME");
            if (StringUtil.isNullOrEmpty((String)this._opatchAutoHome, (boolean)true)) {
                try {
                    File runningJar = ClassLoaderService.getInstance().locateClass(OPatchAuto.class);
                    if (runningJar.isFile() && runningJar.getName().endsWith(".jar")) {
                        this._opatchAutoHome = runningJar.getParentFile().getParentFile().getParentFile().getParent();
                    }
                }
                catch (Exception e) {
                    throw new OPatchAutoException("68038", (Throwable)e, new Object[0]);
                }
                if (StringUtil.isNullOrEmpty((String)this._opatchAutoHome, (boolean)true)) {
                    throw new OPatchAutoException("68038", new Object[0]);
                }
            }
            if (!StringUtil.isNullOrEmpty((String)this._opatchAutoHome, (boolean)true) && ComdevHelper.isWindows()) {
                this._opatchAutoHome = IOUtil.getFile((String)this._opatchAutoHome).getPath();
            }
        }
        return this._opatchAutoHome;
    }

    void setOPatchAutoHome(String opatchAutoHome) {
        this._opatchAutoHome = opatchAutoHome;
    }

    public static String getOPatchAutoHost() {
        return OPatchAutoHelper.getInstance().getInstanceOPatchAutoHost();
    }

    public String getInstanceOPatchAutoHost() {
        if (this._opatchAutoHost == null) {
            try {
                this._opatchAutoHost = InetAddress.getLocalHost().getHostName();
            }
            catch (UnknownHostException e) {
                _log.log(Level.WARNING, "Failed to resolve local host.", e);
                this._opatchAutoHost = "localhost";
            }
        }
        return this._opatchAutoHost;
    }

    public static RemoteConnectionManager getRemoteConnectionManager() throws OPatchAutoException {
        return OPatchAutoHelper.getInstance().getInstanceRemoteConnectionManager();
    }

    public RemoteConnectionManager getInstanceRemoteConnectionManager() throws OPatchAutoException {
        if (this._remoteConnectionManager == null) {
            this._remoteConnectionManager = RemoteConnectionManager.getRemoteConnectionManager((String)OPatchAutoHelper.getOPatchAutoHome(), (ClassLoader)OPatchAutoHelper.getPluginClassLoader());
        }
        return this._remoteConnectionManager;
    }

    public String getOPatchAutoVersion() {
        if (this._opatchAutoVersion == null) {
            try {
                Manifest manifest = null;
                File myLocation = ClassLoaderService.getInstance().locateClass(OPatchAutoHelper.class, OPatchAutoHelper.class.getClassLoader());
                if (myLocation.getName().endsWith(".jar") && !myLocation.isDirectory()) {
                    JarFile jar = new JarFile(myLocation);
                    manifest = jar.getManifest();
                    jar.close();
                } else {
                    String path = myLocation.getAbsolutePath();
                    File manifestFile = new File(myLocation = new File(path.substring(0, path.length() - (OPatchAutoHelper.class.getName().length() + 6))), "META-INF/MANIFEST.MF");
                    if (manifestFile.exists()) {
                        FileInputStream fis = new FileInputStream(manifestFile);
                        manifest = new Manifest(fis);
                        fis.close();
                    }
                }
                if (manifest != null) {
                    Attributes attributes = manifest.getMainAttributes();
                    this._opatchAutoVersion = attributes.getValue("Patch-Version");
                    if (StringUtil.isNullOrEmpty((String)this._opatchAutoVersion)) {
                        this._opatchAutoVersion = attributes.getValue(Attributes.Name.IMPLEMENTATION_VERSION);
                    }
                }
            }
            catch (IOException e) {
                _log.log(Level.FINEST, "Failed to get opatchauto version.", e);
            }
            if (this._opatchAutoVersion != null) {
                String[] split = this._opatchAutoVersion.split("\\.");
                for (int x = split.length; x < 5; ++x) {
                    this._opatchAutoVersion = this._opatchAutoVersion + ".0";
                }
            }
        }
        return this._opatchAutoVersion;
    }

    public static String getCurrentDateTimeStamp() {
        return OPatchAutoHelper.getCurrentDateTimeStamp("yyMMdd.HHmm");
    }

    public static String getCurrentDateTimeStamp(String format) {
        return new SimpleDateFormat(format, Locale.ENGLISH).format(new Date());
    }

    public static boolean pathsExist(String pathPrefix, Set<String> paths, Host host, boolean anyPath, String displayType) throws OPatchAutoException {
        if (paths != null && !paths.isEmpty()) {
            if (host == null || !host.isRemote()) {
                _log.info("Checking local file system for existence of paths " + paths + " under path prefix " + pathPrefix);
                File pathPrefixFile = new File(pathPrefix);
                if (!pathPrefixFile.isDirectory()) {
                    throw new OPatchAutoException("68039", displayType, pathPrefix);
                }
                boolean exists = !anyPath;
                for (String path : paths) {
                    File file = new File(pathPrefix, path);
                    if (anyPath) {
                        if (!file.exists()) continue;
                        exists = true;
                        break;
                    }
                    if (file.exists()) continue;
                    exists = false;
                    break;
                }
                return exists;
            }
            _log.info("Connecting to remote host " + host + " to check for existence of paths " + paths + " under path prefix " + pathPrefix);
            RemoteConnectionManager manager = OPatchAutoHelper.getRemoteConnectionManager();
            try {
                RemoteConnectionHandler handler = manager.getRemoteConnectionHandler((RemoteConnectionHost)host);
                if (!handler.exists(pathPrefix)) {
                    throw new OPatchAutoException("68040", host.getHost(), pathPrefix);
                }
                boolean exists = !anyPath;
                for (String path : paths) {
                    String fullPath = pathPrefix + "/" + path;
                    if (anyPath) {
                        if (!handler.exists(fullPath)) continue;
                        exists = true;
                        break;
                    }
                    if (handler.exists(fullPath)) continue;
                    exists = false;
                    break;
                }
                return exists;
            }
            catch (RemoteConnectionException e) {
                throw new OPatchAutoException("68041", (Throwable)e, host);
            }
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static HostPortUrlHolder parseHostAndPort(String s) throws IllegalArgumentException {
        String host = null;
        String port = null;
        String url = null;
        if (!StringUtil.isNullOrEmpty((String)s, (boolean)true)) {
            String hostAndPort;
            int index = (s = s.trim()).indexOf("://");
            if (index > -1) {
                url = s;
                hostAndPort = s.substring(index + 3);
            } else {
                hostAndPort = s;
            }
            if (hostAndPort.contains("/")) {
                throw new IllegalArgumentException(OPatchAutoHelper.getPublishedMessage("68042", s));
            }
            if (hostAndPort.startsWith("[")) {
                int closeBracket = hostAndPort.indexOf("]", 1);
                if (closeBracket == -1) throw new IllegalArgumentException(OPatchAutoHelper.getPublishedMessage("68042", s));
                host = hostAndPort.substring(1, closeBracket);
                int colon = hostAndPort.indexOf(":", closeBracket);
                if (colon != -1) {
                    port = hostAndPort.substring(closeBracket).trim();
                }
            } else if (hostAndPort.contains(":")) {
                String[] split = hostAndPort.split(":");
                if (split.length > 2) {
                    throw new IllegalArgumentException(OPatchAutoHelper.getPublishedMessage("68042", s));
                }
                host = split[0].trim();
                port = split[1].trim();
            } else {
                host = hostAndPort;
            }
        }
        if (host == null || host.isEmpty()) {
            throw new IllegalArgumentException(OPatchAutoHelper.getPublishedMessage("68042", s));
        }
        if (port == null || !port.isEmpty()) return new HostPortUrlHolder(host, port, url);
        port = null;
        return new HostPortUrlHolder(host, port, url);
    }

    public static char[] getPasswordFromConsole(String prompt) {
        Console console = System.console();
        if (console == null) {
            BufferedReader reader = new BufferedReader(new InputStreamReader(System.in));
            try {
                Reporting.report((String)(prompt + ":"));
                return IOUtil.readLineChars((Reader)reader, (int)1028);
            }
            catch (IOException ioe) {
                _log.log(Level.SEVERE, "Failed to read password from stdin", ioe);
                return null;
            }
        }
        return console.readPassword("%s:", prompt);
    }

    public static byte[] toBytes(char[] chars) {
        CharBuffer charBuffer = CharBuffer.wrap(chars);
        ByteBuffer byteBuffer = Charset.forName("UTF-8").encode(charBuffer);
        byte[] bytes = Arrays.copyOfRange(byteBuffer.array(), byteBuffer.position(), byteBuffer.limit());
        Arrays.fill(charBuffer.array(), '\u0000');
        Arrays.fill(byteBuffer.array(), (byte)0);
        return bytes;
    }

    public static char[] toChars(byte[] bytes) {
        ByteBuffer byteBuffer = ByteBuffer.wrap(bytes);
        CharBuffer charBuffer = Charset.forName("UTF-8").decode(byteBuffer);
        char[] chars = Arrays.copyOfRange(charBuffer.array(), charBuffer.position(), charBuffer.limit());
        Arrays.fill(charBuffer.array(), '\u0000');
        Arrays.fill(byteBuffer.array(), (byte)0);
        return chars;
    }

    public static Collection<Level> getSupportedLogLevels() {
        ArrayList<Level> levels = new ArrayList<Level>();
        levels.add(Level.SEVERE);
        levels.add(Level.WARNING);
        levels.add(Level.INFO);
        levels.add(Level.CONFIG);
        levels.add(Level.FINE);
        levels.add(Level.FINER);
        levels.add(Level.FINEST);
        levels.add(Level.ALL);
        levels.add(Level.OFF);
        return levels;
    }

    public static String getFilePath(File file) throws IOException {
        if (file != null) {
            if (ComdevHelper.isWindows()) {
                return file.getCanonicalPath();
            }
            return file.getAbsolutePath();
        }
        return null;
    }

    public static Set<String> getHostAddresses(String hostname) throws OPatchAutoException {
        LinkedHashSet<String> hostAddresses = new LinkedHashSet<String>();
        if (!StringUtil.isNullOrEmpty((String)hostname, (boolean)true)) {
            hostAddresses.add(hostname);
            try {
                InetAddress[] addresses;
                for (InetAddress address : addresses = InetAddress.getAllByName(hostname)) {
                    hostAddresses.add(address.getHostName());
                    hostAddresses.add(address.getCanonicalHostName());
                    hostAddresses.add(address.getHostAddress());
                }
            }
            catch (UnknownHostException e) {
                throw new OPatchAutoException("68149", (Throwable)e, hostname);
            }
        }
        return hostAddresses;
    }

    public static File copyOPatchAutoRuntime(ProductSupportManager productSupportManager) throws OPatchAutoException {
        return OPatchAutoHelper.copyOPatchAutoRuntime(null, productSupportManager);
    }

    public static File copyOPatchAutoRuntime(File sourceHome, ProductSupportManager productSupportManager) throws OPatchAutoException {
        return OPatchAutoHelper.copyOPatchAutoRuntime(sourceHome, productSupportManager, null);
    }

    public static File copyOPatchAutoRuntime(File sourceHome, ProductSupportManager productSupportManager, File tmpHome) throws OPatchAutoException {
        File opatchAutoHome;
        if (tmpHome == null) {
            try {
                tmpHome = TempFileHandler.getTempFolder((String)OPATCHAUTO_SCRIPT, (String)"home", (boolean)false);
            }
            catch (IOException e) {
                throw new OPatchAutoException("68043", (Throwable)e, new Object[0]);
            }
        }
        File file = opatchAutoHome = ComdevHelper.isWindows() ? IOUtil.getFile((String)OPatchAutoHelper.getOPatchAutoHome()) : new File(OPatchAutoHelper.getOPatchAutoHome());
        if (sourceHome == null || sourceHome.equals(opatchAutoHome)) {
            _log.info("Copying opatchauto runtime to " + tmpHome + " from home location " + opatchAutoHome);
            ClasspathCopier.copyOPatchAuto(opatchAutoHome, tmpHome, OPatchAutoHelper.getAdditionalCopyFiles(productSupportManager));
        } else {
            String scriptExt = ComdevHelper.isWindows() ? ".cmd" : ".sh";
            ArrayList<String> commands = new ArrayList<String>();
            commands.add(sourceHome.getAbsolutePath() + "/" + OPATCHAUTO_BIN_PATH + "/" + OPATCHAUTO_COPY_SCRIPT + scriptExt);
            commands.add(sourceHome.getAbsolutePath());
            commands.add(tmpHome.getAbsolutePath());
            _log.info("Copying opatchauto runtime to " + tmpHome + " from home location " + sourceHome);
            try {
                if (OPatchAutoHelper.runtimeExec(commands, false, true) != 0) {
                    throw new OPatchAutoException("68044", OPATCHAUTO_COPY_SCRIPT);
                }
            }
            catch (IOException e) {
                throw new OPatchAutoException("68045", (Throwable)e, OPATCHAUTO_COPY_SCRIPT);
            }
        }
        return tmpHome;
    }

    public static Collection<String> getAdditionalCopyFiles(ProductSupportManager productSupportManager) throws OPatchAutoException {
        LinkedHashSet<String> additional = new LinkedHashSet<String>();
        if (productSupportManager != null) {
            for (ProductSupport productSupport : productSupportManager.getProductSupport()) {
                Set<File> files = productSupport.getAdditionalCopyFiles();
                if (files == null) continue;
                for (File file : files) {
                    additional.add(file.getAbsolutePath());
                }
            }
        }
        return additional;
    }

    public static File copyJavaHome() throws OPatchAutoException {
        File javaHome;
        String javaHomePath = System.getProperty("java.home");
        if (javaHomePath.endsWith("/jre")) {
            javaHomePath = javaHomePath.substring(0, javaHomePath.lastIndexOf("/"));
        }
        if ((javaHome = new File(javaHomePath)).getAbsolutePath().startsWith(OPatchAutoHelper.getOPatchAutoHome())) {
            File destJdk;
            try {
                destJdk = TempFileHandler.getTempFolder((String)OPATCHAUTO_SCRIPT, (String)"jdk", (boolean)false);
            }
            catch (IOException e) {
                throw new OPatchAutoException("68043", (Throwable)e, new Object[0]);
            }
            destJdk.mkdirs();
            boolean windows = ComdevHelper.isWindows();
            if (windows) {
                try {
                    DirectoryCopy.copy((File)javaHome, (File)destJdk);
                }
                catch (IOException e) {
                    throw new OPatchAutoException("68048", javaHome, destJdk, e);
                }
            }
            ArrayList<String> jdkCopyCommands = new ArrayList<String>();
            jdkCopyCommands.add("cp");
            jdkCopyCommands.add("-r");
            jdkCopyCommands.add(javaHome.getAbsolutePath() + "/*");
            jdkCopyCommands.add(destJdk.getAbsolutePath());
            try {
                if (OPatchAutoHelper.runtimeExec(jdkCopyCommands, false, true) != 0) {
                    throw new OPatchAutoException("68049", new Object[0]);
                }
            }
            catch (IOException e) {
                throw new OPatchAutoException("68049", (Throwable)e, new Object[0]);
            }
        }
        return javaHome;
    }

    public static void invokeOPatchAuto(File tmpHome, File javaHome, PatchSession patchSession, Collection<String> args) throws IOException, OPatchAutoException {
        boolean windows = ComdevHelper.isWindows();
        String scriptExt = windows ? ".cmd" : ".sh";
        File binDir = new File(tmpHome.getAbsolutePath() + "/" + OPATCHAUTO_BIN_PATH);
        ArrayList<String> commands = new ArrayList<String>();
        commands.add(binDir + "/" + OPATCHAUTO_SCRIPT + scriptExt);
        OPatchAutoOption homeOption = patchSession.getOptions().getOption("home");
        if (args != null && !args.isEmpty()) {
            Iterator<String> it = args.iterator();
            OPatchAutoCommand command = OPatchAutoCommand.valueOf(it.next());
            commands.add(command.name());
            while (it.hasNext()) {
                String arg = it.next();
                if (arg.equals(homeOption.getArg())) {
                    if (!it.hasNext()) continue;
                    it.next();
                    continue;
                }
                commands.add(arg);
            }
            if (homeOption.hasCommand(command)) {
                commands.addAll(homeOption.getCommandLine());
            }
        }
        commands.add(patchSession.getOptions().getOption("restarted").getArg());
        HashMap<String, String> envVars = new HashMap<String, String>();
        envVars.put("OPATCHAUTO_JAVA_HOME", javaHome.getAbsolutePath());
        String jvmArgs = System.getProperty("OPATCHAUTO_RESTART_JVM_ARGS");
        if (!StringUtil.isNullOrEmpty((String)jvmArgs, (boolean)true)) {
            envVars.put("OPATCHAUTO_JVM_ARGS", jvmArgs);
        }
        OPatchAutoHelper.restoreStandardStreams();
        if (OPatchAutoHelper.runtimeExec(commands, binDir, envVars, true, false) != 0) {
            throw new OPatchAutoException("68044", OPATCHAUTO_COPY_SCRIPT);
        }
    }

    public static int runtimeExec(List<String> commands, boolean logToConsole, boolean wait) throws IOException {
        return OPatchAutoHelper.runtimeExec(commands, null, null, logToConsole, wait);
    }

    public static int runtimeExec(List<String> commands, File executionDir, Map<String, String> envVars, boolean logToConsole, boolean wait) throws IOException {
        Process process = OPatchAutoHelper.runtimeExec(commands, executionDir, envVars, logToConsole);
        int exitValue = 0;
        if (wait) {
            try {
                exitValue = process.waitFor();
            }
            catch (InterruptedException e) {
                _log.warning(e.getLocalizedMessage());
            }
        }
        return exitValue;
    }

    public static Process runtimeExec(List<String> commands, File executionDir, Map<String, String> envVars, boolean logToConsole) throws IOException {
        Process process = OPatchAutoHelper.runtimeExecInternal(commands, executionDir, envVars, logToConsole);
        if (!logToConsole) {
            LoggedOutputThread stdOutThread = new LoggedOutputThread(process.getInputStream(), "std-stream", _log, Level.INFO);
            LoggedOutputThread stdErrThread = new LoggedOutputThread(process.getErrorStream(), "error-stream", _log, Level.INFO);
            stdOutThread.start();
            stdErrThread.start();
        }
        return process;
    }

    private static Process runtimeExecInternal(List<String> commands, File executionDir, Map<String, String> envVars, boolean logToConsole) throws IOException {
        _log.info("Executing command " + commands);
        if (_log.isLoggable(Level.FINE)) {
            _log.fine("Executing command " + commands + " in dir " + executionDir + " with env " + envVars);
        }
        ProcessBuilder pb = new ProcessBuilder(commands);
        if (logToConsole) {
            pb.redirectInput(ProcessBuilder.Redirect.INHERIT);
            pb.redirectOutput(ProcessBuilder.Redirect.INHERIT);
            pb.redirectError(ProcessBuilder.Redirect.INHERIT);
        }
        if (executionDir != null) {
            pb.directory(executionDir);
        }
        if (envVars != null && !envVars.isEmpty()) {
            Map<String, String> env = pb.environment();
            env.putAll(envVars);
        }
        return pb.start();
    }

    public static List<String> runtimeExecAndCaptureOutput(List<String> commands, File executionDir, Map<String, String> envVars, boolean logToConsole) throws IOException {
        Process process = OPatchAutoHelper.runtimeExecInternal(commands, executionDir, envVars, logToConsole);
        CaptureOutputThread stdOutThread = new CaptureOutputThread(process.getInputStream(), "std-stream");
        CaptureOutputThread stdErrThread = new CaptureOutputThread(process.getErrorStream(), "error-stream");
        stdOutThread.start();
        stdErrThread.start();
        int exitValue = 0;
        try {
            exitValue = process.waitFor();
        }
        catch (InterruptedException e) {
            _log.warning(e.getLocalizedMessage());
        }
        if (exitValue != 0) {
            _log.log(Level.SEVERE, "Execution failure reason::" + stdErrThread.getOutput());
            throw new IOException("RuntimeExec of commands " + commands + " failed with exit code " + exitValue);
        }
        return stdOutThread.getOutput();
    }

    static class CaptureOutputThread
    extends Thread {
        private InputStream _is;
        private List<String> _output = new ArrayList<String>();
        private boolean _done = false;

        public CaptureOutputThread(InputStream is, String name) {
            super(name);
            this._is = is;
        }

        public List<String> getOutput() {
            return this._output;
        }

        public boolean isDone() {
            return this._done;
        }

        @Override
        public void run() {
            try {
                String output;
                BufferedReader br = new BufferedReader(new InputStreamReader(this._is));
                while ((output = br.readLine()) != null) {
                    this._output.add(output + "\n");
                }
                this._done = true;
            }
            catch (IOException ioe) {
                _log.log(Level.FINE, ioe.getMessage(), ioe);
            }
        }
    }

    static class LoggedOutputThread
    extends Thread {
        private InputStream _is;
        private Logger _log;
        private Level _level;

        public LoggedOutputThread(InputStream is, String name, Logger log, Level level) {
            super(name);
            this._is = is;
            this._log = log != null ? log : Logger.getLogger(LoggedOutputThread.class.getName());
            this._level = level != null ? level : Level.INFO;
        }

        @Override
        public void run() {
            try {
                String input;
                BufferedReader br = new BufferedReader(new InputStreamReader(this._is));
                while ((input = br.readLine()) != null) {
                    this._log.log(this._level, input);
                }
            }
            catch (IOException e) {
                this._log.log(Level.SEVERE, e.getMessage(), e);
            }
        }
    }
}

