/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.glcm.patch.auto;

import com.oracle.cie.common.util.DirectoryCopy;
import com.oracle.cie.common.util.FileCopy;
import com.oracle.cie.common.util.IObjectStore;
import com.oracle.cie.common.util.ObjectStoreManager;
import com.oracle.cie.common.util.StringUtil;
import com.oracle.cie.common.util.logging.Destination;
import com.oracle.cie.common.util.logging.LogFactory;
import com.oracle.cie.common.util.reporting.Reporter;
import com.oracle.cie.common.util.reporting.ReporterType;
import com.oracle.cie.common.util.reporting.ReporterTypes;
import com.oracle.cie.common.util.reporting.Reporting;
import com.oracle.cie.common.util.reporting.ReportingException;
import com.oracle.cie.remote.RemoteConnectionManager;
import com.oracle.cie.wizard.WizardConfiguration;
import com.oracle.glcm.patch.auto.OPatchAutoCleanupShutdownHook;
import com.oracle.glcm.patch.auto.OPatchAutoCommand;
import com.oracle.glcm.patch.auto.OPatchAutoException;
import com.oracle.glcm.patch.auto.OPatchAutoHelper;
import com.oracle.glcm.patch.auto.OPatchAutoOption;
import com.oracle.glcm.patch.auto.OPatchAutoOptionGroup;
import com.oracle.glcm.patch.auto.OPatchAutoOptions;
import com.oracle.glcm.patch.auto.OPatchAutoOptionsException;
import com.oracle.glcm.patch.auto.OPatchAutoRestartException;
import com.oracle.glcm.patch.auto.OrchestrationEngineFactory;
import com.oracle.glcm.patch.auto.action.PatchAction;
import com.oracle.glcm.patch.auto.action.PatchActionException;
import com.oracle.glcm.patch.auto.action.PatchActionExecutor;
import com.oracle.glcm.patch.auto.credential.CredentialManager;
import com.oracle.glcm.patch.auto.lifecycle.Goal;
import com.oracle.glcm.patch.auto.lifecycle.OfflinePhase;
import com.oracle.glcm.patch.auto.lifecycle.Phase;
import com.oracle.glcm.patch.auto.product.ProductSupport;
import com.oracle.glcm.patch.auto.product.ProductSupportManager;
import com.oracle.glcm.patch.auto.product.ProductType;
import com.oracle.glcm.patch.auto.product.SupportType;
import com.oracle.glcm.patch.auto.report.OPatchAutoReporting;
import com.oracle.glcm.patch.auto.report.OPatchAutoReportingManager;
import com.oracle.glcm.patch.auto.session.MutablePatchSession;
import com.oracle.glcm.patch.auto.session.PatchSessionImpl;
import com.oracle.glcm.patch.auto.topology.Home;
import com.oracle.glcm.patch.auto.topology.Instance;
import com.oracle.glcm.patch.auto.topology.Topology;
import com.oracle.glcm.patch.auto.topology.TopologyFactory;
import com.oracle.glcm.patch.auto.tracking.PatchTracking;
import com.oracle.glcm.patch.auto.tracking.bindings.StatusType;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class OPatchAuto {
    public static final String OPATCH_AUTO_NAMESPACE = "opatchauto";
    public static final String DEFAULT_LOG_DIR = "cfgtoollogs";
    public static final String OPATCH_AUTO_SESSION_KEY = "patch.session";
    public static final String LOG_FILENAME_DATE_FORMAT = "yyyy-MM-dd_hh-mm-ssa";
    private static final Logger _log = Logger.getLogger(OPatchAuto.class.getName());
    private static boolean _loggingSetup = false;
    private OPatchAutoCommand _command;
    private ProductSupportManager _productSupportManager;
    private boolean _fromCommandLine;
    private MutablePatchSession _patchSession;
    private String _patchPlanTarget;
    private boolean _prepared;
    private Topology _topology;

    public OPatchAuto(OPatchAutoCommand command, ProductSupportManager productSupportManager, boolean fromCommandLine) throws OPatchAutoException {
        this(command, productSupportManager, null, fromCommandLine);
    }

    OPatchAuto(OPatchAutoCommand command, ProductSupportManager productSupportManager, Topology topology, boolean fromCommandLine) throws OPatchAutoException {
        this._command = command;
        this._productSupportManager = productSupportManager;
        this._topology = topology;
        this._fromCommandLine = fromCommandLine;
        if (this._command == null) {
            throw new OPatchAutoException("68004", OPatchAutoCommand.getExternalCommands());
        }
        if (this._productSupportManager == null) {
            throw new OPatchAutoException("68005", new Object[0]);
        }
    }

    public OPatchAutoCommand getCommand() {
        return this._command;
    }

    public ProductSupportManager getProductSupportManager() {
        return this._productSupportManager;
    }

    MutablePatchSession getPatchSession() {
        return this._patchSession;
    }

    public static void main(String[] args) {
        int retCode = 0;
        Throwable throwable = null;
        try {
            OPatchAuto.orchestrate(args);
        }
        catch (OPatchAutoRestartException e) {
            try {
                OPatchAutoHelper.invokeOPatchAuto(e.getHome(), e.getJavaHome(), e.getPatchSession(), Arrays.asList(args));
                try {
                    Thread.sleep(2000L);
                }
                catch (InterruptedException ie) {
                    // empty catch block
                }
                retCode = 0;
            }
            catch (Throwable t) {
                Reporting.report((String)e.getMessage());
                Reporting.report((String)OPatchAutoHelper.getLocalizedString("OPatchAuto.opatchauto.failed", new Object[0]));
                retCode = 40;
            }
        }
        catch (OPatchAutoOptionsException e) {
            Level level;
            if (!e.isHelpRequested()) {
                throwable = e;
                retCode = 41;
            }
            Level level2 = level = _loggingSetup ? Level.INFO : Level.FINE;
            if (_log.isLoggable(level)) {
                _log.log(level, "OPatchAuto options exception...", e);
            }
            Reporting.report((String)e.getMessage());
        }
        catch (Throwable e) {
            throwable = e;
            retCode = 42;
            _log.log(Level.SEVERE, "OPatchAuto failed.", e);
            if (!_loggingSetup) {
                e.printStackTrace();
                Reporting.report((String)OPatchAutoHelper.getLocalizedString("OPatchAuto.opatchauto.failed", new Object[0]));
            }
            Reporting.report((String)e.getMessage());
            Reporting.report((String)OPatchAutoHelper.getLocalizedString("OPatchAuto.opatchauto.failed", new Object[0]));
        }
        if (!Boolean.getBoolean("OPatchAuto.disable.system.exit")) {
            System.exit(retCode);
        } else if (retCode != 0) {
            throw new IllegalStateException(OPatchAutoHelper.getPublishedMessage("68001", retCode), throwable);
        }
    }

    public static void orchestrate(String[] args) throws OPatchAutoException {
        ProductSupportManager productSupportManager = ProductSupportManager.getInstance();
        OPatchAutoOptions options = productSupportManager.getOptions();
        Set<OPatchAutoCommand> unsupportedCommands = productSupportManager.getUnsupportedCommand();
        ArrayList<String> argsList = new ArrayList<String>();
        if (args != null) {
            argsList.addAll(Arrays.asList(args));
        }
        if (argsList.isEmpty()) {
            OPatchAuto.usage(productSupportManager, OPatchAutoHelper.getPublishedMessage("68002", new Object[0]));
        }
        OPatchAutoCommand command = OPatchAutoCommand.apply;
        String operationArg = (String)argsList.remove(0);
        if (operationArg.equalsIgnoreCase(options.getOption("help").getArg())) {
            String message = null;
            boolean helpRequest = true;
            if (!argsList.isEmpty()) {
                message = OPatchAutoHelper.getPublishedMessage("68148", argsList);
                helpRequest = false;
            }
            OPatchAuto.usage(productSupportManager, message, helpRequest);
        }
        try {
            command = OPatchAutoCommand.valueOf(operationArg.toLowerCase());
            if (unsupportedCommands.contains((Object)command)) {
                throw new IllegalArgumentException("Unsupported command::" + (Object)((Object)command));
            }
            options.setCommand(command);
        }
        catch (IllegalArgumentException e) {
            Set<OPatchAutoCommand> filteredCommandList = OPatchAuto.filterUnsuporttedCommands(OPatchAutoCommand.getExternalCommands(), productSupportManager);
            OPatchAuto.usage(productSupportManager, OPatchAutoHelper.getPublishedMessage("68003", operationArg, filteredCommandList));
        }
        if (argsList.isEmpty() && command.hasOptions()) {
            OPatchAuto.usage(productSupportManager, OPatchAutoHelper.getPublishedMessage("68002", new Object[0]), command);
        }
        try {
            options.setPopulatedOptions(OPatchAuto.populateOptionsFromArgs(command, options, argsList));
        }
        catch (OPatchAutoOptionsException e) {
            OPatchAuto.usage(productSupportManager, e.getMessage(), command);
        }
        OPatchAuto.orchestrate(command, productSupportManager, true);
    }

    private static Set<OPatchAutoCommand> filterUnsuporttedCommands(Collection<OPatchAutoCommand> orginalCommandLst, ProductSupportManager productSupportManager) throws OPatchAutoException {
        HashSet<OPatchAutoCommand> filteredCommandList = new HashSet<OPatchAutoCommand>(orginalCommandLst);
        Set<OPatchAutoCommand> unsupportedCommands = productSupportManager.getUnsupportedCommand();
        Iterator filIterator = filteredCommandList.iterator();
        while (filIterator.hasNext()) {
            OPatchAutoCommand externalCommand = (OPatchAutoCommand)((Object)filIterator.next());
            if (!unsupportedCommands.contains((Object)externalCommand)) continue;
            filIterator.remove();
        }
        return filteredCommandList;
    }

    public static void orchestrate(OPatchAutoCommand command, ProductSupportManager productSupportManager) throws OPatchAutoException {
        OPatchAuto.orchestrate(command, productSupportManager, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void orchestrate(OPatchAutoCommand command, ProductSupportManager productSupportManager, boolean fromCommandLine) throws OPatchAutoException {
        try {
            OPatchAuto opatchAuto = new OPatchAuto(command, productSupportManager, fromCommandLine);
            opatchAuto.handleUsageRequests();
            opatchAuto.prepareOrchestration();
            opatchAuto.orchestrate();
        }
        finally {
            if (!fromCommandLine) {
                OPatchAutoHelper.restoreStandardStreams();
            }
        }
    }

    public void handleUsageRequests() throws OPatchAutoException {
        OPatchAutoOptions options = this._productSupportManager.getOptions();
        if (Boolean.parseBoolean(options.getOption("help").getValue())) {
            Set<OPatchAutoOption> populatedOptions;
            OPatchAutoOption patchPlanOption = options.getOption("patch.plan");
            String patchPlan = null;
            if (patchPlanOption.hasValue() && !patchPlanOption.isUsingDefault()) {
                patchPlan = patchPlanOption.getValue();
                this._productSupportManager.validatePatchPlanName(patchPlan);
            }
            if ((populatedOptions = options.getPopulatedOptions()) != null) {
                populatedOptions.remove(options.getOption("help"));
                populatedOptions.remove(options.getOption("patch.plan"));
            }
            String message = null;
            boolean helpRequest = true;
            if (populatedOptions != null && !populatedOptions.isEmpty()) {
                message = OPatchAutoHelper.getPublishedMessage("68148", OPatchAuto.getOptionNames(populatedOptions, true));
                helpRequest = false;
            }
            OPatchAuto.usage(this._productSupportManager, message, helpRequest, this._command, patchPlan);
        }
        if (this._command.isVersion()) {
            OPatchAuto.versionUsage(this._productSupportManager);
        }
        if (this._command.isLsPhases() || this._command.isLsPlans()) {
            this._productSupportManager.initialize(this._command);
            if (this._command.isLsPhases()) {
                OPatchAuto.phaseUsage(this._productSupportManager);
            } else if (this._command.isLsPlans()) {
                OPatchAuto.planUsage(this._productSupportManager);
            }
        }
    }

    public void prepareOrchestration() throws OPatchAutoException {
        OPatchAutoOptions options = this._productSupportManager.getOptions();
        this._prepared = true;
        try {
            String username;
            PatchTracking patchTracking;
            String sessionId;
            String log = options.getOption(OPatchAutoOptions.LOG_KEY).getValue(this.getDefaultLogFileLocation(OPatchAutoHelper.getOPatchAutoHome()));
            String logLevel = options.getOption(OPatchAutoOptions.LOG_LEVEL_KEY).getValue();
            LogFactory logFactory = LogFactory.getFactory();
            logFactory.setupLogging(log, logLevel != null ? logLevel.toUpperCase() : null, true, new String[0]);
            Reporter defaultReporter = Reporting.getDefaultReporter();
            if (defaultReporter != null) {
                defaultReporter.setMessageLoggingLevel(Level.INFO);
            }
            _loggingSetup = true;
            _log.info("OPatchAuto version: " + OPatchAutoHelper.getInstance().getOPatchAutoVersion());
            Reporting.report((String)OPatchAutoHelper.getLocalizedString("OPatchAuto.session.log.file", log));
            if (this._command.isAction()) {
                Destination stdoutDest = Destination.createSystemOutDestination();
                for (Logger logger : logFactory.getRootLogs()) {
                    logFactory.addDestination(logger, stdoutDest);
                }
                try {
                    Reporter reporter = Reporting.addReporter((ReporterType)ReporterTypes.jackson, (OutputStream)System.out);
                    reporter.setMessageIndicator(OPatchAutoHelper.OPATCHAUTO_REMOTE_MESSAGE_INDICATOR);
                }
                catch (ReportingException e) {
                    throw new OPatchAutoException("68006", (Throwable)e, new Object[0]);
                }
                this._productSupportManager.initialize(this._command);
                options.validate(this._command);
                String containerPath = options.getOption("container").getValue();
                if (StringUtil.isNullOrEmpty((String)containerPath, (boolean)true)) {
                    throw new OPatchAutoException("68007", new Object[0]);
                }
                return;
            }
            OPatchAutoHelper.redirectStandardStreams(log);
            OPatchAutoOption sessionOption = options.getOption("session");
            if (this._command.isResume()) {
                sessionId = sessionOption.getValue();
                if (StringUtil.isNullOrEmpty((String)sessionId)) {
                    if (this._fromCommandLine) {
                        OPatchAuto.usage(this._productSupportManager, OPatchAutoHelper.getPublishedMessage("68009", sessionOption.getArg()), this._command);
                    } else {
                        throw new OPatchAutoException("68010", sessionOption.getKey());
                    }
                }
                if ((patchTracking = new PatchTracking(sessionId)).getSessionStatus().equals((Object)StatusType.SUCCESS)) {
                    OPatchAutoOptionsException exception = new OPatchAutoOptionsException("68155", sessionId);
                    exception.setHelpRequested(true);
                    throw exception;
                }
                if (!patchTracking.isExistingSession()) {
                    throw new OPatchAutoException("68011", sessionId);
                }
                _log.info("Resuming existing session with id " + sessionId);
                Reporting.report((String)OPatchAutoHelper.getLocalizedString("OPatchAuto.resuming.existing.session", sessionId));
                patchTracking.populatePreviousSessionOptionValues(options);
                this._command = patchTracking.getCommand();
                if (this._command.isReport()) {
                    throw new OPatchAutoException("68165", new Object[0]);
                }
                this._command.setResumed(true);
                options.setCommand(this._command);
            } else {
                if (this._command.isRollback() && sessionOption.hasValue()) {
                    String prevSessionId = sessionOption.getValue();
                    PatchTracking previousPatchTracking = new PatchTracking(prevSessionId);
                    if (!previousPatchTracking.isExistingSession()) {
                        throw new OPatchAutoException("68012", prevSessionId);
                    }
                    if (previousPatchTracking.getCommand() != OPatchAutoCommand.apply) {
                        throw new OPatchAutoException("68013", new Object[]{OPatchAutoCommand.apply, prevSessionId, previousPatchTracking.getCommand()});
                    }
                    Reporting.report((String)OPatchAutoHelper.getLocalizedString("OPatchAuto.loading.previous.session", prevSessionId));
                    previousPatchTracking.populatePreviousSessionOptionValues(options, true);
                }
                sessionId = PatchTracking.generateSessionId();
                patchTracking = new PatchTracking(sessionId, this._command);
                options.getOption("session").setValue(sessionId);
            }
            this._productSupportManager.initialize(this._command);
            this._productSupportManager.updateProductOptions();
            options.validate(this._command);
            OPatchAutoOption patchPlan = options.getOption("patch.plan");
            this._productSupportManager.validatePatchPlanName(patchPlan.getValue());
            this._patchPlanTarget = patchPlan.getValue();
            IObjectStore objectStore = ObjectStoreManager.getObjectStore((String)OPATCH_AUTO_NAMESPACE);
            OPatchAutoOption binary = options.getOption("binary");
            OPatchAutoOption phasesOption = options.getOption("phases");
            if (Boolean.parseBoolean(binary.getValue())) {
                if (phasesOption.hasValue()) {
                    if (this._fromCommandLine) {
                        OPatchAuto.usage(this._productSupportManager, OPatchAutoHelper.getPublishedMessage("68014", binary.getArg(), phasesOption.getArg()), this._command);
                    } else {
                        throw new OPatchAutoException("68015", binary.getArg(), phasesOption.getArg());
                    }
                }
                phasesOption.setValue(OfflinePhase.Goal.binary_patching.getPhaseGoal() + "," + OfflinePhase.Goal.finalize_binary_patching.getPhaseGoal());
            }
            LinkedHashSet<Goal> goals = new LinkedHashSet<Goal>();
            if (phasesOption.hasValue()) {
                this._patchPlanTarget = "custom";
                String[] phasesSplit = phasesOption.getValue().trim().split(",");
                ArrayList<String> customPhases = new ArrayList<String>();
                ArrayList<String> invalid = new ArrayList<String>();
                for (String p : phasesSplit) {
                    customPhases.add(p.trim());
                    String[] phaseAndGoal = p.split(":");
                    try {
                        Phase phase = Phase.valueOf(phaseAndGoal[0].toLowerCase());
                        if (phaseAndGoal.length > 1) {
                            Goal goal = phase.getGoal(phaseAndGoal[1]);
                            if (goal == null) {
                                invalid.add(p);
                                continue;
                            }
                            goals.add(goal);
                            continue;
                        }
                        if (!phase.hasGoals()) continue;
                        goals.addAll(Arrays.asList(phase.getGoals()));
                    }
                    catch (IllegalArgumentException e) {
                        invalid.add(p);
                    }
                }
                if (!invalid.isEmpty()) {
                    throw new OPatchAutoException("68016", invalid);
                }
                objectStore.storeObject((Object)"CustomPhaseAndGoals.list", customPhases);
            } else {
                goals.addAll(Phase.getAllGoals());
            }
            this._productSupportManager.updatePatchActionOptions(goals);
            options.logOptions();
            this.validateOptions(this._command, this._productSupportManager, this._fromCommandLine);
            CredentialManager credentialManager = new CredentialManager();
            String wallet = options.getOption("wallet").getValue();
            if (!StringUtil.isNullOrEmpty((String)wallet, (boolean)true)) {
                OPatchAutoOption walletPassword = options.getOption("wallet.password");
                credentialManager.setWallet(new File(wallet), walletPassword.hasValue() ? walletPassword.getPasswordValue() : null);
            }
            if (!StringUtil.isNullOrEmpty((String)(username = options.getOption("username").getValue()), (boolean)true)) {
                String[] stringArray;
                String hostName = options.getOption("host").getValue();
                if (hostName.contains(",")) {
                    stringArray = hostName.split(",");
                } else {
                    String[] stringArray2 = new String[1];
                    stringArray = stringArray2;
                    stringArray2[0] = hostName;
                }
                String[] hostNames = stringArray;
                OPatchAutoOption passwordOption = options.getOption("password");
                char[] password = passwordOption.hasValue() ? passwordOption.getPasswordValue() : OPatchAutoHelper.getPasswordFromConsole(OPatchAutoHelper.getLocalizedString("OPatchAuto.password.prompt", username, hostName));
                for (String host : hostNames) {
                    credentialManager.addCredential(host.trim(), username, password);
                }
                if (password != null) {
                    Arrays.fill(password, '\u0000');
                }
            }
            patchTracking.initSessionExecution(options);
            if (!patchTracking.isExistingSession()) {
                _log.info("The id for this session is " + sessionId);
                Reporting.report((String)OPatchAutoHelper.getLocalizedString("OPatchAuto.id.for.session", sessionId));
            }
            this._patchSession = new PatchSessionImpl();
            this._patchSession.setCommand(this._command);
            this._patchSession.setCredentialManager(credentialManager);
            this._patchSession.setPatchInfo(options.getOption("patch.location").getValue(), options.getOption("patch.base.directory").getValue(), options.getOption("id").getValue());
            this._patchSession.setOptions(options);
            this._patchSession.setOPatchAutoHome(new File(OPatchAutoHelper.getOPatchAutoHome()));
            this._patchSession.setProductSupportManager(this._productSupportManager);
            this._patchSession.setAnalyze(Boolean.parseBoolean(options.getOption("analyze").getValue()));
            this._patchSession.setParallelEnabled(Boolean.parseBoolean(options.getOption("parallel").getValue()));
            objectStore.storeObject((Object)OPATCH_AUTO_SESSION_KEY, (Object)this._patchSession);
            this._patchSession.setTopology(this.loadTopology(options, this._productSupportManager, credentialManager));
            this._patchSession.setPatchTracking(patchTracking);
            this._patchSession.setOutOfPlaceEnabled(Boolean.parseBoolean(options.getOption("out.of.place").getValue()));
            this._patchSession.setCreateImageEnabled(Boolean.parseBoolean(options.getOption("create.image").getValue()));
            this._patchSession.setApplyImageEnabled(Boolean.parseBoolean(options.getOption("apply.image").getValue()));
            this._patchSession.setImageLocation(options.getOption("image.location").getValue());
            this._patchSession.setPushImage("push-image".equals(options.getOption("patch.plan").getValue()));
            patchTracking.updateOptions(options);
            patchTracking.initPatchTargets(this._patchSession.getPatchPlanManager().getPatchTargets());
            this._productSupportManager.postPatchSessionInit(this._patchSession);
            this._productSupportManager.validatePatchSession(this._patchSession);
            if (this._command.isReport()) {
                this._productSupportManager.initializeOPatchAutoReporting(options.getOption("type").getValue());
            }
        }
        catch (Throwable t) {
            this._prepared = false;
            this._patchSession = null;
            if (this._productSupportManager != null) {
                this._productSupportManager.closeSession(this._command, false);
            }
            RemoteConnectionManager.closeAll();
            this.postRestarted(options, this._patchSession != null ? this._patchSession.getPatchTracking() : null);
            if (t instanceof OPatchAutoException) {
                throw (OPatchAutoException)t;
            }
            throw new OPatchAutoException(t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void orchestrate() throws OPatchAutoException {
        OPatchAutoOptions options;
        boolean isSuccessful;
        block16: {
            if (!this._prepared) {
                throw new OPatchAutoException("68151", new Object[0]);
            }
            isSuccessful = false;
            options = null;
            try {
                options = this._productSupportManager.getOptions();
                String log = options.getOption(OPatchAutoOptions.LOG_KEY).getValue(this.getDefaultLogFileLocation(OPatchAutoHelper.getOPatchAutoHome()));
                String logLevel = options.getOption(OPatchAutoOptions.LOG_LEVEL_KEY).getValue();
                if (this._command.isAction()) {
                    String containerPath = options.getOption("container").getValue();
                    if (StringUtil.isNullOrEmpty((String)containerPath, (boolean)true)) {
                        throw new OPatchAutoException("68007", new Object[0]);
                    }
                    try {
                        PatchActionExecutor.executeSerializedPatchAction(containerPath, this._productSupportManager, OPatchAutoHelper.getPluginClassLoader());
                        isSuccessful = true;
                    }
                    catch (PatchActionException e) {
                        _log.log(Level.SEVERE, "Failed to execute patch action.", e);
                        throw new OPatchAutoException("68008", (Throwable)e, new Object[0]);
                    }
                }
                if ((this._patchSession.isOutOfPlacePatchingEnabled() || this._patchSession.isApplyImageEnabled()) && !this._patchSession.isCreateImageEnabled() && this._patchSession.getPatchPlanManager().isLocalHomeTargetForPatching(OPatchAutoHelper.getOPatchAutoHome(), this._productSupportManager.getExternalOPatchAutoProductTypes()) && !Boolean.parseBoolean(options.getOption("restarted").getValue())) {
                    File tmpHome = OPatchAutoHelper.copyOPatchAutoRuntime(this._productSupportManager);
                    File javaHome = OPatchAutoHelper.copyJavaHome();
                    File srcDir = new File(OPatchAutoHelper.getOPatchAutoHome(), "inventory/opatchauto");
                    File destDir = new File(tmpHome, "inventory/opatchauto");
                    try {
                        DirectoryCopy.copy((File)srcDir, (File)destDir);
                    }
                    catch (IOException e) {
                        throw new OPatchAutoException("68017", (Throwable)e, srcDir, destDir);
                    }
                    Reporting.report((String)OPatchAutoHelper.getLocalizedString("OPatchAuto.copy.and.restart", new Object[0]));
                    throw new OPatchAutoRestartException(tmpHome, javaHome, this._patchSession);
                }
                IObjectStore objectStore = ObjectStoreManager.getObjectStore((String)OPATCH_AUTO_NAMESPACE);
                objectStore.storeObject((Object)"patching.products.set", this._productSupportManager.getProductIds());
                objectStore.storeAll(options.getOptionsValueMap());
                objectStore.storeObject((Object)"patch.plan.target", (Object)this._patchPlanTarget);
                objectStore.storeObject((Object)"plugin.classpath", OPatchAutoHelper.getInstance().getPluginClasspath());
                HashMap<String, String> configWizOptions = new HashMap<String, String>();
                configWizOptions.put("mode", "silent");
                configWizOptions.put(WizardConfiguration.LOGFILE.getName(), log);
                configWizOptions.put(WizardConfiguration.LOGPRIORITY.getName(), logLevel);
                configWizOptions.put(WizardConfiguration.TARGET.getName(), this._command.name());
                OrchestrationEngineFactory.getOrchestrationEngine().orchestrate(configWizOptions);
                if (!Boolean.parseBoolean(objectStore.getString("patch.plan.found"))) {
                    throw new OPatchAutoException("68018", options.getOption("patch.plan").getValue());
                }
                if (this._command.isReport()) {
                    OPatchAutoReporting reporting = OPatchAutoReportingManager.getInstance().getReportingHandler(options.getOption("type").getValue());
                    boolean report = reporting.report(options.getOption("output").getValue(), options.getOption("format").getValue(), "1.0");
                    OPatchAutoReportingManager.getInstance().clear();
                    if (!report) {
                        _log.log(Level.SEVERE, "Failed to generate report");
                        throw new OPatchAutoException("68164", new Object[0]);
                    }
                }
                isSuccessful = true;
                Reporting.report((String)OPatchAutoHelper.getLocalizedString("OPatchAuto.opatchauto.successful", new Object[0]));
                if (this._command.isAction()) break block16;
            }
            catch (Throwable throwable) {
                if (!this._command.isAction()) {
                    this._patchSession.getPatchTracking().updateSessionStatus(isSuccessful ? StatusType.SUCCESS : StatusType.FAILURE);
                }
                if (this._productSupportManager != null) {
                    this._productSupportManager.closeSession(this._command, isSuccessful);
                }
                RemoteConnectionManager.closeAll();
                this.postRestarted(options, this._patchSession != null ? this._patchSession.getPatchTracking() : null);
                throw throwable;
            }
            this._patchSession.getPatchTracking().updateSessionStatus(isSuccessful ? StatusType.SUCCESS : StatusType.FAILURE);
        }
        if (this._productSupportManager != null) {
            this._productSupportManager.closeSession(this._command, isSuccessful);
        }
        RemoteConnectionManager.closeAll();
        this.postRestarted(options, this._patchSession != null ? this._patchSession.getPatchTracking() : null);
    }

    private void validateOptions(OPatchAutoCommand command, ProductSupportManager productSupportManager, boolean fromCommandLine) throws OPatchAutoException {
        Set<OPatchAutoOptionGroup> optionGroups = productSupportManager.getOptions().getOptionGroups();
        for (OPatchAutoOptionGroup optionGroup : optionGroups) {
            Set<OPatchAutoOption> requireOptions;
            if (optionGroup.getRelationship().isRequiredTogether()) {
                requireOptions = optionGroup.validateRequiredTogether(false);
                if (requireOptions != null && !requireOptions.isEmpty()) {
                    if (fromCommandLine) {
                        OPatchAuto.usage(productSupportManager, OPatchAutoHelper.getPublishedMessage("68019", OPatchAuto.getOptionNames(requireOptions, true)), command);
                    } else {
                        throw new OPatchAutoException("68020", OPatchAuto.getOptionNames(requireOptions, false));
                    }
                }
                if ((requireOptions = optionGroup.validateRequiredTogether(true)) == null || requireOptions.isEmpty()) continue;
                if (fromCommandLine) {
                    OPatchAuto.usage(productSupportManager, OPatchAutoHelper.getPublishedMessage("68021", OPatchAuto.getOptionNames(requireOptions, true)), command);
                    continue;
                }
                throw new OPatchAutoException("68022", OPatchAuto.getOptionNames(requireOptions, false));
            }
            if (optionGroup.getRelationship().isMutuallyExclusive()) {
                requireOptions = optionGroup.validateMutuallyExclusive(false);
                if (requireOptions != null && !requireOptions.isEmpty()) {
                    if (fromCommandLine) {
                        OPatchAuto.usage(productSupportManager, OPatchAutoHelper.getPublishedMessage("68023", OPatchAuto.getOptionNames(requireOptions, true)), command);
                    } else {
                        throw new OPatchAutoException("68024", OPatchAuto.getOptionNames(requireOptions, false));
                    }
                }
                if ((requireOptions = optionGroup.validateMutuallyExclusive(true)) == null || requireOptions.isEmpty()) continue;
                if (fromCommandLine) {
                    OPatchAuto.usage(productSupportManager, OPatchAutoHelper.getPublishedMessage("68025", OPatchAuto.getOptionNames(requireOptions, true)), command);
                    continue;
                }
                throw new OPatchAutoException("68026", OPatchAuto.getOptionNames(requireOptions, false));
            }
            if (optionGroup.getRelationship().isIfFirstThenAllRequired()) {
                requireOptions = optionGroup.validateIfFirstThenAllRequired(false);
                if (requireOptions != null && !requireOptions.isEmpty()) {
                    if (fromCommandLine) {
                        OPatchAuto.usage(productSupportManager, OPatchAutoHelper.getPublishedMessage("68019", OPatchAuto.getOptionNames(requireOptions, true)), command);
                    } else {
                        throw new OPatchAutoException("68020", OPatchAuto.getOptionNames(requireOptions, false));
                    }
                }
                if ((requireOptions = optionGroup.validateIfFirstThenAllRequired(true)) == null || requireOptions.isEmpty()) continue;
                if (fromCommandLine) {
                    OPatchAuto.usage(productSupportManager, OPatchAutoHelper.getPublishedMessage("68021", OPatchAuto.getOptionNames(requireOptions, true)), command);
                    continue;
                }
                throw new OPatchAutoException("68022", OPatchAuto.getOptionNames(requireOptions, false));
            }
            if (optionGroup.getRelationship().isIfFirstThenAtLeastOneRequired()) {
                requireOptions = optionGroup.validateIfFirstThenAtLeastOneRequired(false);
                if (requireOptions != null && !requireOptions.isEmpty()) {
                    if (fromCommandLine) {
                        OPatchAuto.usage(productSupportManager, OPatchAutoHelper.getPublishedMessage("68027", optionGroup.getOptions().iterator().next().getArg(), OPatchAuto.getOptionNames(requireOptions, true)), command);
                    } else {
                        throw new OPatchAutoException("68028", optionGroup.getOptions().iterator().next().getKey(), OPatchAuto.getOptionNames(requireOptions, false));
                    }
                }
                if ((requireOptions = optionGroup.validateIfFirstThenAtLeastOneRequired(true)) == null || requireOptions.isEmpty()) continue;
                if (fromCommandLine) {
                    OPatchAuto.usage(productSupportManager, OPatchAutoHelper.getPublishedMessage("68021", OPatchAuto.getOptionNames(requireOptions, true)), command);
                    continue;
                }
                throw new OPatchAutoException("68022", OPatchAuto.getOptionNames(requireOptions, false));
            }
            if (!optionGroup.getRelationship().isIfFirstThenExcludeAll() || (requireOptions = optionGroup.validateIfFirstThenExcludeAll()) == null || requireOptions.isEmpty()) continue;
            if (fromCommandLine) {
                OPatchAuto.usage(productSupportManager, OPatchAutoHelper.getPublishedMessage("68158", optionGroup.getOptions().iterator().next().getArg(), OPatchAuto.getOptionNames(requireOptions, true)), command);
                continue;
            }
            throw new OPatchAutoException("68159", optionGroup.getOptions().iterator().next().getArg(), OPatchAuto.getOptionNames(requireOptions, false));
        }
        Set<OPatchAutoOption> requiredArgs = productSupportManager.getOptions().getRequiredCommandOptions(command);
        if (!requiredArgs.isEmpty()) {
            LinkedHashSet<OPatchAutoOption> missingRequired = new LinkedHashSet<OPatchAutoOption>();
            for (OPatchAutoOption option : requiredArgs) {
                if (option == null || option.hasValue()) continue;
                missingRequired.add(option);
            }
            if (!missingRequired.isEmpty()) {
                if (fromCommandLine) {
                    OPatchAuto.usage(productSupportManager, OPatchAutoHelper.getPublishedMessage("68021", OPatchAuto.getOptionNames(missingRequired, true)), command);
                } else {
                    throw new OPatchAutoException("68022", OPatchAuto.getOptionNames(missingRequired, false));
                }
            }
        }
    }

    public static Set<OPatchAutoOption> populateOptionsFromArgs(OPatchAutoCommand command, OPatchAutoOptions options, List<String> argsList) throws OPatchAutoException {
        LinkedHashSet<OPatchAutoOption> populatedOptions = new LinkedHashSet<OPatchAutoOption>();
        LinkedHashSet<OPatchAutoOption> supportedOptions = new LinkedHashSet<OPatchAutoOption>();
        supportedOptions.addAll(options.getGlobalOptions());
        supportedOptions.addAll(options.getCommandOptions(command));
        OPatchAutoOption parameter = options.getCommandParameter(command);
        if (parameter != null) {
            supportedOptions.add(parameter);
        }
        HashSet<String> switches = new HashSet<String>();
        HashSet<String> validArgs = new HashSet<String>();
        for (OPatchAutoOption option : supportedOptions) {
            if (option.isSwitch()) {
                switches.add(option.getArg());
                continue;
            }
            validArgs.add(option.getArg());
        }
        Map<String, String> parsedCommandArgs = OPatchAuto.parseCommandLineArgs(argsList, validArgs, switches, parameter != null ? parameter.getArg() : null);
        for (Map.Entry<String, String> entry : parsedCommandArgs.entrySet()) {
            String arg = entry.getKey();
            String value = entry.getValue();
            for (OPatchAutoOption option : supportedOptions) {
                if (!option.getArg().equals(arg)) continue;
                if (option.isDisabled()) {
                    throw new OPatchAutoOptionsException("68150", arg);
                }
                if (option.isPassword()) {
                    option.setPasswordValue(value.toCharArray());
                } else {
                    option.setValue(value);
                }
                populatedOptions.add(option);
            }
        }
        return populatedOptions;
    }

    private static Collection<String> getOptionNames(Collection<OPatchAutoOption> options, boolean fromCommandLine) {
        ArrayList<String> missingRequired = new ArrayList<String>();
        if (options != null) {
            for (OPatchAutoOption option : options) {
                if (option == null) continue;
                missingRequired.add(fromCommandLine ? option.getArg() : option.getKey());
            }
        }
        return missingRequired;
    }

    private static void usage(ProductSupportManager productSupportManager, String message) throws OPatchAutoException {
        OPatchAuto.usage(productSupportManager, message, false);
    }

    private static void usage(ProductSupportManager productSupportManager, String message, boolean helpRequest) throws OPatchAutoException {
        OPatchAuto.usage(productSupportManager, message, helpRequest, null, null);
    }

    private static void usage(ProductSupportManager productSupportManager, String message, OPatchAutoCommand command) throws OPatchAutoException {
        OPatchAuto.usage(productSupportManager, message, false, command, null);
    }

    private static void usage(ProductSupportManager productSupportManager, String message, boolean helpRequest, OPatchAutoCommand command, String patchPlan) throws OPatchAutoException {
        StringBuilder sb = new StringBuilder();
        if (!StringUtil.isNullOrEmpty((String)message, (boolean)true)) {
            sb.append(message).append("\n\n");
        }
        sb.append(OPatchAuto.getUsageHeader());
        if (command == null) {
            sb.append(OPatchAuto.getIndent(Integer.parseInt(OPatchAutoHelper.getLocalizedString("opatchauto.usage.line1.indent", new Object[0]))));
            sb.append(OPatchAutoHelper.getLocalizedString("opatchauto.usage.line1", new Object[0]));
            sb.append("\n\n");
            int indentSize = Integer.parseInt(OPatchAutoHelper.getLocalizedString("opatchauto.usage.command.prefix.indent", new Object[0]));
            String commandPrefix = OPatchAutoHelper.getLocalizedString("opatchauto.usage.command.prefix", new Object[0]) + " ";
            sb.append(OPatchAuto.getIndent(indentSize)).append(commandPrefix);
            indentSize += commandPrefix.length();
            Set<OPatchAutoCommand> filterCommandList = OPatchAuto.filterUnsuporttedCommands(OPatchAutoCommand.getExternalCommands(), productSupportManager);
            for (OPatchAutoCommand c : filterCommandList) {
                sb.append(c.name()).append("\n").append(OPatchAuto.getIndent(indentSize));
            }
            sb.append("\n");
            indentSize = Integer.parseInt(OPatchAutoHelper.getLocalizedString("opatchauto.usage.global.prefix.indent", new Object[0]));
            String globalPrefix = OPatchAutoHelper.getLocalizedString("opatchauto.usage.global.prefix", new Object[0]) + " ";
            sb.append(OPatchAuto.getIndent(indentSize)).append(globalPrefix);
            indentSize += globalPrefix.length();
            Set<OPatchAutoOption> globalOptions = productSupportManager.getOptions().getGlobalOptions();
            for (OPatchAutoOption option : globalOptions) {
                sb.append(option.getArg()).append("\n").append(OPatchAuto.getIndent(indentSize));
            }
            sb.append("\n");
            indentSize = Integer.parseInt(OPatchAutoHelper.getLocalizedString("opatchauto.usage.examples.prefix.indent", new Object[0]));
            String examplesPrefix = OPatchAutoHelper.getLocalizedString("opatchauto.usage.examples.prefix", new Object[0]);
            sb.append(OPatchAuto.getIndent(indentSize)).append(examplesPrefix).append("\n");
            indentSize = Integer.parseInt(OPatchAutoHelper.getLocalizedString("opatchauto.usage.example.indent", new Object[0]));
            String appName = OPatchAutoHelper.getLocalizedString("opatchauto.usage.app.name", new Object[0]);
            for (OPatchAutoOption option : globalOptions) {
                sb.append(OPatchAuto.getIndent(indentSize)).append("'").append(appName).append(" ").append(option.getArg()).append("'\n");
            }
            for (OPatchAutoCommand c : filterCommandList) {
                if (c.isInternal()) continue;
                if (!c.hasOptions()) {
                    sb.append(OPatchAuto.getIndent(indentSize)).append("'").append(appName).append(" ").append(c.name()).append("'\n");
                    continue;
                }
                for (OPatchAutoOption option : globalOptions) {
                    if (!option.isPerCommandGlobal()) continue;
                    sb.append(OPatchAuto.getIndent(indentSize)).append("'").append(appName).append(" ").append(c.name()).append(" ").append(option.getArg()).append("'\n");
                }
            }
            OPatchAutoOption patchPlanOption = productSupportManager.getOptions().getOption("patch.plan");
            if (patchPlanOption.isVisible()) {
                OPatchAutoOption helpOption = productSupportManager.getOptions().getOption("help");
                sb.append(OPatchAuto.getIndent(indentSize)).append("'").append(appName).append(" ").append(OPatchAutoCommand.apply.name()).append(" ").append(patchPlanOption.getCommandLineDescription()).append(" ").append(helpOption.getArg()).append("'\n");
                sb.append(OPatchAuto.getIndent(indentSize)).append("'").append(appName).append(" ").append(OPatchAutoCommand.rollback.name()).append(" ").append(patchPlanOption.getCommandLineDescription()).append(" ").append(helpOption.getArg()).append("'\n");
            }
        } else {
            if (command.isResumed()) {
                command = OPatchAutoCommand.resume;
            }
            boolean patchPlanSpecific = !StringUtil.isNullOrEmpty((String)patchPlan, (boolean)true);
            Set<OPatchAutoOption> commandOptions = productSupportManager.getOptions().getCommandOptions(command);
            Iterator<OPatchAutoOption> it = commandOptions.iterator();
            while (it.hasNext()) {
                OPatchAutoOption commandOption = it.next();
                if (commandOption.isVisible() && (patchPlanSpecific || !commandOption.isPatchPlanSpecific()) && (!patchPlanSpecific || commandOption.hasPatchPlan(patchPlan))) continue;
                it.remove();
            }
            String indent = OPatchAuto.getIndent(Integer.parseInt(OPatchAutoHelper.getLocalizedString("opatchauto.command.description.indent", new Object[0])));
            if (patchPlanSpecific && commandOptions.isEmpty()) {
                sb.append(indent).append(OPatchAutoHelper.getLocalizedString("opatchauto.patch.plan.no.options", patchPlan)).append("\n");
                OPatchAutoOptionsException exception = new OPatchAutoOptionsException(sb.toString(), new Object[0]);
                exception.setHelpRequested(helpRequest);
                throw exception;
            }
            sb.append(OPatchAutoHelper.getLocalizedString("opatchauto.command.description.header", new Object[0]));
            sb.append("\n");
            String description = patchPlanSpecific ? OPatchAutoHelper.getLocalizedString("opatchauto.patch.plan.specific.description", patchPlan) : command.getDescription();
            String formattedDescription = description.replace("\n", "\n" + indent);
            sb.append(indent).append(formattedDescription);
            sb.append("\n\n");
            sb.append(OPatchAutoHelper.getLocalizedString("opatchauto.syntax.description.header", new Object[0]));
            sb.append("\n");
            if (!command.hasOptions()) {
                sb.append(indent).append(OPatchAutoHelper.getLocalizedString("opatchauto.command.no.options", new Object[]{command})).append("\n");
            } else {
                int indentSize;
                int wrap = Integer.parseInt(OPatchAutoHelper.getLocalizedString("opatchauto.syntax.wrap", new Object[0]));
                String appName = indent + OPatchAutoHelper.getLocalizedString("opatchauto.usage.app.name", new Object[0]);
                appName = appName + " " + command.name();
                int currentSize = indentSize = appName.length() + 1;
                String args = "";
                OPatchAutoOption commandParameter = null;
                if (!patchPlanSpecific && (commandParameter = productSupportManager.getOptions().getCommandParameter(command)) != null) {
                    String argsStr = "[ <" + commandParameter.getArg() + "> ]";
                    currentSize += argsStr.length();
                    args = args + " " + (String)argsStr;
                }
                for (OPatchAutoOption commandOption : commandOptions) {
                    String argsStr = "[ " + commandOption.getCommandLineDescription() + " ]";
                    if (currentSize + argsStr.length() > wrap) {
                        args = args + "\n" + OPatchAuto.getIndent(indentSize);
                        currentSize = indentSize;
                    } else {
                        args = args + " ";
                    }
                    currentSize += argsStr.length();
                    args = args + argsStr;
                }
                sb.append(appName).append(args);
                sb.append("\n\n");
                sb.append(OPatchAutoHelper.getLocalizedString("opatchauto.options.description.header", new Object[0]));
                String optionIndent = OPatchAuto.getIndent(Integer.parseInt(OPatchAutoHelper.getLocalizedString("opatchauto.option.indent", new Object[0])));
                String optionDescIndent = OPatchAuto.getIndent(Integer.parseInt(OPatchAutoHelper.getLocalizedString("opatchauto.option.description.indent", new Object[0])));
                for (OPatchAutoOption commandOption : commandOptions) {
                    sb.append("\n");
                    sb.append(optionIndent).append(commandOption.getCommandLineDescription());
                    sb.append("\n");
                    sb.append(optionDescIndent).append(commandOption.getDescription().replace("\n", "\n" + optionDescIndent));
                    if (commandOption.hasSupportedValues()) {
                        String supportIndent = optionDescIndent + "  ";
                        sb.append("\n").append(supportIndent);
                        sb.append(OPatchAutoHelper.getLocalizedString("opatchauto.option.supported.values", new Object[0]));
                        supportIndent = supportIndent + "  ";
                        sb.append("\n").append(supportIndent);
                        for (String val : commandOption.getSupportedValues()) {
                            sb.append(val.replace("\n", "\n" + supportIndent));
                        }
                    }
                    sb.append("\n");
                }
                if (commandParameter != null) {
                    optionIndent = OPatchAuto.getIndent(Integer.parseInt(OPatchAutoHelper.getLocalizedString("opatchauto.parameter.indent", new Object[0])));
                    optionDescIndent = OPatchAuto.getIndent(Integer.parseInt(OPatchAutoHelper.getLocalizedString("opatchauto.parameter.description.indent", new Object[0])));
                    sb.append("\n");
                    sb.append(OPatchAutoHelper.getLocalizedString("opatchauto.parameters.description.header", new Object[0]));
                    sb.append("\n");
                    sb.append(optionIndent).append(commandParameter.getArg());
                    sb.append("\n");
                    sb.append(optionDescIndent).append(commandParameter.getDescription().replace("\n", "\n" + optionDescIndent));
                    sb.append("\n");
                }
            }
            String example = command.getExample();
            if (!StringUtil.isNullOrEmpty((String)example)) {
                sb.append("\n");
                String exampleHeaderString = OPatchAutoHelper.getLocalizedString("opatchauto.command.example.header", new Object[0]);
                sb.append(exampleHeaderString);
                sb.append("\n");
                String formattedExample = example.replace("\n", "\n" + indent);
                sb.append(indent).append(formattedExample);
                sb.append("\n");
            }
        }
        OPatchAutoOptionsException exception = new OPatchAutoOptionsException(sb.toString(), new Object[0]);
        exception.setHelpRequested(helpRequest);
        throw exception;
    }

    private static void versionUsage(ProductSupportManager productSupportManager) throws OPatchAutoException {
        OPatchAutoOptionsException e = new OPatchAutoOptionsException(OPatchAuto.getUsageHeader() + OPatchAuto.getOpatchAutoDisplayVersions(productSupportManager) + "\n", new Object[0]);
        e.setHelpRequested(true);
        throw e;
    }

    private static void phaseUsage(ProductSupportManager productSupportManager) throws OPatchAutoException {
        StringBuilder sb = new StringBuilder();
        sb.append(OPatchAuto.getUsageHeader());
        String indent = "    ";
        sb.append("  ").append(OPatchAutoHelper.getLocalizedString("opatchauto.lsphases.header", new Object[0]));
        for (Phase phase : Phase.values()) {
            sb.append("\n\n");
            sb.append(indent).append(OPatchAutoHelper.getLocalizedString("opatchauto.lsphases.phase", new Object[]{phase}));
            for (Goal goal : phase.getGoals()) {
                sb.append("\n").append(indent).append("  ").append(OPatchAutoHelper.getLocalizedString("opatchauto.lsphases.goal", goal.getPhaseGoal()));
                List<PatchAction> patchActions = productSupportManager.getPatchActionManager().getPatchActions(goal);
                if (patchActions != null && !patchActions.isEmpty()) {
                    for (PatchAction patchAction : patchActions) {
                        String actionName = indent + "    " + OPatchAutoHelper.getLocalizedString("opatchauto.lsphases.patchaction", patchAction.getDisplayName());
                        sb.append("\n").append(actionName);
                        String description = patchAction.getDescription();
                        if (StringUtil.isNullOrEmpty((String)description, (boolean)true)) continue;
                        String descriptionHeader = indent + "      " + OPatchAutoHelper.getLocalizedString("opatchauto.lsphases.patchaction.description", new Object[0]) + " ";
                        sb.append(descriptionHeader);
                        sb.append(description.replace("\n", "\n" + OPatchAuto.getIndent(actionName.length() + descriptionHeader.length())));
                    }
                    continue;
                }
                sb.append("\n").append(indent).append("    ").append(OPatchAutoHelper.getLocalizedString("opatchauto.lsphases.noaction", new Object[0]));
            }
        }
        sb.append("\n");
        OPatchAutoOptionsException exception = new OPatchAutoOptionsException(sb.toString(), new Object[0]);
        exception.setHelpRequested(true);
        throw exception;
    }

    private static void planUsage(ProductSupportManager productSupportManager) throws OPatchAutoException {
        StringBuilder sb = new StringBuilder();
        sb.append(OPatchAuto.getUsageHeader());
        String indent = "  ";
        sb.append(indent).append(OPatchAutoHelper.getLocalizedString("opatchauto.lsplans.header", new Object[0]));
        LinkedHashSet<ProductSupport> productSupports = new LinkedHashSet<ProductSupport>();
        ProductSupport defaultProductSupport = productSupportManager.getDefaultProductSupport();
        productSupports.add(productSupportManager.getDefaultProductSupport());
        for (ProductSupport productSupport : productSupportManager.getProductSupport()) {
            if (productSupport.equals(defaultProductSupport)) continue;
            productSupports.add(productSupport);
        }
        for (ProductSupport productSupport : productSupports) {
            Set<String> patchPlans = productSupport.getPatchPlans();
            if (patchPlans != null && !patchPlans.isEmpty()) {
                sb.append("\n\n").append(indent).append("  ").append(OPatchAutoHelper.getLocalizedString("opatchauto.lsplans.product", productSupport.getProductDisplayName()));
                for (String patchPlan : patchPlans) {
                    String description;
                    String planNameLine = indent + "    " + OPatchAutoHelper.getLocalizedString("opatchauto.lsplans.patch.plan", patchPlan);
                    sb.append("\n").append(planNameLine);
                    if ("rolling".equals(patchPlan)) {
                        sb.append(" ").append(OPatchAutoHelper.getLocalizedString("opatchauto.lsplans.default", new Object[0]));
                    }
                    if (StringUtil.isNullOrEmpty((String)(description = productSupport.getPatchPlanDescription(patchPlan)), (boolean)true)) continue;
                    String descriptionHeader = indent + "      " + OPatchAutoHelper.getLocalizedString("opatchauto.lsplans.patch.plan.description", new Object[0]) + " ";
                    sb.append("\n").append(descriptionHeader);
                    sb.append(description.replace("\n", "\n" + OPatchAuto.getIndent(descriptionHeader.length())));
                }
                continue;
            }
            sb.append("\n").append(indent).append("    ").append(OPatchAutoHelper.getLocalizedString("opatchauto.lsplans.noplans", new Object[0]));
        }
        sb.append("\n");
        OPatchAutoOptionsException exception = new OPatchAutoOptionsException(sb.toString(), new Object[0]);
        exception.setHelpRequested(true);
        throw exception;
    }

    private static String getUsageHeader() {
        return MessageFormat.format(OPatchAutoHelper.getLocalizedString("opatchauto.usage.header1", new Object[0]), OPatchAutoHelper.getInstance().getOPatchAutoVersion()) + "\n" + OPatchAutoHelper.getLocalizedString("opatchauto.usage.header2", new Object[0]) + "\n\n";
    }

    private static String getIndent(int size) {
        return StringUtil.getPad((String)" ", (int)size);
    }

    public static Map<String, String> parseCommandLineArgs(List<String> argsList, Collection<String> validArgs, Collection<String> validSwitches, String parameter) throws OPatchAutoOptionsException {
        boolean hasParameter = !StringUtil.isNullOrEmpty((String)parameter, (boolean)true);
        HashMap<String, String> options = new HashMap<String, String>();
        if (argsList != null && !argsList.isEmpty()) {
            for (int x = 0; x < argsList.size(); ++x) {
                String value;
                String arg = argsList.get(x);
                if (arg == null) {
                    throw new OPatchAutoOptionsException("68029", "null");
                }
                if (!arg.startsWith("-")) {
                    if (hasParameter && !options.containsKey(parameter)) {
                        options.put(parameter, arg);
                        continue;
                    }
                    throw new OPatchAutoOptionsException("68029", arg);
                }
                if (validSwitches != null && validSwitches.contains(arg)) {
                    value = "true";
                } else {
                    if (validArgs != null && !validArgs.contains(arg)) {
                        throw new OPatchAutoOptionsException("68029", arg);
                    }
                    if (argsList.size() <= ++x || argsList.get(x).startsWith("-")) {
                        if (argsList.size() <= x) {
                            throw new OPatchAutoOptionsException("68030", arg);
                        }
                        throw new OPatchAutoOptionsException("68031", argsList.get(x), arg);
                    }
                    value = argsList.get(x);
                }
                options.put(arg, value);
            }
        }
        return options;
    }

    private Topology loadTopology(OPatchAutoOptions options, ProductSupportManager productSupportManager, CredentialManager credentialManager) throws OPatchAutoException {
        Set<Home> set;
        if (this._topology != null) {
            return this._topology;
        }
        Topology basicTopology = null;
        String topologyPath = options.getOption("topology").getValue();
        if (!StringUtil.isNullOrEmpty((String)topologyPath, (boolean)true)) {
            File topologyFile = new File(topologyPath);
            if (!topologyFile.exists()) {
                throw new OPatchAutoException("68032", topologyPath);
            }
            boolean found = false;
            Set<ProductSupport> set2 = productSupportManager.getProductSupport();
            for (ProductSupport support : set2) {
                if (!support.isSupportedTopology(topologyFile, options, credentialManager)) continue;
                support.setTopologyFile(topologyFile);
                found = true;
            }
            if (!found) {
                throw new OPatchAutoException("68033", topologyPath);
            }
        } else if (!productSupportManager.isDefaultTopologyDisabled()) {
            basicTopology = TopologyFactory.getBasicTopology(options, credentialManager);
            Set<Instance> instances = basicTopology.getInstances();
            if (instances != null && !instances.isEmpty()) {
                for (Instance instance : instances) {
                    boolean found = false;
                    Set<ProductType> productTypes = productSupportManager.getProductSupportTypes(SupportType.instance);
                    for (ProductType productType : productTypes) {
                        if (!productType.isSupportedInstance(instance)) continue;
                        instance.addProductType(productType);
                        productSupportManager.getProductSupportForProductType(productType.getType()).setTopology(basicTopology);
                        found = true;
                    }
                    if (found) continue;
                    throw new OPatchAutoException("68034", instance);
                }
            }
            Set<ProductType> productTypes = productSupportManager.getProductSupportTypes(SupportType.home);
            for (Home home : basicTopology.getHomes()) {
                boolean found = false;
                for (ProductType type : productTypes) {
                    if (!type.isSupportedHome(home)) continue;
                    home.addProductType(type);
                    found = true;
                }
                if (found) continue;
                throw new OPatchAutoException("68035", home);
            }
        }
        LinkedHashSet<Topology> topologies = new LinkedHashSet<Topology>();
        for (ProductSupport productSupport : productSupportManager.getProductSupport()) {
            productSupport.loadTopology(options, credentialManager);
            Topology topology = productSupport.getTopology();
            if (topology == null) continue;
            topologies.add(topology);
        }
        if (basicTopology != null) {
            topologies.add(basicTopology);
        }
        Topology fullTopology = TopologyFactory.mergeTopologies(topologies);
        if (!productSupportManager.isDefaultTopologyDisabled() && (set = fullTopology.getHomes()) != null) {
            for (Home home : set) {
                home.addProductType(productSupportManager.getDefaultProductSupport().getType("default"));
            }
        }
        if (fullTopology.getHomes().isEmpty() && fullTopology.getInstances().isEmpty()) {
            throw new OPatchAutoException("68036", new Object[0]);
        }
        _log.info("Topology loaded:\n" + fullTopology);
        return fullTopology;
    }

    private String getDefaultLogFileLocation(String home) throws OPatchAutoException {
        return this.getLogDirectoryLocation(home) + File.separator + OPATCH_AUTO_NAMESPACE + OPatchAutoHelper.getCurrentDateTimeStamp(LOG_FILENAME_DATE_FORMAT) + ".log";
    }

    private String getLogDirectoryLocation(String home) throws OPatchAutoException {
        String logDir = home + File.separator + DEFAULT_LOG_DIR + File.separator + OPATCH_AUTO_NAMESPACE;
        OPatchAutoOptions options = this._productSupportManager.getOptions();
        String customLogDir = options.getOption("customLogDir").getValue();
        if (!StringUtil.isNullOrEmpty((String)customLogDir)) {
            logDir = customLogDir + File.separator + OPATCH_AUTO_NAMESPACE;
        }
        return logDir;
    }

    private static String getOpatchAutoDisplayVersions(ProductSupportManager productSupportManager) {
        int i = 1;
        String s = i + ". " + OPatchAutoHelper.getLocalizedString("OPatchAuto.opatchauto.version", OPatchAutoHelper.getInstance().getOPatchAutoVersion());
        Map<String, String> versions = productSupportManager.getPluginVersions();
        if (versions != null) {
            for (Map.Entry<String, String> entry : versions.entrySet()) {
                s = s + "\n" + ++i + ". " + OPatchAutoHelper.getLocalizedString("OPatchAuto.version", entry.getKey(), entry.getValue());
            }
        }
        return s;
    }

    private void postRestarted(OPatchAutoOptions options, PatchTracking patchTracking) throws OPatchAutoException {
        String originalHome;
        if (options != null && Boolean.parseBoolean(options.getOption("restarted").getValue()) && !StringUtil.isNullOrEmpty((String)(originalHome = options.getOption("home").getValue()))) {
            OPatchAutoOption logOption = options.getOption(OPatchAutoOptions.LOG_KEY);
            if (logOption.isUsingDefault()) {
                File sourceLog = new File(logOption.getValue());
                File destLog = new File(this.getLogDirectoryLocation(originalHome), sourceLog.getName());
                try {
                    Reporting.report((String)OPatchAutoHelper.getLocalizedString("OPatchAuto.copying.log.file", sourceLog, destLog));
                    FileCopy.copy((File)sourceLog, (File)destLog);
                }
                catch (IOException e) {
                    _log.log(Level.WARNING, "Failed to copy log file " + sourceLog + " to " + destLog, e);
                }
            }
            if (patchTracking != null) {
                File sourceTracking = patchTracking.getSessionFile();
                File destTracking = new File(PatchTracking.getSessionDir(originalHome), sourceTracking.getName());
                try {
                    Reporting.report((String)OPatchAutoHelper.getLocalizedString("OPatchAuto.copying.patch.tracking", patchTracking.getSessionId(), originalHome));
                    FileCopy.copy((File)sourceTracking, (File)destTracking);
                }
                catch (IOException e) {
                    _log.log(Level.WARNING, "Failed to copy patch tracking file " + sourceTracking + " to " + destTracking, e);
                }
            }
            String tmpHome = OPatchAutoHelper.getOPatchAutoHome();
            Reporting.report((String)OPatchAutoHelper.getLocalizedString("OPatchAuto.deleting.temporary.home", tmpHome));
            OPatchAutoCleanupShutdownHook.add(new File(tmpHome), true);
        }
    }

    static {
        OPatchAutoHelper.manageResourceBundles();
    }
}

