/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.glcm.patch.auto;

import com.oracle.cie.common.comdev.ComdevHelper;
import com.oracle.cie.common.util.DirectoryCopy;
import com.oracle.cie.common.util.FileCopy;
import com.oracle.cie.common.util.IOUtil;
import com.oracle.glcm.patch.auto.OPatchAutoException;
import com.oracle.glcm.patch.auto.OPatchAutoHelper;
import com.oracle.glcm.patch.auto.product.ProductSupportManager;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.logging.Logger;

public class ClasspathCopier {
    private static final Logger _log = Logger.getLogger(ClasspathCopier.class.getName());
    private List<File> _classpath;
    private Map<File, File> _destMap = new LinkedHashMap<File, File>();

    public static void main(String[] args) {
        try {
            File home;
            if (args.length < 2) {
                System.out.println(OPatchAutoHelper.getLocalizedString("ClasspathCopier.incorrect.arguments", new Object[0]));
                ClasspathCopier.usage();
                System.exit(-2);
            }
            if (!(home = new File(args[0])).isDirectory()) {
                throw new OPatchAutoException("68136", home);
            }
            File destDir = new File(args[1]);
            if (destDir.exists()) {
                if (!destDir.isDirectory()) {
                    throw new OPatchAutoException("68137", destDir);
                }
            } else if (!destDir.mkdirs()) {
                throw new OPatchAutoException("68138", destDir);
            }
            Collection<String> additional = OPatchAutoHelper.getAdditionalCopyFiles(ProductSupportManager.getInstance());
            if (args.length > 2) {
                additional.addAll(Arrays.asList(args[2].split(",")));
            }
            ClasspathCopier.copyOPatchAuto(home, destDir, additional);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(-1);
        }
    }

    public static void copyOPatchAuto(File home, File destDir, Collection<String> additional) throws OPatchAutoException {
        if (additional == null) {
            additional = new HashSet<String>();
        }
        additional.add(home + "/" + OPatchAutoHelper.OPATCH_PATH);
        additional.add(home + "/" + OPatchAutoHelper.OUI_PATH);
        ClasspathCopier copier = new ClasspathCopier(OPatchAutoHelper.getPluginClassLoader(), additional);
        copier.copy(home, destDir, !Boolean.getBoolean(System.getProperty("ClasspathCopier.exclude.directories")));
        if (!ComdevHelper.isWindows()) {
            ArrayList<String> chmodCommands = new ArrayList<String>();
            chmodCommands.add("/bin/sh");
            chmodCommands.add("-c");
            chmodCommands.add("chmod -R 700 " + destDir.getAbsolutePath());
            try {
                if (OPatchAutoHelper.runtimeExec(chmodCommands, false, true) != 0) {
                    throw new OPatchAutoException("68046", new Object[0]);
                }
            }
            catch (IOException e) {
                throw new OPatchAutoException("68047", (Throwable)e, new Object[0]);
            }
        }
    }

    public static void usage() {
        System.out.println(OPatchAutoHelper.getLocalizedString("ClasspathCopier.usage", ClasspathCopier.class.getName()));
    }

    public ClasspathCopier(ClassLoader classLoader, Collection<String> additionalPaths) throws OPatchAutoException {
        if (classLoader == null) {
            classLoader = ClasspathCopier.class.getClassLoader();
        }
        this._classpath = this.getClasspath(classLoader);
        if (additionalPaths != null) {
            for (String path : additionalPaths) {
                this.addAdditional(new File(path));
            }
        }
    }

    private void addAdditional(File additional) {
        if (additional != null) {
            if (additional.isDirectory()) {
                File[] files = additional.listFiles();
                if (files != null && files.length > 0) {
                    for (File file : files) {
                        this.addAdditional(file);
                    }
                }
            } else if (!this._classpath.contains(additional)) {
                this._classpath.add(additional);
            }
        }
    }

    public List<File> getClasspath(ClassLoader classLoader) throws OPatchAutoException {
        ArrayList<File> classpath = new ArrayList<File>();
        ClassLoader parent = classLoader.getParent();
        if (parent != null) {
            classpath.addAll(this.getClasspath(parent));
        }
        if (!URLClassLoader.class.isAssignableFrom(classLoader.getClass())) {
            throw new OPatchAutoException("68139", new Object[0]);
        }
        URLClassLoader urlClassLoader = (URLClassLoader)classLoader;
        URL[] urls = urlClassLoader.getURLs();
        if (urls != null && urls.length > 0) {
            for (URL url : urls) {
                try {
                    classpath.add(new File(url.toURI()));
                }
                catch (URISyntaxException e) {
                    throw new OPatchAutoException("68140", (Throwable)e, url);
                }
            }
        }
        return classpath;
    }

    /*
     * WARNING - void declaration
     */
    public void copy(File commonParentDir, File destDir, boolean includeDirs) {
        try {
            String commonParentDirPath = (ComdevHelper.isWindows() ? IOUtil.getFile((File)commonParentDir) : commonParentDir).getAbsolutePath().replace("\\", "/");
            for (File file : this._classpath) {
                void var6_7;
                String filePath;
                if (!file.exists()) {
                    _log.info("File did not exist -- " + file);
                    continue;
                }
                if (!includeDirs && file.isDirectory()) {
                    _log.info("Skipping directory -- " + file);
                    continue;
                }
                if (ComdevHelper.isWindows()) {
                    File file2 = IOUtil.getFile((File)file);
                }
                if ((filePath = var6_7.getAbsolutePath().replace("\\", "/")).startsWith(commonParentDirPath)) {
                    String homeRelativePath = filePath.substring(commonParentDirPath.length(), filePath.length());
                    File destFile = new File(destDir, homeRelativePath);
                    this.addFile((File)var6_7, destFile, destDir, commonParentDirPath, includeDirs);
                    continue;
                }
                _log.info("Skipping file which was outside home -- " + var6_7);
            }
            if (!this._destMap.isEmpty()) {
                for (Map.Entry entry : this._destMap.entrySet()) {
                    if (((File)entry.getKey()).isDirectory()) {
                        DirectoryCopy.copy((File)((File)entry.getKey()), (File)((File)entry.getValue()), (FileFilter)(Boolean.getBoolean("ClasspathCopier.recursive.directory.copy") ? null : new FileFilter(){

                            @Override
                            public boolean accept(File pathname) {
                                return !pathname.isDirectory();
                            }
                        }));
                        continue;
                    }
                    FileCopy.copy((File)((File)entry.getKey()), (File)((File)entry.getValue()));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void addFile(File srcFile, File destFile, File destDir, String commonParentDirPath, boolean includeDirs) throws IOException {
        if (!this._destMap.containsKey(srcFile)) {
            this._destMap.put(srcFile, destFile);
            if (srcFile.getName().endsWith(".jar")) {
                String classpath;
                Attributes attributes;
                JarFile jarFile = new JarFile(srcFile);
                Manifest manifest = jarFile.getManifest();
                if (manifest != null && (attributes = manifest.getMainAttributes()) != null && (classpath = attributes.getValue(Attributes.Name.CLASS_PATH)) != null) {
                    String[] split;
                    File parentDir = srcFile.getParentFile();
                    String parentPath = parentDir.getAbsolutePath().replace("\\", "/");
                    parentPath = parentPath.substring(commonParentDirPath.length(), parentPath.length());
                    for (String s : split = classpath.split("\\s+")) {
                        File src = new File(parentDir, s);
                        if (!src.exists()) {
                            _log.info("File did not exist -- " + src);
                            continue;
                        }
                        if (!includeDirs && src.isDirectory()) {
                            _log.info("Skipping directory -- " + src);
                            continue;
                        }
                        src = IOUtil.getFile((File)src);
                        File dest = new File(destDir, parentPath + "/" + s);
                        this.addFile(src, dest, destDir, commonParentDirPath, includeDirs);
                    }
                }
                jarFile.close();
            }
        }
    }

    static {
        OPatchAutoHelper.manageResourceBundles();
    }
}

