/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatchauto.core.patchanalyzer.systempatch.engsystempatch;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import oracle.opatchauto.core.patchanalyzer.PatchPackageException;
import oracle.opatchauto.core.patchanalyzer.systempatch.ISystemPatchGenerator;
import oracle.opatchauto.core.patchanalyzer.systempatch.SubpatchModel;
import oracle.opatchauto.core.patchanalyzer.systempatch.SystemPatchBundleXML;
import oracle.opatchauto.core.patchanalyzer.systempatch.engsystempatch.EngSystemPatchValidator;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class EngSystemPatchGenerator
implements ISystemPatchGenerator {
    private EngSystemPatchValidator validator = new EngSystemPatchValidator();

    @Override
    public boolean isPatchValid(String patchLocation) throws PatchPackageException {
        assert (patchLocation != null);
        this.validator.validate(patchLocation);
        return true;
    }

    @Override
    public SystemPatchBundleXML generate(String patchLocation, boolean validate) throws PatchPackageException {
        SystemPatchBundleXML esysbundle = this.readContent(patchLocation, validate);
        return esysbundle;
    }

    private SystemPatchBundleXML readContent(String patchLocation, boolean validate) throws PatchPackageException {
        SystemPatchBundleXML bundleXML = null;
        StringBuffer bundleXMLLoc = new StringBuffer(patchLocation);
        bundleXMLLoc.append(File.separator);
        bundleXMLLoc.append("bundle.xml");
        File xmlFile = new File(bundleXMLLoc.toString());
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document doc = db.parse(xmlFile);
            doc.getDocumentElement().normalize();
            SystemPatchBundleXML tempBundleXML = this.extractBundleXMLInfo(patchLocation, doc);
            if (validate) {
                this.validateContent(tempBundleXML, doc);
            }
            bundleXML = tempBundleXML;
        }
        catch (SAXException e) {
            throw new PatchPackageException("xml file is not valid as " + e.getLocalizedMessage());
        }
        catch (IOException e) {
            throw new PatchPackageException("Failed while reading bundle xml " + e.getLocalizedMessage());
        }
        catch (ParserConfigurationException e) {
            throw new PatchPackageException("Failed while parsing bundle xml " + e.getLocalizedMessage());
        }
        return bundleXML;
    }

    public void validateContent(SystemPatchBundleXML bundleXML, Document doc) throws PatchPackageException {
        NodeList fValueNodeList = doc.getElementsByTagName("fvalue");
        HashMap<String, String> paramList = new HashMap<String, String>();
        if (fValueNodeList != null && fValueNodeList.getLength() > 0) {
            NodeList functionList;
            Element fvalueNode = (Element)fValueNodeList.item(0);
            NodeList valueList = fvalueNode.getElementsByTagName("value");
            if (valueList != null && valueList.getLength() > 0) {
                paramList.put("value", valueList.item(0).getTextContent());
            }
            if ((functionList = fvalueNode.getElementsByTagName("function")) != null && functionList.getLength() > 0) {
                paramList.put("function", functionList.item(0).getTextContent());
            }
        }
        this.validator.validate(bundleXML, paramList);
    }

    private SystemPatchBundleXML extractBundleXMLInfo(String patchLocation, Document bundleXMLFile) throws ParserConfigurationException, SAXException, IOException {
        SystemPatchBundleXML systemPatchBundleXml = null;
        NodeList system_patch_bundle_tag = bundleXMLFile.getElementsByTagName("system_patch_bundle_xml");
        if (system_patch_bundle_tag != null && system_patch_bundle_tag.getLength() > 0) {
            NodeList subpatchNodeList;
            systemPatchBundleXml = new SystemPatchBundleXML();
            systemPatchBundleXml.setPatchLocation(patchLocation);
            Element primaryNode = (Element)system_patch_bundle_tag.item(0);
            if (primaryNode.hasAttribute("patch_id")) {
                systemPatchBundleXml.setPatchID(primaryNode.getAttribute("patch_id"));
            }
            if ((subpatchNodeList = primaryNode.getElementsByTagName("subpatch")) != null && subpatchNodeList.getLength() > 0) {
                ArrayList<SubpatchModel> subpatchList = new ArrayList<SubpatchModel>();
                for (int i = 0; i < subpatchNodeList.getLength(); ++i) {
                    Element subpatch = (Element)subpatchNodeList.item(i);
                    SubpatchModel subpatchModel = this.getSubpatch(subpatch);
                    subpatchList.add(subpatchModel);
                }
                systemPatchBundleXml.setSubPatchList(subpatchList);
            }
        }
        return systemPatchBundleXml;
    }

    private SubpatchModel getSubpatch(Element subpatchElement) {
        SubpatchModel subpatchModel = new SubpatchModel();
        subpatchModel.setPatchID(subpatchElement.getAttribute("patch_id"));
        subpatchModel.setLocation(subpatchElement.getAttribute("location"));
        subpatchModel.setPatchingTool(this.getpatchingTool(subpatchElement.getAttribute("patching_tool")));
        NodeList targetNodeList = subpatchElement.getElementsByTagName("target_type");
        if (targetNodeList != null && targetNodeList.getLength() > 0) {
            ArrayList<String> targetList = new ArrayList<String>();
            for (int i = 0; i < targetNodeList.getLength(); ++i) {
                Element targetNode = (Element)targetNodeList.item(i);
                if (!targetNode.hasAttribute("type")) continue;
                targetList.add(targetNode.getAttribute("type"));
            }
            subpatchModel.setTargetTypes(targetList);
        }
        return subpatchModel;
    }

    private ISystemPatchGenerator.PatchingTool getpatchingTool(String val) {
        ISystemPatchGenerator.PatchingTool patchingTool = null;
        if (ISystemPatchGenerator.PatchingTool.OPATCH.name().equals(val)) {
            patchingTool = ISystemPatchGenerator.PatchingTool.OPATCH;
        } else if (ISystemPatchGenerator.PatchingTool.NONOPATCH.name().equals(val)) {
            patchingTool = ISystemPatchGenerator.PatchingTool.NONOPATCH;
        } else if (ISystemPatchGenerator.PatchingTool.EXAPATCH.name().equals(val)) {
            patchingTool = ISystemPatchGenerator.PatchingTool.EXAPATCH;
        }
        return patchingTool;
    }
}

