/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatchauto.core.patchanalyzer.systempatch.bundlepatch;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import oracle.opatchauto.core.patchanalyzer.PatchPackageException;
import oracle.opatchauto.core.patchanalyzer.systempatch.ISystemPatchGenerator;
import oracle.opatchauto.core.patchanalyzer.systempatch.SubpatchModel;
import oracle.opatchauto.core.patchanalyzer.systempatch.SystemPatchBundleXML;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class BundlePatchGenerator
implements ISystemPatchGenerator {
    @Override
    public boolean isPatchValid(String patchLocation) throws PatchPackageException {
        File patchDir = new File(patchLocation);
        if (!patchDir.exists()) {
            throw new PatchPackageException("Patch Location " + patchLocation + " does not exist.");
        }
        if (!patchDir.isDirectory()) {
            throw new PatchPackageException("The patch specified by the given location " + patchLocation + " is not a directory");
        }
        StringBuffer bundleXMLLoc = new StringBuffer(patchLocation);
        bundleXMLLoc.append(File.separator);
        bundleXMLLoc.append("bundle.xml");
        File bxml = new File(bundleXMLLoc.toString());
        if (!bxml.exists()) {
            throw new PatchPackageException("Bundle.xml does not exist");
        }
        if (!bxml.isFile()) {
            throw new PatchPackageException("Bundle.xml exists at location " + bxml.getAbsolutePath() + " but is not a file");
        }
        return true;
    }

    @Override
    public SystemPatchBundleXML generate(String patchLocation, boolean validate) throws PatchPackageException {
        SystemPatchBundleXML esysbundle = this.readContent(patchLocation);
        return esysbundle;
    }

    private SystemPatchBundleXML readContent(String patchLocation) throws PatchPackageException {
        SystemPatchBundleXML bundleXML = null;
        StringBuffer bundleXMLLoc = new StringBuffer(patchLocation);
        bundleXMLLoc.append(File.separator);
        bundleXMLLoc.append("bundle.xml");
        File xmlFile = new File(bundleXMLLoc.toString());
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document doc = db.parse(xmlFile);
            doc.getDocumentElement().normalize();
            bundleXML = this.extractBundleXMLInfo(patchLocation, doc);
        }
        catch (SAXException e) {
            throw new PatchPackageException("xml file is not valid as " + e.getLocalizedMessage());
        }
        catch (IOException e) {
            throw new PatchPackageException("Failed while reading bundle xml " + e.getLocalizedMessage());
        }
        catch (ParserConfigurationException e) {
            throw new PatchPackageException("Failed while parsing bundle xml " + e.getLocalizedMessage());
        }
        return bundleXML;
    }

    private SystemPatchBundleXML extractBundleXMLInfo(String patchLocation, Document bundleXMLFile) throws ParserConfigurationException, SAXException, IOException {
        SystemPatchBundleXML systemPatchBundleXml = null;
        NodeList bundle_tag = bundleXMLFile.getElementsByTagName("bundle");
        if (bundle_tag != null && bundle_tag.getLength() > 0) {
            systemPatchBundleXml = new SystemPatchBundleXML();
            systemPatchBundleXml.setPatchLocation(patchLocation);
            Element primaryNode = (Element)bundle_tag.item(0);
            NodeList entityList = primaryNode.getElementsByTagName("entity");
            if (entityList != null && entityList.getLength() > 0) {
                ArrayList<SubpatchModel> subpatchList = new ArrayList<SubpatchModel>();
                for (int i = 0; i < entityList.getLength(); ++i) {
                    SubpatchModel subpatchModel = this.getSubpatch((Element)entityList.item(i));
                    subpatchList.add(subpatchModel);
                }
                systemPatchBundleXml.setSubPatchList(subpatchList);
            }
        }
        return systemPatchBundleXml;
    }

    private SubpatchModel getSubpatch(Element subpatchElement) {
        SubpatchModel subpatchModel = new SubpatchModel();
        if (subpatchElement.hasAttribute("location")) {
            subpatchModel.setLocation(subpatchElement.getAttribute("location"));
        }
        subpatchModel.setPatchingTool(ISystemPatchGenerator.PatchingTool.OPATCH);
        NodeList targetNodeList = subpatchElement.getElementsByTagName("target");
        if (targetNodeList != null && targetNodeList.getLength() > 0) {
            ArrayList<String> targetList = new ArrayList<String>();
            for (int i = 0; i < targetNodeList.getLength(); ++i) {
                Element targetNode = (Element)targetNodeList.item(i);
                if (!targetNode.hasAttribute("type")) continue;
                targetList.add(targetNode.getAttribute("type"));
            }
            subpatchModel.setTargetTypes(targetList);
        }
        return subpatchModel;
    }
}

