/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatchauto.core.binary.systempatch;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import oracle.opatchauto.core.binary.systempatch.AppliedpatchInfo;

@XmlRootElement(name="system-patch")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class AppliedSystemPatchInformation {
    @XmlAttribute(name="id")
    private String systemPatchID;
    @XmlAttribute(name="time")
    private String appliedTime;
    @XmlElement(name="sub-patch")
    private List<AppliedpatchInfo> patchIDList = null;

    public String getSystempatchID() {
        return this.systemPatchID;
    }

    public void setSystempatchID(String id) {
        this.systemPatchID = id;
    }

    public List<String> getAppliedPatchList() {
        ArrayList<String> idList = new ArrayList<String>();
        for (AppliedpatchInfo info : this.patchIDList) {
            idList.add(info.getId());
        }
        return idList;
    }

    public void addAppliedPatchList(List<String> patchList) {
        if (this.patchIDList == null) {
            this.patchIDList = new CopyOnWriteArrayList<AppliedpatchInfo>();
        }
        for (String id : patchList) {
            if (this.get(id) != null) continue;
            AppliedpatchInfo patchInfo = new AppliedpatchInfo();
            patchInfo.setId(id);
            patchInfo.setTime(new SimpleDateFormat("yyyy/MM/dd HH:mm:ss").format(Calendar.getInstance().getTime()));
            this.patchIDList.add(patchInfo);
        }
    }

    public void removeAppliedPatchList(List<String> patchList) {
        if (this.patchIDList != null) {
            for (String id : patchList) {
                AppliedpatchInfo appliedpatchInfo = this.get(id);
                if (appliedpatchInfo == null) continue;
                this.patchIDList.remove(appliedpatchInfo);
            }
        }
    }

    private AppliedpatchInfo get(String id) {
        AppliedpatchInfo patchInfo = null;
        for (AppliedpatchInfo info : this.patchIDList) {
            if (!info.getId().equals(id)) continue;
            patchInfo = info;
            break;
        }
        return patchInfo;
    }
}

