/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatchauto.core.binary;

import java.io.File;
import oracle.opatchauto.core.binary.OACLogger;
import oracle.opatchauto.core.binary.OracleTarget;

public class PatchingSessionOptions {
    private OracleTarget target;
    private boolean isOhInstanceUp;
    private boolean analyze;
    private boolean hasPatchLocn;
    private boolean hasPatchDir;
    private boolean isFileBusyPatchingMode;
    private boolean stopOnPrereqFailure;
    private boolean stopOnPatchFailure;
    private String invPtrLoc;
    private boolean isForceConflict;
    private boolean isSkipConflict;
    private boolean isNoRelink;
    private boolean isNoPatchgen;
    private boolean prepareHome;
    private boolean ignoreJdkValidation;

    public PatchingSessionOptions(OracleTarget oracleTarget) {
        this.target = oracleTarget;
        this.analyze = false;
        this.stopOnPrereqFailure = false;
        this.stopOnPatchFailure = false;
        this.isOhInstanceUp = false;
        this.invPtrLoc = oracleTarget.getOracleHome() + File.separator + "oraInst.loc";
        this.hasPatchDir = false;
        this.hasPatchLocn = false;
        this.isFileBusyPatchingMode = false;
        this.isForceConflict = false;
        this.isSkipConflict = false;
        this.isNoRelink = false;
        this.isNoPatchgen = false;
        this.prepareHome = false;
        this.ignoreJdkValidation = false;
    }

    public OracleTarget getTarget() {
        return this.target;
    }

    public void setOHInstanceRunning(boolean isOhInstanceUp) {
        this.isOhInstanceUp = isOhInstanceUp;
    }

    public boolean isOhInstanceRunning() {
        return this.isOhInstanceUp;
    }

    public void setAnalyze(boolean analyze) {
        this.analyze = analyze;
    }

    public boolean getAnalyze() {
        return this.analyze;
    }

    public void setHasPatchLocn(boolean hasPatchLocn) {
        this.hasPatchLocn = hasPatchLocn;
    }

    public boolean getHasPatchLocn() {
        return this.hasPatchLocn;
    }

    public void setHasPatchDir(boolean hasPatchDir) {
        this.hasPatchDir = hasPatchDir;
    }

    public boolean getHasPatchDir() {
        return this.hasPatchDir;
    }

    public void setIsFileBusyPatchingMode(boolean isFileBusyPatchingMode) {
        this.isFileBusyPatchingMode = isFileBusyPatchingMode;
    }

    public boolean getIsFileBusyPatchingMode() {
        return this.isFileBusyPatchingMode;
    }

    public void setStopOnPatchFailure(boolean stopOnError) {
        this.stopOnPatchFailure = stopOnError;
    }

    public boolean getStopOnPatchFailure() {
        return this.stopOnPatchFailure;
    }

    public void setStopOnPrereqFailure(boolean stopOnError) {
        this.stopOnPrereqFailure = stopOnError;
    }

    public boolean getStopOnPrereqFailure() {
        return this.stopOnPrereqFailure;
    }

    public void setInvPtrLocn(String invPtrLoc) {
        this.invPtrLoc = invPtrLoc;
    }

    public String getInvPtrLocn() {
        return this.invPtrLoc;
    }

    public void enableConsoleOutput() {
        OACLogger.enableConsoleOutput();
    }

    public void disableConsoleOutput() {
        OACLogger.disableConsoleOutput();
    }

    public boolean isForceConflict() {
        return this.isForceConflict;
    }

    public void setForceConflict(boolean force_conflict) {
        this.isForceConflict = force_conflict;
    }

    public boolean isSkipConflict() {
        return this.isSkipConflict;
    }

    public void setSkipConflict(boolean isSkipConflict) {
        this.isSkipConflict = isSkipConflict;
    }

    public boolean isNoRelink() {
        return this.isNoRelink;
    }

    public void setNoRelink(boolean noRelink) {
        this.isNoRelink = noRelink;
    }

    public boolean isNoPatchgen() {
        return this.isNoPatchgen;
    }

    public void setNoPatchgen(boolean noPatchgen) {
        this.isNoPatchgen = noPatchgen;
    }

    public boolean isPrepareHome() {
        return this.prepareHome;
    }

    public void setPrepareHome(boolean prepareHome) {
        this.prepareHome = prepareHome;
    }

    public boolean isIgnoreJdkValidation() {
        return this.ignoreJdkValidation;
    }

    public void setIgnoreJdkValidation(boolean ignoreJdkValidation) {
        this.ignoreJdkValidation = ignoreJdkValidation;
    }

    public String getOptionDetails() {
        return this.toString();
    }

    public String toString() {
        StringBuffer summary = new StringBuffer();
        summary.append("Analyze     : " + this.analyze + "\n");
        summary.append("Inventory   : " + this.invPtrLoc + "\n");
        summary.append("StopOnPrereqFailure : " + this.stopOnPrereqFailure + "\n");
        summary.append("StopOnPatchFailure  : " + this.stopOnPatchFailure + "\n");
        summary.append("IsFileBusyPatchingMode  : " + this.isFileBusyPatchingMode + "\n");
        summary.append("IsOhInstance Running   : " + this.isOhInstanceUp + "\n");
        summary.append("Force conflict   : " + this.isForceConflict + "\n");
        summary.append("Skip conflict   : " + this.isSkipConflict + "\n");
        summary.append("No relink   : " + this.isNoRelink + "\n");
        summary.append("No patchgen   : " + this.isNoPatchgen + "\n");
        summary.append("prepare home   : " + this.prepareHome + "\n");
        return summary.toString();
    }
}

