/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatchauto.core.binary;

import java.io.File;
import oracle.opatchauto.core.binary.OACLogger;
import oracle.opatchauto.core.binary.OPatchAutoException;

public class OracleTarget {
    private final String oracleHome;
    private String target_type;

    public OracleTarget(String oraclehome) throws OPatchAutoException {
        this.oracleHome = oraclehome;
        if (this.oracleHome == null) {
            throw new OPatchAutoException("Oracle Home path is null");
        }
        if (!new File(this.oracleHome).exists()) {
            throw new OPatchAutoException("Oracle Home path does not exist: " + this.oracleHome);
        }
        OACLogger.setupLogging(this.oracleHome);
        OACLogger.console("Oracle Home : " + this.oracleHome);
    }

    public void setTargetType(String target_type) {
        this.target_type = target_type;
        OACLogger.console("Target type : " + target_type);
    }

    public String getTargetType() {
        return this.target_type;
    }

    public String getOracleHome() {
        return this.oracleHome;
    }
}

