/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatchauto.core.binary;

import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import oracle.opatchauto.core.binary.OACLogger;
import oracle.opatchauto.core.binary.systempatch.SystemPatchInformationLoader;
import oracle.opatchauto.core.binary.systempatch.SystemPatchStorageHelper;
import oracle.opatchauto.core.patchanalyzer.PatchAnalyzer;

public class BundlePatchRollbackFilter {
    public List<FilterResult> filter(List<String> idList, String oracleHome, String targetType) {
        ArrayList<FilterResult> filterResultList = new ArrayList<FilterResult>();
        String opatchautostorageLoc = SystemPatchStorageHelper.getOPatchAutoStorageLocation(oracleHome);
        File opatchautoStorageLocDir = new File(opatchautostorageLoc);
        ArrayList<String> filteredPatchList = new ArrayList<String>();
        if (opatchautoStorageLocDir.exists()) {
            File[] patchDirList;
            for (File patchDir : patchDirList = opatchautoStorageLocDir.listFiles(new BundlepatchFilter())) {
                String bundlePatchID = patchDir.getName();
                OACLogger.info("Found bundle xml with ID ::" + bundlePatchID);
                List<String> patchIDList = this.getSubPatchIDs(patchDir.getAbsolutePath(), targetType);
                List<String> appliedSubPatchList = SystemPatchInformationLoader.getInstance().getAppliedSubpatchIDList(oracleHome, bundlePatchID);
                ArrayList<String> applicablePatches = null;
                applicablePatches = appliedSubPatchList == null || appliedSubPatchList.isEmpty() ? new ArrayList<String>(patchIDList) : new ArrayList<String>(appliedSubPatchList);
                for (String rollbackId : idList) {
                    if (applicablePatches.contains(rollbackId)) {
                        if (!idList.containsAll(applicablePatches)) {
                            ArrayList<String> tempList = new ArrayList<String>(applicablePatches);
                            tempList.removeAll(idList);
                            String reason = "Dependent patch ids " + tempList + " are missing in rollback patch id list, as patch id supplied is part of bundle patch " + bundlePatchID;
                            filterResultList.add(new FilterResult(rollbackId, bundlePatchID, 1, reason));
                            filteredPatchList.add(rollbackId);
                            OACLogger.info("Validation failed for patch ID::" + rollbackId + " for reason " + reason);
                            continue;
                        }
                        OACLogger.info("Validation successful for patch ID::" + rollbackId);
                        filteredPatchList.add(rollbackId);
                        filterResultList.add(new FilterResult(rollbackId, bundlePatchID, 0, ""));
                        continue;
                    }
                    if (!patchIDList.contains(rollbackId)) continue;
                    String reason = "Patch with id " + rollbackId + " is not applied as part of bundle patch " + bundlePatchID;
                    filterResultList.add(new FilterResult(rollbackId, bundlePatchID, 1, reason));
                    filteredPatchList.add(rollbackId);
                    OACLogger.info("Validation failed for patch ID::" + rollbackId);
                }
            }
        }
        for (String patchId : idList) {
            if (filteredPatchList.contains(patchId)) continue;
            OACLogger.info("Validation successful for patch ID::" + patchId);
            filterResultList.add(new FilterResult(patchId, null, 0, ""));
        }
        return filterResultList;
    }

    private List<String> getSubPatchIDs(String bundlePatchLoc, String targetType) {
        List<String> patchIDList = new ArrayList<String>();
        ArrayList<String> target_typeList = null;
        if (null != targetType) {
            target_typeList = new ArrayList<String>();
            target_typeList.add(targetType);
        }
        PatchAnalyzer analyzer = new PatchAnalyzer();
        try {
            Map<String, List<String>> bundle_entries = analyzer.getPatchIDSFromBundleXML(bundlePatchLoc, target_typeList);
            if (bundle_entries.size() > 0) {
                if (targetType != null) {
                    patchIDList = bundle_entries.get(targetType);
                } else {
                    for (String key : bundle_entries.keySet()) {
                        List<String> list = bundle_entries.get(key);
                        patchIDList.addAll(list);
                    }
                }
            }
        }
        catch (Exception e) {
            OACLogger.severe("Retrieving patch ID from bundle xml failed due to " + e.getLocalizedMessage());
        }
        return patchIDList;
    }

    public class FilterResult {
        private static final byte SUCCESS = 0;
        private static final byte FAILURE = 1;
        private String patchID;
        private byte status = 0;
        private String failureReason = null;
        private String bundlePatchID = null;

        public FilterResult(String patchID, String bundlePatchID, byte status, String reason) {
            this.patchID = patchID;
            this.bundlePatchID = bundlePatchID;
            this.status = status;
            this.failureReason = reason;
        }

        public String getPatchId() {
            return this.patchID;
        }

        public String getBundlePatchId() {
            return this.bundlePatchID;
        }

        public boolean isPassed() {
            return this.status == 0;
        }

        public String getFailureReason() {
            return this.failureReason;
        }
    }

    private class BundlepatchFilter
    implements FileFilter {
        private BundlepatchFilter() {
        }

        @Override
        public boolean accept(File pathname) {
            return pathname.isDirectory() && new File(pathname, "bundle.xml").exists();
        }
    }
}

