/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch.opatchsdk;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import oracle.opatch.FMWClientFactory;
import oracle.opatch.fmwclient.FMWClient;
import oracle.opatch.opatchlogger.OLogger;
import oracle.opatch.opatchsdk.OPatchBIPDeployAction;
import oracle.opatch.opatchsdk.OPatchDeployAction;
import oracle.opatch.opatchsdk.OPatchDeployException;
import oracle.opatch.opatchsdk.OPatchException;
import oracle.opatch.opatchsdk.OPatchFAAutomationAction;
import oracle.opatch.opatchsdk.OPatchFAOperation;
import oracle.opatch.opatchsdk.OPatchFAStep;
import oracle.opatch.opatchsdk.OPatchInterviewAction;
import oracle.opatch.opatchsdk.OPatchPatch;
import oracle.opatch.opatchsdk.OPatchStepOperation;
import oracle.opatch.opatchsdk.OPatchUtils;
import oracle.opatch.wrappers.WrapperFactory;

public class OPatchMultipleBIPDeploy
extends OPatchFAAutomationAction
implements Cloneable {
    private OPatchBIPDeployAction[] biActions = new OPatchBIPDeployAction[0];
    private Properties dynamicProp = new Properties();
    private String biHome = "";
    private String originalPatchLocation = "";

    public OPatchBIPDeployAction[] getBIPDeployActions() {
        return this.biActions;
    }

    public OPatchMultipleBIPDeploy(OPatchBIPDeployAction[] biActions) throws OPatchException {
        int i;
        if (biActions == null || biActions.length == 0) {
            throw new OPatchException("Input array of BIP actions cannot be <null> or empty.");
        }
        ArrayList<Object> validate = new ArrayList<Object>();
        for (i = 0; i < biActions.length; ++i) {
            String oh = biActions[i].getOracleHome();
            if (!validate.contains(oh) && validate.size() != 0) {
                throw new OPatchException("All BIP actions must be targeted for the same Oracle Home.");
            }
            if (validate.contains(oh)) continue;
            validate.add(oh);
        }
        this.setOracleHomePath(biActions[0].getOracleHome());
        validate.clear();
        for (i = 0; i < biActions.length; ++i) {
            OPatchPatch patch = biActions[i].getWrapperPatch();
            if (!validate.contains(patch) && validate.size() != 0) {
                throw new OPatchException("All BIP actions must come from the same patch.");
            }
            if (validate.contains(patch)) continue;
            validate.add(patch);
        }
        this.setWrapperPatch(biActions[0].getWrapperPatch());
        validate.clear();
        for (i = 0; i < biActions.length; ++i) {
            String chome = biActions[i].getCommonComponentsHome();
            if (!validate.contains(chome) && validate.size() != 0) {
                throw new OPatchException("All BIP actions must have the same value for common components home.");
            }
            if (validate.contains(chome)) continue;
            validate.add(chome);
        }
        this.setCommonComponentsHome(biActions[0].getCommonComponentsHome());
        validate.clear();
        boolean dryRun = true;
        for (int i2 = 0; i2 < biActions.length; ++i2) {
            dryRun = dryRun && biActions[i2].isDryRun();
        }
        this.setDryRun(dryRun);
        OPatchInterviewAction[] interviewList = biActions[0].getInterviewElements();
        OPatchInterviewAction[] clonedInterviewList = new OPatchInterviewAction[interviewList.length];
        for (int i3 = 0; i3 < clonedInterviewList.length; ++i3) {
            clonedInterviewList[i3] = (OPatchInterviewAction)interviewList[i3].clone();
        }
        this.setInterviewList(clonedInterviewList);
        this.biActions = biActions;
        this.setOperatingFAContext(biActions[0].getOperatingFAContext());
        this.setConfigLogFile(biActions[0].getConfigLogFile());
        this.setExecLogFile(biActions[0].getExecLogFile());
    }

    public void setDynamicProperties(Properties dynamicProp) {
        this.dynamicProp = dynamicProp;
        for (int i = 0; i < this.biActions.length; ++i) {
            this.biActions[i].setDynamicProperties((Properties)dynamicProp.clone());
        }
    }

    public Properties getDynamicProperties() {
        return this.dynamicProp;
    }

    public void setBIHome(String biHome) {
        this.biHome = biHome;
        for (int i = 0; i < this.biActions.length; ++i) {
            this.biActions[i].setBIHome(this.biHome);
        }
    }

    public String getBIHome() {
        return this.biHome;
    }

    public void setOriginalPatchLocation(String originalPatchLocation) {
        this.originalPatchLocation = originalPatchLocation;
        for (int i = 0; i < this.biActions.length; ++i) {
            this.biActions[i].setOriginalPatchLocation(this.originalPatchLocation);
        }
    }

    public String getOriginalPatchLocation() {
        return this.originalPatchLocation;
    }

    @Override
    protected Map constructMap() {
        HashMap env = new HashMap();
        Map superEnv = super.constructMap();
        env.putAll(superEnv);
        env.putAll(this.biActions[0].constructMap());
        return env;
    }

    private OPatchMultipleBIPDeploy() {
    }

    @Override
    public String toString() {
        StringBuffer buff = new StringBuffer();
        for (int i = 0; i < this.biActions.length; ++i) {
            buff.append(this.biActions[i].toString());
            if (i == this.biActions.length - 1) continue;
            buff.append("\n");
        }
        return buff.toString();
    }

    protected void doPrereq(OPatchFAOperation operation, String patchLocation) throws OPatchException {
        int i;
        try {
            for (i = 0; i < this.biActions.length; ++i) {
                this.biActions[i].inputPatchLoc = patchLocation;
            }
            this.doPrereq(operation);
        }
        catch (OPatchException e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                for (int i2 = 0; i2 < this.biActions.length; ++i2) {
                    this.biActions[i2].inputPatchLoc = "";
                }
                throw throwable;
            }
        }
        for (i = 0; i < this.biActions.length; ++i) {
            this.biActions[i].inputPatchLoc = "";
        }
    }

    public void deploy(String patchLocation) throws OPatchDeployException {
        int i;
        try {
            for (i = 0; i < this.biActions.length; ++i) {
                this.biActions[i].inputPatchLoc = patchLocation;
            }
            this.deploy();
        }
        catch (OPatchDeployException e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                for (int i2 = 0; i2 < this.biActions.length; ++i2) {
                    this.biActions[i2].inputPatchLoc = "";
                }
                throw throwable;
            }
        }
        for (i = 0; i < this.biActions.length; ++i) {
            this.biActions[i].inputPatchLoc = "";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void deploy() throws OPatchDeployException {
        FMWClient client = null;
        OPatchStepOperation failedStep = null;
        this.setFailedPrereqStep(null);
        this.setFailedClosingStep(null);
        boolean updatePrereqFailure = false;
        String oracleHomePath = "";
        String logFile = "";
        OPatchDeployException de = null;
        try {
            String stepMsg;
            String errorMsg;
            oracleHomePath = this.getOracleHome();
            OPatchPatch patch = this.getWrapperPatch();
            try {
                if (patch == null) {
                    throw new OPatchDeployException("Log file cannot be created because OPatch does not know the source patch for this artifact.");
                }
                logFile = OPatchUtils.initLogFile(oracleHomePath, patch.getLogTimeStamp(), "Deploy_Multiple_BIP", true);
                this.setLogFile(logFile);
            }
            catch (Throwable t) {
                String stepMsg2 = "Check if log file is created properly for the operation.";
                String errorMsg2 = t.getMessage();
                failedStep = OPatchUtils.constructFailedStep(OPatchFAStep.CHECK_INIT_LOG_FILE, stepMsg2, errorMsg2, new RuntimeException(t));
                this.setFailedPrereqStep(failedStep);
                throw t;
            }
            boolean isFailed = false;
            StringBuffer failBuffer = new StringBuffer("");
            for (int i = 0; i < this.biActions.length; ++i) {
                OLogger.justlog((int)OLogger.INFO, (String)("Checking bind for artifact: " + this.biActions[i].toString()));
                if (this.biActions[i].isArtifactBoundtoConfigInstance()) continue;
                failBuffer.append(this.biActions[i].toString());
                failBuffer.append("\n");
                isFailed = true;
            }
            if (isFailed) {
                String errorMsg3 = "Failed artifacts: " + failBuffer.toString();
                String stepMsg3 = "Check if artifact(s) are bound to required end point instances from Cloned Configuration instance.";
                failedStep = OPatchUtils.constructFailedStep(OPatchFAStep.CHECK_FA_BIND_TO_CLONE_ARTIFACT, stepMsg3, errorMsg3, null);
                this.setFailedPrereqStep(failedStep);
                OLogger.justlog((int)OLogger.INFO, (String)failedStep.toString());
                throw new OPatchDeployException(errorMsg3);
            }
            isFailed = false;
            failBuffer = new StringBuffer("");
            try {
                OPatchDeployAction.setCopyVerHashMap(this.getOracleHome());
            }
            catch (OPatchException e) {
                OPatchDeployAction.resetCopyVerHashMap();
            }
            if (!this.isDryRun() && !OPatchUtils.isApplied(this.getWrapperPatch(), oracleHomePath)) {
                String errorMsg4 = "OPatch requires that Patch \"" + patch.getPatchLanguageId() + "\" be " + "installed in Oracle Home \"" + oracleHomePath + "\" for the FA operation \"" + OPatchFAOperation.PREREQ_DEPLOY.toString() + "\"";
                String stepMsg4 = "Check if FA Patch is installed.";
                failedStep = OPatchUtils.constructFailedStep(OPatchFAStep.CHECK_FA_PATCH_INSTALLED, stepMsg4, errorMsg4, null);
                this.setFailedPrereqStep(failedStep);
                OLogger.justlog((int)OLogger.INFO, (String)failedStep.toString());
                throw new OPatchDeployException(errorMsg4);
            }
            for (int i = 0; i < this.biActions.length; ++i) {
                try {
                    OLogger.justlog((int)OLogger.INFO, (String)("Running core prerequisites for artifact: " + this.biActions[i].toString()));
                    this.biActions[i].switchOffPatchInstallCheck = true;
                    this.biActions[i].invokeSuperPrereq(OPatchFAOperation.PREREQ_DEPLOY);
                    continue;
                }
                catch (OPatchException e) {
                    isFailed = true;
                    if (this.biActions[i].getFailedPrereqStep() == null) continue;
                    failBuffer.append(this.biActions[i].toString());
                    failBuffer.append("\n");
                    continue;
                }
                catch (Throwable t) {
                    isFailed = true;
                    if (this.biActions[i].getFailedPrereqStep() == null) continue;
                    failBuffer.append(this.biActions[i].toString());
                    failBuffer.append("\n");
                    continue;
                }
                finally {
                    this.biActions[i].switchOffPatchInstallCheck = false;
                }
            }
            if (!this.isDryRun() && !isFailed) {
                boolean isTouched = false;
                try {
                    isTouched = OPatchDeployAction.isTouchedByLaterAppliedPatch(this.biActions);
                }
                catch (Exception e) {
                    String errorMsg5 = "OPatch could not figure out if some patches installed later touch this artifact \"" + this.toString() + "\"";
                    String stepMsg5 = "Check if any later installed patch touches this artifact";
                    RuntimeException re = new RuntimeException(e.getMessage());
                    re.setStackTrace(e.getStackTrace());
                    failedStep = OPatchUtils.constructFailedStep(OPatchFAStep.CHECK_ARTIFACT_TOUCHED_BY_LATER_INSTALLED_PATCH, stepMsg5, errorMsg5, re);
                    this.setFailedPrereqStep(failedStep);
                    OLogger.justlog((int)OLogger.INFO, (String)failedStep.toString());
                    throw new OPatchDeployException(errorMsg5);
                }
                if (isTouched) {
                    errorMsg = "OPatch cannot deploy this artifact\"" + this.toString() + "\" as some or all sub BIP artifacts" + "are touched by later installed patch(es)";
                    String stepMsg6 = "Check if any later installed patch(es) touches this artifact";
                    failedStep = OPatchUtils.constructFailedStep(OPatchFAStep.CHECK_ARTIFACT_TOUCHED_BY_LATER_INSTALLED_PATCH, stepMsg6, errorMsg, null);
                    this.setFailedPrereqStep(failedStep);
                    OLogger.justlog((int)OLogger.INFO, (String)failedStep.toString());
                    throw new OPatchDeployException(errorMsg);
                }
            }
            if (isFailed) {
                StringBuffer err = new StringBuffer("OPatch failed in consolidated core deployment prerequisites. Please check individual action prerequisite failure.\n");
                err.append("Failed artifacts: " + failBuffer.toString());
                stepMsg = "Check if core pre-requisites for individual BI actions have passed.";
                failedStep = OPatchUtils.constructFailedStep(OPatchFAStep.CHECK_CONSOLIDATED_CORE_PREREQS, stepMsg, err.toString(), null);
                this.setFailedPrereqStep(failedStep);
                OLogger.justlog((int)OLogger.INFO, (String)failedStep.toString());
                OPatchException oe = new OPatchException(err.toString());
                throw oe;
            }
            isFailed = false;
            failBuffer = new StringBuffer("");
            try {
                OPatchUtils.lockHome(oracleHomePath);
            }
            catch (Throwable t) {
                errorMsg = "OPatch failed to lock the Oracle Home \"" + oracleHomePath + "\"";
                String stepMsg7 = "Check if OPatch can lock the Oracle Home \"" + oracleHomePath + "\"";
                RuntimeException re = new RuntimeException(t.getMessage());
                re.setStackTrace(t.getStackTrace());
                failedStep = OPatchUtils.constructFailedStep(OPatchFAStep.CHECK_LOCK_HOME, stepMsg7, errorMsg, re);
                this.setFailedPrereqStep(failedStep);
                OLogger.justlog((int)OLogger.INFO, (String)failedStep.toString());
                throw t;
            }
            if (this.originalPatchLocation == null || this.originalPatchLocation.equals("")) {
                String errorMsg6 = "Please set the correct patch location for the BIP artifact using setOriginalPatchLocation() API.";
                stepMsg = "Check if original patch location is set in the artifact.";
                failedStep = OPatchUtils.constructFailedStep(OPatchFAStep.CHECK_BIP_ORIGINAL_PATCH_LOCATION_SET, stepMsg, errorMsg6, null);
                this.setFailedPrereqStep(failedStep);
                OLogger.justlog((int)OLogger.INFO, (String)failedStep.toString());
                throw new OPatchDeployException(errorMsg6);
            }
            Path f = WrapperFactory.getNioServiceWrapper().getPath(this.originalPatchLocation, new String[0]);
            if (!Files.exists(f, new LinkOption[0]) || !Files.isDirectory(f, new LinkOption[0])) {
                errorMsg = "The original patch location set for BIP artifact does not exist (or) is not a directory. Please check the location \"" + this.originalPatchLocation + "\".";
                String stepMsg8 = "Check if original patch location is accessible.";
                failedStep = OPatchUtils.constructFailedStep(OPatchFAStep.CHECK_BIP_ORIGINAL_PATCH_LOCATION_VALIDITY, stepMsg8, errorMsg, null);
                this.setFailedPrereqStep(failedStep);
                OLogger.justlog((int)OLogger.INFO, (String)failedStep.toString());
                throw new OPatchDeployException(errorMsg);
            }
            if (this.biHome == null || this.biHome.equals("")) {
                errorMsg = "Please set the correct BI home for the BIP artifact using setBIHome() API.";
                String stepMsg9 = "Check if BI Oracle Home is set.";
                failedStep = OPatchUtils.constructFailedStep(OPatchFAStep.CHECK_BI_HOME, stepMsg9, errorMsg, null);
                this.setFailedPrereqStep(failedStep);
                OLogger.justlog((int)OLogger.INFO, (String)failedStep.toString());
                throw new OPatchDeployException(errorMsg);
            }
            f = WrapperFactory.getNioServiceWrapper().getPath(this.biHome, new String[0]);
            if (!Files.exists(f, new LinkOption[0]) || !Files.isDirectory(f, new LinkOption[0])) {
                errorMsg = "The location set for BI home does not exist (or) is not a directory. Please check the location \"" + this.biHome + "\".";
                String stepMsg10 = "Check if BI location is valid.";
                failedStep = OPatchUtils.constructFailedStep(OPatchFAStep.CHECK_BI_HOME, stepMsg10, errorMsg, null);
                this.setFailedPrereqStep(failedStep);
                OLogger.justlog((int)OLogger.INFO, (String)failedStep.toString());
                throw new OPatchDeployException(errorMsg);
            }
            OPatchInterviewAction[] interAction = this.getInterviewElements();
            ArrayList<String> mandatoryKeysNotFilled = new ArrayList<String>();
            if (interAction != null) {
                for (int k = 0; k < interAction.length; ++k) {
                    if (interAction[k] == null || !interAction[k].isRequired()) continue;
                    String value = interAction[k].getDefaultValue();
                    if (!(value = OPatchUtils.norm(value)).equals("")) continue;
                    mandatoryKeysNotFilled.add(interAction[k].getKey());
                }
            }
            if (mandatoryKeysNotFilled.size() != 0) {
                String errorMsg7 = "The mandatory keys \"" + mandatoryKeysNotFilled.toString() + "\" in the interview are not filled for this artifact.";
                String stepMsg11 = "Check if mandatory keys are given for this artifact.";
                failedStep = OPatchUtils.constructFailedStep(OPatchFAStep.CHECK_MANDATORY_INTERVIEW_VALUES_GIVEN, stepMsg11, errorMsg7, null);
                this.setFailedPrereqStep(failedStep);
                OLogger.justlog((int)OLogger.INFO, (String)failedStep.toString());
                throw new OPatchDeployException(errorMsg7);
            }
            try {
                Properties p = new Properties();
                p.putAll((Map<?, ?>)this.getInterviewProperties());
                p.putAll((Map<?, ?>)this.getDynamicProperties());
                client = FMWClientFactory.getClient((OPatchFAAutomationAction)this, (Map)this.constructMap(), (Properties)p);
            }
            catch (Throwable t) {
                String errorMsg8 = "OPatch failed to get the FMW client for artifact execution (Internal OPatch issue)";
                String stepMsg12 = "Check if OPatch can get the client for artifact execution";
                RuntimeException re = new RuntimeException(t.getMessage());
                re.setStackTrace(t.getStackTrace());
                failedStep = OPatchUtils.constructFailedStep(OPatchFAStep.CHECK_FA_CLIENT, stepMsg12, errorMsg8, re);
                this.setFailedPrereqStep(failedStep);
                OLogger.justlog((int)OLogger.INFO, (String)failedStep.toString());
                throw t;
            }
            client.deploy();
            OPatchUtils.updatePrereq(client, this);
            OPatchStepOperation prereqStep = this.getFailedPrereqStep();
            updatePrereqFailure = true;
            if (prereqStep != null) {
                throw new OPatchDeployException("OPatch failed in prerequisite checks prior to deploy.");
            }
        }
        catch (Throwable t) {
            try {
                if (!updatePrereqFailure) {
                    OPatchUtils.updatePrereq(client, this);
                    updatePrereqFailure = true;
                }
                OPatchDeployException re = new OPatchDeployException(t.getMessage());
                re.setStackTrace(t.getStackTrace());
                de = re;
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                try {
                    if (!oracleHomePath.equals("")) {
                        OPatchUtils.unlockHome(oracleHomePath);
                    }
                }
                catch (Throwable t2) {
                    String errorMsg = "OPatch failed to unlock the Oracle Home \"" + oracleHomePath + "\"";
                    String stepMsg = "Check if OPatch can unlock the Oracle Home.";
                    RuntimeException re = new RuntimeException(t2.getMessage());
                    re.setStackTrace(t2.getStackTrace());
                    failedStep = OPatchUtils.constructFailedStep(OPatchFAStep.CHECK_UNLOCK_HOME, stepMsg, errorMsg, re);
                    this.setFailedClosingStep(failedStep);
                    OLogger.justlog((int)OLogger.INFO, (String)failedStep.toString());
                }
                OPatchUtils.closeLogFile();
                OPatchStepOperation prereqStep = this.getFailedPrereqStep();
                if (prereqStep != null) {
                    if (client != null) {
                        client.close();
                    }
                    if (de == null) return;
                    throw de;
                }
                OPatchUtils.updateExecutionContext(client, this, OPatchFAOperation.DEPLOY);
                OPatchUtils.logExecutionContext(oracleHomePath, this.getOperatingFAContext(), "", this);
                if (client != null) {
                    client.close();
                }
                if (de == null) return;
                throw de;
            }
        }
        try {
            if (!oracleHomePath.equals("")) {
                OPatchUtils.unlockHome(oracleHomePath);
            }
        }
        catch (Throwable t) {
            String errorMsg = "OPatch failed to unlock the Oracle Home \"" + oracleHomePath + "\"";
            String stepMsg = "Check if OPatch can unlock the Oracle Home.";
            RuntimeException re = new RuntimeException(t.getMessage());
            re.setStackTrace(t.getStackTrace());
            failedStep = OPatchUtils.constructFailedStep(OPatchFAStep.CHECK_UNLOCK_HOME, stepMsg, errorMsg, re);
            this.setFailedClosingStep(failedStep);
            OLogger.justlog((int)OLogger.INFO, (String)failedStep.toString());
        }
        OPatchUtils.closeLogFile();
        OPatchStepOperation prereqStep = this.getFailedPrereqStep();
        if (prereqStep != null) {
            if (client != null) {
                client.close();
            }
            if (de == null) return;
            throw de;
        }
        OPatchUtils.updateExecutionContext(client, this, OPatchFAOperation.DEPLOY);
        OPatchUtils.logExecutionContext(oracleHomePath, this.getOperatingFAContext(), "", this);
        if (client != null) {
            client.close();
        }
        if (de == null) return;
        throw de;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void doPrereq(OPatchFAOperation operation) throws OPatchException {
        OPatchStepOperation failedStep = null;
        this.setFailedPrereqStep(null);
        FMWClient client = null;
        OPatchException oe = null;
        String oracleHomePath = this.getOracleHome();
        OPatchPatch patch = this.getWrapperPatch();
        String logFile = "";
        this.setLogFile("");
        try {
            String stepMsg;
            String errorMsg;
            String stepMsg2;
            int i;
            try {
                if (patch == null) {
                    throw new OPatchException("Log file cannot be created because OPatch does not know the source patch for this artifact.");
                }
                logFile = OPatchUtils.initLogFile(oracleHomePath, patch.getLogTimeStamp(), "Prereq_Multiple_BIP", true);
                this.setLogFile(logFile);
            }
            catch (Throwable t) {
                String stepMsg3 = "Check if log file is created properly for the operation.";
                String errorMsg2 = t.getMessage();
                failedStep = OPatchUtils.constructFailedStep(OPatchFAStep.CHECK_INIT_LOG_FILE, stepMsg3, errorMsg2, new RuntimeException(t));
                this.setFailedPrereqStep(failedStep);
                throw t;
            }
            boolean isFailed = false;
            StringBuffer failBuffer = new StringBuffer("");
            for (i = 0; i < this.biActions.length; ++i) {
                OLogger.justlog((int)OLogger.INFO, (String)("Checking bind for artifact: " + this.biActions[i].toString()));
                if (this.biActions[i].isArtifactBoundtoConfigInstance()) continue;
                failBuffer.append(this.biActions[i].toString());
                failBuffer.append("\n");
                isFailed = true;
            }
            if (isFailed) {
                String errorMsg3 = "Failed artifacts: " + failBuffer.toString();
                String stepMsg4 = "Check if artifact(s) are bound to required end point instances from Cloned Configuration instance.";
                failedStep = OPatchUtils.constructFailedStep(OPatchFAStep.CHECK_FA_BIND_TO_CLONE_ARTIFACT, stepMsg4, errorMsg3, null);
                this.setFailedPrereqStep(failedStep);
                OLogger.justlog((int)OLogger.INFO, (String)failedStep.toString());
                throw new OPatchException(errorMsg3);
            }
            isFailed = false;
            failBuffer = new StringBuffer("");
            if (!this.isDryRun() && !OPatchUtils.isApplied(this.getWrapperPatch(), oracleHomePath)) {
                String errorMsg4 = "OPatch requires that Patch \"" + patch.getPatchLanguageId() + "\" be " + "installed in Oracle Home \"" + oracleHomePath + "\" for the FA operation \"" + OPatchFAOperation.PREREQ_DEPLOY.toString() + "\"";
                String stepMsg5 = "Check if FA Patch is installed.";
                failedStep = OPatchUtils.constructFailedStep(OPatchFAStep.CHECK_FA_PATCH_INSTALLED, stepMsg5, errorMsg4, null);
                this.setFailedPrereqStep(failedStep);
                OLogger.justlog((int)OLogger.INFO, (String)failedStep.toString());
                throw new OPatchException(errorMsg4);
            }
            for (i = 0; i < this.biActions.length; ++i) {
                try {
                    OLogger.justlog((int)OLogger.INFO, (String)("Running core prerequisites for artifact: " + this.biActions[i].toString()));
                    this.biActions[i].switchOffPatchInstallCheck = true;
                    this.biActions[i].invokeSuperPrereq(OPatchFAOperation.PREREQ_DEPLOY);
                    continue;
                }
                catch (OPatchException e) {
                    isFailed = true;
                    if (this.biActions[i].getFailedPrereqStep() == null) continue;
                    failBuffer.append(this.biActions[i].toString());
                    failBuffer.append("\n");
                    continue;
                }
                catch (Throwable t) {
                    isFailed = true;
                    if (this.biActions[i].getFailedPrereqStep() == null) continue;
                    failBuffer.append(this.biActions[i].toString());
                    failBuffer.append("\n");
                    continue;
                }
                finally {
                    this.biActions[i].switchOffPatchInstallCheck = false;
                }
            }
            if (isFailed) {
                StringBuffer err = new StringBuffer("OPatch failed in consolidated core deployment prerequisites.\n");
                err.append("Failed artifacts:" + failBuffer.toString());
                stepMsg2 = "Check if core pre-requisites for individual BI actions have passed.";
                failedStep = OPatchUtils.constructFailedStep(OPatchFAStep.CHECK_CONSOLIDATED_CORE_PREREQS, stepMsg2, err.toString(), null);
                this.setFailedPrereqStep(failedStep);
                OLogger.justlog((int)OLogger.INFO, (String)failedStep.toString());
                OPatchException failedPrereq = new OPatchException(err.toString());
                throw failedPrereq;
            }
            if (this.originalPatchLocation == null || this.originalPatchLocation.equals("")) {
                String errorMsg5 = "Please set the correct patch location for the BIP artifact using setOriginalPatchLocation() API.";
                stepMsg2 = "Check if original patch location is set in the artifact.";
                failedStep = OPatchUtils.constructFailedStep(OPatchFAStep.CHECK_BIP_ORIGINAL_PATCH_LOCATION_SET, stepMsg2, errorMsg5, null);
                this.setFailedPrereqStep(failedStep);
                OLogger.justlog((int)OLogger.INFO, (String)failedStep.toString());
                throw new OPatchException(errorMsg5);
            }
            Path f = WrapperFactory.getNioServiceWrapper().getPath(this.originalPatchLocation, new String[0]);
            if (!Files.exists(f, new LinkOption[0]) || !Files.isDirectory(f, new LinkOption[0])) {
                errorMsg = "The original patch location set for BIP artifact does not exist (or) is not a directory. Please check the location \"" + this.originalPatchLocation + "\".";
                String stepMsg6 = "Check if original patch location is accessible.";
                failedStep = OPatchUtils.constructFailedStep(OPatchFAStep.CHECK_BIP_ORIGINAL_PATCH_LOCATION_VALIDITY, stepMsg6, errorMsg, null);
                this.setFailedPrereqStep(failedStep);
                OLogger.justlog((int)OLogger.INFO, (String)failedStep.toString());
                throw new OPatchException(errorMsg);
            }
            if (this.biHome == null || this.biHome.equals("")) {
                errorMsg = "Please set the correct BI home for the BIP artifact using setBIHome() API.";
                String stepMsg7 = "Check if BI Oracle Home is set.";
                failedStep = OPatchUtils.constructFailedStep(OPatchFAStep.CHECK_BI_HOME, stepMsg7, errorMsg, null);
                this.setFailedPrereqStep(failedStep);
                OLogger.justlog((int)OLogger.INFO, (String)failedStep.toString());
                throw new OPatchException(errorMsg);
            }
            f = WrapperFactory.getNioServiceWrapper().getPath(this.biHome, new String[0]);
            if (!Files.exists(f, new LinkOption[0]) || !Files.isDirectory(f, new LinkOption[0])) {
                errorMsg = "The location set for BI home does not exist (or) is not a directory. Please check the location \"" + this.biHome + "\".";
                String stepMsg8 = "Check if BI location is valid.";
                failedStep = OPatchUtils.constructFailedStep(OPatchFAStep.CHECK_BI_HOME, stepMsg8, errorMsg, null);
                this.setFailedPrereqStep(failedStep);
                OLogger.justlog((int)OLogger.INFO, (String)failedStep.toString());
                throw new OPatchException(errorMsg);
            }
            OPatchInterviewAction[] interAction = this.getInterviewElements();
            ArrayList<String> mandatoryKeysNotFilled = new ArrayList<String>();
            if (interAction != null) {
                for (int k = 0; k < interAction.length; ++k) {
                    if (interAction[k] == null || !interAction[k].isRequired()) continue;
                    String value = interAction[k].getDefaultValue();
                    if (!(value = OPatchUtils.norm(value)).equals("")) continue;
                    mandatoryKeysNotFilled.add(interAction[k].getKey());
                }
            }
            if (mandatoryKeysNotFilled.size() != 0) {
                String errorMsg6 = "The mandatory keys \"" + mandatoryKeysNotFilled.toString() + "\" in the interview are not filled for this artifact.";
                stepMsg = "Check if mandatory keys are given for this artifact.";
                failedStep = OPatchUtils.constructFailedStep(OPatchFAStep.CHECK_MANDATORY_INTERVIEW_VALUES_GIVEN, stepMsg, errorMsg6, null);
                this.setFailedPrereqStep(failedStep);
                OLogger.justlog((int)OLogger.INFO, (String)failedStep.toString());
                throw new OPatchException(errorMsg6);
            }
            try {
                Properties p = new Properties();
                p.putAll((Map<?, ?>)this.getInterviewProperties());
                p.putAll((Map<?, ?>)this.getDynamicProperties());
                client = FMWClientFactory.getClient((OPatchFAAutomationAction)this, (Map)this.constructMap(), (Properties)p);
            }
            catch (Throwable t) {
                String errorMsg7 = "OPatch failed to get the FMW client for artifact execution (Internal OPatch issue)";
                String stepMsg9 = "Check if OPatch can get the client for artifact execution";
                RuntimeException re = new RuntimeException(t.getMessage());
                re.setStackTrace(t.getStackTrace());
                failedStep = OPatchUtils.constructFailedStep(OPatchFAStep.CHECK_FA_CLIENT, stepMsg9, errorMsg7, re);
                this.setFailedPrereqStep(failedStep);
                OLogger.justlog((int)OLogger.INFO, (String)failedStep.toString());
                throw t;
            }
            try {
                if (operation != OPatchFAOperation.PREREQ_DEPLOY) {
                    String errorMsg8 = "OPatch does not support the operation \"" + operation.toString() + "\" for this artifact.";
                    stepMsg = "Check if operation \"" + operation.toString() + "\" is supported.";
                    failedStep = OPatchUtils.constructFailedStep(OPatchFAStep.CHECK_OPERATION_SUPPORTED, stepMsg, errorMsg8, null);
                    this.setFailedPrereqStep(failedStep);
                    OLogger.justlog((int)OLogger.INFO, (String)failedStep.toString());
                    OPatchException re = new OPatchException(errorMsg8);
                    throw re;
                }
                client.prereq(true);
            }
            catch (Throwable t) {
                OPatchException re = new OPatchException("OPatch fails in prereq on the artifact. " + t.getMessage());
                re.setStackTrace(t.getStackTrace());
                throw re;
            }
        }
        catch (Throwable t) {
            try {
                OPatchException re = new OPatchException(t.getMessage());
                re.setStackTrace(t.getStackTrace());
                oe = re;
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                OPatchUtils.updatePrereq(client, this);
                try {
                    if (!oracleHomePath.equals("")) {
                        OPatchUtils.unlockHome(oracleHomePath);
                    }
                }
                catch (Throwable t2) {
                    String errorMsg10 = "OPatch failed to unlock the Oracle Home \"" + oracleHomePath + "\"";
                    String stepMsg11 = "Check if OPatch can unlock the Oracle Home.";
                    RuntimeException re = new RuntimeException(t2.getMessage());
                    re.setStackTrace(t2.getStackTrace());
                    failedStep = OPatchUtils.constructFailedStep(OPatchFAStep.CHECK_UNLOCK_HOME, stepMsg11, errorMsg10, re);
                    this.setFailedClosingStep(failedStep);
                    OLogger.justlog((int)OLogger.INFO, (String)failedStep.toString());
                }
                OPatchUtils.closeLogFile();
                if (client != null) {
                    client.close();
                }
                if (oe == null) return;
                throw oe;
            }
        }
        OPatchUtils.updatePrereq(client, this);
        try {
            if (!oracleHomePath.equals("")) {
                OPatchUtils.unlockHome(oracleHomePath);
            }
        }
        catch (Throwable t) {
            String errorMsg9 = "OPatch failed to unlock the Oracle Home \"" + oracleHomePath + "\"";
            String stepMsg10 = "Check if OPatch can unlock the Oracle Home.";
            RuntimeException re = new RuntimeException(t.getMessage());
            re.setStackTrace(t.getStackTrace());
            failedStep = OPatchUtils.constructFailedStep(OPatchFAStep.CHECK_UNLOCK_HOME, stepMsg10, errorMsg9, re);
            this.setFailedClosingStep(failedStep);
            OLogger.justlog((int)OLogger.INFO, (String)failedStep.toString());
        }
        OPatchUtils.closeLogFile();
        if (client != null) {
            client.close();
        }
        if (oe == null) return;
        throw oe;
    }

    @Override
    public Object clone() {
        OPatchMultipleBIPDeploy bip = (OPatchMultipleBIPDeploy)super.clone();
        bip.setBIHome(this.getBIHome());
        Properties prop = this.getDynamicProperties();
        bip.setDynamicProperties((Properties)prop.clone());
        bip.setOriginalPatchLocation(this.getOriginalPatchLocation());
        bip.biActions = new OPatchBIPDeployAction[this.biActions.length];
        for (int i = 0; i < this.biActions.length; ++i) {
            bip.biActions[i] = (OPatchBIPDeployAction)this.biActions[i].clone();
        }
        return bip;
    }
}

