/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch.opatchsdk;

import java.util.ArrayList;
import model.fafmw.SOAComposite;
import model.fafmw.SOAResourceBundle;
import model.fafmw.WLAdminServer;
import model.fafmw.WLDomain;
import model.fafmw.WLServer;

public class OPatchConfigWLDomain {
    private WLDomain domainInfo;
    private ArrayList<SOACompositeWrapper> compositeWrappers = new ArrayList();
    private ArrayList<SOAResourceBundleWrapper> SOARbWrappers = new ArrayList();
    private ArrayList<OPatchConfigWLServer> servers = new ArrayList();
    private ArrayList<OPatchConfigSOAServer> soa = new ArrayList();

    protected OPatchConfigWLDomain(WLDomain domain) {
        this.domainInfo = domain;
    }

    public WLDomain getWLDomain() {
        return this.domainInfo;
    }

    protected void addManagedServer(WLServer server) {
        if (this.servers == null) {
            this.servers = new ArrayList();
        }
        ArrayList<OPatchConfigWLServer> serverWrappers = this.getManagedServerWrappers();
        for (int i = 0; i < serverWrappers.size(); ++i) {
            OPatchConfigWLServer serverWrap = serverWrappers.get(i);
            String serverName = serverWrap.getWLServer().getName();
            if (!serverName.equals(server.getName())) continue;
            return;
        }
        OPatchConfigWLServer newServer = new OPatchConfigWLServer(server);
        this.servers.add(newServer);
    }

    protected void addManagedServer(WLServer server, boolean isStart, boolean failure) {
        if (this.servers == null) {
            this.servers = new ArrayList();
        }
        ArrayList<OPatchConfigWLServer> serverWrappers = this.getManagedServerWrappers();
        for (int i = 0; i < serverWrappers.size(); ++i) {
            OPatchConfigWLServer serverWrap = serverWrappers.get(i);
            String serverName = serverWrap.getWLServer().getName();
            if (!serverName.equals(server.getName())) continue;
            if (failure) {
                serverWrap.setStarted(false);
                serverWrap.setStopped(false);
            } else {
                serverWrap.setStarted(isStart);
                serverWrap.setStopped(!isStart);
            }
            return;
        }
        OPatchConfigWLServer newServer = new OPatchConfigWLServer(server);
        if (failure) {
            newServer.setStarted(false);
            newServer.setStopped(false);
        } else {
            newServer.setStarted(isStart);
            newServer.setStopped(!isStart);
        }
        this.servers.add(newServer);
    }

    protected void removeSOACompositeRevision(String compositeName, String prevRevision, String curRevision, String revToDelete, boolean failure, String host, int port) {
        OPatchConfigSOAServer ss = new OPatchConfigSOAServer(host, port);
        if (!this.soa.contains(ss)) {
            this.soa.add(ss);
        }
        String inName = compositeName;
        ArrayList<SOACompositeWrapper> composites = this.getSOACompositeWrappers();
        for (int i = 0; i < composites.size(); ++i) {
            SOACompositeWrapper wrapper = composites.get(i);
            String soaCompName = wrapper.getCompositeName();
            if (!inName.equals(soaCompName)) continue;
            if (!failure) {
                wrapper.removeRevision(revToDelete);
                wrapper.setActiveRevisionID(curRevision);
                wrapper.setPreviousRevisionID(prevRevision);
            } else {
                wrapper.setActiveRevisionID("");
                wrapper.setPreviousRevisionID("");
            }
            return;
        }
    }

    protected void addSOAComposite(String compositeName) {
        String inName = compositeName;
        if (this.compositeWrappers == null) {
            this.compositeWrappers = new ArrayList();
        }
        ArrayList<SOACompositeWrapper> composites = this.getSOACompositeWrappers();
        for (int i = 0; i < composites.size(); ++i) {
            SOACompositeWrapper wrapper = composites.get(i);
            String soaCompName = wrapper.getCompositeName();
            if (!inName.equals(soaCompName)) continue;
            return;
        }
        SOACompositeWrapper compositeWrapper = new SOACompositeWrapper(compositeName);
        this.compositeWrappers.add(compositeWrapper);
    }

    protected void addSOAComposite(String compositeName, String prevRevision, String curRevision, boolean failure, String host, int port) {
        OPatchConfigSOAServer ss = new OPatchConfigSOAServer(host, port);
        if (!this.soa.contains(ss)) {
            this.soa.add(ss);
        }
        String inName = compositeName;
        if (this.compositeWrappers == null) {
            this.compositeWrappers = new ArrayList();
        }
        ArrayList<SOACompositeWrapper> composites = this.getSOACompositeWrappers();
        for (int i = 0; i < composites.size(); ++i) {
            SOACompositeWrapper wrapper = composites.get(i);
            String soaCompName = wrapper.getCompositeName();
            if (!inName.equals(soaCompName)) continue;
            if (!failure) {
                wrapper.setActiveRevisionID(curRevision);
                wrapper.setPreviousRevisionID(prevRevision);
            } else {
                wrapper.setActiveRevisionID("");
                wrapper.setPreviousRevisionID(prevRevision);
            }
            if (!failure) {
                wrapper.addRevisionHistory(prevRevision, curRevision);
            }
            return;
        }
        SOACompositeWrapper compositeWrapper = new SOACompositeWrapper(compositeName);
        compositeWrapper.setPreviousRevisionID(prevRevision);
        compositeWrapper.setActiveRevisionID(curRevision);
        compositeWrapper.addRevisionHistory(prevRevision, curRevision);
        this.compositeWrappers.add(compositeWrapper);
    }

    protected void addSOAResourceBundle(String rbJar, boolean failure, String host, int port) {
        if (this.SOARbWrappers == null) {
            this.SOARbWrappers = new ArrayList();
        }
        ArrayList<SOAResourceBundleWrapper> soarb = this.getSOARbWrappers();
        for (int i = 0; i < soarb.size(); ++i) {
            SOAResourceBundleWrapper wrapper = soarb.get(i);
            String jarName = wrapper.getName();
            if (!jarName.equals(rbJar)) continue;
            return;
        }
        SOAResourceBundle soaRBObject = new SOAResourceBundle();
        soaRBObject.setName(rbJar);
        SOAResourceBundleWrapper soaRbWrapper = new SOAResourceBundleWrapper(soaRBObject);
        if (!failure) {
            soaRbWrapper.setDeployed(true);
        } else {
            soaRbWrapper.setDeployed(false);
        }
        this.SOARbWrappers.add(soaRbWrapper);
    }

    public ArrayList<SOACompositeWrapper> getSOACompositeWrappers() {
        return this.compositeWrappers;
    }

    public ArrayList<OPatchConfigSOAServer> getSOAServers() {
        return this.soa;
    }

    public ArrayList<SOAResourceBundleWrapper> getSOARbWrappers() {
        return this.SOARbWrappers;
    }

    public ArrayList<OPatchConfigWLServer> getManagedServerWrappers() {
        return this.servers;
    }

    public int hashCode() {
        return this.getWLDomain().getWLAdminServer().getPort();
    }

    public boolean equals(Object o) {
        WLDomain domain2;
        OPatchConfigWLDomain inDomain = (OPatchConfigWLDomain)o;
        WLDomain domain1 = inDomain.getWLDomain();
        if (domain1 == (domain2 = this.getWLDomain())) {
            return true;
        }
        if (domain1 != null && domain2 != null) {
            WLAdminServer a1 = domain1.getWLAdminServer();
            WLAdminServer a2 = domain2.getWLAdminServer();
            if (a1 != null && a2 != null) {
                String adminURL1 = a1.getURL();
                String adminURL2 = a2.getURL();
                int port1 = a1.getPort();
                int port2 = a2.getPort();
                return adminURL1.equals(adminURL2) && port1 == port2;
            }
            return false;
        }
        return false;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("");
        sb.append("\n[WLDomain Name = \"");
        sb.append(this.domainInfo.getName());
        sb.append("\", Admin Server URL = \"");
        sb.append(this.domainInfo.getWLAdminServer().getURL());
        sb.append("\", Port = \"");
        sb.append(this.domainInfo.getWLAdminServer().getPort() + "\"");
        if (this.compositeWrappers != null && this.compositeWrappers.size() != 0) {
            sb.append("\nSOA Composites:");
            for (SOACompositeWrapper wrapper : this.compositeWrappers) {
                sb.append(wrapper.toString());
                sb.append(" ");
            }
        }
        if (this.SOARbWrappers != null && this.SOARbWrappers.size() != 0) {
            sb.append("\nSOA Resource Bundles:");
            for (SOAResourceBundleWrapper rbWrapper : this.SOARbWrappers) {
                sb.append(rbWrapper.toString());
                sb.append(" ");
            }
        }
        if (this.servers != null && this.servers.size() != 0) {
            sb.append("\nManaged Servers:");
            for (OPatchConfigWLServer server : this.servers) {
                sb.append(server.toString());
                sb.append(" ");
            }
        }
        if (this.soa != null && this.soa.size() != 0) {
            sb.append("\nSOA Servers:");
            for (OPatchConfigSOAServer ss : this.soa) {
                sb.append(ss.toString());
                sb.append(" ");
            }
        }
        sb.append("]\n");
        return sb.toString();
    }

    public class OPatchConfigWLServer {
        private WLServer wlserver = null;
        private boolean isStarted = false;
        private boolean isStopped = false;

        protected OPatchConfigWLServer(WLServer wlserver) {
            this.wlserver = wlserver;
        }

        public WLServer getWLServer() {
            return this.wlserver;
        }

        protected void setStarted(boolean isStarted) {
            this.isStarted = isStarted;
        }

        protected void setStopped(boolean isStopped) {
            this.isStopped = isStopped;
        }

        public boolean isStarted() {
            return this.isStarted;
        }

        public boolean isStopped() {
            return this.isStopped;
        }

        public int hashCode() {
            String server = this.getWLServer().getName();
            if (server == null) {
                return 0;
            }
            return server.length();
        }

        public boolean equals(Object o) {
            OPatchConfigWLServer inServer = (OPatchConfigWLServer)o;
            WLServer server1 = inServer.getWLServer();
            WLServer server2 = this.getWLServer();
            return server1.getName().equals(server2.getName());
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("\n[Managed Server: Name = \"");
            sb.append(this.wlserver.getName());
            sb.append("\"");
            sb.append(", Started = ");
            sb.append(this.isStarted);
            sb.append(", Stopped = ");
            sb.append(this.isStopped);
            sb.append("]");
            return sb.toString();
        }
    }

    public class OPatchConfigSOAServer {
        private String host = "";
        private int port = -1;

        protected OPatchConfigSOAServer(String host, int port) {
            this.host = host;
            this.port = port;
        }

        public String getSOAHost() {
            return this.host;
        }

        public int getSOAPort() {
            return this.port;
        }

        public int hashCode() {
            return this.port;
        }

        public boolean equals(Object o) {
            OPatchConfigSOAServer s1 = this;
            OPatchConfigSOAServer s2 = (OPatchConfigSOAServer)o;
            if (s2 == null) {
                return false;
            }
            if (s1.getClass().getName().equals(s2.getClass().getName())) {
                return s1.host.equals(s2.host) && s1.port == s2.port;
            }
            return false;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("\n[SOA Server: Host = \"");
            sb.append(this.getSOAHost());
            sb.append("\"");
            sb.append(", Port = \"");
            sb.append(this.getSOAPort());
            sb.append("\"");
            sb.append("]");
            return sb.toString();
        }
    }

    public class SOAResourceBundleWrapper {
        private boolean isDeployed = false;
        private SOAResourceBundle soaRb;

        protected SOAResourceBundleWrapper(SOAResourceBundle soaRb) {
            this.soaRb = soaRb;
        }

        public String getName() {
            return this.soaRb.getName();
        }

        public boolean isDeployed() {
            return this.isDeployed;
        }

        protected void setDeployed(boolean isDeployed) {
            this.isDeployed = isDeployed;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("\n[SOA Resource Bundle: jar = \"");
            sb.append(this.soaRb.getName());
            sb.append("\", Deployed = ");
            sb.append(this.isDeployed);
            sb.append("]");
            return sb.toString();
        }
    }

    public class SOACompositeWrapper {
        private SOAComposite composite = null;
        private ArrayList<SOACompositeRevisionHistory> revisionHistory = new ArrayList();
        private String previousRevisionID = "";

        protected SOACompositeWrapper(String compositeName) {
            this.composite = new SOAComposite();
            this.composite.setName(compositeName);
        }

        private SOACompositeWrapper() {
        }

        public ArrayList<SOACompositeRevisionHistory> getRevisionHistory() {
            return this.revisionHistory;
        }

        protected void removeRevision(String rev) {
            for (int i = 0; i < this.revisionHistory.size(); ++i) {
                SOACompositeRevisionHistory rh = this.revisionHistory.get(i);
                if (!rh.getCurrentRevision().equals(rev)) continue;
                this.revisionHistory.remove(i);
                return;
            }
        }

        protected void addRevisionHistory(String prev, String cur) {
            SOACompositeRevisionHistory rh = new SOACompositeRevisionHistory(prev, cur);
            this.revisionHistory.add(rh);
        }

        protected void setPreviousRevisionID(String previousRevisionID) {
            this.previousRevisionID = previousRevisionID;
        }

        public String getCompositeName() {
            return this.composite.getName();
        }

        public String getPreviousRevisionID() {
            return this.previousRevisionID;
        }

        public String getActiveRevisionID() {
            String revID = this.composite.getRevisionId();
            if (revID == null) {
                revID = "";
            }
            return revID;
        }

        protected void setActiveRevisionID(String revision) {
            this.composite.setRevisionId(revision);
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("\n[SOA Composite: compositeName = \"");
            sb.append(this.composite.getName());
            sb.append("\", Previous Revision = \"");
            sb.append(this.previousRevisionID);
            sb.append("\", Current Revision = \"");
            sb.append(this.composite.getRevisionId());
            sb.append("\"");
            sb.append("]");
            return sb.toString();
        }

        public boolean equals(Object o) {
            SOACompositeWrapper in = (SOACompositeWrapper)o;
            String inName = in.getCompositeName();
            String curName = this.getCompositeName();
            return inName != null && curName != null && inName.equals(curName);
        }
    }

    public class SOACompositeRevisionHistory {
        private String prevRevision = "";
        private String curRevision = "";

        protected SOACompositeRevisionHistory(String prevRevision, String curRevision) {
            this.prevRevision = prevRevision;
            this.curRevision = curRevision;
        }

        public String getPreviousRevision() {
            return this.prevRevision;
        }

        public String getCurrentRevision() {
            return this.curRevision;
        }

        protected void setPreviousRevision(String prevRevision) {
            this.prevRevision = prevRevision;
        }

        protected void setCurrentRevision(String curRevision) {
            this.curRevision = curRevision;
        }
    }
}

